/*Filename: TIME.C                                          */
/*"MFSAMPLE" Generated by WindowsMAKER Professional         */
/*Author: Bill G.                                           */

#include <WINDOWS.H>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "MFSAMPLE.H"
 
#include "TIME.WMC"
    
    
    
 
int BLD_TimeDlgFunc(hWnd,message,wParam,lParam) /* Startup procedure for modal dialog box */
HWND hWnd;       
unsigned message;
WORD wParam;     
LONG lParam;     
    {
    FARPROC lpProc;
    int ReturnValue;
 
    lpProc = MakeProcInstance(BLD_TimeDlgProc,hInst);
    ReturnValue = DialogBox(hInst, (LPSTR)"TIME", hWnd, lpProc);
    FreeProcInstance(lpProc);
    if (ReturnValue==-1)
        BLDDisplayMessage(hWnd,BLD_CannotCreate,"TIME",
                          MB_OK | MB_ICONHAND);
    return ReturnValue;
    }
 
BOOL FAR PASCAL BLD_TimeDlgProc(hDlg, message, wParam, lParam) /* Modal dialog box procedure */
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
    {
	time_t	tTime;
	struct tm *lpTime;
	MFTIME mfTime;
	int	err;

    switch(message)
        {
        case WM_INITDIALOG:
    		SetProp(hDlg,HELPSTATUS,0);

            // How to use C runtime functions with Magic Fields
		    time (&tTime);
		    lpTime = localtime (&tTime);
		    mfTime.iHour = lpTime->tm_hour;
		    mfTime.iMinute = lpTime->tm_min;
		    mfTime.iSecond = lpTime->tm_sec;
		    MfSetFieldTime (hDlg, ID_TIME, &mfTime, &err);

            return BLD_TimeDlgDefault(hDlg,message,wParam,lParam);
            break;

        case WM_COMMAND:
            switch(wParam)
                {
            case IDOK:
                 if (!BLD_TimeDlgDefault(hDlg,message,wParam,lParam))
                     EndDialog(hDlg,IDOK);
                 break;
            case IDCANCEL:
                 if (!BLD_TimeDlgDefault(hDlg,message,wParam,lParam))
                     EndDialog(hDlg,IDCANCEL);
                 break;
            default:
                 return BLD_TimeDlgDefault(hDlg,message,wParam,lParam); 
                 break;
                }
            break;
 
        case WM_DESTROY :
            if (GetProp(hDlg,HELPSTATUS))
                EndHelp(hDlg);
            RemoveProp(hDlg,HELPSTATUS);
            return FALSE; 
            break;

        case MFD_NOTIFY:
            {
            switch (wParam)
                {
                case MFN_ONLINEHELP:
          	    	SetProp(hDlg,HELPSTATUS,1);
                    StartHelp(hDlg,IDH_Time_Example);
                    break;
                default:
                    return FALSE;
                    break;
                }
            }
            break;

        default:
            return BLD_TimeDlgDefault(hDlg,message,wParam,lParam); 
            break;
        }
    return TRUE;/* Did process the message */
    }

 
BOOL BLD_TimeToStructUDCFunc(hWnd,message,wParam,lParam) /* User Defined Code */
HWND hWnd;
unsigned message;
WORD wParam;     
LONG lParam;     
    {
    MFTIME  Time;
    int err;

    if (!MfGetFieldTime(hWnd,ID_TIME,&Time,&err))
        {
        MessageBox(hWnd,"Unable to get time. Press F2 in field for more info.",OWN_CAPTION,MB_OK|MB_ICONASTERISK);
        return FALSE;
        }
    SetDlgItemInt(hWnd,ID_HOUR, Time.iHour,FALSE);
    SetDlgItemInt(hWnd,ID_MIN,Time.iMinute,FALSE);
    SetDlgItemInt(hWnd,ID_SEC,  Time.iSecond,FALSE);
    return TRUE;
    }


 
 
BOOL BLD_StructToTimeUDCFunc(hWnd,message,wParam,lParam) /* User Defined Code */
HWND hWnd;
unsigned message;
WORD wParam;     
LONG lParam;     
    {
    MFTIME  Time;
    BOOL b;
    int err;

    Time.iHour   =GetDlgItemInt(hWnd,ID_HOUR,&b,FALSE);
    Time.iMinute =GetDlgItemInt(hWnd,ID_MIN,&b,FALSE);
    Time.iSecond =GetDlgItemInt(hWnd,ID_SEC,&b,FALSE);
    if (!MfSetFieldTime(hWnd,ID_TIME,&Time,&err))
        {
        MessageBox(hWnd,"Unable to set time.",OWN_CAPTION,MB_OK|MB_ICONASTERISK);
        return FALSE;
        }
    return TRUE;
    }

