// defined MAX values used by Magic Fields
#define MFMAXPATH                           140
#define MFMAXCLASS                          20
#define MFMAXNAME                           14
#define MFMAXPICTURE                        80


/*************************************************************************/
/*           DIALOG BOX PROPERTIES USED BY Magic Fields                  */
/*************************************************************************/

#define MFCTRL_MFEDIT                       0
#define MFCTRL_COMBOBOX                     1
#define MFCTRL_EDIT                         2
#define MFCTRL_LISTBOX                      3
#define MFCTRL_SCROLLBAR                    4
#define MFCTRL_STATIC                       5
#define MFCTRL_GRAYFRAME                    6
#define MFCTRL_BUTTON                       7
#define MFCTRL_PUSHBUTTON                   8
#define MFCTRL_GROUPBOX                     9
#define MFCTRL_RADIOBUTTON                  10
#define MFCTRL_CHECKBOX                     11

#define MFCTRL_MAX                          20

#define MFCBIT_GRAYCONTROL                  0x0001
#define MFCBIT_NEXTLOOKUP                   0x0002
#define MFCBIT_NEXTLOOKDOWN                 0x0004

#define MFCBIT_DLGF1HELP                    0x0001
#define MFCBIT_DLGNEXTLOOK                  0x0002

/*************************************************************************/
/* DATA TYPES & STRUCTURES USED BY Magic Fields                          */
/*************************************************************************/

typedef struct tagMFDATE
	{
    int     iYear;
    int     iMonth;
    int     iDay;
	}MFDATE;
typedef MFDATE far *LPMFDATE;


typedef struct tagMFTIME
	{
    int     iHour;
    int     iMinute;
    int     iSecond;
	}MFTIME;
typedef MFTIME far *LPMFTIME;


typedef struct tagMFNUMBER
	{
    BOOL    bNeg;
    long    lNumber;
    int     iDecInitZeros;
    long    lDecimal;
	}MFNUMBER;
typedef MFNUMBER far *LPMFNUMBER;


typedef struct tagMFDLLINFO
	{
    int     iVersion;
    BOOL    bRuntime;
    char    szPath[MFMAXPATH+1];
    char    szClass[MFMAXCLASS+1];
	}MFDLLINFO;
typedef MFDLLINFO far *LPMFDLLINFO;

typedef struct tagMFFIELDINFO
	{
    int     iFieldType;
    char    szValidationName[MFMAXNAME+1];
    char    szColorName[MFMAXNAME+1];
    char    szHelpName[MFMAXNAME+1];
    char    szPicture[MFMAXPICTURE+1];
    BOOL    bRangeChecking;
    BOOL    bTemplateValues;
    BOOL    bGlobalErrorHandling;
    BOOL    bGlobalInputMode;
    BOOL    bGlobalCustomProcessing;
    BOOL    bGlobalColor;
    char    szSetupFile[MFMAXPATH+1];
	}MFFIELDINFO;
typedef MFFIELDINFO far *LPMFFIELDINFO;


typedef struct tagMFNOTIFICATION
	{
    HWND    hField;
    WORD    message;
    WORD    wParam;
    LONG    lParam;
    DWORD   dwReturn;
    BOOL    bProcessed;
    WORD    wValidationType;
    WORD    wValidationStatus;
	}MFNOTIFICATION;
typedef MFNOTIFICATION far *LPMFNOTIFICATION;

typedef struct tagMFDLGPROPERTY
	{
    DWORD   dwSetup;
    DWORD   dwControl[MFCTRL_MAX];
	}MFDLGPROPERTY;
typedef MFDLGPROPERTY far *LPMFDLGPROPERTY;


/*************************************************************************/
/* NOTIFICATION MESSAGES FROM Magic Fields                               */
/*************************************************************************/

#define MFD_NOTIFY                          WM_USER+333

// SUB MESSAGES
#define MFN_TESTMODE                        1
#define MFN_ONLINEHELP                      2
#define MFN_MENUHELP                        3

#define MFN_VALIDATE                        10
#define MFN_POSTVALIDATE                    11

#define MFN_PROCESSMESSAGE                  20
#define MFN_PROCESSHELP                     21
#define MFN_PROCESSERROR                    22


/*************************************************************************/
/* FORMAT TYPES used by Magic Fields                                     */
/*************************************************************************/

#define MFTYPE_Custom                       0
#define MFTYPE_Date                         1
#define MFTYPE_Time                         2
#define MFTYPE_Currency                     3
#define MFTYPE_Number                       4
#define MFTYPE_Integer                      5


/*************************************************************************/
/* VALIDATION TYPES used by Magic Fields                                 */
/*************************************************************************/

#define VTYPE_F2                            1
#define VTYPE_FOCUS                         2
#define VTYPE_SPECIAL                       3
#define VTYPE_MESSAGE                       4
#define VTYPE_CR                            5
#define VTYPE_CHAR                          6
#define VTYPE_SETTEXT                       7


/*************************************************************************/
/* ERROR RETURNS USED BY Magic Fields                                    */
/*************************************************************************/

// ERRORS BELOW 100 is internal Magic Fields error

// ERROR RETURNS FOR Magic Fields API FUNCTIONS
#define MFERR_NOPARENTWINDOW                100
#define MFERR_NOFIELD                       101
#define MFERR_NOTMFIELD                     102
#define MFERR_ILLEGALFIELDTYPE              103
#define MFERR_SETTEXTSTOPPED                104
#define MFERR_ILLEGALDATA                   105
#define MFERR_NOTFIXEDSTRING                106
#define MFERR_TOOLONGNETSTRING              107
#define MFERR_TOOSHORTNETSTRING             108
#define MFERR_TOOSHORTSTRING                109
#define MFERR_TOOLONGSTRING                 110

#define MFERR_EMPTYFIELD                    120
#define MFERR_OVERFLOW                      121
#define MFERR_CHARAFTERNUMBER               122

// ERRORS BETWEEN 200 and 999 is Magic Fields format errors


// ERRORS HIGHER THAN 1000 is Magic Fields validation errors

// COMMON VALIDATION ERRORS
#define VALERR_NOSYSTEMTIME                 1000
#define VALERR_NEEDMORE                     1001
#define VALERR_ILLEGALSEPARATOR             1002
#define VALERR_PICTUREENDSTRING             1003
#define VALERR_PICTUREENDCHAR               1004
#define VALERR_CHARACTER                    1005
#define VALERR_REFORMATERROR                1006
#define VALERR_STRING                       1007
#define VALERR_EMPTYFIELD                   1008
#define VALERR_ILLEGALFORMAT                1009

// DATE VALIDATION ERRORS
#define VALERR_ILLEGALDAY                   1050
#define VALERR_ILLEGALMONTH                 1051
#define VALERR_ILLEGALYEAR                  1052

// TIME VALIDATION ERRORS
#define VALERR_ILLEGALHOUR                  1060
#define VALERR_ILLEGALMINUTE                1061
#define VALERR_ILLEGALSECOND                1062
#define VALERR_ILLEGALAMPM                  1063

// VALUE ERRORS - ILLEGAL & OUT RANGE ERRORS
#define VALERR_ILLEGALDATE                  1100
#define VALERR_SMALLDATE                    1101
#define VALERR_LARGEDATE                    1102

#define VALERR_ILLEGALTIME                  1110
#define VALERR_SMALLTIME                    1111
#define VALERR_LARGETIME                    1112

#define VALERR_ILLEGALCURRENCY              1120
#define VALERR_SMALLCURRENCY                1121
#define VALERR_LARGECURRENCY                1122

#define VALERR_ILLEGALNUMBER                1130
#define VALERR_SMALLNUMBER                  1131
#define VALERR_LARGENUMBER                  1132

#define VALERR_ILLEGALINTEGER               1140
#define VALERR_SMALLINTEGER                 1141
#define VALERR_LARGEINTEGER                 1142

#define VALERR_ILLEGALPICTURE               1150
#define VALERR_SMALLPICTURE                 1151
#define VALERR_LARGEPICTURE                 1152

#define VALERR_DECIMALOVERFLOW              1160
#define VALERR_NUMBEROVERFLOW               1161

// CUSTOM ERRORS 
#define VALERR_CUSTOMFIRST                  1200
#define VALERR_CUSTOMLAST                   1299

/*************************************************************************/
/* LIBRARY API FUNCTIONS IN Magic Fields                                 */
/*************************************************************************/

WORD FAR PASCAL MfInitMFEDIT(void);
BOOL FAR PASCAL MfGetDLLInfo(LPMFDLLINFO lpInfo);
BOOL FAR PASCAL MfSetSetupFile(HANDLE hInst,LPSTR lpPath);
BOOL FAR PASCAL MfIsMagicMessage(HWND hDlg,unsigned message,WORD wParam,LONG lParam);
BOOL FAR PASCAL MfSetDlgBoxProperty(HWND hDlg,LPMFDLGPROPERTY lpFrame);

BOOL FAR PASCAL MfGetCurrentDate(LPMFDATE lpDate);

BOOL FAR PASCAL MfGetCurrentTime(LPMFTIME lpTime);

BOOL FAR PASCAL MfIsDateLegal(LPMFDATE lpDate);
BOOL FAR PASCAL MfIsTimeLegal(LPMFTIME lpTime);
BOOL FAR PASCAL MfIsNumberLegal(LPMFNUMBER lpNumber);

int FAR PASCAL MfCompareDate(LPMFDATE lpDate1,LPMFDATE lpDate2);
int FAR PASCAL MfCompareTime(LPMFTIME lpTime1,LPMFTIME lpTime2);
int FAR PASCAL MfCompareNumber(LPMFNUMBER lpNumber1,LPMFNUMBER lpNumber2);

BOOL FAR PASCAL MfIsLeapYear(int iYear);

BOOL FAR PASCAL MfDateToString(LPMFDATE lpDate,LPSTR lpStr,int max);
BOOL FAR PASCAL MfTimeToString(LPMFTIME lpTime,LPSTR lpStr,int max);
BOOL FAR PASCAL MfCurrencyToString(LPMFNUMBER lpNumber,LPSTR lpStr,int max);
BOOL FAR PASCAL MfNumberToString(LPMFNUMBER lpNumber,LPSTR lpStr,int max);

BOOL FAR PASCAL MfIsFieldValid(HWND hDlg,int nField,LPINT lpError);
BOOL FAR PASCAL MfGetFieldInfo(HWND hDlg,int nField,LPMFFIELDINFO lpInfo,LPINT lpError);

BOOL FAR PASCAL MfGetFieldDate(HWND hDlg,int nField,LPMFDATE lpDate,LPINT lpError);
BOOL FAR PASCAL MfGetFieldTime(HWND hDlg,int nField,LPMFTIME lpTime,LPINT lpError);
BOOL FAR PASCAL MfGetFieldCurrency(HWND hDlg,int nField,LPMFNUMBER lpNumber,LPINT lpError);
BOOL FAR PASCAL MfGetFieldNumber(HWND hDlg,int nField,LPMFNUMBER lpNumber,LPINT lpError);
BOOL FAR PASCAL MfGetFieldLong(HWND hDlg,int nField,LPLONG lpLong,LPINT lpError);
BOOL FAR PASCAL MfGetFieldNetString(HWND hDlg,int nField,LPSTR lpNet,int max,LPINT lpError);

BOOL FAR PASCAL MfSetFieldDate(HWND hDlg,int nField,LPMFDATE lpDate,LPINT lpError);
BOOL FAR PASCAL MfSetFieldTime(HWND hDlg,int nField,LPMFTIME lpTime,LPINT lpError);
BOOL FAR PASCAL MfSetFieldCurrency(HWND hDlg,int nField,LPMFNUMBER lpNumber,LPINT lpError);
BOOL FAR PASCAL MfSetFieldNumber(HWND hDlg,int nField,LPMFNUMBER lpNumber,LPINT lpError);
BOOL FAR PASCAL MfSetFieldLong(HWND hDlg,int nField,LPLONG lpLong,LPINT lpError);
BOOL FAR PASCAL MfSetFieldNetString(HWND hDlg,int nField,LPSTR lpNet,LPINT lpError);

BOOL FAR PASCAL MfNumberToDouble(LPMFNUMBER lpNumber,double far *lpDouble);
BOOL FAR PASCAL MfDoubleToNumber(LPMFNUMBER lpNumber,double far *lpDouble);


