/******************************************/
/* xwinged.h                              */
/* Copyright (C) 1993 David Bollinger     */
/* A Ship Editor For Lucas Arts' X-Wing   */
/* compiled w/ Borland C++ 3.1 & TASM 2.0 */
/******************************************/

/*****************/
/* GENERAL STUFF */
/*****************/
#define SUCCESS       0               /* stuff to improve readability */
#define FAILURE       -1
#define AND           &&
#define OR            ||
#define NOT           !
#define TRUE          (0==0)
#define FALSE         (1==0)
#define DATAFILE      "flight.ovl"    /* file that has ship data */
#define SHIPOFFSET    177633L         /* where the data is within file */
#define BYTESPERSHIP  224             /* how much data per ship */
#define NUMSHIPS      17              /* how many ships */
#define NUMWEAPONS    8               /* how many weapon structure per ship */
#define NUMFIELDS     8               /* how many fields in field editor */

/*********************/
/* SCREEN LOCATIONS */
/********************/
#define DUMPX         2               /* screen column of hex dump */
#define DUMPY         10              /* screen row of hex dump */
#define DUMPTXTX      62              /* screen column of hex dump text */
#define WEAPONX       47              /* screen column of weapon display */

/*****************/
/* SCREEN COLORS */
/*****************/
#define DATACOLOR     31
#define HEXCOLOR      31
#define TEXTCOLOR     31
#define BORDERCOLOR   31
#define TITLECOLOR    32

/*****************/
/* KEYBOARD DEFs */
/*****************/
#define BKSP          8
#define TAB           9
#define ENTR          13
#define ESC           27
#define BKTB          -15
#define HOME          -71
#define UP            -72
#define PGUP          -73
#define LEFT          -75
#define RGHT          -77
#define END           -79
#define DOWN          -80
#define PGDN          -81
#define INS           -82
#define DEL           -83

/*************/
/* edit mode */
/*************/
#define HEXEDITOR     1
#define FIELDEDITOR   2
#define QUITEDITOR    3

/************************/
/* DVgets return values */
/************************/
#define STILLEDITING   0
#define NEXTFIELD     -1
#define PREVFIELD     -2
#define NEXTBLOCK     -3
#define PREVSHIP      -4
#define NEXTSHIP      -5
#define QUIT          -6

typedef unsigned char uchar;
typedef unsigned int  uint;

/*********************************************/
/* STRUCTURE OF SHIP STILL UNDER DEVELOPMENT */
/*********************************************/
struct SHIPS
   {
   uchar  shortname[3];
   uchar  unknown1[7];
   uchar  longname[24];
   uchar  unknown2[4];
   int    power;
   int    shieldsf;
   int    shieldsr;
   uchar  unknown3[2];
   int    hull;
   uchar  unknown4[2];
   int    speed;
   uchar  unknown5[16];
   uchar  filename[5];
   uchar  nulls[4];
   uchar  weapontype1[2];
   uchar  unknown6[18];
   uchar  weapontype2[8];
   uchar  unknown7[1];
   struct WEAPONS
      {                        /* imageine this as an xwing rear view: */
      int  xaxis;              /*    o\   /o      <-xaxis->        ^   */
      int  yaxis;              /*      >O<                       yaxis */
      int  zaxis;              /*    o/   \o   back-zaxis-front    V   */
      int  projectilecount;
      } weapon[NUMWEAPONS];
   uchar  unknown8[54];
   } ships[NUMSHIPS], *ship;   /* array to hold data, pointer for curship */

/********************/
/* GLOBAL VARIABLES */
/********************/
int  editmode, curship, curbyte, curnibble;

/***********************/
/* FUNCTION PROTOTYPES */
/***********************/
void Editor(void);
void HexEditor(void);
void FieldEditor(void);
void DisplayShip(void);
void PositionCursor(void);
void ChangeShip(int inc);
void ChangeByte(int inc);
void ChangeNibble(int inc);
void SaveByte(uchar c);
int  ReadShips(void);
int  WriteShips(void);
void DVprintf(int x, int y, int attr, char *fmt, ...);
void DVputs(int x, int y, int attr, char *str);
void DVputc(int x, int y, int attr, uchar chr);
int  DVgets(int x, int y, int len, char *dest);
int  DVgeti(int x, int y, int len, int *dest);
int  DVgetc(int x, int y, int len, uchar *dest);
int  dgetch(void);
void DrawScreen(void);

/**********************************/
/* BYTE DESCRIPTION ARRAY         */
/* OK, sorry I didn't load a file */
/**********************************/
char *descript[BYTESPERSHIP] =
   {"Short Name, 1 of 3",         /* 0 */
    "Short Name, 2 of 3",
    "Short Name, 3 of 3",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "Long Name, 1 of 24",         /* 10 */
    "Long Name, 2 of 24",
    "Long Name, 3 of 24",
    "Long Name, 4 of 24",
    "Long Name, 5 of 24",
    "Long Name, 6 of 24",
    "Long Name, 7 of 24",
    "Long Name, 8 of 24",
    "Long Name, 9 of 24",
    "Long Name, 10 of 24",
    "Long Name, 11 of 24",        /* 20 */
    "Long Name, 12 of 24",
    "Long Name, 13 of 24",
    "Long Name, 14 of 24",
    "Long Name, 15 of 24",
    "Long Name, 16 of 24",
    "Long Name, 17 of 24",
    "Long Name, 18 of 24",
    "Long Name, 19 of 24",
    "Long Name, 20 of 24",
    "Long Name, 21 of 24",        /* 30 */
    "Long Name, 22 of 24",
    "Long Name, 23 of 24",
    "Long Name, 24 of 24",
    "?",
    "?",
    "Damage Indicator?",
    "?",
    "Engine Power, lo",
    "Engine Power, hi",
    "Shields Forward, lo",        /* 40 */
    "Shields Forward, hi",
    "Shields Rear, lo",
    "Shields Rear, hi",
    "?",
    "?",
    "Hull, lo",
    "Hull, hi",
    "?",
    "?",
    "Speed, lo",                  /* 50 */
    "Speed, hi",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",                          /* 60 */
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "CP File Name, 1 of 5",
    "CP File Name, 2 of 5",
    "CP File Name, 3 of 5",       /* 70 */
    "CP File Name, 4 of 5",
    "CP File Name, 5 of 5",
    "Nulls",
    "Nulls",
    "Nulls",
    "Nulls",
    "Weapon Type?",
    "Weapon Type?",
    "?",
    "?",                          /* 80 */
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "Laser Link Mode?",
    "?",                          /* 90 */
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "Weapon Type?, 1 of 8",
    "Weapon Type?, 2 of 8",
    "Weapon Type?, 3 of 8",
    "Weapon Type?, 4 of 8",       /* 100 */
    "Weapon Type?, 5 of 8",
    "Weapon Type?, 6 of 8",
    "Weapon Type?, 7 of 8",
    "Weapon Type?, 8 of 8",
    "?",
    "Weapon #1, 1 of 8, x axis lo",
    "Weapon #1, 2 of 8, x axis hi",
    "Weapon #1, 3 of 8, y axis lo",
    "Weapon #1, 4 of 8, y axis hi",
    "Weapon #1, 5 of 8, z axis lo",
    "Weapon #1, 6 of 8, z axis hi",
    "Weapon #1, 7 of 8, projectile count",
    "Weapon #1, 8 of 8",
    "Weapon #2, 1 of 8, x axis lo",
    "Weapon #2, 2 of 8, x axis hi",
    "Weapon #2, 3 of 8, y axis lo",
    "Weapon #2, 4 of 8, y axis hi",
    "Weapon #2, 5 of 8, z axis lo",
    "Weapon #2, 6 of 8, z axis hi",
    "Weapon #2, 7 of 8, projectile count",
    "Weapon #2, 8 of 8",
    "Weapon #3, 1 of 8, x axis lo",
    "Weapon #3, 2 of 8, x axis hi",
    "Weapon #3, 3 of 8, y axis lo",
    "Weapon #3, 4 of 8, y axis hi",
    "Weapon #3, 5 of 8, z axis lo",
    "Weapon #3, 6 of 8, z axis hi",
    "Weapon #3, 7 of 8, projectile count",
    "Weapon #3, 8 of 8",
    "Weapon #4, 1 of 8, x axis lo",
    "Weapon #4, 2 of 8, x axis hi",
    "Weapon #4, 3 of 8, y axis lo",
    "Weapon #4, 4 of 8, y axis hi",
    "Weapon #4, 5 of 8, z axis lo",
    "Weapon #4, 6 of 8, z axis hi",
    "Weapon #4, 7 of 8, projectile count",
    "Weapon #4, 8 of 8",
    "Weapon #5, 1 of 8, x axis lo",
    "Weapon #5, 2 of 8, x axis hi",
    "Weapon #5, 3 of 8, y axis lo",
    "Weapon #5, 4 of 8, y axis hi",
    "Weapon #5, 5 of 8, z axis lo",
    "Weapon #5, 6 of 8, z axis hi",
    "Weapon #5, 7 of 8, projectile count",
    "Weapon #5, 8 of 8",
    "Weapon #6, 1 of 8, x axis lo",
    "Weapon #6, 2 of 8, x axis hi",
    "Weapon #6, 3 of 8, y axis lo",
    "Weapon #6, 4 of 8, y axis hi",
    "Weapon #6, 5 of 8, z axis lo",
    "Weapon #6, 6 of 8, z axis hi",
    "Weapon #6, 7 of 8, projectile count",
    "Weapon #6, 8 of 8",
    "Weapon #7, 1 of 8, x axis lo",
    "Weapon #7, 2 of 8, x axis hi",
    "Weapon #7, 3 of 8, y axis lo",
    "Weapon #7, 4 of 8, y axis hi",
    "Weapon #7, 5 of 8, z axis lo",
    "Weapon #7, 6 of 8, z axis hi",
    "Weapon #7, 7 of 8, projectile count",
    "Weapon #7, 8 of 8",
    "Weapon #8, 1 of 8, x axis lo",
    "Weapon #8, 2 of 8, x axis hi",
    "Weapon #8, 3 of 8, y axis lo",
    "Weapon #8, 4 of 8, y axis hi",
    "Weapon #8, 5 of 8, z axis lo",
    "Weapon #8, 6 of 8, z axis hi",
    "Weapon #8, 7 of 8, projectile count",
    "Weapon #8, 8 of 8",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
    "?",
     };

/* end of xwinged.h */
