
/***************
**
**  optimize.c
**  last revised: april 10, 1992
**
**  Optimize optimizes a dictionary by sorting it and removing all
**  multiple entries from it. Furthermore, all entries are shortened
**  to 8 or less characters.
**
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote.
**
**  Copyright (C)1992, Zabkar
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include <alloc.h>


FILE *infile;
FILE *outfile;


struct words
{
    char word[9];
    struct words *next;
};



/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Optimize version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: optimize [-r] [-f fromdict] [-o todict]\n\n"\
  "\t-r: sort in reversed order (descending). default is ascending.\n"\
  "\t-f: read from 'fromdict' instead of stdin\n"\
  "\t-o: write to 'todict' instead of stdout\n\n"\
  "no -f specified: dictfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}


/***************
 freebuf()
 freebuf erases all memory occupied by linked-list begin.
***************/

void free_buf(struct words *begin)
{
    struct words *p;

    if (begin)
    {
      p = begin;
      while (p != NULL)
      {
        p = p->next;
        free(begin);
        begin = p;
      }
    }
}



/***************
 haltmemory()
 displays out-of-memory message and stops execution.
***************/

void haltmemory(struct words *begin)
{
    free_buf(begin);

    fprintf(stderr,
    "Not enaugh memory to sort entire file, split dictionary and run\n"\
    "optimize again for all parts. Then run merge to merge files.\n");
    exit(0);
}
    


/***************
 sort()
 sorts wordfile `infile' to linked-list begin. if asc==0 then wordfile
 is sorted in descending order, otherwise in ascending order.
***************/

void *sort(FILE *infile, struct words **begin, char asc)
{
    struct words *p;
    struct words *q;
    struct words *r;
    char s[80];

    if (!(*begin = malloc(sizeof(struct words))))
       haltmemory(*begin);

    strcpy((*begin)->word, "");
    (*begin)->next = NULL;

    while (fscanf(infile, "%s", s) == 1)
    {
        if (strlen(s) > 8) s[8]='\0';
        if (!(q = malloc(sizeof(struct words))))
           haltmemory(*begin);

        p = *begin;

        if (asc)
          while ((p->next != NULL) && (strcmp(p->next->word,s) < 0))
             p = p->next;
        else
          while ((p->next != NULL) && (strcmp(p->next->word,s) > 0))
             p = p->next;     /* descending */

        r = p->next;
        p->next = q;
        strcpy(q->word, s);
        q->next = r;
    }
}



/***************
 to_file()
 writes contents of linked-list begin to file of.
***************/

void to_file(FILE *of, struct words *begin)
{
    struct words *p;

    p = begin->next;
    while (p != NULL)
    {
        fprintf(of, "%s\n", p->word);
        p = p->next;
    }
}


/***************
 remdouble()
 removes double entries from sorted linked list begin.
***************/

void remdouble(struct words *begin)
{
    struct words *p, *q;

    p = begin;
    while (p->next != NULL)
    {
        if (!strcmp(p->next->word, p->word))
        {
            q = p->next->next;
            free(p->next);
            p->next = q;
        }
        else
            p = p->next;
    }
}



/***************
 do_optimize()
 sorts file `inf' to file `of'. If asc==0 sorting is done descending,
 otherwise ascending.
***************/

void do_optimize(FILE *inf, FILE *of, char asc)
{
  struct words *begin;

  sort(inf, &begin, asc);
  remdouble(begin);
  to_file(of, begin);
  free_buf(begin);
}


/***************
 main()
 main function of optimizer.
***************/

main (char argc, char **argv)
{
  char fname[80], oname[80];
  char ascending=1;
  int i;

  strcpy(fname, "");
  strcpy(oname, "");

  if (argc > 1)
  {
    for (i=1; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                          strcpy(fname, &argv[i][2]);
                        else if (argc < (i+2))
                          haltusage();
                        else
                          strcpy(fname, argv[++i]);
                        break;
            case 'O' : if (strlen(argv[i]) > 2)
                          strcpy(oname, &argv[i][2]);
                        else if (argc < (i+2))
                           haltusage();
                        else
                           strcpy(oname, argv[++i]);
                        break;
            case 'R' : ascending = 0; break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  if (strcmp(fname,""))
    infile = fopen(fname, "rt");
  else
    infile = stdin;

  if (!infile)
    {
    fprintf(stderr, "optimize: %s: couldn't open file\n", fname);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "optimize: %s: could't create file\n", oname);
    exit(0);
    }

  do_optimize(infile, outfile, ascending);

  fclose(infile);
  fclose(outfile);

  }

/* EOF OPTIMIZE.C */
 
