
/***************
**
**  hits.c
**  last revised: april 12, 1992
**
**  hits generates a list of passwords that were cracked in earlier
**  sessions of hades. It reads a passwordlist as generated by hades
**  and scans the password-field for the '=' character. when found,
**  the rest of the field is written to the dictionary.
**
**  Usage: hits [-f resultfile] [-o outfile]
**
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote.
**
**  Copyright (C)1992, Zabkar
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include "pwd.h"


FILE *outfile;
FILE *infile;

extern FILE *_pw_file;     /* So sneaky, it could have been from CC! */
                           /* I wonder if it works under UNIX!!      */


/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Hits version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: hits [-f resultfile] [-o outfile]\n\n"\
  "\t-f: read from 'resultfile' instead of stdin\n"\
  "\t-o: write to 'outfile' instead of stdout\n\n"\
  "no -f specified: resultfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}


/***************
 createhitlist()
 creates a list of the earlier cracked passwords that are stored in
 the hades-resultfile inf and writes the list to file of.
***************/

void createhitlist(FILE *inf, FILE *of)
{
    char *word;
    struct passwd *buf;

    _pw_file = inf;
    while ((buf = getpwent()) != NULL)
    {
        word = strchr(buf->pw_passwd, '=');
        if (strlen(word) > 1)       /* chars after the '='? */
           fprintf(of, "%s\n", &word[1]);
    }
}



/***************
 main()
 main function of program hits
****************/

main(char argc, char **argv)
{
  char fname[80], oname[80];
  int i;

  strcpy(fname, "");
  strcpy(oname, "");

  if (argc > 1)
  {
    for (i=1; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                 strcpy(fname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(fname, argv[++i]);
			       break;
            case 'O' : if (strlen(argv[i]) > 2)
                 strcpy(oname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(oname, argv[++i]);
			       break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  if (strcmp(fname,""))
    infile = fopen(fname, "rt");
  else
    infile = stdin;

  if (!infile)
    {
    fprintf(stderr, "hits: %s: couldn't open file\n", fname);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "hits: %s: could't create file\n", oname);
    exit(0);
    }

  createhitlist(infile, outfile);

  fclose(infile);
  fclose(outfile);

  }

/* EOF HITS.C */

