
/***************
**
**  convert.c
**  last revised: april 14, 1992
**
**  Convert version 1.00 alpha, Copyright (C)1992 Zabkar
**  DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.
**
**  Convert converts a dictionary to all-uppercase, all-lowercase,
**  name-alike (first uppercase, rest lowercase) and/or reversed words.
**
**  Usage: convert [-c] [-l] [-1] [-r] [-n] [-f wordfile] [-o outfile]
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include "dictword.h"


FILE *outfile;
FILE *infile;


/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Convert version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: convert [-c] [-l] [-1] [-r] [-n] [-f wordfile] "\
  "[-o outfile]\n\n"\
  "\t-c: capitalize whole word\n"\
  "\t-l: lowercase whole word\n"\
  "\t-1: all lowercase, first uppercase\n"\
  "\t-r: generate all selected options reversed, too\n"\
  "\t-f: read from 'wordfile' instead of stdin\n"\
  "\t-o: write to 'outfile' instead of stdout\n\n"\
  "Use of one of the options c, l or 1 causes the normal word to disapear,\n"\
  "to have the normal form back again, add the -n switch.\n\n"\
  "no -f specified: wordfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}



/***************
 convertwords()
 converts words from file inf and writes them to file of.
****************/

void convertwords(FILE *inf, FILE *of, int mode)
{
    char word[80];
    char buffer[80];
    char dest[256];

    while (fscanf(inf, "%s", word) > 0)
    {
       strcpy(buffer, "");
       if (mode & NORMAL || mode & EXTNORMAL)
       {
          strcat(buffer, word);
          strcat(buffer, "\n");
       }

       if (mode & LOWER)
       {
          strcat(buffer, all_lower(dest, word));
          strcat(buffer, "\n");
       }

       if (mode & UPPER)
       {
          strcat(buffer, all_upper(dest, word));
          strcat(buffer, "\n");
       }

       if (mode & FIRSTUP)
       {
          strcat(buffer, first_upper(dest, word));
          strcat(buffer, "\n");
       }

       if (mode & REVERSE)
       {
          reverse(dest, buffer);    /* reverse of all the above */
          strcat(buffer, &dest[1]); /* strip leading newline */
          strcat(buffer, "\n");     /* add line-feed to end */
       }

       fprintf(of, "%s", buffer);   /* Print all words on of */
    }
}



/***************
 main()
 main function of program mailist
****************/

main(char argc, char **argv)
{
  char fname[80], oname[80];
  int i;
  int convmode = NORMAL;

  strcpy(fname, "");
  strcpy(oname, "");

  if (argc > 1)
  {
    for (i=1; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                 strcpy(fname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(fname, argv[++i]);
			       break;
            case 'O' : if (strlen(argv[i]) > 2)
                 strcpy(oname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(oname, argv[++i]);
			       break;
            case 'C': convmode |= UPPER; convmode &= ~NORMAL; break;
            case 'L': convmode |= LOWER; convmode &= ~NORMAL; break;
            case '1': convmode |= FIRSTUP; convmode &= ~NORMAL; break;
            case 'R': convmode |= REVERSE; break;
            case 'N': convmode |= EXTNORMAL; break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  if (strcmp(fname,""))
    infile = fopen(fname, "rt");
  else
    infile = stdin;

  if (!infile)
    {
    fprintf(stderr, "convert: %s: couldn't open file\n", fname);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "convert: %s: could't create file\n", oname);
    exit(0);
    }

  convertwords(infile, outfile, convmode);

  fclose(infile);
  fclose(outfile);

  }

/* EOF CONVERT.C */
