;*****************************************************************************
;*
;*  rman_dcl.lsp
;*  Copyright (C) 1991-1992 by Autodesk, Inc.
;*
;*  Permission to use, copy, modify, and distribute this software
;*  for any purpose and without fee is hereby granted, provided
;*  that the above copyright notice appears in all copies and that
;*  both that copyright notice and this permission notice appear in
;*  all supporting documentation.
;*
;*  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;*  WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;*  PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;*
;*****************************************************************************
;*****************************************************************************
;*  New PROTEUS UDD code for the RenderMan Icon menu.
;*  Larry Knott,  12-2-91
;*****************************************************************************
;------------------------------------------------------------------------------
(setq rm_dcl (load_dialog "rmmenu.dcl"))
;------------------------------------------------------------------------------
(defun C:RMMENU ()

(if (minusp rm_dcl)
   (setq rm_dcl (load_dialog "rmmenu.dcl")))
(cond
   ((minusp rm_dcl)
      (princ (strcat
            "\nThe file \"rmmenu.dcl\" was not found in your search path "
            "directories.\nCheck the installation of the Support Files "
            "and try again.")))
   ((and (null #GTSPO)
         (null (findfile "rman.lsp")))
      (unload_dialog rm_dcl)
      (setq rm_dcl -1)
      (princ (strcat
    "\nThe RenderMan \"rman.lsp\" file can't be found in your search path."
    "\nTo use RenderMan, you need AutoShade V2 with Autodesk RenderMan."
    "\nSee your AutoShade documentation for installation instructions.")))
   ((and (null #GTSPO)
         (not (load "rman.lsp" nil)))
      (princ "\nError loading \"rman.lsp\".")
      (setq #GTSPO nil))
   (T (menucmd "S=X")
      (menucmd "S=RMAN")
      (while (> (DRIVE_RMAN_DCL) 1) T)))
(princ))
;------------------------------------------------------------------------------
(defun DRIVE_RMAN_DCL (/ slides width height item1 key rslt)

(new_dialog "rmmenu" rm_dcl)
(setq slides (list   (cons "SETUP" "" )   (cons "PROP"  "")
                     (cons "ATTAC" "H")   (cons "EDIT"  "")
                     (cons "COPY"  "" )   (cons "LIST"  ""))
      width    (1- (dimx_tile "SETUP"))
      height   (1- (dimy_tile "SETUP")))
(foreach item1 slides
   (start_image (setq key (car item1)))
   (slide_image 0 0 width height (strcat "rmmenu(irm" key ")"))
   (end_image)
   (action_tile key "(setq key $key)(done_dialog 2)"))
(action_tile "RMSCAN" "(done_dialog 3)")
(action_tile "DEFAULTS" "(done_dialog 4)")
(setq rslt (start_dialog))
(cond
   ((= rslt 2) (setq key (strcat "RM" key (cdr (assoc key slides))))
               (prompt key)
               (eval (list (read (strcat "C:" key)))))
   ((= rslt 3) (C:RMSCAN))
   ((= rslt 4) (C:DEFAULTS))
   (T          (prin1)))
rslt)
;------------------------------------------------------------------------------
