;*****************************************************************************
;*
;*  ave_xmpl.lsp
;*  Copyright (C) 1992 by Autodesk, Inc.
;*
;*  Permission to use, copy, modify, and distribute this software
;*  for any purpose and without fee is hereby granted, provided
;*  that the above copyright notice appears in all copies and that
;*  both that copyright notice and this permission notice appear in
;*  all supporting documentation.
;*
;*  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;*  WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;*  PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;*
;*****************************************************************************
;*****************************************************************************
;*  Sample AutoLISP (API) routines for R12 Render.
;*  LTK - 1/92
;*****************************************************************************

;-----------------------------------------------------------------------------
;  Make sure we're loaded...
;-----------------------------------------------------------------------------
(if (/= (type C:RENDER) 'EXSUBR) (xload "averendr"))
;-----------------------------------------------------------------------------
(defun DTR (a1) (* pi (/ a1 180.0)))
(defun RTD (a1) (* 180.0 (/ a1 pi)))
;-----------------------------------------------------------------------------
;  Command-Line REPLAY
;-----------------------------------------------------------------------------
(defun C:CLREPLAY (/ prompt_str str1 temp_str)

(setq replay_ext  (cond (replay_ext) (T "tga"))
      prompt_str  (strcat "\nReplay image type "
                     (cdr (assoc replay_ext (list
                        (cons "tga" "TIf/Gif/Rnd/<TGa>: ")
                        (cons "tif" "TGa/Gif/Rnd/<TIf>: ")
                        (cons "gif" "TGa/TIf/Rnd/<Gif>: ")
                        (cons "rnd" "TGa/TIf/Gif/<Rnd>: "))))))
(initget "TGa TIff Gif Rnd")
(if (setq str1 (getkword prompt_str))
   (setq replay_ext (substr (strcase str1 T) 1 3)))

(if (not replay_name) (initget 1))
(setq temp_str    (getstring (strcat "\nReplay image name <"
                     (cond (replay_name) (""))  ">: "))
      replay_name (if (/= temp_str "") temp_str replay_name))
(c:replay replay_name replay_ext))

;-----------------------------------------------------------------------------
;  Show light names and intensities
;-----------------------------------------------------------------------------
(defun C:SHOWINTN (/ str1 str2 list1)

(foreach str1 (C:LIGHT "L")
   (setq list1 (C:LIGHT "L" str1))
   (princ (strcat "\nLight: "       (substr (strcat str1 "       ") 1 8)
                  "  Type: "        (car list1)
                  "  Intensity: "))
   (princ (caddr list1)))
(princ))

;-----------------------------------------------------------------------------
;  Convert all Pointlights to have an intensity of 0.5
;-----------------------------------------------------------------------------
(defun C:POINT_5 (/ str1 list1)

(foreach str1 (C:LIGHT "L")
   (setq list1 (C:LIGHT "L" str1))
   (if (eq (car list1) "P")
      (eval (list 'C:LIGHT "M" (cadr list1) 0.5))))
(princ))

;-----------------------------------------------------------------------------
;  Convert all Spotlight to have an intensity equal to the distance between
;  its location and target point (inverse linear falloff).
;-----------------------------------------------------------------------------
(defun C:SPOT_LINEAR (/ str1 list1 real1)

(foreach str1 (C:LIGHT "L")
   (setq list1 (C:LIGHT "L" str1))
   (if (eq (car list1) "S")
      (progn
         (setq pt1   (nth 3 list1)
               pt2   (nth 4 list1)
               real1 (distance pt1 pt2))
         (grvecs (list 256 pt1 pt2))
         (eval (list 'C:LIGHT "M" (cadr list1) real1))
         (grvecs (list 256 pt1 pt2)))))
(princ))

;-----------------------------------------------------------------------------
;  Spin a distantlight around '(0 0 0).  A routine like this could be used
;  to animate lights in R12 Render.
;-----------------------------------------------------------------------------
(defun C:CIRCULAR_DISTANT (/ str1 list1)

(setq name     "SPIN_ME"
      start    '(10.0 0.0 0.0)
      center   '(0 0 0)
      ang1     0.0
      frames   32.0
      delta    (/ 360.0 frames)
      delta_r  (DTR delta))
(command "_.ZOOM" "_C" center 22.0)
(C:LIGHT "ND" name 1.0 start center)
(setq light (entlast))
(repeat 32

   ;  Here's where a rendering to file would happen.
   ;  (C:RENDER)

   (setq start (polar center (setq ang1 (+ ang1 delta_r)) 10.0))
   (grvecs (list 256 start center))
   (command "_.ROTATE" light "" '(0 0 0) delta)
   (grvecs (list 256 start center))))

;-----------------------------------------------------------------------------
;  Attach an existing finish to the ACI of a selected entity.
;-----------------------------------------------------------------------------
(defun C:ENTACI (/ list1 str1 int1)

(while (not (member  (setq str1 (strcase (getstring "\nFinish name: ")))
                     (C:FINISH "L")))
   (princ (strcat "Cannot find finish \"" str1 "\".")))
(while (null (setq list1 (nentsel "\nSelect an entity: ")))
   (prompt "No object found."))
(setq list1 (entget (car list1))
      int1  (cond
               ((cdr (assoc 62 list1)))
               ((cdr (assoc 62 (tblsearch "layer" (cdr (assoc 8 list1))))))))
(if (C:FINISH "A" str1 int1)
   (princ (strcat "Finish \"" str1 "\" attached to ACI-" (itoa int1) ".")))
(princ))

;-----------------------------------------------------------------------------
(princ)