/********************************************************************
 * PC installer (aldsetup) control file for PageMaker 5.0  1.44mb Disks
 * Copyright (C) 1992 - 1993 Aldus Corporation.  All rights reserved.
 * Control file administrator: Dave Perkins
 ********************************************************************/

PRODUCT "PageMaker 5.0"

VERSIONREQ "2.3"

ALDUSDIRECTORY "Aldus" "AldeoDirectory" "C:\ALDEO"


/********   DBUILD SECTION  ***********/


DISK "(1)"
   {
   (C)ALDUS.'93         62,
   ALDSETUP.EXE     253616  CHECKDATE,
   PM5_144.CTL       60352,
   README.TXT           64,
   PM5.HL~          479873  "ALDUS\USENGLSH"  VITAL,
   ALDUSN00.VP~     339968  "ALDUS\USENGLSH"  VITAL,
   LEARNPM5.HL~     334811  "PM5\LEARNPM5",
   LEARNPM5.TR~      50672  "PM5\LEARNPM5"
   }


DISK "(2)"
   {
   GRAPHIC.TIF       10892,
   LOGOTYPE.TIF      10892,
   BIGTABLE.TIF      49511,
   VIATEXT.RT~        1976,
   SMLTABLE.TIF        950,
   ALDCLP5.DL~      123315  VITAL,
   ALDFS.DL~         66383  VITAL,
   ALDIM3.DL~       192816  VITAL,
   ALDVM.DL~         84302  VITAL,
   ALDWPLS.DL~      160912  VITAL,
   ALDPLS2.DL~      135968  VITAL,
   PICTWMF.DL~      103400  VITAL,
   PKWTUTOR.EX~     173488,
   PKWTUT3.DL~        4064,
   PKWTUT2.DL~        3104,
   PKWTUT1.DL~        6122,
   PRXLNGST.DL~       6144  VITAL,
   BUMPS.EXE         49848  CHECKDATE,
   TRAKVALS.BI~        730  "ALDUS\USENGLSH"  VITAL,
   PM5RES.RS~       282544  "ALDUS\USENGLSH"  VITAL,
   PM5SHORT.HL~      55596  "ALDUS\USENGLSH"  VITAL,
   ALDCLP5R.RS~      17920  "ALDUS\USENGLSH"  VITAL,
   ALDFSRES.RS~       4272  "ALDUS\USENGLSH"  VITAL,
   ALDIM3RS.RS~       5888  "ALDUS\USENGLSH"  VITAL,
   ALDUSN.BP~        32319  "ALDUS\USENGLSH"  VITAL,
   ALDUSN.MS~         1024  "ALDUS\USENGLSH"  VITAL,
   ALDUSN.NF~           63  "ALDUS\USENGLSH"  VITAL,
   ALDUSN.UD~         1024  "ALDUS\USENGLSH"  NOREPLACE,
   PANTONE.BC~       40694  "ALDUS\USENGLSH\COLOR",
   PCSG.BC~         162950  "ALDUS\USENGLSH\COLOR",
   TOYOPC.BC~        57326  "ALDUS\USENGLSH\COLOR",
   TRUMATCH.BC~     114242  "ALDUS\USENGLSH\COLOR",
   CRAYON.AC~         2748  "ALDUS\USENGLSH\COLOR",
   FOCOLTON.BC~      43286  "ALDUS\USENGLSH\COLOR",
   PANTONEE.BC~      40370  "ALDUS\USENGLSH\COLOR",
   DIC-PCN.BC~       69746  "ALDUS\USENGLSH\COLOR",
   GREYS.AC~          6841  "ALDUS\USENGLSH\COLOR",
   PCSGE.BC~        162950  "ALDUS\USENGLSH\COLOR"
   }


DISK "(3)"
   {
   (C)ALDUS.'93         62,
   PM5.EX~           22528  VITAL,
   PM5part1.12~     2334720  VITAL,
   LEARNPM5.PK~     281925,
   LEARNPM5.IC~        766,
   X7.RT~             2567,
   X1.PT~             7296,
   X2.PT~             7424,
   X3.PT~             8384,
   X4.PT~             8576,
   X5.PT~             7296,
   X9.TB~              681,
   X6.PT~            16512,
   X8.PT~             9664,
   X10.PT~           18624,
   TABLE.WM~         10138
   }


DISK "(4)"
   {
   (C)ALDUS.'93         62,
   PM5part2.12~     382848  VITAL,
   TE.EX~           274464  "PM5",
   ALDVMRES.RS~       5120  "ALDUS\USENGLSH"  VITAL,
   PRXLNGST.RS~       3072  "ALDUS\USENGLSH"  VITAL,
   CGMIMP.FL~        52912  "ALDUS\USENGLSH\FILTERS",
   EPSIMP.FL~       106507  "ALDUS\USENGLSH\FILTERS",
   CHARTIMP.P5~       9568  "ALDUS\USENGLSH\FILTERS",
   PICTIMP.FL~        6520  "ALDUS\USENGLSH\FILTERS",
   AMIIMP.P5~        16096  "ALDUS\USENGLSH\FILTERS",
   TWAINIMP.FL~      39168  "ALDUS\USENGLSH\FILTERS",
   TEIMP.FL~         68432  "ALDUS\USENGLSH\FILTERS",
   123IMP.FL~        72576  "ALDUS\USENGLSH\FILTERS",
   ADIIMP.FL~         3680  "ALDUS\USENGLSH\FILTERS",
   WPGIMP.FL~        38144  "ALDUS\USENGLSH\FILTERS",
   ASCIIEXP.FL~       2848  "ALDUS\USENGLSH\FILTERS",
   EXCELIMP.FL~      59840  "ALDUS\USENGLSH\FILTERS",
   DATETIME.TY~        296  "ALDUS\USENGLSH\FILTERS",
   DBSIMP.FL~        41168  "ALDUS\USENGLSH\FILTERS",
   DCAEXP.FL~         7952  "ALDUS\USENGLSH\FILTERS",
   PCWIMP.FL~        17036  "ALDUS\USENGLSH\FILTERS",
   RTFEXP.FL~         9312  "ALDUS\USENGLSH\FILTERS",
   MSWDIMP.FL~       42496  "ALDUS\USENGLSH\FILTERS",
   SAMAWIMP.FL~      14997  "ALDUS\USENGLSH\FILTERS",
   DXFIMP.FL~        43952  "ALDUS\USENGLSH\FILTERS",
   GEMIMP.FL~        34448  "ALDUS\USENGLSH\FILTERS",
   PCDIMP.FL~        79332  "ALDUS\USENGLSH\FILTERS",
   PCXIMP.FL~        59664  "ALDUS\USENGLSH\FILTERS",
   PM5IMP.FL~        44216  "ALDUS\USENGLSH\FILTERS",
   RTFIMP.FL~        31328  "ALDUS\USENGLSH\FILTERS",
   TEXTIMP.FL~       17360  "ALDUS\USENGLSH\FILTERS",
   WP5IMP.FL~        40960  "ALDUS\USENGLSH\FILTERS",
   TEKIMP.FL~         7160  "ALDUS\USENGLSH\FILTERS",
   TIMEIMP.FL~       18432  "ALDUS\USENGLSH\FILTERS",
   VIDSHIMP.FL~     107008  "ALDUS\USENGLSH\FILTERS",
   VPIMP.FL~        125203  "ALDUS\USENGLSH\FILTERS",
   WANGIMP.FL~        5115  "ALDUS\USENGLSH\FILTERS",
   WINWDIMP.FL~      39936  "ALDUS\USENGLSH\FILTERS",
   WMFIMP.FL~         3718  "ALDUS\USENGLSH\FILTERS",
   WNWD2IMP.FL~      47104  "ALDUS\USENGLSH\FILTERS",
   WP4IMP.FL~         7248  "ALDUS\USENGLSH\FILTERS",
   WP5EXP.FL~        11264  "ALDUS\USENGLSH\FILTERS",
   WSTRIMP.FL~       32768  "ALDUS\USENGLSH\FILTERS",
   CHREXPC.TB~        3811  "ALDUS\USENGLSH\FILTERS",
   CHRIMPC.TB~        3785  "ALDUS\USENGLSH\FILTERS",
   XY3EXP.FL~        39831  "ALDUS\USENGLSH\FILTERS",
   XY3IMP.FL~        29297  "ALDUS\USENGLSH\FILTERS",
   DCAIMP.FL~         8768  "ALDUS\USENGLSH\FILTERS",
   DECWPIMP.FL~       8690  "ALDUS\USENGLSH\FILTERS",
   DRAWIMP.FL~       26624  "ALDUS\USENGLSH\FILTERS",
   HPGLIMP.FL~       39936  "ALDUS\USENGLSH\FILTERS",
   LOTUSIMP.FL~       7680  "ALDUS\USENGLSH\FILTERS",
   MSWDEXP.FL~       17520  "ALDUS\USENGLSH\FILTERS",
   MULTIIMP.FL~       5683  "ALDUS\USENGLSH\FILTERS",
   OLIVIMP.FL~        6193  "ALDUS\USENGLSH\FILTERS",
   SCRPTSPL.TX~       4416  "ALDUS\USENGLSH\UTILITY",
   DICTED.PT~        97664  "ALDUS\USENGLSH\UTILITY",
   DICTED.EX~       379856  "ALDUS\USENGLSH\UTILITY",
   PPDSHELL.PS~      11632  "ALDUS\USENGLSH\UTILITY\PS_TOOLS"
   }


DISK "(5)"
   {
   (C)ALDUS.'93         62,
   MAI.DL~           85656  "ALDUS"  VITAL,
   NCPDLL.DL~        19892  "ALDUS"  VITAL,
   NWNETAPI.DL~     106047  "ALDUS"  VITAL,
   ALDFONTA.FO~      22512  "ALDUS"  VITAL,
   ALDFONTB.FO~      17776  "ALDUS"  VITAL,
   ALDFONTE.FO~      30896  "ALDUS"  VITAL,
   ALDFONTF.FO~      32672  "ALDUS"  VITAL,
   TE.HL~            49445  "ALDUS\USENGLSH",
   ALDWPLSR.RS~       9232  "ALDUS\USENGLSH"  VITAL,
   ALDCOLOR.AD~      67072  "ALDUS\USENGLSH\ADDITION",
   ATG.AD~          167936  "ALDUS\USENGLSH\ADDITION",
   BALANCEC.AD~      75344  "ALDUS\USENGLSH\ADDITION",
   BLDBKLT.AD~      131445  "ALDUS\USENGLSH\ADDITION",
   CONTINUE.AD~      66208  "ALDUS\USENGLSH\ADDITION",
   DINGWIN.CH~        3293  "ALDUS\USENGLSH\ADDITION",
   DROPCAP.AD~       98872  "ALDUS\USENGLSH\ADDITION",
   EDITSTOR.AD~      58144  "ALDUS\USENGLSH\ADDITION",
   EXPWIN.CH~         4900  "ALDUS\USENGLSH\ADDITION",
   HEADERS.AD~       71888  "ALDUS\USENGLSH\ADDITION",
   HOLEHOP.AD~       61196  "ALDUS\USENGLSH\ADDITION",
   HOLEINFO.AD~      83900  "ALDUS\USENGLSH\ADDITION",
   KERNING.AD~      200704  "ALDUS\USENGLSH\ADDITION",
   KERNWIN.CH~        4900  "ALDUS\USENGLSH\ADDITION",
   KEYLINER.AD~      88592  "ALDUS\USENGLSH\ADDITION",
   LISTSTYL.AD~      59376  "ALDUS\USENGLSH\ADDITION",
   NUMPARAS.AD~      80352  "ALDUS\USENGLSH\ADDITION",
   OVERSET.AD~       59672  "ALDUS\USENGLSH\ADDITION",
   PAGESORT.AD~      72569  "ALDUS\USENGLSH\ADDITION",
   PUBINFO.AD~       71252  "ALDUS\USENGLSH\ADDITION",
   RUNSCRIP.AD~      70244  "ALDUS\USENGLSH\ADDITION",
   STRYINFO.AD~      84468  "ALDUS\USENGLSH\ADDITION",
   TRACKER.AD~      146988  "ALDUS\USENGLSH\ADDITION",
   LIBLOADR.AD~      16822  "ALDUS\USENGLSH\ADDITION",
   LIBRARY.PA~      251194  "ALDUS\USENGLSH\ADDITION",
   ATG.TR~           34924  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   AVERY.AT~          7154  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   BROCHUR1.AT~      17795  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   BROCHUR2.AT~       9492  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CALENDAR.AT~       7410  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CASSLAB.AT~        1824  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CASSLINE.AT~       6475  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CDLINER.AT~        4999  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CDNOTES.AT~        3917  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   DISKETTE.AT~       3106  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   ENVELOPE.AT~       4614  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   FAX.AT~            9581  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   INVOICE.AT~        7540  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   MANUAL.AT~        57837  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   NEWSLTR2.AT~      33142  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   PURCHASE.AT~       7968  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   VHS.AT~            3709  "ALDUS\USENGLSH\ADDITION\TEMPLATE",
   CHARSET.PT~       25472  "PM5",
   CALIBRAT.PT~      39744  "PM5",
   NETWORK.TX~        9652  "PM5",
   ADDITION.TX~       9652  "PM5",
   ENABLSRV.EX~      14493  "PM5",
   TEXT.TX~            543  "PM5\TUTORIAL\EXPLORE",
   TEXT.TX~           3508  "PM5\TUTORIAL\LESSON1",
   BROC_US.PT~        5248  "PM5\TUTORIAL\LESSON2",
   BROC_INT.PT~       5504  "PM5\TUTORIAL\LESSON2",
   PKWTUTOR.IN~        571  "WINDOWS",
   ALDLEARN.DL~      27568  "WINDOWS",
   PCDLIB.DL~        83040  "WINDOWS",
   PANOSE.DA~        15930  "WINDOWS",
   TWAIN.DL~         22944  "WINDOWS"
   }


DISK "(6)"
   {
   (C)ALDUS.'93         62,
   PSCRIPT.DRV      138594,
   UNIDRV.DLL        77841,
   UNIDRV.HLP        45107,
   HPPCL5MS.DRV     113705,
   PRINTER.TXT        2608,
   OEMSETUP.INF        288,
   ALJII523.PP~      11342  "ALDUS\USENGLSH\PPD4",
   AMCHR518.PP~       9265  "ALDUS\USENGLSH\PPD4",
   AGSTDS21.PP~      18699  "ALDUS\USENGLSH\PPD4",
   AC500503.PP~      10889  "ALDUS\USENGLSH\PPD4",
   CG94_493.PP~      15893  "ALDUS\USENGLSH\PPD4",
   AGACCST1.PP~      24067  "ALDUS\USENGLSH\PPD4",
   AGACCSF1.PP~      31168  "ALDUS\USENGLSH\PPD4",
   AGPRO941.PP~      20603  "ALDUS\USENGLSH\PPD4",
   AGP94SF1.PP~      24455  "ALDUS\USENGLSH\PPD4",
   AGPR9551.PP~      20736  "ALDUS\USENGLSH\PPD4",
   AGP95SF1.PP~      24455  "ALDUS\USENGLSH\PPD4",
   AGPRS961.PP~      20808  "ALDUS\USENGLSH\PPD4",
   AGP96SF1.PP~      24521  "ALDUS\USENGLSH\PPD4",
   AGPRO971.PP~      21645  "ALDUS\USENGLSH\PPD4",
   AGP97SP1.PP~      25360  "ALDUS\USENGLSH\PPD4",
   AGP98SF1.PP~      32743  "ALDUS\USENGLSH\PPD4",
   AGPRO981.PP~      25083  "ALDUS\USENGLSH\PPD4",
   AGSELS51.PP~      25947  "ALDUS\USENGLSH\PPD4",
   AGSL5SF1.PP~      33114  "ALDUS\USENGLSH\PPD4",
   AGSELS71.PP~      26566  "ALDUS\USENGLSH\PPD4",
   AGSL7SF1.PP~      33722  "ALDUS\USENGLSH\PPD4",
   LWNT_470.PP~      11915  "ALDUS\USENGLSH\PPD4",
   LWNTX470.PP~      12049  "ALDUS\USENGLSH\PPD4",
   LWNTX518.PP~      12101  "ALDUS\USENGLSH\PPD4",
   AP_NTXJ1.PP~      15959  "ALDUS\USENGLSH\PPD4",
   APLWIIf1.PP~      14333  "ALDUS\USENGLSH\PPD4",
   APLWIIg1.PP~      14764  "ALDUS\USENGLSH\PPD4",
   APPLE380.PP~      11650  "ALDUS\USENGLSH\PPD4",
   APPLE422.PP~      11688  "ALDUS\USENGLSH\PPD4",
   APTOLLD1.PP~      21364  "ALDUS\USENGLSH\PPD4",
   APTOLD81.PP~      21294  "ALDUS\USENGLSH\PPD4",
   APTOLLW1.PP~      21806  "ALDUS\USENGLSH\PPD4",
   APPLE230.PP~      10663  "ALDUS\USENGLSH\PPD4",
   APLWNTR1.PP~      14186  "ALDUS\USENGLSH\PPD4",
   APS08522.PP~      11856  "ALDUS\USENGLSH\PPD4",
   APS80522.PP~      11494  "ALDUS\USENGLSH\PPD4",
   APS12522.PP~      10586  "ALDUS\USENGLSH\PPD4",
   APS26522.PP~      10544  "ALDUS\USENGLSH\PPD4",
   AST__470.PP~      12005  "ALDUS\USENGLSH\PPD4",
   AU108V71.PP~      23118  "ALDUS\USENGLSH\PPD4",
   AU70CV71.PP~      23898  "ALDUS\USENGLSH\PPD4",
   AU660071.PP~      16348  "ALDUS\USENGLSH\PPD4",
   AUCM_V71.PP~      30850  "ALDUS\USENGLSH\PPD4",
   CNLBP4_1.PP~      14941  "ALDUS\USENGLSH\PPD4",
   CNLBP8_1.PP~      13304  "ALDUS\USENGLSH\PPD4",
   CNLBP8R1.PP~      14274  "ALDUS\USENGLSH\PPD4",
   CNLBP8T1.PP~      13444  "ALDUS\USENGLSH\PPD4",
   CN_500_1.PP~      14158  "ALDUS\USENGLSH\PPD4",
   CN_500J1.PP~      20400  "ALDUS\USENGLSH\PPD4",
   NCOL_519.PP~      11904  "ALDUS\USENGLSH\PPD4",
   CPPMQ151.PP~      29280  "ALDUS\USENGLSH\PPD4",
   CPPMQ201.PP~      30887  "ALDUS\USENGLSH\PPD4",
   DP_US470.PP~      21780  "ALDUS\USENGLSH\PPD4",
   DPL15601.PP~      21685  "ALDUS\USENGLSH\PPD4",
   DPLZ9601.PP~      15588  "ALDUS\USENGLSH\PPD4",
   DATAP462.PP~      11572  "ALDUS\USENGLSH\PPD4",
   DCD11501.PP~      18248  "ALDUS\USENGLSH\PPD4",
   DCD21501.PP~      17776  "ALDUS\USENGLSH\PPD4",
   DCD22501.PP~      24312  "ALDUS\USENGLSH\PPD4",
   DCLPS201.PP~      22870  "ALDUS\USENGLSH\PPD4",
   DCLPS401.PP~      20450  "ALDUS\USENGLSH\PPD4",
   EPL75523.PP~      12684  "ALDUS\USENGLSH\PPD4",
   EPL3KF21.PP~      14967  "ALDUS\USENGLSH\PPD4",
   EPL3KF51.PP~      18694  "ALDUS\USENGLSH\PPD4",
   EP826051.PP~      12557  "ALDUS\USENGLSH\PPD4",
   F71RX503.PP~      11877  "ALDUS\USENGLSH\PPD4",
   GCBLPEL1.PP~      12255  "ALDUS\USENGLSH\PPD4",
   GCBLP2_1.PP~      13725  "ALDUS\USENGLSH\PPD4",
   GCBLP2S1.PP~      13727  "ALDUS\USENGLSH\PPD4",
   GCBL4921.PP~      13319  "ALDUS\USENGLSH\PPD4",
   GCBL5141.PP~      13319  "ALDUS\USENGLSH\PPD4",
   GSGL8001.PP~      11613  "ALDUS\USENGLSH\PPD4",
   HPIID522.PP~      14139  "ALDUS\USENGLSH\PPD4",
   HPIII522.PP~      13112  "ALDUS\USENGLSH\PPD4",
   HPLJ_31.PP~       14744  "ALDUS\USENGLSH\PPD4",
   HP_3D522.PP~      14926  "ALDUS\USENGLSH\PPD4",
   HPLJ_3D1.PP~      19123  "ALDUS\USENGLSH\PPD4",
   HP_3P522.PP~      13307  "ALDUS\USENGLSH\PPD4",
   HPLJ_3P1.PP~      16153  "ALDUS\USENGLSH\PPD4",
   HP3SI523.PP~      14884  "ALDUS\USENGLSH\PPD4",
   HPIIP522.PP~      12863  "ALDUS\USENGLSH\PPD4",
   HPPJXL31.PP~      19133  "ALDUS\USENGLSH\PPD4",
   IBM17523.PP~      15372  "ALDUS\USENGLSH\PPD4",
   IBM39523.PP~      16775  "ALDUS\USENGLSH\PPD4",
   IB4029B1.PP~      18363  "ALDUS\USENGLSH\PPD4",
   IB4029A1.PP~      19731  "ALDUS\USENGLSH\PPD4",
   IBM20470.PP~      18056  "ALDUS\USENGLSH\PPD4",
   IBM30505.PP~      12196  "ALDUS\USENGLSH\PPD4",
   A_PNT518.PP~      12707  "ALDUS\USENGLSH\PPD4",
   L100_425.PP~      15343  "ALDUS\USENGLSH\PPD4",
   L200_471.PP~      20804  "ALDUS\USENGLSH\PPD4",
   L200_493.PP~      20802  "ALDUS\USENGLSH\PPD4",
   L300_471.PP~      22527  "ALDUS\USENGLSH\PPD4",
   L300_493.PP~      22523  "ALDUS\USENGLSH\PPD4",
   L330_523.PP~      19023  "ALDUS\USENGLSH\PPD4",
   L3330523.PP~      35580  "ALDUS\USENGLSH\PPD4",
   L500_493.PP~      20780  "ALDUS\USENGLSH\PPD4",
   L530_523.PP~      16549  "ALDUS\USENGLSH\PPD4",
   L5330523.PP~      29399  "ALDUS\USENGLSH\PPD4",
   LH_630_1.PP~      15018  "ALDUS\USENGLSH\PPD4",
   MOIM1201.PP~      16224  "ALDUS\USENGLSH\PPD4",
   Mono_522.PP~      29826  "ALDUS\USENGLSH\PPD4",
   NCCPS401.PP~      10874  "ALDUS\USENGLSH\PPD4",
   NCCPS801.PP~      12125  "ALDUS\USENGLSH\PPD4",
   NCSW_951.PP~      13960  "ALDUS\USENGLSH\PPD4",
   NC95FAX1.PP~      18241  "ALDUS\USENGLSH\PPD4",
   NC97FAX1.PP~      18243  "ALDUS\USENGLSH\PPD4",
   NCS29901.PP~      12467  "ALDUS\USENGLSH\PPD4",
   NX_NLP_1.PP~       7731  "ALDUS\USENGLSH\PPD4",
   O5242503.PP~      11160  "ALDUS\USENGLSH\PPD4",
   OK801PF1.PP~      19362  "ALDUS\USENGLSH\PPD4",
   OL830525.PP~      13169  "ALDUS\USENGLSH\PPD4",
   OL840518.PP~      12829  "ALDUS\USENGLSH\PPD4",
   P4455514.PP~      12800  "ALDUS\USENGLSH\PPD4",
   QCS10503.PP~      10686  "ALDUS\USENGLSH\PPD4",
   QCS20503.PP~      10385  "ALDUS\USENGLSH\PPD4",
   QCS30503.PP~      10708  "ALDUS\USENGLSH\PPD4",
   QMSCS494.PP~      10708  "ALDUS\USENGLSH\PPD4",
   QMSJP461.PP~      10564  "ALDUS\USENGLSH\PPD4",
   QMSJ_461.PP~       9192  "ALDUS\USENGLSH\PPD4",
   QM1700_1.PP~      15870  "ALDUS\USENGLSH\PPD4",
   QM2000_1.PP~      14397  "ALDUS\USENGLSH\PPD4",
   Q2200523.PP~      13382  "ALDUS\USENGLSH\PPD4",
   Q2210523.PP~      13600  "ALDUS\USENGLSH\PPD4",
   Q2220523.PP~      13461  "ALDUS\USENGLSH\PPD4",
   QMPS4101.PP~      12932  "ALDUS\USENGLSH\PPD4",
   QMS8P461.PP~      11406  "ALDUS\USENGLSH\PPD4",
   QMS8_461.PP~      10035  "ALDUS\USENGLSH\PPD4",
   Q810T517.PP~      11822  "ALDUS\USENGLSH\PPD4",
   QMS81470.PP~      11153  "ALDUS\USENGLSH\PPD4",
   QM815MR1.PP~      15436  "ALDUS\USENGLSH\PPD4",
   QMPS8151.PP~      13386  "ALDUS\USENGLSH\PPD4",
   Q820T517.PP~      11862  "ALDUS\USENGLSH\PPD4",
   Q820_517.PP~      12194  "ALDUS\USENGLSH\PPD4",
   QM825MR1.PP~      15688  "ALDUS\USENGLSH\PPD4",
   QMPS8251.PP~      13633  "ALDUS\USENGLSH\PPD4",
   QUME_470.PP~      10506  "ALDUS\USENGLSH\PPD4",
   R6000505.PP~      12307  "ALDUS\USENGLSH\PPD4",
   SCG20522.PP~      32872  "ALDUS\USENGLSH\PPD4",
   S5232503.PP~      10745  "ALDUS\USENGLSH\PPD4",
   S746J522.PP~      11188  "ALDUS\USENGLSH\PPD4",
   N890_470.PP~      11522  "ALDUS\USENGLSH\PPD4",
   N890X505.PP~      12036  "ALDUS\USENGLSH\PPD4",
   N2290520.PP~      10402  "ALDUS\USENGLSH\PPD4",
   N2090522.PP~      11451  "ALDUS\USENGLSH\PPD4",
   TKPXE171.PP~      10838  "ALDUS\USENGLSH\PPD4",
   TKPXE391.PP~      12199  "ALDUS\USENGLSH\PPD4",
   TKPHZR21.PP~      13140  "ALDUS\USENGLSH\PPD4",
   TKPHZR22.PP~      13054  "ALDUS\USENGLSH\PPD4",
   TKPHZ2J1.PP~      15582  "ALDUS\USENGLSH\PPD4",
   TKPHZR31.PP~      19553  "ALDUS\USENGLSH\PPD4",
   TKPHZR32.PP~      18924  "ALDUS\USENGLSH\PPD4",
   TKPHZ3J1.PP~      22014  "ALDUS\USENGLSH\PPD4",
   T1513470.PP~      10509  "ALDUS\USENGLSH\PPD4",
   T1535470.PP~      11877  "ALDUS\USENGLSH\PPD4",
   TIm17521.PP~      14479  "ALDUS\USENGLSH\PPD4",
   TIm35521.PP~      15595  "ALDUS\USENGLSH\PPD4",
   TIx17521.PP~      14503  "ALDUS\USENGLSH\PPD4",
   TIx35521.PP~      15602  "ALDUS\USENGLSH\PPD4",
   TITRB161.PP~      16654  "ALDUS\USENGLSH\PPD4",
   TITRBO61.PP~      16651  "ALDUS\USENGLSH\PPD4",
   TITRBO91.PP~      16651  "ALDUS\USENGLSH\PPD4",
   TI08_450.PP~       9973  "ALDUS\USENGLSH\PPD4",
   UNI17521.PP~      15367  "ALDUS\USENGLSH\PPD4",
   UNI39521.PP~      16716  "ALDUS\USENGLSH\PPD4",
   U9415470.PP~      12243  "ALDUS\USENGLSH\PPD4",
   VT4L3001.PP~      80512  "ALDUS\USENGLSH\PPD4",
   VT4L3301.PP~      89168  "ALDUS\USENGLSH\PPD4",
   VT4L5001.PP~      82331  "ALDUS\USENGLSH\PPD4",
   VT4L5301.PP~      82300  "ALDUS\USENGLSH\PPD4",
   VT42P522.PP~      17102  "ALDUS\USENGLSH\PPD4",
   VT43P522.PP~      19576  "ALDUS\USENGLSH\PPD4",
   VT530522.PP~      26690  "ALDUS\USENGLSH\PPD4",
   V5334522.PP~      30262  "ALDUS\USENGLSH\PPD4",
   VT550522.PP~      13258  "ALDUS\USENGLSH\PPD4",
   VT600P1.PP~       10294  "ALDUS\USENGLSH\PPD4",
   VT60P480.PP~       9937  "ALDUS\USENGLSH\PPD4",
   VT600W1.PP~       10598  "ALDUS\USENGLSH\PPD4",
   VT49901.PP~       26634  "ALDUS\USENGLSH\PPD4",
   VT4510A1.PP~      17430  "ALDUS\USENGLSH\PPD4",
   VT4530A1.PP~      43448  "ALDUS\USENGLSH\PPD4",
   VT4530B1.PP~      32771  "ALDUS\USENGLSH\PPD4",
   VT4530C1.PP~      27304  "ALDUS\USENGLSH\PPD4",
   VT4533B1.PP~      48937  "ALDUS\USENGLSH\PPD4",
   VT4533C1.PP~      39692  "ALDUS\USENGLSH\PPD4",
   VT453EA1.PP~      44141  "ALDUS\USENGLSH\PPD4",
   VT453EB1.PP~      33443  "ALDUS\USENGLSH\PPD4",
   VT4550A1.PP~      27134  "ALDUS\USENGLSH\PPD4",
   VT4550B1.PP~      30443  "ALDUS\USENGLSH\PPD4",
   VT4550C1.PP~      27010  "ALDUS\USENGLSH\PPD4",
   VT4551A1.PP~      19236  "ALDUS\USENGLSH\PPD4",
   VT4563A1.PP~      33581  "ALDUS\USENGLSH\PPD4",
   VT4563B1.PP~      32621  "ALDUS\USENGLSH\PPD4",
   XRDOCU11.PP~      24670  "ALDUS\USENGLSH\PPD4",
   XRDT1351.PP~      24672  "ALDUS\USENGLSH\PPD4",
   XRDT0851.PP~      16519  "ALDUS\USENGLSH\PPD4",
   XRDT0901.PP~      16521  "ALDUS\USENGLSH\PPD4"
   }


/*********** DBUILD END ******************/


/*****   DIALOG & VARIABLE INITIALIZATION  *****/

INITIAL PM5Dir "C:\PM5"
	{
	"Type the name of the drive and directory where"
	"you want to install Aldus PageMaker 5.0 files."
	" "
	"If this is the directory you want, click OK."
	}


DIALOG ModPath "&Setup" "&Manual"
{
	CAPTION "Modify your system file?"
	TEXT
	{
	"The PATH statement in AUTOEXEC.BAT must include"
	"references to your Aldus PageMaker and Aldus directories"
	"in order for the program to run.  Setup can modify this"
	"file now, or you can modify it yourself after installation."
	" "
	"If you want to edit the PATH statement yourself later,"
	"click ""Manual.""  If you want Aldus Setup to modify"
	"the PATH statement, click ""Setup."""
	}
}

DIALOG PathWarning "OK" 
{
	CAPTION "Please Note!"
	TEXT
	{
	"If you receive error messages regarding missing"
	"files when you attempt to start PageMaker, it is" 
	"because your PageMaker and Aldus directories are"
	"not on your PATH."  
	""
	"To correct this, you will need to modify your" 
	"AUTOEXEC.BAT file by adding the Aldus(\ALDUS) and"
	"PageMaker (\PM5) directories to your PATH.  For"
	"additional help check the README.TXT file located"
	"in your PageMaker directory."
	}
}

DIALOG AldeoLocation "OK" "Cancel" 
{
	CAPTION "Aldus Directory Creation"
	TEXT
	{
	"Type the drive letter and subdirectory where"
	"you want to install the Aldus files.  Please"
	"use the default directory name below, so the"
	"current Aldus files aren't overwritten."
	}
}
DIALOG PrintInfo "&OK"
{
	CAPTION "Must install Drivers"
	TEXT
	{
	"The Printer Dialog will appear when you click"
	"OK.  Please install the PostScript or Universal"
	"driver from the last PageMaker 5.0 disk."
	" "
	"Note:  PageMaker 5.0 requires that one of these new"
	"drivers be installed before you can print."
	}
}

DIALOG AldusGroup "&Continue"
{
	CAPTION "Aldus Group"
	TEXT
	{
	"The Aldus Setup program has created the Aldus"
	"group window."
	" "
	"Aldus Setup, Aldus PageMaker 5.0, Table Editor and"
	"Learning PageMaker 5.0 (if installed) have been added"
	"to the Aldus Group.  Double-click the program icon to"
	"launch the program."
	}
}

DIALOG SucRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been"
	"successfully installed."
	}
}

DIALOG MoreInfo "&OK"
{
	CAPTION "Installer Diagnostics"
	TEXT
	{
	" "
	"You may now exit this program or choose to read the Aldus"
	"PageMaker 5.0 README.TXT file, which has been added to the" 
	"View menu.  You may also choose to examine other information"
	"provided from the Diagnostics or View menus in Aldus Setup."
	" "
	"Thank you for purchasing Aldus PageMaker 5.0. Your installation"
	"is complete.  Please fill out and send in your registration card."
	}
}

DIALOG SucNoRead "&OK"
{
	CAPTION "Setup complete"
	TEXT
	{
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to examine the"
	"information provided from the Diagnostics or View menu"
	"in Aldus Setup."
	}
}

DIALOG LaunchTutorial "&Yes" "&No"
{	
	CAPTION "Launch Tutorial after install?"
	TEXT
	{
	"The ALDSETUP program can automatically start the program"
	"""Learning PageMaker 5.0"" at the conclusion of the installation."
	" "
	"Click ""Yes"" to run the tutorial at the end of this install"
        "or ""NO"" to continue."
	}
}	

/*********** INITIALIZATION END *************/


/*****   PACKAGE DEFINITION SECTION *********/


PACKAGE PROLOGUE "" SELECTED INVISIBLE
{
/***** Global Variable Declarations *****/
SET ExeInstalled "FALSE"
SET MustReboot "FALSE"
SET Answer2 "&Manual"
SET Ans1 "&Manual"
SET NewFeatures "FALSE"
SET CheckAns "FALSE"
GETALDDIR AldDir AldeoLocation
GETBOOTDRIVE BootDrive
SET LearnDir "NODIR"
SET Serialize "FALSE"
SET OpenTempAns "NO"
SET TutorInstalled "FALSE"
SET RunTutorVar "&No"
GETWINDIR WinDir
GETWINSYSDIR WinSysDir
}

PACKAGE InstallEverything "Install Everything (15MB)" SELECTED
	{
	/**** Package Initializations *****/

	CONFIRMDIR PM5Dir
	SET Serialize "TRUE"
/*	SET TutorInstalled "TRUE"  */
	
	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT EngDir "COLOR" AColorDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/


	FILES AldDir     
		{
		ALDFONTB.FO~
		ALDFONTE.FO~
		ALDFONTF.FO~
		ALDFS.DL~
		ALDFONTA.FO~
		ALDPLS2.DL~
		ALDWPLS.DL~
		ALDIM3.DL~
		ALDCLP5.DL~
		NCPDLL.DL~
		MAI.DL~
		ALDVM.DL~
		PKWTUTOR.EX~
		PICTWMF.DL~
		NWNETAPI.DL~
		PRXLNGST.DL~
		PKWTUT1.DL~
		PKWTUT2.DL~
		PKWTUT3.DL~
		}

	FILES EngDir
		{
		ALDCLP5R.RS~
		PM5RES.RS~
		ALDFSRES.RS~
		ALDUSN.MS~
		ALDVMRES.RS~
		ALDUSN.UD~
		ALDUSN.NF~
		ALDUSN.BP~
		ALDUSN00.VP~
		PM5.HL~
		ALDIM3RS.RS~
		PRXLNGST.RS~
		PM5SHORT.HL~
		TE.HL~
		TRAKVALS.BI~
		ALDWPLSR.RS~
		}

	FILES SetupDir
		{
		ALDSETUP.EXE
		PM5_144.CTL
		}

	FILES AFiltDir
		{
		CGMIMP.FL~
		EPSIMP.FL~
		CHARTIMP.P5~
		PICTIMP.FL~
		AMIIMP.P5~
		TEIMP.FL~
		TWAINIMP.FL~
		123IMP.FL~
		ADIIMP.FL~
		WPGIMP.FL~
		ASCIIEXP.FL~
		EXCELIMP.FL~
		DATETIME.TY~
		DBSIMP.FL~
		DCAEXP.FL~
		PCWIMP.FL~
		RTFEXP.FL~
		MSWDIMP.FL~
		SAMAWIMP.FL~
		DXFIMP.FL~
		GEMIMP.FL~
		PCDIMP.FL~
		PCXIMP.FL~
		PM5IMP.FL~
		RTFIMP.FL~
		TEXTIMP.FL~
		WP5IMP.FL~
		TEKIMP.FL~
		TIMEIMP.FL~
		VIDSHIMP.FL~
		VPIMP.FL~
		WANGIMP.FL~
		WINWDIMP.FL~
		WMFIMP.FL~
		WNWD2IMP.FL~
		WP4IMP.FL~
		WP5EXP.FL~
		WSTRIMP.FL~
		CHREXPC.TB~
		CHRIMPC.TB~
		XY3EXP.FL~
		XY3IMP.FL~
		DCAIMP.FL~
		DECWPIMP.FL~
		DRAWIMP.FL~
		HPGLIMP.FL~
		LOTUSIMP.FL~
		MSWDEXP.FL~
		MULTIIMP.FL~
		OLIVIMP.FL~
		}

	FILES AColorDir
		{
		PANTONE.BC~
		PCSG.BC~
		TOYOPC.BC~
		TRUMATCH.BC~
		CRAYON.AC~
		FOCOLTON.BC~
		PANTONEE.BC~
		DIC-PCN.BC~
		GREYS.AC~
		PCSGE.BC~
		}

	FILES AADDitionDir
		{
		DROPCAP.AD~
		BLDBKLT.AD~
		RUNSCRIP.AD~
		ALDCOLOR.AD~
		CONTINUE.AD~
		EDITSTOR.AD~
		HOLEHOP.AD~
		HOLEINFO.AD~
		LISTSTYL.AD~
		NUMPARAS.AD~
		OVERSET.AD~
		PUBINFO.AD~
		STRYINFO.AD~
		LIBLOADR.AD~
		LIBRARY.PA~ 
		BALANCEC.AD~
		HEADERS.AD~
		DINGWIN.CH~
		EXPWIN.CH~
		KERNING.AD~
		KERNWIN.CH~
		ATG.AD~
		TRACKER.AD~
		PAGESORT.AD~
		KEYLINER.AD~
		}

	FILES TemplateDir
		{
		ATG.TR~
		AVERY.AT~
		BROCHUR1.AT~
		BROCHUR2.AT~
		CALENDAR.AT~
		CASSLAB.AT~
		CASSLINE.AT~
		CDLINER.AT~
		CDNOTES.AT~
		DISKETTE.AT~
		ENVELOPE.AT~
		FAX.AT~
		INVOICE.AT~
		MANUAL.AT~
/*		NEWSLTR1.AT~ */
		NEWSLTR2.AT~
		PURCHASE.AT~
		VHS.AT~
		}

	FILES AUtilDir
		{
		DICTED.PT~
		SCRPTSPL.TX~
		DICTED.EX~
		}

	FILES PSTDir
		{
		PPDSHELL.PS~
		}
	
	FILES PM5Dir
		{
		CALIBRAT.PT~
		ADDITION.TX~
		NETWORK.TX~
		README.TXT
		TE.EX~
		CHARSET.PT~
		ENABLSRV.EX~
		PM5.EX~
		PM5PART1.12~
		PM5PART2.12~
		}

	FILES LearnDir
		{
		LEARNPM5.HL~
		X2.PT~
		LEARNPM5.PK~
		X3.PT~
		X4.PT~
		X5.PT~
		X6.PT~
		X7.RT~
		X8.PT~
		X9.TB~
		LEARNPM5.TR~
		X1.PT~
		TABLE.WM~
		LEARNPM5.IC~
		X10.PT~
		}

	FILES TutExpDir
		{
		GRAPHIC.TIF
		TEXT.TX~
		}
	FILES TutLess1Dir
		{
		LOGOTYPE.TIF
		TEXT.TX~
		}

	FILES TutLess2Dir
		{
		BROC_US.PT~
		BROC_INT.PT~
		SMLTABLE.TIF
		VIATEXT.RT~
		BIGTABLE.TIF
		}		  

	FILES WinDir
		{
		ALDLEARN.DL~
	   	PKWTUTOR.IN~	
		PCDLIB.DL~
		PANOSE.DA~
		TWAIN.DL~
		}			    

	/**** end File Subdirectory Assignments ****/

	SELECT1 "Select Printer Devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the Printer Files you wish to install:"
			}
		ITEMS
			{
			S5232503.PP~	"5253 Color PostScript Printer",
			CG94_493.PP~	"9400PS",
			ALJII523.PP~	"Adobe LaserJet II Cartridge",
			AGSTDS21.PP~	"AGFA StudioSet2000",
			AGACCST1.PP~	"AGFA_AccuSet v52.3",
			AGACCSF1.PP~	"AGFA_AccuSetSF v52.3",
			AGPRO941.PP~	"AGFA_ProSet9400 v52.3",
			AGP94SF1.PP~	"AGFA_ProSet9400SF v52.3",
			AGPR9551.PP~	"AGFA_ProSet9550 v52.3",
			AGP95SF1.PP~	"AGFA_ProSet9550SF v52.3",
			AGPRS961.PP~	"AGFA_ProSet9600 v52.3",
			AGP96SF1.PP~	"AGFA_ProSet9600SF v52.3",
			AGPRO971.PP~	"AGFA_ProSet9700 v52.3",
			AGP97SP1.PP~	"AGFA_ProSet9700SF v52.3",
			AGP98SF1.PP~	"AGFA_ProSet9800SF v52.3",
			AGPRO981.PP~	"AGFA_ProSet9800 v52.3",
			AGSELS51.PP~	"AGFA_SelectSet5000 v52.3",
			AGSL5SF1.PP~	"AGFA_SelectSet5000SF v52.3",
			AGSELS71.PP~	"AGFA_SelectSet7000 v52.3",
			AGSL7SF1.PP~	"AGFA_SelectSet7000SF v52.3",
			APS08522.PP~	"APS-PS PIP with APS-6-108",
			APS80522.PP~	"APS-PS PIP with APS-6-80",
			APS12522.PP~	"APS-PS PIP with LZR 1200",
			APS26522.PP~	"APS-PS PIP with LZR 2600",
			AU108V71.PP~	"Autologic APS-6/108c v52.3",
			AU70CV71.PP~	"Autologic APS-6/70c v52.3",
			AU660071.PP~	"Autologic APS-6600 v52.3",
			AUCM_V71.PP~	"Autologic APS-ColorMaster v52.3",
			GCBLPEL1.PP~	"BLP Elite",
			GCBLP2_1.PP~	"BLP II",
			GCBLP2S1.PP~	"BLP IIS",
			CN_500_1.PP~	"Canon PS-IPU Color Laser Copier",
			CN_500J1.PP~	"CnonPS-IPUKanjiColorLaserCopier",
			S746J522.PP~	"CHC-746PSJ",
			NCOL_519.PP~	"Colormate PS",
			NCCPS401.PP~	"Colormate PS40",
			NCCPS801.PP~	"Colormate PS80",
			CPPMQ151.PP~	"COMPAQ PAGEMARQ 15 v2012.015",
			CPPMQ201.PP~	"COMPAQ PAGEMARQ 20 v2012.015",
			DP_US470.PP~	"Dataproducts LZR 1260",
			DATAP462.PP~	"Dataproducts LZR 2665",
			DCD11501.PP~	"Digital DEClaser 1150 v51.4",
			DCD21501.PP~	"Digital DEClaser 2150 v51.4",
			DCD22501.PP~	"Digital DEClaser 2250 v51.4",
			DCLPS201.PP~	"Digital PrintServer 20 v48.3",
			DCLPS401.PP~	"DigitalPrintServer40 Plus v48.3",
			EPL75523.PP~	"EPSON EPL-7500",
			EPL3KF21.PP~	"EPSON LP-3000PS F2",
			EPL3KF51.PP~	"EPSON LP-3000PS F5",
			EP826051.PP~	"EPSON PostScript CARD",
			O5242503.PP~	"G5242-PS",
			GCBL4921.PP~	"GCC Business LaserPrinter v49.2",
			GCBL5141.PP~	"GCC Business LaserPrinter v51.4",
			HPIID522.PP~	"HP LaserJet IID v52.2",
			HPIII522.PP~	"HP LaserJet III v52.2",
			HPLJ_31.PP~	"HP LaserJet III v2010.118",
			HP_3D522.PP~	"HP LaserJet IIID v52.2",
			HPLJ_3D1.PP~	"HP LaserJet IIID v2010.118",
			HP_3P522.PP~	"HP LaserJet IIIP v52.2",
			HPLJ_3P1.PP~	"HP LaserJet IIIP v2010.118",
			HP3SI523.PP~	"HP LaserJet IIISi",
			HPIIP522.PP~	"HP LaserJet IIP v52.2",
			HPPJXL31.PP~	"HP PaintJet XL300 v2011.112",
			IBM17523.PP~	"IBM 4019 17 fonts",
			IBM39523.PP~	"IBM 4019 39 fonts",
			IB4029B1.PP~	"IBM LaserPrinter 4029 17 fonts",
			IB4029A1.PP~	"IBM LaserPrinter 4029 39 fonts",
			IBM20470.PP~	"IBM Personal Pageprinter",
			IBM30505.PP~	"IBM Personal Page Printer II",
			APPLE230.PP~	"LaserWriter",
			LWNT_470.PP~	"LaserWriter II NT",
			LWNTX470.PP~	"LaserWriter II NTX v47.0",
			LWNTX518.PP~	"LaserWriter II NTX v51.8",
			AP_NTXJ1.PP~	"LaserWriter II NTX v50.5",
			APLWIIf1.PP~	"LaserWriter IIf v2010.113",
			APLWIIg1.PP~	"LaserWriter IIg v2010.113",
			A_PNT518.PP~	"LaserWriter Personal NT",
			APLWNTR1.PP~	"LaserWriter Personal NTR",
			APPLE380.PP~	"LaserWriter Plus v38.0",
			APPLE422.PP~	"LaserWriter Plus v42.2",
			APTOLLD1.PP~	"LaserWriter Pro 600 v2010.130 4",
			APTOLD81.PP~	"LaserWriter Pro 600 v2010.130 8",
			APTOLLW1.PP~	"LaserWriter Pro 630 v2010.130",
			CNLBP8_1.PP~	"LBP-8III-PS",
			CNLBP8R1.PP~	"LBP-8IIIR-PS",
			CNLBP8T1.PP~	"LBP-8IIIT-PS",
			L100_425.PP~	"Linotronic 100",
			L200_471.PP~	"Linotronic 200 v47.1",
			L200_493.PP~	"Linotronic 200 v49.3",
			L300_471.PP~	"Linotronic 300 v47.1",
			L300_493.PP~	"Linotronic 300 v49.3",
			L330_523.PP~	"Linotronic 330 v52.3",
			L3330523.PP~	"Linotronic 330-RIP 30 v52.3",
			L500_493.PP~	"Linotronic 500 v49.3",
			L530_523.PP~	"Linotronic 530 v52.3",
			L5330523.PP~	"Linotronic 530-RIP 30 v52.3",
			LH_630_1.PP~	"Linotronic 630 v52.3",
			DPL15601.PP~	"LZR 1560",
			DPLZ9601.PP~	"LZR 960",
			P4455514.PP~	"Matsushita Laser Partner",
			TITRB161.PP~	"microLaser16 Turbo",
			TITRBO61.PP~	"microLaser6 Turbo",
			TITRBO91.PP~	"microLaser9 Turbo",
			OK801PF1.PP~	"ML801PS+F",
			MOIM1201.PP~	"Monotype ImageMaster 1200",
			Mono_522.PP~	"Monotype Imagesetter v52.2",
			NC95FAX1.PP~	"NEC Silentwriter 95 v2011.111",
			NC97FAX1.PP~	"NEC Silentwriter 97 v2011.111",
			NX_NLP_1.PP~	"NeXT B&W Level 1 Laser Printer",
			OL830525.PP~	"OL830",
			OL840518.PP~	"OL840",
			TI08_450.PP~	"OmniLaser",
			TKPXE171.PP~	"Phaser II PXe 17 fonts",
			TKPXE391.PP~	"Phaser II PXe 39 fonts",
			TKPHZR21.PP~	"Phaser II PXi v2010.116",
			TKPHZR22.PP~	"Phaser II PXi v2011.108",
			TKPHZ2J1.PP~	"Phaser II PXiJ v2011.108",
			TKPHZR31.PP~	"Phaser III PXi v2010.116",
			TKPHZR32.PP~	"Phaser III PXi v2011.108",
			TKPHZ3J1.PP~	"Phaser III PXiJ v2011.108",
			AMCHR518.PP~	"PRISMA",
			QMSJ_461.PP~	"PS Jet",
			QMSJP461.PP~	"PS Jet+",
			AST__470.PP~	"PS-R4081",
			QCS10503.PP~	"QMS ColorScript 100 Model 10",
			QCS20503.PP~	"QMS ColorScript 100 Model 20",
			QCS30503.PP~	"QMS ColorScript 100 Model 30",
			QMSCS494.PP~	"QMS ColorScript 100 v49.4",
			QM1700_1.PP~	"QMS-PS 1700",
			QM2000_1.PP~	"QMS-PS 2000",
			Q2200523.PP~	"QMS-PS 2200",
			Q2210523.PP~	"QMS-PS 2210",
			Q2220523.PP~	"QMS-PS 2220",
			QMPS4101.PP~	"QMS-PS 410",
			QMS8P461.PP~	"QMS-PS 800+",
			QMS8_461.PP~	"QMS-PS 800",
			QMS81470.PP~	"QMS-PS 810",
			Q810T517.PP~	"QMS-PS 810 Turbo",
			QMPS8151.PP~	"QMS-PS 815",
			QM815MR1.PP~	"QMS-PS 815 MR",
			Q820_517.PP~	"QMS-PS 820",
			Q820T517.PP~	"QMS-PS 820 Turbo",
			QMPS8251.PP~	"QMS-PS 825",
			QM825MR1.PP~	"QMS-PS 825 MR",
			QUME_470.PP~	"Qume ScripTEN",
			R6000505.PP~	"Ricoh PC Laser 6000/PS",
			F71RX503.PP~	"RX7100PS",
			SCG20522.PP~	"Scantext",
			GSGL8001.PP~	"Scout-P800",
			CNLBP4_1.PP~	"ScriptCard PS-2",
			N890_470.PP~	"Silentwriter",
			NCSW_951.PP~	"SilentWriter 95",
			N890X505.PP~	"Silentwriter XL",
			N2290520.PP~	"Silentwriter2",
			N2090522.PP~	"Silentwriter2 90",
			NCS29901.PP~	"Silentwriter2 990",
			AC500503.PP~	"TabScript C500",
			T1513470.PP~	"TI 2115 13 fonts",
			T1535470.PP~	"TI 2115 35 fonts",
			TIm17521.PP~	"TI microLaser PS17",
			TIm35521.PP~	"TI microLaser PS35",
			TIx17521.PP~	"TI microLaser XL PS17",
			TIx35521.PP~	"TI microLaser XL PS35",
			UNI17521.PP~	"UNISYS AP9210 17 Fonts",
			UNI39521.PP~	"UNISYS AP9210 39 Fonts",
			U9415470.PP~	"UNISYS AP9415",
			VT4L3001.PP~	"Varityper 4000-L300 v52.3",
			VT4L3301.PP~	"Varityper 4000-L330 v52.3",
			VT4L5001.PP~	"Varityper 4000-L500 v52.3",
			VT4L5301.PP~	"Varityper 4000-L530 v52.3",
			VT42P522.PP~	"Varityper 4200B-P",
			VT43P522.PP~	"Varityper 4300P",
			VT530522.PP~	"Varityper Series 4000-5300",
			V5334522.PP~	"Varityper Series 4000-5330",
			VT550522.PP~	"Varityper Series 4000-5500",
			VT600P1.PP~	"Varityper VT-600",
			VT60P480.PP~	"Varityper VT-600P v48.0",
			VT600W1.PP~	"Varityper VT-600W",
			VT49901.PP~	"Varityper VT4990 v52.3",
			VT4510A1.PP~	"Varityper VT4_510A v52.3",
			VT4530A1.PP~	"Varityper VT4_530A v52.3",
			VT4530B1.PP~	"Varityper VT4_530B v52.3",
			VT4530C1.PP~	"Varityper VT4_530C v52.3",
			VT4533B1.PP~	"Varityper VT4_533B v52.3",
			VT4533C1.PP~	"Varityper VT4_533C v52.3",
			VT453EA1.PP~	"Varityper VT4_53EA v52.3",
			VT453EB1.PP~	"Varityper VT4_53EB v52.3",
			VT4550A1.PP~	"Varityper VT4_550A v52.3",
			VT4550B1.PP~	"Varityper VT4_550B v52.3",
			VT4550C1.PP~	"Varityper VT4_550C v52.3",
			VT4551A1.PP~	"Varityper VT4_551A v52.3",
			VT4563A1.PP~	"VT4_563A v52.3",
			VT4563B1.PP~	"VT4_563B v52.3",
			XRDOCU11.PP~	"Xerox DocuTech",
			XRDT1351.PP~	"Xerox DocuTech 135 v2010.130",
			XRDT0851.PP~	"Xerox DocuTech 85 v2010.130",
			XRDT0901.PP~	"Xerox DocuTech 90 v2010.130"
			}
		HELP
			{
			"Help text for PPD selection needed from"
			"documentation."
			}

		}  /**** end select ppds  ***/	


	/**** INI Initializations ****/

	CONCAT PM5Dir "pm5.exe ^.pt5" PT5_ExtText
	CONCAT PM5Dir "pm5.exe ^.pm5" PM5_ExtText
	CONCAT PM5Dir "te.exe ^.tbl"  TE_ExtText


	/**** INI Settings ****/

	ALDUSINI
		{
		"ATG" "Templates" TemplateDir,
		"Bullets" "Bullet1" "176,12,18,Times New Roman",
		"Bullets" "Bullet2" "176,14,18,Times New Roman",
		"Bullets" "Bullet3" "149,12,18,Times New Roman",
		"Bullets" "Bullet4" "181,18,2,Wingdings",
		"Bullets" "Bullet5" "168,14,18,Symbol",
		"PageMaker5" "Maximize" "1",	      
		"PageMaker5" "ListVectors" "0",
		"PageMaker5" "SlideTimer" "2",
		"PageMaker5" "Color" "1",
		"PageMaker5" "RGBShade" "1",
		"PageMaker5" "ColorBitmaps" "0",
		"PageMaker5" "StyleBar" "1",
		"PageMaker5" "DisplayMarks" "0",
		"PageMaker5" "LearnPM5" LearnDir
		} 

	WININI
		{
		"Aldus" "AldeoDirectory" AldDir,
/*		"Aldus" "AldusDirectory" AldDir,	  */
/*		"Aldus" "NetAldusDirectory" "NONE",	  */
		"Aldus" "NetAldeoDirectory" "NONE",
		"Aldus" "PPD4" APPD4Dir,
		"Aldus"	"PM5LangDir" "USENGLSH",
		"Extensions" "pt5" PT5_ExtText,
		"Extensions" "pm5" PM5_ExtText,
		"Extensions" "tbl" TE_ExtText,
		"Extensions" "HLP" "WINHELP.EXE ^.hlp"
		}

	/*** Oninstall initializations ***/

	SET NewFeatures "TRUE"
	SET ExeInstalled "TRUE"
	SET MustReboot "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
	CONCAT PM5Dir "PM5.exe" FullPMName
	CONCAT PM5Dir "te.exe" TableEditorName		    
	CONCAT LearnDir "learnpm5.hlp" LearnTutorName
	CONCAT LearnDir "learnpm5.ico" LearnIconName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		ASSEMBLE "PM5APP.EXE"
			{
			PM5PART1.12~
			PM5PART2.12~
			}		      

		PERSONALIZE EngDir "PM5RES.RSL"

		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullPMName "Aldus PageMaker 5.0 B5" FullPMName 0
		ADDPROGRAMITEM "Aldus" TableEditorName "Table Editor 2.1" TableEditorName 0  
		ADDPROGRAMITEM "Aldus" LearnTutorName "Learning PageMaker 5.0" LearnIconName 0	

		DISPLAY AldusGroup

		WINDOWSMENU PM5Dir "README.TXT" "&README.TXT" 


/*  THIS SHOULD NOT BE NEEDED NOW
		DISPLAY ModPath Ans1

		IF Ans1 EQS "&Setup"
			{			   
			MODIFY "AUTOEXEC.BAT" BootDrive
				{
				PATH "path" PM5Dir
				PATH "path" AldDir	   
				}
			}  
*/

		}	/** End Oninstall **/

	}	/***** END PageMaker Easy Install *****/


PACKAGE BlankLine "----------------------------------------------------" UNSELECTED
{
/*  For testing purposes

	CONFIRMDIR PM5Dir

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT EngDir "COLOR" AColorDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir
	CONCAT LearnDir "learnpm5.hlp" LearnTutorName

SET TutorInstalled "TRUE"
SET RunTutorVar "&Yes"
*/

SET Fred "Barney"
}

PACKAGE PageMaker "PageMaker 5.0 (7MB)" UNSELECTED
	{
	/**** Package Initializations *****/

	CONFIRMDIR PM5Dir
	SET Serialize "TRUE"

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "SETUP" SetupDir
	CONCAT EngDir "FILTERS" AFiltDir
	CONCAT EngDir "COLOR" AColorDir
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir
	CONCAT EngDir "PPD4" APPD4Dir
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/


	FILES AldDir     
		{
		ALDFONTB.FO~
		ALDFONTE.FO~
		ALDFONTF.FO~
		ALDFS.DL~
		ALDFONTA.FO~
		ALDPLS2.DL~
		ALDWPLS.DL~
		ALDIM3.DL~
		ALDCLP5.DL~
		NCPDLL.DL~
		MAI.DL~
		ALDVM.DL~
		PCDLIB.DL~
		PICTWMF.DL~
		NWNETAPI.DL~
		PRXLNGST.DL~
		}

	FILES EngDir
		{
		ALDCLP5R.RS~
		PM5RES.RS~
		ALDFSRES.RS~
		ALDUSN.MS~
		ALDVMRES.RS~
		ALDUSN.UD~
		ALDUSN.NF~
		ALDUSN.BP~
		ALDUSN00.VP~
		PM5.HL~
		ALDIM3RS.RS~
		PRXLNGST.RS~
		PM5SHORT.HL~
		TE.HL~
		TRAKVALS.BI~
		ALDWPLSR.RS~
		}

	FILES SetupDir
		{
		ALDSETUP.EXE
		PM5_144.CTL
		}

	FILES AFiltDir
		{
		ASCIIEXP.FL~
		RTFIMP.FL~
		TEXTIMP.FL~
		}

	FILES AColorDir
		{
		PANTONE.BC~
		PCSG.BC~
		TOYOPC.BC~
		TRUMATCH.BC~
		CRAYON.AC~
		FOCOLTON.BC~
		PANTONEE.BC~
		DIC-PCN.BC~
		GREYS.AC~
		PCSGE.BC~
		}

	FILES AADDitionDir
		{
		LIBRARY.PA~
		LIBLOADR.AD~
		ATG.AD~
		}

	FILES TemplateDir
		{
		ATG.TR~
		AVERY.AT~
		BROCHUR1.AT~
		BROCHUR2.AT~
		CALENDAR.AT~
		CASSLAB.AT~
		CASSLINE.AT~
		CDLINER.AT~
		CDNOTES.AT~
		DISKETTE.AT~
		ENVELOPE.AT~
		FAX.AT~
		INVOICE.AT~
		MANUAL.AT~
/*		NEWSLTR1.AT~ */
		NEWSLTR2.AT~
		PURCHASE.AT~
		VHS.AT~
		}

	FILES APPD4Dir
		{
		LWNT_470.PP~
		}

	FILES AUtilDir
		{
		DICTED.PT~
		SCRPTSPL.TX~
		DICTED.EX~
		}

	FILES PSTDir
		{
		PPDSHELL.PS~
		}

	FILES PM5Dir
		{
		CALIBRAT.PT~
		ADDITION.TX~
		NETWORK.TX~
		README.TXT
		TE.EX~
		CHARSET.PT~
		ENABLSRV.EX~
		PM5.EX~
		PM5PART1.12~
		PM5PART2.12~
		}

	FILES WinDir
		{
		PCDLIB.DL~
		TWAIN.DL~
		PANOSE.DA~
		}

	/**** end File Subdirectory Assignments ****/


	/**** INI Initializations ****/

	CONCAT PM5Dir "pm5.exe ^.pt5" PT5_ExtText
	CONCAT PM5Dir "pm5.exe ^.pm5" PM5_ExtText
	CONCAT PM5Dir "te.exe ^.tbl"  TE_ExtText

	/**** INI Settings ****/

	ALDUSINI
		{
		"Bullets" "Bullet1" "176,12,18,Times New Roman",
		"Bullets" "Bullet2" "176,14,18,Times New Roman",
		"Bullets" "Bullet3" "149,12,18,Times New Roman",
		"Bullets" "Bullet4" "181,18,2,Wingdings",
		"Bullets" "Bullet5" "168,14,18,Symbol",
		"PageMaker5" "Maximize" "1",	      
		"PageMaker5" "ListVectors" "0",
		"PageMaker5" "SlideTimer" "2",
		"PageMaker5" "Color" "1",
		"PageMaker5" "RGBShade" "1",
		"PageMaker5" "ColorBitmaps" "0",
		"PageMaker5" "StyleBar" "1",
		"PageMaker5" "DisplayMarks" "0"
		} 

	WININI
		{
		"Aldus" "AldeoDirectory" AldDir,
/*		"Aldus" "AldusDirectory" AldDir,	  */
/*		"Aldus" "NetAldusDirectory" "NONE",	  */
		"Aldus" "NetAldeoDirectory" "NONE",
		"Aldus"	"PM5LangDir" "USENGLSH",
		"Aldus" "PPD4" APPD4Dir,
		"Extensions" "pt5" PT5_ExtText,
		"Extensions" "pm5" PM5_ExtText,
		"Extensions" "tbl" TE_ExtText,
		"Extensions" "HLP" "WINHELP.EXE ^.hlp"
		}


	/*** Oninstall initializations ***/

	SET NewFeatures "TRUE"
	SET ExeInstalled "TRUE"
	SET MustReboot "TRUE"
	CONCAT SetupDir "aldsetup.exe /I" FullInstallerName
	CONCAT PM5Dir "PM5.exe" FullPMName
	CONCAT PM5Dir "te.exe" TableEditorName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		ASSEMBLE "PM5APP.EXE"
			{
			PM5PART1.12~
			PM5PART2.12~
			}		      

		PERSONALIZE EngDir "PM5RES.RSL"

		ADDPROGRAMITEM "Aldus" FullInstallerName "Aldus Setup" FullInstallerName 0
		ADDPROGRAMITEM "Aldus" FullPMName "Aldus PageMaker 5.0 B5" FullPMName 0
		ADDPROGRAMITEM "Aldus" TableEditorName "Table Editor 2.1" TableEditorName 0 

		DISPLAY AldusGroup

		WINDOWSMENU PM5Dir "README.TXT" "&README.TXT" 

/*  THIS SHOULD NOT BE NEEDED NOW
		DISPLAY ModPath Ans1
 
		GETBOOTDRIVE BootDrive
		IF Ans1 EQS "&Setup"
			{			   
			MODIFY "AUTOEXEC.BAT" BootDrive
				{
				PATH "path" PM5Dir
				PATH "path" AldDir	   
				}
			}
*/

		}	/** End Oninstall **/

	}	/***** END PageMaker *****/


PACKAGE Tutorial "Tutorial (2MB)" UNSELECTED
	{
	/**** Package Initializations *****/
	CONFIRMDIR PM5Dir
/*	SET TutorInstalled "TRUE" */

	CONCAT PM5Dir "LEARNPM5" LearnDir
	CONCAT PM5Dir "tutorial" TutRootDir
	CONCAT TutRootDir "explore" TutExpDir
	CONCAT TutRootDir "LESSON1" TutLess1Dir
	CONCAT TutRootDir "LESSON2" TutLess2Dir

	/**** File Subdirectory Assignments *****/

	FILES AldDir     
		{
		PKWTUTOR.EX~
		PKWTUT1.DL~
		PKWTUT2.DL~
		PKWTUT3.DL~
		}

	FILES LearnDir
		{
		LEARNPM5.HL~
		X2.PT~
		LEARNPM5.PK~
		X3.PT~
		X4.PT~
		X5.PT~
		X6.PT~
		X7.RT~
		X8.PT~
		X9.TB~
		LEARNPM5.TR~
		X1.PT~
		TABLE.WM~
		LEARNPM5.IC~
		X10.PT~
		}

	FILES TutExpDir
		{
		GRAPHIC.TIF
		TEXT.TX~
		}
	FILES TutLess1Dir
		{
		LOGOTYPE.TIF
		TEXT.TX~
		}

	FILES TutLess2Dir
		{
		BROC_US.PT~
		BROC_INT.PT~
		SMLTABLE.TIF
		VIATEXT.RT~
		BIGTABLE.TIF
		}		  

	FILES WinDir
		{
		ALDLEARN.DL~
	   	PKWTUTOR.IN~	
		}			    

	/**** INI Settings ****/

	ALDUSINI
		{
		"PageMaker5" "LearnPM5" LearnDir
		}

	/*** Oninstall initializations ***/

	CONCAT LearnDir "learnpm5.hlp" LearnTutorName
	CONCAT LearnDir "learnpm5.ico" LearnIconName

	/**** Oninstall Commands ******/

	ONINSTALL
		{
		ADDPROGRAMITEM "Aldus" LearnTutorName "Learning PageMaker 5.0" LearnIconName 0	
		}

	}	/***** END Tutorial *****/


PACKAGE Filters "Filters (2MB)" UNSELECTED
	{
	/**** Package Initializations *****/

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "FILTERS" AFiltDir


	FILES WinDir
		{
		PCDLIB.DL~
		TWAIN.DL~
		PANOSE.DA~
		}

	SELECT1 "Select filters" AFiltDir
		{
		TEXT
			{
			"Select the filters you want to install:"
			}
		ITEMS
			{
			ADIIMP.FL~ "ADI (.PLT) Import",
			ADIIMP.FL~ "ADI (.ADI) Import",
			AMIIMP.p5~ "Ami Pro Import",      
			CGMIMP.FL~ "CGM Graphics Import",	  
			DBSIMP.FL~ "dBase Import",
			DCAIMP.FL~ "DCA Import",
			DXFIMP.FL~ "AutoCAD (.DXF) Import",	    
			DECWPIMP.FL~ "DEC-WPS Import",    
			EPSIMP.FL~ "EPS Import",
			EXCELIMP.FL~ "Excel Spreadsheet Import",	   
			CHARTIMP.p5~ "Excel Chart Import",
			GEMIMP.FL~ "GEM Import",	   
			HPGLIMP.FL~ "HPGL Import",
			LOTUSIMP.FL~ "Lotus 1-2-3 (.PIC) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 1A (.WKS) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import",
			123IMP.FL~ "Lotus 1-2-3 Rel 3 (.WK3) Import",
			MSWDIMP.FL~ "Microsoft Windows Write Import",
			MSWDIMP.FL~ "Microsoft Word Import",
			MULTIIMP.FL~ "MultiMate/Advantage II Import",
			OLIVIMP.FL~ "Olivetti Import",
			PM5IMP.FL~ "PageMaker Pub (.PM5) Import",
			PM5IMP.FL~ "PageMaker Template (.PT5) Import",
			PCDIMP.FL~ "Kodak PhotoCD (.PCD) Import",	
			PCXIMP.FL~ "ZSoft Format (.PCX) Import",
			PCWIMP.FL~ "PC Write Import",
			PICTIMP.FL~ "PICT Import",
			DCAIMP.FL~ "RFT Import",
			RTFIMP.FL~ "Rich Text Format (RTF) Import",
			SAMAWIMP.FL~ "Samna Word Import",
			123IMP.FL~ "Symphony 1.0-1.01 (.WRK) Import",
			123IMP.FL~ "Symphony 1.1-2.0 (.WR1) Import",
			TEIMP.FL~ "Table Editor Import",
			TEKIMP.FL~ "Tektronix PLOT-10 Import",
			TEXTIMP.FL~ "Text-Only Import",	      
			DATETIME.TY~+
			TIMEIMP.FL~ "Time Stamp Import",
			TWAINIMP.FL~ "Twain Image Acquisition Import",
			VIDSHIMP.FL~ "VideoShow (NAPLPS) Import",
			WANGIMP.FL~ "Wang Import",
			DRAWIMP.FL~ "Windows Draw Import",	       
			WMFIMP.FL~ "Windows Metafile Import",
			WINWDIMP.FL~ "Word for Windows 1.0 Import",
			WNWD2IMP.FL~ "Word for Windows 2.0 Import",
			WP4IMP.FL~ "WordPerfect 4.2 Import",
			WP5IMP.FL~ "WordPerfect 5.0-5.1 Import",
			WSTRIMP.FL~ "WordStar (.WS) Import",
			WSTRIMP.FL~ "WordStar (.WST) Import",
			WPGIMP.FL~ "WorPerfect Graphics (.WPG) Import",	   
			VPIMP.FL~ "Ventura Publisher Import",
			CHRIMPC.TB~+
			XY3IMP.FL~ "XYWrite III Import",
			/*					*/
			/* These are the export filters         */
			/*					*/
			ASCIIEXP.FL~ "ASCII Text Export",
			DCAEXP.FL~ "DCA/RFT Export",
			MSWDEXP.FL~ "Microsoft Windows Write Export",
			MSWDEXP.FL~ "Microsoft Word 3.0 - 5.x Export",
			RTFEXP.FL~ "Rich Text Format (RTF) Export",
			WP5EXP.FL~ "WordPerfect 5.0-5.1 Export",	    
			CHREXPC.TB~+
			XY3EXP.FL~ "XYWrite III Export"
			}
		HELP
			{
			"Help text for Filter selection needed from"
			"documentation."
			}

		}  /*** End Select Filters ****/


	}   /*** END Filters Package ***/


PACKAGE Additions  "Additions (2MB)"  UNSELECTED
{
	/**** Package Initializations *****/

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "ADDITION" AADDitionDir
	CONCAT AADDitionDir "TEMPLATE" TemplateDir

	/**** File Subdirectory Assignments *****/
	

	SELECT1 "Select Additions" AADDitionDir
		{
		TEXT
			{
			"Select the Additions you want to install:"
			}
		ITEMS
			{
			CONTINUE.AD~	"Continuation...",
			BALANCEC.AD~	"Balance columns...",
			BLDBKLT.AD~	"Build Booklet...",
			NUMPARAS.AD~	"Bullets and numbering...",
			ALDCOLOR.AD~	"Create color library...",
			KEYLINER.AD~	"Create keyline...",
			PUBINFO.AD~	"Display pub info...",
			STRYINFO.AD~	"Display story info...",
			DROPCAP.AD~	"Drop cap...",
			EDITSTOR.AD~	"Edit all stories",
			TRACKER.AD~	"Edit tracks...",
			DINGWIN.CH~+
			EXPWIN.CH~+
			KERNWIN.CH~+
			KERNING.AD~	"Expert kerning...",
			OVERSET.AD~	"Find overset text",
			LISTSTYL.AD~	"List styles used",
			LIBRARY.PA~+
			LIBLOADR.AD~	"Library Loader",
			HEADERS.AD~	"Running headers/footers",
			RUNSCRIP.AD~	"Run script...",
			PAGESORT.AD~	"Sort pages...",
			HOLEINFO.AD~	"Text block info...",
			HOLEHOP.AD~	"Traverse text blocks..."
			}
		HELP
			{
			"Help text for Additions selection needed from"
			"documentation."
			}
		}  /****  End Select Additions ****/
	
	ALDUSINI
		{
		"Bullets" "Bullet1" "176,12,18,Times New Roman",
		"Bullets" "Bullet2" "176,14,18,Times New Roman",
		"Bullets" "Bullet3" "149,12,18,Times New Roman",
		"Bullets" "Bullet4" "181,18,2,Wingdings",
		"Bullets" "Bullet5" "168,14,18,Symbol"
		}
		
	}  /*** END of ADDITIONS package ***/


PACKAGE PPDs "Printer files (2MB)" UNSELECTED
{

	CONCAT AldDir "USENGLSH" EngDir	 
	CONCAT EngDir "UTILITY" AUtilDir
	CONCAT AUtilDir "PS_TOOLS" PSTDir
	CONCAT EngDir "PPD4" APPD4Dir

	FILES PSTDir
		{
		PPDSHELL.PS~
		}

	SELECT1 "Select Printer Devices" APPD4Dir NOSELECTALL
		{
		TEXT
			{
			"Select the Printer files you wish to install:"
			}
		ITEMS
			{
			S5232503.PP~	"5253 Color PostScript Printer",
			CG94_493.PP~	"9400PS",
			ALJII523.PP~	"Adobe LaserJet II Cartridge",
			AGSTDS21.PP~	"AGFA StudioSet2000",
			AGACCST1.PP~	"AGFA_AccuSet v52.3",
			AGACCSF1.PP~	"AGFA_AccuSetSF v52.3",
			AGPRO941.PP~	"AGFA_ProSet9400 v52.3",
			AGP94SF1.PP~	"AGFA_ProSet9400SF v52.3",
			AGPR9551.PP~	"AGFA_ProSet9550 v52.3",
			AGP95SF1.PP~	"AGFA_ProSet9550SF v52.3",
			AGPRS961.PP~	"AGFA_ProSet9600 v52.3",
			AGP96SF1.PP~	"AGFA_ProSet9600SF v52.3",
			AGPRO971.PP~	"AGFA_ProSet9700 v52.3",
			AGP97SP1.PP~	"AGFA_ProSet9700SF v52.3",
			AGP98SF1.PP~	"AGFA_ProSet9800SF v52.3",
			AGPRO981.PP~	"AGFA_ProSet9800 v52.3",
			AGSELS51.PP~	"AGFA_SelectSet5000 v52.3",
			AGSL5SF1.PP~	"AGFA_SelectSet5000SF v52.3",
			AGSELS71.PP~	"AGFA_SelectSet7000 v52.3",
			AGSL7SF1.PP~	"AGFA_SelectSet7000SF v52.3",
			APS08522.PP~	"APS-PS PIP with APS-6-108",
			APS80522.PP~	"APS-PS PIP with APS-6-80",
			APS12522.PP~	"APS-PS PIP with LZR 1200",
			APS26522.PP~	"APS-PS PIP with LZR 2600",
			AU108V71.PP~	"Autologic APS-6/108c v52.3",
			AU70CV71.PP~	"Autologic APS-6/70c v52.3",
			AU660071.PP~	"Autologic APS-6600 v52.3",
			AUCM_V71.PP~	"Autologic APS-ColorMaster v52.3",
			GCBLPEL1.PP~	"BLP Elite",
			GCBLP2_1.PP~	"BLP II",
			GCBLP2S1.PP~	"BLP IIS",
			CN_500_1.PP~	"Canon PS-IPU Color Laser Copier",
			CN_500J1.PP~	"CnonPS-IPUKanjiColorLaserCopier",
			S746J522.PP~	"CHC-746PSJ",
			NCOL_519.PP~	"Colormate PS",
			NCCPS401.PP~	"Colormate PS40",
			NCCPS801.PP~	"Colormate PS80",
			CPPMQ151.PP~	"COMPAQ PAGEMARQ 15 v2012.015",
			CPPMQ201.PP~	"COMPAQ PAGEMARQ 20 v2012.015",
			DP_US470.PP~	"Dataproducts LZR 1260",
			DATAP462.PP~	"Dataproducts LZR 2665",
			DCD11501.PP~	"Digital DEClaser 1150 v51.4",
			DCD21501.PP~	"Digital DEClaser 2150 v51.4",
			DCD22501.PP~	"Digital DEClaser 2250 v51.4",
			DCLPS201.PP~	"Digital PrintServer 20 v48.3",
			DCLPS401.PP~	"DigitalPrintServer40 Plus v48.3",
			EPL75523.PP~	"EPSON EPL-7500",
			EPL3KF21.PP~	"EPSON LP-3000PS F2",
			EPL3KF51.PP~	"EPSON LP-3000PS F5",
			EP826051.PP~	"EPSON PostScript CARD",
			O5242503.PP~	"G5242-PS",
			GCBL4921.PP~	"GCC Business LaserPrinter v49.2",
			GCBL5141.PP~	"GCC Business LaserPrinter v51.4",
			HPIID522.PP~	"HP LaserJet IID v52.2",
			HPIII522.PP~	"HP LaserJet III v52.2",
			HPLJ_31.PP~	"HP LaserJet III v2010.118",
			HP_3D522.PP~	"HP LaserJet IIID v52.2",
			HPLJ_3D1.PP~	"HP LaserJet IIID v2010.118",
			HP_3P522.PP~	"HP LaserJet IIIP v52.2",
			HPLJ_3P1.PP~	"HP LaserJet IIIP v2010.118",
			HP3SI523.PP~	"HP LaserJet IIISi",
			HPIIP522.PP~	"HP LaserJet IIP v52.2",
			HPPJXL31.PP~	"HP PaintJet XL300 v2011.112",
			IBM17523.PP~	"IBM 4019 17 fonts",
			IBM39523.PP~	"IBM 4019 39 fonts",
			IB4029B1.PP~	"IBM LaserPrinter 4029 17 fonts",
			IB4029A1.PP~	"IBM LaserPrinter 4029 39 fonts",
			IBM20470.PP~	"IBM Personal Pageprinter",
			IBM30505.PP~	"IBM Personal Page Printer II",
			APPLE230.PP~	"LaserWriter",
			LWNT_470.PP~	"LaserWriter II NT",
			LWNTX470.PP~	"LaserWriter II NTX v47.0",
			LWNTX518.PP~	"LaserWriter II NTX v51.8",
			AP_NTXJ1.PP~	"LaserWriter II NTX v50.5",
			APLWIIf1.PP~	"LaserWriter IIf v2010.113",
			APLWIIg1.PP~	"LaserWriter IIg v2010.113",
			A_PNT518.PP~	"LaserWriter Personal NT",
			APLWNTR1.PP~	"LaserWriter Personal NTR",
			APPLE380.PP~	"LaserWriter Plus v38.0",
			APPLE422.PP~	"LaserWriter Plus v42.2",
			APTOLLD1.PP~	"LaserWriter Pro 600 v2010.130 4",
			APTOLD81.PP~	"LaserWriter Pro 600 v2010.130 8",
			APTOLLW1.PP~	"LaserWriter Pro 630 v2010.130",
			CNLBP8_1.PP~	"LBP-8III-PS",
			CNLBP8R1.PP~	"LBP-8IIIR-PS",
			CNLBP8T1.PP~	"LBP-8IIIT-PS",
			L100_425.PP~	"Linotronic 100",
			L200_471.PP~	"Linotronic 200 v47.1",
			L200_493.PP~	"Linotronic 200 v49.3",
			L300_471.PP~	"Linotronic 300 v47.1",
			L300_493.PP~	"Linotronic 300 v49.3",
			L330_523.PP~	"Linotronic 330 v52.3",
			L3330523.PP~	"Linotronic 330-RIP 30 v52.3",
			L500_493.PP~	"Linotronic 500 v49.3",
			L530_523.PP~	"Linotronic 530 v52.3",
			L5330523.PP~	"Linotronic 530-RIP 30 v52.3",
			LH_630_1.PP~	"Linotronic 630 v52.3",
			DPL15601.PP~	"LZR 1560",
			DPLZ9601.PP~	"LZR 960",
			P4455514.PP~	"Matsushita Laser Partner",
			TITRB161.PP~	"microLaser16 Turbo",
			TITRBO61.PP~	"microLaser6 Turbo",
			TITRBO91.PP~	"microLaser9 Turbo",
			OK801PF1.PP~	"ML801PS+F",
			MOIM1201.PP~	"Monotype ImageMaster 1200",
			Mono_522.PP~	"Monotype Imagesetter v52.2",
			NC95FAX1.PP~	"NEC Silentwriter 95 v2011.111",
			NC97FAX1.PP~	"NEC Silentwriter 97 v2011.111",
			NX_NLP_1.PP~	"NeXT B&W Level 1 Laser Printer",
			OL830525.PP~	"OL830",
			OL840518.PP~	"OL840",
			TI08_450.PP~	"OmniLaser",
			TKPXE171.PP~	"Phaser II PXe 17 fonts",
			TKPXE391.PP~	"Phaser II PXe 39 fonts",
			TKPHZR21.PP~	"Phaser II PXi v2010.116",
			TKPHZR22.PP~	"Phaser II PXi v2011.108",
			TKPHZ2J1.PP~	"Phaser II PXiJ v2011.108",
			TKPHZR31.PP~	"Phaser III PXi v2010.116",
			TKPHZR32.PP~	"Phaser III PXi v2011.108",
			TKPHZ3J1.PP~	"Phaser III PXiJ v2011.108",
			AMCHR518.PP~	"PRISMA",
			QMSJ_461.PP~	"PS Jet",
			QMSJP461.PP~	"PS Jet+",
			AST__470.PP~	"PS-R4081",
			QCS10503.PP~	"QMS ColorScript 100 Model 10",
			QCS20503.PP~	"QMS ColorScript 100 Model 20",
			QCS30503.PP~	"QMS ColorScript 100 Model 30",
			QMSCS494.PP~	"QMS ColorScript 100 v49.4",
			QM1700_1.PP~	"QMS-PS 1700",
			QM2000_1.PP~	"QMS-PS 2000",
			Q2200523.PP~	"QMS-PS 2200",
			Q2210523.PP~	"QMS-PS 2210",
			Q2220523.PP~	"QMS-PS 2220",
			QMPS4101.PP~	"QMS-PS 410",
			QMS8P461.PP~	"QMS-PS 800+",
			QMS8_461.PP~	"QMS-PS 800",
			QMS81470.PP~	"QMS-PS 810",
			Q810T517.PP~	"QMS-PS 810 Turbo",
			QMPS8151.PP~	"QMS-PS 815",
			QM815MR1.PP~	"QMS-PS 815 MR",
			Q820_517.PP~	"QMS-PS 820",
			Q820T517.PP~	"QMS-PS 820 Turbo",
			QMPS8251.PP~	"QMS-PS 825",
			QM825MR1.PP~	"QMS-PS 825 MR",
			QUME_470.PP~	"Qume ScripTEN",
			R6000505.PP~	"Ricoh PC Laser 6000/PS",
			F71RX503.PP~	"RX7100PS",
			SCG20522.PP~	"Scantext",
			GSGL8001.PP~	"Scout-P800",
			CNLBP4_1.PP~	"ScriptCard PS-2",
			N890_470.PP~	"Silentwriter",
			NCSW_951.PP~	"SilentWriter 95",
			N890X505.PP~	"Silentwriter XL",
			N2290520.PP~	"Silentwriter2",
			N2090522.PP~	"Silentwriter2 90",
			NCS29901.PP~	"Silentwriter2 990",
			AC500503.PP~	"TabScript C500",
			T1513470.PP~	"TI 2115 13 fonts",
			T1535470.PP~	"TI 2115 35 fonts",
			TIm17521.PP~	"TI microLaser PS17",
			TIm35521.PP~	"TI microLaser PS35",
			TIx17521.PP~	"TI microLaser XL PS17",
			TIx35521.PP~	"TI microLaser XL PS35",
			UNI17521.PP~	"UNISYS AP9210 17 Fonts",
			UNI39521.PP~	"UNISYS AP9210 39 Fonts",
			U9415470.PP~	"UNISYS AP9415",
			VT4L3001.PP~	"Varityper 4000-L300 v52.3",
			VT4L3301.PP~	"Varityper 4000-L330 v52.3",
			VT4L5001.PP~	"Varityper 4000-L500 v52.3",
			VT4L5301.PP~	"Varityper 4000-L530 v52.3",
			VT42P522.PP~	"Varityper 4200B-P",
			VT43P522.PP~	"Varityper 4300P",
			VT530522.PP~	"Varityper Series 4000-5300",
			V5334522.PP~	"Varityper Series 4000-5330",
			VT550522.PP~	"Varityper Series 4000-5500",
			VT600P1.PP~	"Varityper VT-600",
			VT60P480.PP~	"Varityper VT-600P v48.0",
			VT600W1.PP~	"Varityper VT-600W",
			VT49901.PP~	"Varityper VT4990 v52.3",
			VT4510A1.PP~	"Varityper VT4_510A v52.3",
			VT4530A1.PP~	"Varityper VT4_530A v52.3",
			VT4530B1.PP~	"Varityper VT4_530B v52.3",
			VT4530C1.PP~	"Varityper VT4_530C v52.3",
			VT4533B1.PP~	"Varityper VT4_533B v52.3",
			VT4533C1.PP~	"Varityper VT4_533C v52.3",
			VT453EA1.PP~	"Varityper VT4_53EA v52.3",
			VT453EB1.PP~	"Varityper VT4_53EB v52.3",
			VT4550A1.PP~	"Varityper VT4_550A v52.3",
			VT4550B1.PP~	"Varityper VT4_550B v52.3",
			VT4550C1.PP~	"Varityper VT4_550C v52.3",
			VT4551A1.PP~	"Varityper VT4_551A v52.3",
			VT4563A1.PP~	"VT4_563A v52.3",
			VT4563B1.PP~	"VT4_563B v52.3",
			XRDOCU11.PP~	"Xerox DocuTech",
			XRDT1351.PP~	"Xerox DocuTech 135 v2010.130",
			XRDT0851.PP~	"Xerox DocuTech 85 v2010.130",
			XRDT0901.PP~	"Xerox DocuTech 90 v2010.130"
			}
		HELP
			{
			"Help text for PPD selection needed from"
			"documentation."
			}
		}  /*** End select ppds *****/	

	/**** INI Settings ****/

	WININI
		{
		"Aldus" "PPD4" APPD4Dir
		} 

	SET PPDsInst "TRUE"


	}  /*** END of PPD package ***/



PACKAGE LastPREinstall "" SELECTED INVISIBLE
	{
	IF Serialize EQS "TRUE"
		{
        	GETPERSONAL
		}
/*	IF TutorInstalled EQS "TRUE"
		{
        	DISPLAY LaunchTutorial RunTutorVar
		}
*/
	}



PACKAGE LastOninstalls "" SELECTED INVISIBLE
	{

	/***  Stuff to be done after all other ONINSTALL's are completed ***/

	CONCAT WinDir "CONTROL.EXE" WinCtl	
	CONCAT WinDir "CONTROL.EXE" WinCtl	

	ONINSTALL
		{

		/* DDE messages for PageMaker entry in Reg database */
		ADDOLEREGKEY "OLE_ROOT" "PageMakerPub"
		SETOLEREGVALUE "PageMakerPub" "open""%1"",0;"
		SETOLEREGVALUE "PageMakerPub" "open""%1"",0;print;close;quit;"

		IF ExeInstalled EQS "FALSE"
			{
	        	DISPLAY SucNoRead
			}

		IF ExeInstalled EQS "TRUE"
			{
			DISPLAY PrintInfo    
			LAUNCH WinCtl "Printers"    
			DISPLAY SucRead 
			DISPLAY MoreInfo
			}
/*
		IF RunTutorVar EQS "&Yes"
			{
			LAUNCH "WINHELP" LearnTutorName
			}
*/
		}  /**** End Oninstall ****/

	}  /***** End LastOninstalls ****/




/****
	Use EPILOGUE only for options which should be run when the
	user clicks the EXIT button from ALDSETUP

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
        DISPLAY RebootReminder

    }
****/

