'**************************************************************************
'*************************  Setup Detect API's  ***************************
'**************************************************************************

''detect

DECLARE FUNCTION LcbFreeDrive LIB "msdetstf.dll" (nDrive%) AS LONG
DECLARE FUNCTION FIsValidDrive LIB "msdetstf.dll" (nDrive%) AS INTEGER
DECLARE FUNCTION CbGetIniKeyString LIB "msdetstf.dll" (szFile$, szSect$, szKey$, szBuf$, cbBuf%) AS INTEGER
DECLARE FUNCTION FDoesFileExist LIB "msdetstf.dll" (szFileName$, mode%) AS INTEGER




'*************************************************************************
'****************  Detect Basic Wrapper Declarations  ********************
'*************************************************************************


'' detect

DECLARE FUNCTION IsDriveValid (szDrive$) AS INTEGER
DECLARE FUNCTION GetFreeSpaceForDrive (szDrive$) AS LONG
DECLARE FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) AS STRING
DECLARE FUNCTION DoesFileExist (szFile$, mode%) AS INTEGER



'*************************************************************************
FUNCTION IsDriveValid (szDrive$) STATIC  AS INTEGER
	if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "IsDriveValid", szDrive$
    end if
	IsDriveValid = FIsValidDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION GetFreeSpaceForDrive (szDrive$) STATIC  AS LONG
	if FValidDrive(szDrive$) = 0 then
        BadArgErr 1, "GetFreeSpaceForDrive", szDrive$
    end if
	GetFreeSpaceForDrive = LcbFreeDrive(ASC(UCASE$(szDrive$)) - ASC("A") + 1)
END FUNCTION


'*************************************************************************
FUNCTION GetIniKeyString (szFile$, szSect$, szKey$) STATIC  AS STRING
	if FValidIniFile(szFile$) = 0 then
        n% = 1
    elseif szKey$ = "" then
        n% = 3
    else
        n% = 0
    end if
    if n% > 0 then
        BadArgErr n%, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
    end if

    cb% = 512
    szBuf$ = STRING$(cb%, 32)
    cbRet% = CbGetIniKeyString(szFile$, szSect$, szKey$, szBuf$, cb%)
    GetIniKeyString = szBuf$
	IF cbRet% >= cb% THEN
        StfApiErr saeOvfl, "GetIniKeyString", szFile$+", "+szSect$+", "+szKey$
        ERROR STFERR
    END IF
	szBuf$ = ""
END FUNCTION


'*************************************************************************
FUNCTION DoesFileExist (szFileName$, mode%) STATIC  AS INTEGER
'$ifdef DEBUG
    if FValidFATPath(szFileName$) = 0 then
        BadArgErr 1, "DoesFileExist", szFileName$+", "+STR$(mode%)
    end if
'$endif ''DEBUG
    DoesFileExist = FDoesFileExist(szFileName$, mode%)
END FUNCTION
