/******************************************************************

Description:    SPSS Installation Exec.

Details:        This exec asks the user what local directory
                should be used for the SPSS.  The directory
                spec is created and recorded in OS2.INI.

                The required DATA files are copied locally.

                The root directory of the remote drive is added
                to the user's LIBPATH if needed.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
   Drive(s):    Always use same drive.
   Directories: DLLs and EXEs in current directory.
   Window Type: FS/Win
   App Title:   None

******************************************************************/
'@echo off'
trace 'o'

/* Load externals */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/*  Get drive letter being used */
parse upper source . . drv
drv = left(drv,2)


/** Say what we are about to do **/
say
say ' SPSS Installation:'
say ' ------------------'
say


/* Give current setting */
Local.Directory = RxOS2Ini(, 'SPSS', 'WORKDIR')
if RxDirExist(Local.Directory)=1 then do
  say 'Current local directory = 'Local.Directory
end


/* Query user */
do forever
     say
     say ' Enter a local directory where local SPSS files may be stored:'
     Local.Directory = linein('STDIN')
     if Local.Directory<>'' then do
       call rxMkDir Local.Directory
       if rxDirExist(Local.Directory) then do
          call RxOS2Ini , 'SPSS', 'WORKDIR', Local.Directory
          leave
       end
     end
     say d2c(7)
     say ' Invalid Directory.  Please enter a valid directory.'
end  /* Do Forever */


/** Make directories and copy needed files **/
call RxMkDir Local.Directory'\DATA'
call RxMkDir Local.Directory'\TEMP'
'COPY 'drv'\DATA\*.* 'Local.Directory'\DATA\*.*>nul 2>&1'


/** Add drive entry to LIBPATH statement if needed **/
call LIBEDIT drv'\' 'A'    /* External Rexx Exec */
LibEditRC = value('LIBEDIT.RC',,'OS2ENVIRONMENT')
if LibEditRC=0 then do
  say d2c(7)
  say ' Important Note:'
  say ' ---------------'; say
  say ' The 'drv'\ entry has just been added to the LIBPATH statement'
  say ' of your C:\CONFIG.SYS file.  You must reboot before SPSS'
  say ' will run correctly.'
  say
end
else do
  say
  say ' SPSS is ready to run on your PC.'
  say
end
call RxPause
'exit'
