/******************************************************************

Description:    Smalltalk/V PM Run Exec.

Details:        This exec sets up the appropriate Smalltalk/V PM
                environment.

                The local directory is created if needed and
                recorded in OS2.INI.

                If VCORE.EXE (the object file) does not exist
                in the local directory, it is copied from the
                server.

                The local directory is changed to and the remote
                directory is added to the path and dpath.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR PACKAGE.
                HIDEWIN.EXE - Part of VENDOR PACKAGE.
   Drive(s):    Always use same drive.
   Directories: None
   Window Type: FS/Win
   App Title:   SmallTalk/V PM

******************************************************************/
'@ECHO OFF'
trace 'o'

/* Load external funcs */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'


/* Setup a few vars */
parse source . . file
Dir = left(file,3)
Env = 'OS2ENVIRONMENT'


/* Give header */
say
say ' Smalltalk/V PM'
say ' --------------'
say


/* Get local directory spec */
Local.Directory = RxOS2Ini(, 'SMALLTALK', 'WORKDIR')
do forever
   if Local.Directory = '' | rxDirExist(Local.Directory)=0 then do
     say
     say 'Enter a local directory where your SmallTalk/V PM source files'
     say 'will be saved: '
     Local.Directory = linein('STDIN')
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'SMALLTALK', 'WORKDIR', Local.Directory
        leave
     end
     else do
      say d2c(7)
      say 'Invalid Directory.  Please enter a valid directory.'
     end
   end
   else leave
end  /* Do Forever */



if right(Local.Directory,1) <> '\' then
   ObjFile = translate(Local.Directory'\VCORE.EXE')
else
   ObjFile = translate(Local.Directory'VCORE.EXE')

if rxFileExist(ObjFile)=0 then do
   say
   say ' Copying SmallTalk object file to 'ObjFile'...'
   'COPY V.EXE 'ObjFile
end
else do
   say
   say ' Note:  You may rename your current 'ObjFile' object file at any'
   say '        time to automatically obtain latest default V.EXE file from '
   say '        the vendor server upon your *next* SmallTalk V/PM session.'
   say
end


/** Setup the proper SmallTalk Environment **/
oldpath  = value('PATH',,Env)
olddpath = value('DPATH',, Env)
call value 'PATH',  Dir';'oldpath,  Env
call value 'DPATH', Dir';'olddpath, Env
call directory Local.Directory


/** Run SmallTalk **/
say
say ' Starting SmallTalk/V PM...'
say
say ' Local directory = 'Local.Directory
say
say ' Please wait a moment while SmallTalk/V PM is loaded.'
say '       ( This may take more than a minute )'
say
say ' This window will be hidden after SmallTalk/V PM has'
say ' started...'
'START HIDEWIN /D=20 SmallTalk/V PM'
if right(Local.Directory,1) <> '\' then
   Dir'VPM 'Local.Directory'\VCORE.EXE'
else
   Dir'VPM 'Local.Directory'VCORE.EXE'

'exit'
