/******************************************************************

Description:    IBM FORTRAN/2 Run Exec.

Details:        This exec sets up the IBM FORTRAN/2 environment.
                If the required DLLs are not contained along the
                LIBPATH, they will be copied to a local directory
                in the users LIBPATH.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: Toolkit installed in \TOOLKT12 directory.
   Window Type: FS/Win
   App Title:   None

******************************************************************/
trace 'O'
'@echo off'

 /* Add external funcs */
 call RxFuncAdd 'RxSearchPath', 'RXUTILS', 'RXSEARCHPATH'

 /* Give message */
 say
 say 'Setting up IBM FORTRAN/2 environment for this session...'


 /* Set vars */
 parse source . . exec
 Cdr     = left(exec, lastpos('\', exec))
 F2d     = Cdr'FORTRAN\'
 TKdr    = Cdr'TOOLKT12\'
 Env     = 'OS2ENVIRONMENT'
 oldpath = value('PATH',,Env)
 newpath = Cdr';'Cdr'FORTRAN;'TKdr'BIN;'oldpath
 newlib  = Cdr'PLIB;'Cdr'FLIB;'Cdr'RLIB;'TKdr'LIB;'
 newinc  = TKdr'FORTRAN\INCLUDE;'
 oldhelp = value('HELP',,Env)
 newhelp = TKdr'DM;'TKdr'DTL;'TKdr'BIN;'oldhelp
 oldbook = value('BOOKSHELF',, Env)
 newbook = TKdr'PROGREF;'oldbook


 /* Set env vars */
 call value 'PATH'       , newpath    , Env
 call value 'LIB'        , newlib     , Env
 call value 'INCLUDE'    , newinc     , Env
 call value 'BOOKSHELF'  , newbook    , Env
 call value 'HELP'       , newhelp    , Env
 call value 'BREAK'      , ON         , Env
 call value 'FORTRAN.CER', F2dr'FORTRAN.CER' , Env
 call value 'FORTRAN.DER', F2dr'FORTRAN.DER' , Env
 call value 'FORTRAN.ERR', F2dr'FORTRAN.ERR' , Env
 call value 'FORTRAN.HLP', F2dr'FORTRAN.HLP' , Env


 /* Copy DLLs locally if needed */
 IfExist = RxSearchPath( 'LIBPATH', 'FORTRUN.DLL' )
 if IfExist = '' then do
   where = RxSearchPath( 'LIBPATH', 'RXUTILS.DLL' )
   dir = left(where, lastpos('\',where))
   say
   say 'The FORTRUN.DLL and FORTRUE.DLL are needed by the FORTRAN/2'
   say 'Compiler.'
   say
   say 'These files will be placed in a subdirectory in your LIBPATH.'
   say
   say 'Copying files to 'dir' subdirectory...'
   copy Cdr'FORTRAN\FORTRUN.DLL' dir
   copy Cdr'FORTRAN\FORTRUE.DLL' dir
 end


 say 'Done.  IBM FORTRAN/2 is ready to run in this session.'
 exit 0
