/******************************************************************

Description:    Freelance 4.0 Install Exec

Details:        This exec calls the FLINSTAL.COM.

                The exec also asks the user what local directory
                was created by FLINSTAL, and stores said info in
                OS2.INI where the Freelance Run exec may get it.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
                HIDEWIN.EXE  - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/Win
   App Title:   Freelance 4.0 (Dos)

******************************************************************/
trace 'O'
'@echo off'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/*******************************************/
/** Give greetings messages               **/
/*******************************************/
call RxCls
say;
say 'Freelance 4.0 (DOS) Installation'
say '--------------------------------'; say
say 'You are about to run the Freelance install program'
say 'provided with the Freelance package.  This program'
say 'will be run in the DOS box.'; say
say 'The Freelance installation program will ask you'
say 'what drive and directory you would like to use'
say 'for the storage of local Freelance components.'; say
say 'Please remember the drive and directory you'
say 'specify when running the Freelance installation'
say 'program.'; say
call RxPause


/***************************************/
/** Initialize vars that might change **/
/***************************************/
App     = 'FLINSTAL.COM'         /* Dos application to run          */
Params  = ''                     /* Parameters to DOS app (if any)  */
Session = 'Freelance 4.0 (Dos)'  /* Session title (used by HIDEWIN) */

/*******************************************/
/** Initialze vars that will never change **/
/*******************************************/
parse upper source . . fspec                 /* Get full exec fspec   */
Dir     = left(fspec, lastpos('\', fspec)-1) /* Get full dir name     */
App     = Dir'\'App                          /* Get full app spec     */
Drive   = left(App,2)                        /* Get the drive letter  */

'START HIDEWIN 'Session'>NUL 2>&1'
App' 'Params

/************************************************/
/** Ask the user what personal directory they  **/
/** created.                                   **/
/************************************************/
'START HIDEWIN /S 'Session'>NUL 2>&1'
call RxCls
say; say d2c(7)
say 'You have just completed running the Freelance installation'
say 'program.'; say
say 'VENDOR has no way of knowing what drive and directory you specified'
say 'for the storage of local Freelance components.'; say
say 'Therefore, please enter the drive and directory you specified'
say 'while running the installation program:'; say
do until done='TRUE'
 call RxSay 'Enter local Freelance drive and directory (ie D:\FL) > '
 do until Dir<>''
   Dir = LINEIN('STDIN')
 end
 if RxDirExist(Dir) then do
   done='TRUE'
  end
 else do
   say d2c(7)
   say 'The drive and directory you specified does not seem to exist.'
   say 'Please try again...'; say
   done='FALSE'
  end
end

call RxCls
say; say 'VENDOR Plotter configuration'; say '----------------------------'
say;
say 'To use the COM ports you need  DEVICE=C:\OS2\COM02.SYS in CONFIG.SYS.'
say; say 'Do you have a Plotter attached to a serial port that you would'
Plotter =  YesNoPrompt( 'like to use with Freelance.' )
if Plotter = 'Y' then do
  say;
  done = FALSE
  do until done='TRUE'
    done = TRUE
    say 'Enter the COM port that the plotter is attached to:'
    say '  1. COM1'; say '  2. COM2'; say '  3. QUIT';
    call RxSay 'Which port >'
    COMport = LINEIN( STDIN )
    if COMport = 1 | COMport = 2 then
       call RxOS2Ini , 'FLCOMPORT', 'ACTIVE', 'COM'COMport
    else if COMport <> 3 then
       done = FALSE
  end
end

call RxCls
say
say 'Storing local directory information for future reference...'; say
call RxOS2Ini , 'Directories', 'FLV4', Dir
say 'Installation complete!';
say 'Freelance 4.0 is ready to run.'; say
call RxPause
EXIT'


/**************************************************/
/** YesNoPrompt(prompt)                          **/
/**                                              **/
/** Procedure which excepts a prompt and prompts **/
/** the user for a Y/N response.                 **/
/**************************************************/
YesNoPrompt: procedure
parse arg prompt
call RxSay prompt||' [Y/N] > '
do until resp='Y' | resp='N'
   resp = translate(RxGetKey('NOECHO'))
   if resp<>'Y' & resp<>'N' then call RxSay D2C(7)
end
say resp
return resp
