/******************************************************************

Description:    Microsoft Excel v3.0 Run Exec.

Details:        This exec is used to setup and run Excel v3.0.

                The first time this exec is run, the user will
                be prompted for a local directory to store work
                files.  This directory spec is stored in OS2.INI.
                Two configuration files will also be copied to
                the user's C:\OS2 subdirectory.  They are DE.INI
                and EXCEL.INI.  Whenever Excel is run this exec
                will query the Vendor drive letter and overlay it
                in the Init Commands, solver application key.
                The user will also be asked if he or she wants to
                start any of Excel's companion programs.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                HIDEWIN.EXE - Part of VENDOR package.
   Drive(s):    None
   Directories: All DLL and EXE files in same directory.
   Window Type: FS/WIN
   App Title:   Excel

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

Bdr = RxBootDrive()
IniFile = Bdr'\OS2\EXCEL.INI'

/* Give header */
say
say ' Starting Excel Run Exec'
say ' -----------------------'
say

/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)

/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'Excel')
if Local.Directory = '$RXERROR' then do
   Local.Directory = RxOS2Ini(, 'Excel', 'LOCALDIR')
   if Local.Directory <> '$RXERROR' then do
      call RxOS2Ini , 'Directories', 'Excel', Local.Directory
      call RxOS2Ini , 'Excel', 'LOCALDIR', '$RXDEL'
   end
end

/* Create local directory for Excel if one doesn't already exist */
 do while rxDirExist(Local.Directory)=0
   /* Get the valid local drives, remove the VDISK, prompt user */
   DrvMap = RxDriveMap('C:', 'LOCAL' )
   parse upper value RxDriveInfo( right(DrvMap,2)) with . 'LABEL='label .
   if pos('VDISK', label)<>0 then DrvMap=left(DrvMap, length(DrvMap)-3)

    say
    say ' Enter a local directory where your Excel files will be saved.'
    say ' If it does not already exist it will be created.'
    say ' Valid local drives:' DrvMap
    say

   OK=0
   do until OK=1
      Local.Directory = translate( LINEIN('STDIN') )
      if POS( left(Local.Directory,2), DrvMap) <> 0 then OK=1
      else
        say d2c(7)||' Cannot create directory.  Try again....'
   end /* do */

   call rxMkDir(Local.Directory)
   if rxDirExist(Local.Directory)=1 then
     call RxOS2Ini , 'Directories', 'Excel', Local.Directory
   else
     say d2c(7)||' Cannot create directory.  Try again....'
 end

/* Copy Excel ini files to c:\os2 directory */
if RxFileExist(IniFile)=0 then do
  say 'Two configuration files will be copied to'
  say 'your C:\OS2 subdirectory.'
  'copy 'path'excel.ini c:\os2'
  'copy 'path'qe.ini c:\os2'
end

/* Overlay drive letter in Excel.ini with current Vendor drive */
if RxFileExist(IniFile)=1 then do
  Data = rxOS2Ini(IniFile,'Init Commands','solver')
  P.1 = pos('\EXCEL30\', Data) - 2
  if P.1 > 0 then do
    Data = overlay(Drive, Data, P.1, 2)
    call rxOs2Ini IniFile, 'Init Commands','solver',Data
  end  /* if P.1 */
end  /* if then else */

/* Ask user which companion programs to start */
say
say 'Excel comes with three companion programs.  You have the'
say 'option to start any or all of these now.  Each of these'
say 'may also be started from within Excel.  However, if you'
say 'decide to start several of these you may run out of'
say 'window resources so make sure that you to not have too'
say 'many PM programs running.'

say
say 'The Dialog Editor allows you to create custom dialog'
say 'boxes for use in custom Data Forms and Excel command'
say 'Macros.  Do you want to start Dialog Editor? (Y/N)'
do until StartDialog='Y' | StartDialog='N'
  StartDialog = translate(left(linein(STDIN),1))

say
say 'Q+E is a database application that allows you to'
say 'manipulate and update database files from a variety'
say 'of formats, including dBASE, MS SQL Server, Oracle,'
say 'OS/2 Extended Edition.  Do you want to start Q+E? (Y/N)'
do until StartQE='Y' | StartQE='N'
  StartQE = translate(left(linein(STDIN),1))

say
say 'The Macro Translator helps you import Lotus 1-2-3'
say 'macros as Excel macros.  There is a bug with the'
say 'Macro Translator which causes FORBROWS to Trap and'
say 'prompts you to close PMDIARY if it is running.'
say 'Do you want to start Macro Translator? (Y/N)'
do until StartMacro='Y' | StartMacro='N'
  StartMacro = translate(left(linein(STDIN),1))

if StartDialog='Y' then
  'START EXCELDE'
if StartQE='Y' then
  'START QE'
if StartMacro='Y' then
  'START TRANS'
end

/** Run Excel **/
say
say ' Starting Excel...'
say
say ' Please wait a moment while Excel is loaded.'
say '       ( This may take a more than a minute )'
say
say ' Once Excel has started this window will be hidden.'
'START HIDEWIN /D=20 Excel'
'EXCEL'

'exit'
