/******************************************************************

Description:    IBM EASEL Install Exec.

Details:        This exec creates a local EASEL directory,
                adds the current drive/dir path to the
                LIBPATH of the CONFIG.SYS if needed, and
                install the AEDD_OS2.SYS device driver if
                needed.

                Local directory info is stored in OS2.INI.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
                LIBEDIT.CMD - Part of VENDOR package.
                ANSI state must be on.
   Drive(s):    User must always use same drive.
   Directories: Assumes DLLs and EXEs in root directory of
                 assigned drive.
   Window Type: FS/Win
   App Title:   None

******************************************************************/
trace 'O'
'@echo off'


/* Load external funcs */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'


/* Give panel */
call RxCls
Esc = d2c(27)
say  Esc'['1';37;'41'm'      /* White on Red */
say ' ********************************************************************* '
say ' *         IBM EASEL Version 1.1 for OS/2 Extended Edition           * '
say ' ********************************************************************* '
say '                                                                       '
say ' EASEL Package Installation Procedure:                                 '
say '                                                                       '
say ' The EASEL Package requires that this program will always run from     '
say ' the same Network Drive.  A reboot of your IBM PS/2 computer will be   '
say ' necessary before IBM EASEL will run successfully.                     '
say '                                                                       '
say ' This Installation Program will modify your CONFIG.SYS to include this '
say ' EASEL Network Drive along your LIBPATH statement.  It will also ask   '
say ' you for a subdirectory in which your EASEL Source Code can be placed. '
say ' If you have an Audio Visual Card or plan on using the Audio Visual    '
say ' capabilities of EASEL a Device Driver needs to copied to your         '
say ' workstation and a DEVICE statement will be added to your CONFIG.SYS.  '
say  Esc'['1';37;'40'm'      /* White on Black */
'pause'


/* Setup vars */
EaselInit = RxOS2Ini(, 'EASEL', 'EASELINIT')
parse source . . exec
Edr=left(exec, lastpos('\', exec))


/* Give user info as to what we are doing */
  if EaselInit = 1 then do
     call RxCls
     say
     call SayCnC ' You are about to re-install the IBM EASEL product.    '
     call SayCnC ' All previous information and setup you have installed '
     call SayCnC ' will be erased.                                       '
     say
  end
  else do            /* New Installation */
     call RxCls
     say
     call SayCnC ' This is the first time you have run EASEL from the  '
     call SayCnC ' Vendor Server.                                      '
     call SayCnC '                                                     '
     call SayCnC ' The LIBPATH statement must be modified to find the  '
     call SayCnC ' Easel DLLs.                                         '
     call SayCnC '                                                     '
     call SayCnC ' If using the Audio Visual Adapter, it is required   '
     call SayCnC ' that a device driver be loaded via your CONFIG.SYS. '
     call SayCnC '                                                     '
     call SayCnC ' ** You must reboot after the Easel installation **  '
     say
  end

  say 'Should the EASEL Initialization proceed (Y/N)?'
  do until OK='Y' | OK='N'
    OK = translate(linein('STDIN'))
  end
  if OK <> 'Y' then do
     say d2c(7)
     call SayCnC 'IBM EASEL Initialization Aborted'
     say
     'pause'
     'exit 0'
  end


/* Proceed with EASEL Installation */
/* Add this network drive to the LIBPATH */
   call LIBEDIT Edr';' 'A'

   call RxOS2Ini , 'EASEL', 'EASELINIT', 1
   Local.Directory = RxOS2Ini(, 'EASEL', 'WORKDIR')

   if rxDirExist(Local.Directory) = 1 then do
      say 'Do you want to continue using 'Local.Directory' as your'
      say 'EASEL Source Code path (Y/N)? '
      do until OK='Y' | OK='N'
        OK = translate(linein('STDIN'))
      end
      if OK = 'N' then
         Local.Directory = ''
   end
   else Local.Directory = ''


/* Get local directory spec from user */
   if Local.Directory = '' then do
      do forever
         say 'Enter a local directory where your IBM EASEL Source Code will'
         say 'be saved:'
         Local.Directory =  linein('STDIN')
         call rxMkDir Local.Directory
         if rxDirExist(Local.Directory) then do
            call RxOS2Ini , 'EASEL', 'WORKDIR', Local.Directory
            leave
         end
         else do
            say d2c(7)
            call SayCnC ' Invalid Path.  Please enter a valid path. '
            say
         end
      end
   end


/* Read config.sys */
   rc = RxRead('C:\CONFIG.SYS', Config)
   if rc > 0 then do
      say d2c(7)
      call SayCnC 'Problem reading C:\CONFIG.SYS'
      say
      'pause'
      'exit 0'
   end


/* Search for AEDD_OS2 device drivers */
   do index = 1 to Config.0
      parse var Config.index 'DEVICE=' DevStatement
      if Pos('AEDD_OS2.SYS',DevStatement) <> 0 then do
         Audio = 'TRUE'
         leave
      end
   end


/* Add DD if not found */
   if AUDIO <> 'TRUE' then do
      say 'Would you like to install the Audio Visual Adapter Card device'
      say 'driver (Y/N)?'
      do until OK='Y' | OK='N'
        OK = translate(linein('STDIN'))
      end
      if OK = 'Y' then do
         do forever
            say 'Enter a local path where the AEDD_OS2.SYS file will be'
            say 'copied:'
            AVC.Directory = linein('STDIN')
            call rxMkDir AVC.Directory
            if rxDirExist(AVC.Directory) = 1 then do
               if right( AVC.Directory, 1) <> '\' then
                  AVC.Directory=AVC.Directory'\'
               'COPY 'Edr'AEDD_OS2.SYS 'AVC.Directory'AEDD_OS2.SYS'
               TheEnd = Config.0
               Config.TheEnd = 'DEVICE='AVC.Directory'AEDD_OS2.SYS'
               call RxWrite 'C:\CONFIG.SYS',Config, 1, TheEnd, 'A'
               leave
            end
            else do
               say d2c(7)
               call SayCnC ' Invalid Path.  Please enter a valid path. '
            end
         end
      end
   end


/* Tell user we are done */
  say d2c(7)
  call SayCnC 'IBM EASEL Installation Complete.'
  call SayCnc
  call SayCnC 'You will have to reboot your computer'
  call SayCnC 'to activate the new configuration.'
  say
'pause'
'exit'



/*** Little proc for saying a line with style ***/
SayCnC:     /* Say with Centering and Color */
parse arg str
  say Esc'[1;37;41m'||center(str, 79)||Esc'[1;37;40m'
return
