/******************************************************************

Description:    DisplayWrite 5-2 Install Exec.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    None
   Directories: None
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
trace 'O'
'@echo off'

/* Load external funcs */
call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

/* Get args */
parse source . . exec
Cdr=left(exec, lastpos('\', exec))

/* Give header */
say
say  'DisplayWrite SETUP'
say  '------------------'; say

/* Give install info then run INSTALL */
say 'The installation process will ask you a few questions:'
say
say ' - What directory do you want to store local files in (~100K)?'
say '   The consultants suggest using C:\DW52 or D:\DW52.'
say '   Remember what you specify as you will be asked later.'
say
say ' - What is your monitor (VGA) and mouse (PS/2) type?'
say
say ' - What are the nicknames of the printers you want to use?'
say '   The printer names defined are as follows:'
say
say '     Nickname  Printer type'
say '     =================================================='
say '     4216    - IBM Personal Pageprinter II (Postscript)'
say '     4019    - IBM 4019 Laser Printer'
say '     IBMPRO  - IBM Proprinter'
say '     HPLASER - HP Laserjet series II'
say '     GRAPHIC - IBM Graphics printer'
say '     QUIET   - IBM Quietwriter'
say
say 'If you have any questions, please contact OS/2 Consultants.'
call RxPause 'Press any key to start Installation program...'
Cdr'DW5-2\INSTALL /W'

/* Ask what directory we was installed to */
ok = 0
do until ok = 1
   call RxCls
   say
   say 'What path did you tell DisplayWrite to install the local files'
   say 'in?'; say
   call RxSay '> '
   dw5path = translate(linein(STDIN))
   dir = dw5path'\DW5-2'
   if RxDirExist(dir)=0 then do
        dir = left(dw5path,1)':\DW5-2'    /* try a different guess */
        if RxDirExist(dir)=0 then do
           say d2c(7)
           say 'Error - path specified incorrectly.  Please retry.'
           say
        end
        else do
           call RxOS2Ini , 'Directories', 'DW5/2', dir||d2c(0)
           ok = 1
        end
   end
   else do
        call RxOS2Ini , 'Directories', 'DW5/2', dir||d2c(0)
        ok = 1
   end
end

/* Tell user its ready to run */
call RxCls
say
say 'DisplayWrite 5/2 is ready to run.  There is no need for a'
say 'reboot.'; say
call RxPause 'Press any key to exit installation...'

'exit'
