/******************************************************************

Description:    DeScribe 3.0 Installation Exec.

Details:        This exec is used to install DeScribe.

                Installation consists of asking the user for a
                local directory spec in which to store local
                files.  This info is stored in OS2.INI.  It also
                allows the user to copy the tutorial files to his
                or her local directory.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR package.
   Drive(s):    Must be run from same drive to preserve path
                information for layouts and macros.
   Directories: Work files (tutorial, layout, clipart) files must be
                copied locally in order to be edited.
   Window Type: FS/WIN
   App Title:   None

******************************************************************/
'@ECHO OFF'
trace 'o'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

say
say ' DeScribe Installation'
say ' ---------------------'
say


/* Parse args */
parse source . . exec
path=left(exec, lastpos('\', exec))
drive=left(path,2)


/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'DScribe3')

/* Let user change it */
do forever
  if rxDirExist(Local.Directory)=1 then do
   say ' Current DeScribe local directory = 'Local.Directory
   say
  end  /* if rxDirExist... */

  say ' Enter a local directory where DeScribe files will be saved:'
  Local.Directory = strip(left(translate(linein('STDIN')), 11))
  if Local.Directory<>'' then do
    call rxMkDir Local.Directory
    call rxMkDir Local.Directory'\temp'
    call rxMkDir Local.Directory'\usrdicts'
    call rxMkDir Local.Directory'\data'

    if rxDirExist(Local.Directory) then do
      call RxOS2Ini , 'Directories', 'DScribe3', '$RXDEL'
      call RxOS2Ini , 'Directories', 'DScribe3', Local.Directory
     leave
    end  /* if rxDirExist... */
  end  /* if Local... */

  else do
    say d2c(7)
    say ' Invalid Directory.  Please enter a valid directory.'
  end  /* else do */
end  /* Do Forever */

if rxFileExist('c:\os2\describe.dat') then do
  call rxDelete 'c:\os2\describe.dat'
end  /* Do */


/* Ask if User wants to copy tutorial files now */
say ''
say ''
say 'DeScribe comes with some tutorial files which are used'
say 'in the DeScribe Workbook exercises.  They take up'
say 'approxiamately 510KB of disk space.  These files cannot'
say 'be accessed across the network.  You may copy these files'
say 'to your hard disk now or you may do so at a later time.'
say 'If you decide to copy the tutorial files later please read'
say 'the package information file for instructions.'
say ''
say 'Do you want to copy these files to your hard disk?  (Y/N)'

do until conv='Y' | conv='N'
   conv = translate(left(linein(STDIN),1))
end  /* do until... */

if (conv='Y') then do
  call rxMkDir Local.Directory'\tutorial'
  call rxMkDir Local.Directory'\tutorial\art'
  call rxMkDir Local.Directory'\tutorial\examples'
  call rxMkDir Local.Directory'\tutorial\layouts'
  call rxMkDir Local.Directory'\tutorial\text'
  call rxMkDir Local.Directory'\tutorial\Working'
    'copy 'path'tutorial\art\*.*' Local.Directory'\tutorial\art\'
    'copy 'path'tutorial\examples\*.*' Local.Directory'\tutorial\examples\'
    'copy 'path'tutorial\layouts\*.*' Local.Directory'\tutorial\layouts\'
    'copy 'path'tutorial\text\*.*' Local.Directory'\tutorial\text\'
end  /* if (conv='Y')... */

/* Give User Information about copying files */
say
say 'DeScribe comes with some files which you may want to edit'
say 'at some point, i.e. clipart, macros, layouts.  These files'
say 'cannot be edited unless they are copied to your hard disk.'
say 'Please read the Package Information file to find out how to'
say 'do this and for other important information about DeScribe.'
say

/* Start PMBrowse to tell user to modify Global Preferences in DeScribe */
'start pmbrowse spellchk.inf'

/* Give message */
say
say ' DeScribe is now ready to run.'
say
call RxPause

'exit'
