/******************************************************************

Description:    CorelDRAW! 2.00a run exec.

Details:        This exec checks to see if Corel Draw! has been
                installed by looking for C:\COREL20\CDCONFIG.SYS.
                If the file is not found it tells the user to run
                the installation program.  If the file exists it
                prompts the user for the companion programs which
                should be started when the main CorelDRAW! program
                is started.  If C:\COREL20\CDCONFIG.SYS is not found
                the user is told to run the installation program.

Dependencies:
   Externals:   RXUTILS.DLL - Part of VENDOR PACKAGE.
                HIDEWIN.EXE - Part of VENDOR PACKAGE.
   Drive(s):    Corel Draw! must be run from the R: drive
   Directories: C:\COREL20 - See install exec for this package.
   Window Type: FS/Win
   App Title:   CorelDRAW! for OS/2

******************************************************************/
trace 'O'
'@echo off'

call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
call RxLoadFuncs 'QUIET'

parse source . . exec
path=left(exec, lastpos('\', exec))
UserDrive = value('USER.DRIVE',,'OS2ENVIRONMENT')

/***************************************************/
/** Check for local CorelDRAW! configuration file **/
/***************************************************/

if \RxFileExist('C:\COREL20\CDCONFIG.SYS') then do
  say
  say
  say 'CorelDRAW! has not been set up to run on your system.'
  say 'Please run the installation program'
  say
  'pause'
  'exit'
end
else

say
say ' CorelDRAW! for OS/2'
say ' -------------------'
say

/************************************************/
/** Ask user which companion programs to start **/
/************************************************/

say
say 'Corel Draw! comes with three companion programs and a help'
say 'program.  You have the option to start any or all of these'
say 'now.  However, it is recommended that you do not start more'
say 'than 1 or 2 of these.  If you decide to start more, you may'
say 'run out of PM resources, therefore make sure that you do not'
say 'have too many Presentation Manager programs running.  View the'
say 'Package Info file for a brief description of these programs.'

say
say 'Do you want to start Corel Trace? (Y/N)'
do until StartTrace='Y' | StartTrace='N'
  StartTrace = translate(left(linein(STDIN),1))
end

say
say 'Do you want to start Mosaic? (Y/N)'
do until StartMosaic='Y' | StartMosaic='N'
  StartMosaic = translate(left(linein(STDIN),1))
end

say
say 'Do you want to start WFN Boss? (Y/N)'
do until StartWFNBoss='Y' | StartWFNBoss='N'
  StartWFNBoss = translate(left(linein(STDIN),1))
end

say
say 'Do you want to start the on-line help program? (Y/N)'
do until StartHelp='Y' | StartHelp='N'
   StartHelp = translate(left(linein(STDIN),1))
end

/** Run CorelDraw! **/
say
say ' Starting CorelDRAW!....'
say ' Please wait a moment while CorelDRAW! is loaded.'
say '       ( This may take a short while. )'

if StartTrace='Y' then
  'START TRACE'
if StartMosaic='Y' then
  'START MOSAIC'
if StartWFNBoss='Y' then
  'START WFNBOSS'
if StartHelp='Y' then
  'START WINHELP'

'START HIDEWIN /D=20 CorelDRAW! for OS/2'
'CORELDRW'

'EXIT 0'
