/******************************************************************

Description:    IBM SAA AD/Cycle WorkStation Platform/2

Details:        This exec sets up the appropriate IBM AD/Cycle WSP env.
                AD/Cycle requires that the HELP, PATH, DPATH, LIBPATH,
                and Bookshelf statements be set correctly. An EPFWORKDIR
                Env Var must also be set to a local directory.  A TMP
                Env Var also has to be set to the local directory in order
                to use the Graphic Services Design Tool. This exec sets
                all Env Vars.

                So as to find its appropiate DLLs, the EPFVADC.EXE
                must be run from the current drive if the assigned
                drive is not in the LIBPATH.

Dependencies:
   Externals:   HIDEWIN.EXE  - Part of VENDOR package.
                RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    Must always use the same drive.
   Directories: None
   Window Type: FS/Win
   App Title:   AD/Cycle WorkStation Platform/2

******************************************************************/
 trace 'O'
 '@echo off'

/* Add external funcs */
 call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
 call RxLoadFuncs 'QUIET'

/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'ADCWSP2')

Install = 'N'

/* If not there then ask user */
do forever
   if Local.Directory = '' | rxDirExist(Local.Directory)=0 then do

     Install = 'Y'

     say ' Enter a local directory where AD/Cycle WSP/2 files will be saved:'
     say ''
     Local.Directory = translate(linein('STDIN'))
     call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
        call RxOS2Ini , 'Directories', 'ADCWSP2', '$RXDEL'
        call RxOS2Ini , 'Directories', 'ADCWSP2', Local.Directory
        leave
     end  /* if */
     else do
      say d2c(7)
      say ' Invalid Directory.  Please enter a valid directory.'
     end  /* else do */
   end  /* if Local.Directory... */
   else leave
end  /* Do Forever */

 parse source . . exec
 CurDir=left(exec, lastpos('\', exec))

 if (value('B.DRIVE',,'OS2ENVIRONMENT')<>CurDir) then do
/*  Give greetings messages  */
   say;
   say ' AD/Cycle WorkStation Platform/2'
   say ' -------------------------------'
   say;

/* Set up so its non-entrant */
   call value 'B.DRIVE', CurDir, 'OS2ENVIRONMENT'

/* teb - 7 Aug 91 - start additions */
/* Test for IOPL=YES */
call rxGrep 'IOPL', 'C:\CONFIG.SYS', 'TEMP.'
Ok = 0
do I = 1 to Temp.0 until Ok
  parse var Temp.I A '=' B
  Ok = (A = 'IOPL' & B = 'YES')
end
if \Ok
  then do
    say d2c(7)'IOPL=YES must be specified in CONFIG.SYS.'
    say 'You must add this line and reboot before using AD/Cycle WSP/2.'
    exit 2
  end
/* teb - end additions */

/* Set up the HELP Statement */
   oldhelp = value('HELP',,'OS2ENVIRONMENT')
   newhelp =CurDir';'oldhelp
   call value 'HELP',   newhelp, 'OS2ENVIRONMENT'

/* Set up the PATH Statement */
   oldpath = value('PATH',,'OS2ENVIRONMENT')
   newpath =CurDir';'oldpath
   call value 'PATH',   newpath, 'OS2ENVIRONMENT'

/* Set up the DPATH Statement */
   olddpath = value('DPATH',,'OS2ENVIRONMENT')
   newdpath =CurDir';'olddpath
   call value 'DPATH',   newdpath, 'OS2ENVIRONMENT'

/* Set up the BOOKSHELF Statement */
   oldbookshelf = value('BOOKSHELF',,'OS2ENVIRONMENT')
   newbookshelf =CurDir';'oldbookshelf
   call value 'BOOKSHELF',   newbookshelf, 'OS2ENVIRONMENT'

/* Set up the EPFWORKDIR Statement */
   call value 'EPFWORKDIR', Local.Directory, 'OS2ENVIRONMENT'

/* Set up the TMP Statement */
   call value 'TMP', Local.Directory, 'OS2ENVIRONMENT'

/* Start AD/Cycle WorkStation Platform/2 Application */
 say ' Loading AD/Cycle WorkStation Platform/2....'
 say
 say ' This can take up to 30 seconds.  Please Wait...'

 'START HIDEWIN /D=30 AD/Cycle WorkStation Platform/2'
 'START EPFVADC'

/* Determine if AD/Cycle WSP setup this session */
 if Install = 'Y' | RxFileExist(Local.Directory'\EPFVREG.INI')=0 then do

/* Copy Parameter file to Local.Directory */
  'copy' CurDir'epfall.adr' Local.Directory

/* Change PROGRAMPATH drive letter to drive letter Vendor is using */
  call RxRead Local.Directory'\EPFALL.ADR', 'file'

    NewDrv=left(CurDir,1)

    do i=1 to file.0
       if abbrev(file.i, 'PROGRAMPATH=D:') <>0 then do
         Parse var file.i begin'='Drv'E\'end
         file.i = begin'='NewDrv':\'end
       end  /* if...then do */
    end /* do */

  call RxWrite Local.Directory'\EPFALL.ADR', 'file'

 'EPFVBTCH' Local.Directory'\EPFALL.ADR'
 end  /* if...then do */
 end
 'exit 0'
