/******************************************************************

Description:    IBM SAA AD/Cycle WorkStation Platform/2 install exec.

Details:        This exec creates a local directory for IBM AD/Cycle WSP
                files and stores this directory in OS2.INI.  It also
                deletes certain old files which is necessary for to set
                up AD/Cycle WSP if it is installed a second time.

Dependencies:
   Externals:   RXUTILS.DLL  - Part of VENDOR package.
   Drive(s):    Must always use the same drive.
   Directories: None
   Window Type: FS/Win
   App Title:   AD/Cycle WorkStation Platform/2

******************************************************************/
 trace 'O'
 '@echo off'

/* Add external funcs */
 call RxFuncAdd 'RxLoadFuncs', 'RXUTILS', 'RxLoadFuncs'
 call RxLoadFuncs 'QUIET'

/* Check if it already exists */
Local.Directory = RxOS2Ini(, 'Directories', 'ADCWSP2')

/* Let user change it */
do forever
   if rxDirExist(Local.Directory)=1 then do
    say ' Current local directory = 'Local.Directory
    say
   end
   say ' Enter a local directory where AD/Cycle WSP files will be saved:'
   say
   Local.Directory = strip(left(translate(linein('STDIN')), 11))
   call rxMkDir Local.Directory
     if rxDirExist(Local.Directory) then do
       call RxOS2Ini , 'Directories', 'ADCWSP2', '$RXDEL'
       call RxOS2Ini , 'Directories', 'ADCWSP2', Local.Directory

/* Delete local files if they exist - necessary for new installation */
       call RxDelete(Local.Directory'\EPFALL.ADR')
       call RxDelete(Local.Directory'\EPFVREG.INI')
       call RxDelete(Local.Directory'\EPFCWSP.INI')
       call RxDelete(Local.Directory'\EPFVBTCH.OUT')
       leave
     end  /* if */
     else do
       say d2c(7)
       say ' Invalid Directory.  Please enter a valid directory.'
     end  /* else do */
end  /* Do Forever */


/* Give message */
say
say ' AD/Cycle WorkStation Platform/2 is now ready to run.'
say
call RxPause

'exit'
