#include <conio.h>
#include <stdio.h>
#include <bios.h>
#include <dos.h>
#include <graph.h>
#include <types.h>
#include <timeb.h>
#include <time.h>
#include <limits.h>
#include "esinc.h"
#include "esfunc.h"



int es(int macro_num, int wait, int dsptime, int dsperror)
{
 struct timeb time_buffer;
 char *date_time;
 char textbuf[81];
 unsigned int	time_out;
 int to,cnt;
 char	char_in;
 int es_id;
 int ExitCode = 0;
 int ErrorCode = 0;
 union REGS inreg,outreg;

    if (es_id = get_es_id())
       {
	if (!es_macro(es_id,macro_num))
           {
            if (dsptime)
              {
               ftime(&time_buffer);
               sprintf(textbuf,"Start Time = %s",ctime(&time_buffer.time));
               _settextposition(23,10);
               _outtext(textbuf);
              }

            if (wait)
               {
                to = 0;
	        while ((es_macro_stat(es_id)) && (!ExitCode))
	        {
   	         time_out = 0x500;
	         while (time_out--);
                 if (dsptime)
                    {
                     if (!to)
                       {
                        ftime(&time_buffer);
                        sprintf(textbuf,"Current Time = %s",ctime(&time_buffer.time));
                        _settextposition(24,8);
                        _outtext(textbuf);
                        to = 200;
                       }
                    else
                        to--;
                   }
                 if (LOBYTE(_bios_keybrd(_KEYBRD_READY)) == 0x1B)
                    {
                     es_cancel(es_id);
                     ExitCode = TRUE;
                     ErrorCode = CANCEL;
                    }
	        }
               }
            if (dsptime)
               {
                ftime(&time_buffer);
                sprintf(textbuf,"Finished Time = %s",ctime(&time_buffer.time));
                _settextposition(24,7);
                _outtext(textbuf);
               }
           }
        else
           ErrorCode = ES_BUSY;
       }
    else
        ErrorCode = NO_ES;

    if ((ErrorCode) && (dsperror))
       {
        switch(ErrorCode)
        {
         case NO_ES:
              printf ("\015\012EasyShare Not Loaded.");
              printf ("\015\012Please Load EasyShare and Try Again.\015\012");
              break;

         case ES_BUSY:
              printf ("\015\012EasyShare Is Busy Processing Previous Macro.\015\012");
              break;

         case CANCEL:
              printf ("\015\012EasyShare Cancelled by User.\015\012");
              break;
        }
       }
    return(ErrorCode);
}

/**** sample structure needed by the calling program ****/
/* union GSBUF {                                        */
/*       struct gsptr {                                 */
/*                      int  gsoffset;                  */
/*                      int  gsseg;                     */
/*                     } Gsptr;                         */
/*        char  gsbuf[4];                               */
/*    char far *ptr;                                    */
/*              } Gsbuf;                                */
/*                                                      */
/*                                                      */
/* Example:                                      */
/*                                                      */
/*     get_esbuf(&Gsbuf.gsbuf[2], &Gsbuf.gsbuf[0]);     */
/*                                                      */
/*                                                      */
/********************************************************/

int get_esbuf(int es_id,int *buf_seg, int *buf_offset)
{

    if (es_id)
        esbuf(es_id,buf_seg, buf_offset);
    else
       return(-1);
    return(0);
}


/***** get EasyShare id *****/
int get_es_id()
{
  int   es_id;
  int   target_id;
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    es_id = 0;
    target_id = 0xc0;

    while ((!es_id) && (target_id <= 0xff))
       {
	intno = 47;	 /***** video BISO (INT 2FH) *****/
	inregs.h.ah = target_id;
	inregs.h.al = ESAPI_IDSTAT;
	int86(intno,&inregs,&outregs);
	if ((outregs.h.al == 0xff) && (outregs.x.dx == PKEY_DX) &&
                (outregs.x.bx == PKEY_BX))
	    es_id = target_id;
	else
	    target_id++;
       }
  return(es_id);
}

int esbuf(int es_id,int *buf_seg, int *buf_offset)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    intno = 47;      /***** video BISO (INT 2FH) *****/
    inregs.h.ah = es_id;
    inregs.h.al = ESAPI_GETBUF;  /***** function code *****/
    int86(intno,&inregs,&outregs);
    *buf_seg = outregs.x.bx;
    *buf_offset = outregs.x.dx;
    return (outregs.h.al);
}


int es_macro(int es_id, int macro_num)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    intno = 47;      /***** video BISO (INT 2FH) *****/
    inregs.h.ah = es_id;
/*
    if (macro_num <= 5)
	inregs.h.al = macro_num + 12;
    else
	if (macro_num <=10)
	    inregs.h.al = macro_num + 14;
	else
	    inregs.h.al = macro_num + 17;
*/
    inregs.h.al = ESAPI_MAC;	   /* function code */
    inregs.h.cl = macro_num;
    inregs.x.dx = PKEY_DX;
    inregs.x.bx = PKEY_BX;
    int86(intno,&inregs,&outregs);
    return (outregs.h.al);

}

int es_macro_stat(int es_id)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    intno = 47;      /***** video BISO (INT 2FH) *****/
    inregs.h.ah = es_id;
    inregs.h.al = ESAPI_MACSTAT;  /***** function code *****/
    int86(intno,&inregs,&outregs);
    return (outregs.h.al);
}

void es_cancel(int es_id)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    intno = 47;      /***** video BISO (INT 2FH) *****/
    inregs.h.ah = es_id;
    inregs.h.al = ESAPI_CANCEL;  /***** function code *****/
    int86(intno,&inregs,&outregs);
    return (outregs.h.al);
}

int es_on(int es_id)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;

    if (es_id)
       {
        intno = 47;      /***** video BISO (INT 2FH) *****/
        inregs.h.ah = es_id;
        inregs.h.al = ESAPI_PRG_ON;  /***** function code *****/
        inregs.x.dx = PKEY_DX;
        inregs.x.bx = PKEY_BX;
        int86(intno,&inregs,&outregs);
        return (outregs.h.al);
       }
    else
        return (1);
}

int es_off(int es_id)
{
  int	flags;
  int	intno;
  union REGS	inregs;
  union REGS	outregs ;
    if (es_id)
       {
        intno = 47;      /***** video BISO (INT 2FH) *****/
        inregs.h.ah = es_id;
        inregs.h.al = ESAPI_PRG_OFF;  /***** function code *****/
        inregs.x.dx = PKEY_DX;
        inregs.x.bx = PKEY_BX;
        int86(intno,&inregs,&outregs);
        return (outregs.h.al);
       }
    else
        return(1);
}
