 { -----------------------------------------------------------------
 . samapi.pas
 . interface to SAMAPI.EXE
 . ----------------------------------------------------------------- }

const
  DEFAULT_SAMMUX = $99;	{ default mux id (ah on int 0x2f to access API) }

  { API commands }
  SamGetVersion       = 0;
  SamSetLevel         = 1;
  SamGetNumRecs       = 2;
  SamGetDatabaseDate  = 3;
  SamFindCall         = 4;
  SamGetRecordByCall  = 5;
  SamFindName         = 6;
  SamGetRecordByName  = 7;
  SamGetDictCode      = 8;
  SamRemove           = 20;

  { API error returns }
  SerrNoError         = 0;
  SerrNotFound        = 1; { normal error }
  SerrFail            = 2; { normal error for setlevel }
  SerrBadCmd          = 3; { bad input from API caller }
  SerrFatal           = 4; { SAMAPI internal error }

  { Dictionary Numbers }
  DnoLastName         = 0;
  DnoFirstName        = 1;
  DnoAddress          = 2;
  DnoCity             = 3;
  DnoState            = 4;

type

 { -----------------------------------------------------------------
 . datarec_t
 . data records returned from/passed to SAMAPI
 . ----------------------------------------------------------------- }

datarec_t = record
  Cindex: longint;            { sorted by call index }
  Nindex: longint;            { sorted by name index }
  LastNameCode: longint;      { last name dictionary code }
  FirstNameCode: longint;     { first name dict. code }
  AddressCode: longint;       { address dict. code }
  CityCode: longint;          { city dict. code }
  StateCode: longint;         { state dict. code (note this one 16 bits) }
  ZipNumber: longint;         { zip code number 0-99999 }
  DobNumber: integer;         { date of birth number 0-99}
  PackFlags: integer;         { bitmask of fields that are not unpacked }
                                      { asciz (0 terminated strings) }
  Call:       array[0..6] of char;  { call, area is always Call[2] }
  Class:      array[0..1] of char;  { class, N,T,G,A, or E }
  LastName:   array[0..20] of char; { last name, 20 max }
  FirstName:  array[0..11] of char; { first name, 11 max }
  MidInitial: array[0..1] of char;  { middle initial }
  Address:    array[0..35] of char; { mailing address, 35 max }
  City:       array[0..20] of char; { city, 20 max }
  State:      array[0..2] of char;  { state }
  Zip:        array[0..5] of char;  { zip code string }
  Dob:        array[0..2] of char;  { date of birth string "00" to "99" }
  reserved:   array[0..10] of char;
end;

 { -----------------------------------------------------------------
 . callstrings_t
 . The asciz strings from a SAM datarec_t converted to pascal strings
 . ----------------------------------------------------------------- }

  callstrings_t = record
    Call      : string[6];
    Class     : string[1];
    LastName  : string[20];
    FirstName : string[11];
    MidInitial: string[1];
    Address   : string[35];
    City      : string[20];
    State     : string[2];
    Zip       : string[5];
    Dob       : string[2];   { date of birth '00'-'99' }
  end;


{ API command buffer (DS:SI) header }

chdr_t = record
  cmd: byte;
  fill: array[0..2] of byte;
end;

{ API response buffer (ES:DI) header }

rhdr_t = record
    err: byte;
	xerr: byte;
    fill: array[0..1] of byte;
end;

{ API commands }
                                {--------------------------------------}
{ SamGetVersion       0 }
    { in: }                   { chdr_t }
    { out: }                  rspversion_t = record
                                h: rhdr_t;
                                version: integer;
                                level: integer;
                              end;
                                {--------------------------------------}
                                { if you find a later version/level    }
                                { than you programmed for, you can chk }
                                { compat. by attempting to set level   }
{ SamSetLevel         1 }
    { in: }                   cmdsetlevel_t = record
                                h: rhdr_t;
                                level: integer;
                              end;
    { out: }                  { rhdr_t }
                                {--------------------------------------}
                                { over 500k at last count and growing! }
{ SamGetNumRecs       2 }
    { in: }                   { chdr_t }
    { out: }                  rspnumrecs_t = record
                                h: rhdr_t;
                                numrecs: longint;
                              end;
                                {--------------------------------------}
                                { date of data. scope is               }
                                { something like "All USA Calls" or    }
                                { "District 4" or "New York"           }
{ SamGetDatabaseDate  3 }
    { in: }                   { chdr_t }
    { out: }                  rspdbdate_t = record
                                h: rhdr_t;
                                date: array[0..9] of char; { asciz }
                                scope: array[0..24] of char; { asciz }
                              end;
                                {--------------------------------------}
                                { find record containing matching call }
                                { (packflags = 0 for all unpacked)     }
{ SamFindCall         4 )
    { in: }                   cmdfindcall_t = record
                                h: chdr_t;
                                packflags: integer;
                                call: array[0..6] of char; { asciz }
                              end;
    { out: }                  rspdatarec_t = record
                                h: rhdr_t;
                                d: datarec_t;
                              end;
                                {--------------------------------------}
                                { get record with matching Cindex      }
{ SamGetRecordByCall  5 }
    { in: }                   cmd_getrecs_t = record
                                h: chdr_t;
                                packflags: integer;
                                index: longint;    { Cindex (or Nindex) }
                              end;
    { out: }                  { rspdatarec_t }
                                {--------------------------------------}
                                { find record with matching (or close) }
                                { name                                 }
{ SamFindName         6 }
    { in: }                   cmdfindname_t = record
                                h: chdr_t;
                                packflags: integer;
                                lastname: array[0..20] of char; { asciz }
                                firstname: array[0..11] of char; { asciz }
                                midinitial: array[0..1] of char; { asciz }
                              end;
    { out: }                  { rspdatarec_t }
                                {--------------------------------------}
                                { find record with matching Nindex     }
                                { NOTE: SamFindCall and                }
                                { SamGetRecordbyCall return with       }
                                { Nindex == -1                         }
{ SamGetRecordByName  7 }
    { in: }                   { cmdgetrecs_t }
    { out: }                  { rspdatarec_t }
                                {--------------------------------------}
                                { Use this to implement fast sequential}
                                { searches.  Look thru records without }
                                { unpacking them                       }
{ SamGetDictCode      8 }
    { in: }                   cmdgetdictcode_t = record
                                h: chdr_t;
                                dno: integer;    { dictionary number }
                                astring: array[0..35] of char; {asciz}
                              end;
    { out: }                  rspgetdictcode_t = record
                                h: chdr_t;
                                dictcode: longint;
                              end;
                                {--------------------------------------}
                                { preps SAMAPI.EXE for removal (best   }
                                { not used, do it with SAMAPI /r)      }
{ SamRemove          20 }
    { in: }                   { chdr_t }
    { out: }                  { rhdr_t }
                                {--------------------------------------}



