MANEUVERING THROUGH THE MENUS

The entire program operates under the same basic principles in order
to maneuver between sections.


MENU BASICS

You can select an option in both the main menu bar and the individual
sub-menus through either one of the following methods:

Using the cursor movement keys (or mouse), highlight the desired
option.  Press the <Enter> key (or click the mouse).

Within the sub-menus, you can also select an option by pressing the
first letter or highlighted letter of the option you wish to invoke
(i.e., pressing <A> for "Add...").  In the event two options within a
sub-menu begin with the same letter, another letter within one of the
options may be highlighted on the menu marking that letter as the
"hot" key to invoke the option.

If, at any time, a sub-menu should be blocking information you wish to
view, the sub-menu can be temporarily removed from the screen by
pressing either the <Del> or <End> key.  Pressing any other key will
return the sub-menu to the screen.


<ESC>

Pressing this key while a pop-up menu is active will cancel the
operation in progress and return you to the next highest level (e.g.,
this can be used to abort an EDIT operation).  It is important to
remember, however, that <ESC> cancels an operation--so any changes
made to the input screen will not be saved.



DELETING AND UNDELETING RECORDS

At any point in the system in which you are working with deleting
records, this procedure works similar in principle to a "toggle"
switch.  While you may enter a "Delete" option or press either the
letter <D> or the <Del> key to delete a record, performing the same
operation a second time will result in undeleting, or restoring, a
record.  (Additional information on removal of deleted records is
included in the section covering the INDEX & PACK option.)


USING SPECIAL FEATURES


HELP <F1>

By pressing <F1> at any time in the program will display a special
"Help" section with an explanation of usage of the option highlighted
at the time the "Help" was invoked.  It is possible to cycle through
the "Help" section by pressing <N>-next, <P>-previous, or <T> for a
listing of the various topics available.  Pressing <ESC> will return
you to the program at the spot from which you invoked "Help".


CALENDAR <F2>

By pressing <F2> at any time in the program you are able to call to
the screen a reference calendar.  When the calendar is brought to the
screen it will display the current month with the current date
highlighted.  It is possible to refer to another date/month/year by
using the keys as follows:

Right Arrow:  Advances the calendar to the next month.
Left Arrow:   Moves the calendar to the previous month.
Up Arrow:     Advances the calendar to the next year.
Down Arrow:   Moves the calendar to the previous year.
<ESC>:        Removes the calendar from the screen.

It is important to note that the date showing as the current date will
reflect the date as set in your computer's internal clock.  Should
this information not display accurately, consult your system
specialist to have the clock corrected.


CALCULATOR <F3>

By pressing <F3> at any point in the program you are able to call to
the screen the system calculator.  The calculator functions in theory
the same as most standard calculators.  The basic functions are as
follows:


Display:  This will display the calculator on the screen and allow for
information to be entered.


Enter:  This selection will bring to the screen a "Formula" line in
which you can enter your formula for calculation.  Functions available
are displayed on the display screen face (i.e., * (multiplication),
+(addition), - (subtraction), or / (division), etc.).

When you have entered your formula, press <Enter> and the result will
be displayed at the bottom of the screen.


Load:  It is possible to use either a previously stored "Result" or
"Formula" for further calculation.  To view the data already stored in
your calculator press <D>.  (This step is not necessary if you already
know which function key contains the data you wish to use.)  When you
press <L> (i.e., Load) you will be prompted to select which of the
stored data you wish to load, to which you should respond by pressing
the corresponding function key. Next press <E> to call the "Formula"
line onto the screen.  The data you had selected will be automatically
loaded into the formula line and you may continue your calculations as
necessary.


Memory:  This selection allows you to save either a formula or result
for future reference.  After completing a calculation and the result
is displayed on the screen, select "Memory".  You will be prompted to
select a function key.  Should you wish to store the result of your
calculation, select keys <F3> through <F6>.  Should you wish to store
the formula itself, select keys <F7> through <F10>.  If you choose a
function key in which data is already stored, it will be replaced by
the new data.  Information placed in "Memory" may be recalled to the
Formula Line through use of the "Load" selection.


Replace:  From the data entry screen itself, it is possible to replace
a numeric field with calculated information.  For instance, let's say
you have a field in which you place salary information and you need to
figure out new pay information.  When you reach the field in which you
would place that information, you would invoke the calculator using
<F3>.  Using the other features outlined above, you would perform all
necessary calculations.  When calculations are completed, simply
select "Replace".  Your result would automatically be placed in the
numeric field of your data entry screen.  If this is done from an
"Edit" mode, your calculation would replace any data already placed in
the field.


<Ins>:  While entering data in the Formula Line, it is possible to
place your cursor in "Typeover" mode by pressing the <Ins> key.  This
key acts as a "toggle" switch, so pressing <Ins> would once again
place your cursor in "Insert" mode.


<Esc>:  Will return you to the program at the point from which the
calculator was invoked.



WORKING WITH FILES

When the program is executed, it presents a pull-down menu system. 
The first option displayed is entitled FILE, which incorporates the
majority of the basic file operations.  In the sections that follow,
we will examine each option presented and describe its function and
related operations.


[FILE] MAIN MENU OPTIONS


"ADD..."

"ADD..." allows you to append new entries to the database file.  When
"ADD..." is selected, the screen designed in FoxView will be displayed
along with a status bar on the top and bottom of the screen.

The top status bar lists the next record number to be appended at the
left-hand side of the screen.  To the right of the status bar a marker
will display <blank> to signify that a blank record is available for
entry.

The far right hand of the status bar displays the current system
date.  The status bar at the bottom of the screen highlights whether
you are in append or edit and also displays the number of entry pages
on the lower right hand corner.

Upon entering the "ADD..." section, the cursor will be positioned on
the first field of the index key.  The program waits for you to place
some information in this field (or fields).  Should no information be
entered (pressing the <Enter> key on the blank field), the program
will then display the "push-up" menu in the lower left-hand corner of
the screen.  If the entry is not blank, the program will perform any
data validation which has been requested and then allow you to fill in
the remaining screen or screens.


"ADD..." Options

Upon completion of the entry, the menu then gives you several 
choices.


ADD-ANOTHER:  If you need to make additional entries, the Add-another
option can be selected for another entry.


CARRY-ADD:  This option is identical to Add-another except that it
retains all the previous field values.  This feature speeds up data
entry when a number of almost identical records need to be created.


EDIT:  Allows you to modify the current entry if corrections need to
be made.


DELETE:  Cancels the current entry.  When this is done, the <Blank>
designation at the top right-hand side of the screen is replaced with
<Del>.

With both the EDIT and DELETE options, there is no actual record being
edited or deleted in the database file.  The record remains stored in
memory variables until you either decide to add another record or
select RETURN.


RETURN:  Selecting this option will bring the program back to the main
screen.



"EDIT..."

The "EDIT..." selection allows the database file to be updated as
required.  Upon entry of this section, the entry screen is displayed
along with the status bars described in the "ADD..." Section and a
"push-up" menu.  The current record is displayed.


"EDIT..." Options


EDIT:  This option allows you to update the record displayed.  Once
additions or corrections have been made, the menu is redisplayed so
that the next operation can be selected.  


FIND:  When this option is selected, a pop-up menu is displayed on the
screen.  The options listed on this menu are indexes which have been
created for the database and allows you to search rapidly for specific
information.  Find allows you to select any of the available indexes
created for the application and to find matching records.  Once an
index is selected, a second menu is displayed with the options:

Standard:  Will match the information you enter with the information
in the database, stopping at the first like match.  Use this selection
at times when a partial match is needed, such as finding the first
record with a last name that starts with "BOR".  The STANDARD find
will stop at the first name it reaches that contains those first three
letters (i.e., BORT, BORDERS, or BORMAN).  If no names contain these
letters, a "No Find" message is displayed.

Approximate:  Will search for a match and, if it does not find a
matching entry, it will stop at the first record closest to the
entered information.  For instance, using this selection to search for
a last name beginning with BOR may result in the search ending at a
record with a last name of BUTLER, CALDWELL, or even ZAMPA.  This
option is particularly handy for locating the first record of a
particular month.  If you were to use a standard find with date
information, a find would only be successful if there were a record
that matched.  However, an approximate seek would find the first date
closest to the entry figure.  This is also true if you are doing
searches on numeric information.

Exact:  Will make comparisons so that the information entered has to
match the information in the file in its entirety.  For instance, if
we were again to search for a last name which was "BOR", should there
be no last name spelled "BOR", a "No Find" message will be displayed.

Once the type of FIND has been selected, a pop-up window will be
displayed on the screen requesting you to enter the information you
wish to find. Leaving the information blank or pressing <ESC> will
abort the operation.  If the operation is successful, the screen will
then display the record which was found.  If, however, the operation
was not successful the "No Find" message is displayed.


GOTO:  This selection can be used to go quickly to either a record
whose record number is known or to go to the top or the bottom of the
database.  When the GOTO option is selected, a pop-up menu is
displayed which has the following options:

Top:  Moves you to the beginning of the database file.

Bottom:  Moves you to the end of the database file.

Number:  Places a pop-up window on the screen which requests you to
enter the record number, if it is known.

Return:  Cancels the operation.  Pressing <ESC> will do the same.



LOCATE:  LOCATE allows you to search for records which may not have
the information required in an index.  This method is much slower than
using the FIND option, but can be helpful when unusual searches are
needed.  For instance, you might wish to view only records which are
older than a certain date which is stored in your file, or examine
records of people whose last name is "Smith".  These types of
conditions can be created with the system.

When LOCATE is selected, a "browse" screen is displayed.  This screen
will list any previously created "conditions" to locate a record.  You
may select any condition that is listed or create a new condition.  A
condition is a statement which instructs the database to use only
those records which meet a certain criteria.  

To create or add a condition, you would press <A>.  The screen will
then allow you to choose a field from the database that you wish to
use in your condition.  Once the field is chosen, you are then given a
second menu which will allow you to select the desired logical
operator (i.e., <, >, =, etc.).  You are finally prompted to enter a
value that completes the condition expression.  You may exit at this
point if your condition has only one set of criteria or you may need
to add extra statements which would be used in conjunction with the
first expression built.  In this way, complex conditions can be
designed to limit the database to a small subset of the whole.

The "Condition Notes" field may be used for you to place for future
reference any special information or situations regarding the usage or
the condition.


Edit:  Should you wish to modify an existing condition, highlight the
desired condition and press <E>.

Select:  Allows you to choose an existing condition by highlighting
the desired condition and pressing <S>.  The selected condition will
then be displayed at the bottom of the screen.

Count:  Once a condition is selected, you can use Count to determine
the number of records which meet the condition.  The number of records
will be displayed on the top left-hand side of the screen.  To invoke
Count, first Select the condition you wish to use and press <C>.

cLear:  Pressing <L> will clear the selected condition.

Delete:  Highlighting a condition and pressing <D> will remove that
condition from the file.

<Esc>:  Ends the LOCATE operation and returns you to the previous
section.



DELETE:  This option marks the record for deletion and displays the
deleted status at the top right hand side of the screen.  This
selection can be thought of as a toggle switch, since deleting the
record a second time will result in it being undeleted.

Selecting DELETE does not physically remove the record from the
database.  The record is physically removed by going back to the main
menu and selecting the Index and Pack operation.  It is the "packing"
operation which then removes any records which have been marked for
removal.  (Refer to the section on INDEX & PACK).  


TURN-PAGE:  Should your entry screen consist of several pages of
information, selecting Turn-page will allows you to view the entire
record.


NEXT-RECORD and PREV-RECORD:  These selections allow you to go either
forward or backward through the database file.


RELATED FILE:  (Special note for developer--This selection is
customized by you.  End user instructions in the usage of a
Related-file selection should be inserted here.)


RETURN:  This option takes you back to the main menu.



"BROWSE" Option


"BROWSE" presents the database in a table format which can be very
helpful when it is necessary to view a listing of records.  The top of
the browse screen displays the current record number and total number
of records and underneath the field names for the information being
displayed.  ("BROWSE" automatically uses the first index listed in the
FIND menu.  Should you wish to use "BROWSE" with any other index
available in your program, refer to the FIND information in this
section.)

The cursor movement keys allow you to maneuver through the information
listed in the table one position at a time until you locate and
highlight the necessary record or information.  To move quickly from
column to column you can use the following key combinations:

     <TAB> moves your cursor one column to the right.
     <SHIFT>+<TAB> moves your cursor one column to the left.

Along the bottom of the screen is presented a number of operations
which can be performed from this section.  Each operation has a
highlighted letter which, if pressed, will perform that operation. 
For instance, to edit the record which is currently highlighted on the
browse screen, all that is necessary is to press the "E" key and the
program will then execute the "EDIT..." option.  Likewise, to "Find",
"Goto" or "fiLter" the database, you would press either "F", "G", or
"L" respectively.


FIND:  When this option is selected, a pop-up menu is displayed on the
screen.  The options listed on this menu are indexes which have been
created for the database and allows you to search rapidly for specific
information.  FIND allows you to select any of the available indexes
created for the application and to find matching records.  Once an
index is selected, a second menu is displayed with the following
options:

Standard: (Will match the information you enter with the information
in the database, stopping at the first like match.  Use this selection
at times when a partial match is needed, such as finding the first
record with a last name that starts with "BOR".  The Standard find
will stop at the first name it reaches that contains those first three
letters (i.e., BORT, BORDERS, or BORMAN).  If no names contain these
letters, a "No Find" message is displayed.

Approximate:  Will search for a match and, if it does not find a
matching entry, it will stop at the first record closest to the
entered information.  For instance, using this selection to search for
a last name beginning with BOR may result in the search ending at a
record with a last name of BUTLER, CALDWELL, or even ZAMPA.  This
option is particularly handy for locating the first record of a
particular month.  If you were to use a Standard FIND with date
information, a find would only be successful if there were a record
that matched.  However, an Approximate FIND would find the first date
closest to the entry figure.  This is also true if you are doing
searches on numeric information.)

Exact:  Will make comparisons so that the information entered has to
match the information in the file in its entirety.  For instance, if
we were again to search for a last name which was "BOR", should there
be no last name spelled "BOR", a "No Find" message will be displayed.

Once the type of FIND has been selected, a pop-up window will be
displayed on the screen requesting you to enter the information you
wish to find. Leaving the information blank or pressing <ESC> will
abort the operation.  If the operation is successful, the screen will
then display the record which was found.  If, however, the operation
was not successful the "No Find" message is displayed.


GOTO:  This selection can be used to go quickly to either a record
whose record number is known or to go to the top or the bottom of the
database.  When the Goto option is selected, a pop-up menu is
displayed which has the following options:

Top:  Moves you to the beginning of the database file.

Bottom:  Moves you to the end of the database file.

Number:  Places a pop-up window on the screen which requests you to
enter the record number, if it is known.

Return:  Cancels the operation.  Pressing <ESC> will do the same.



FILTER:  FILTER is similar in function to the LOCATE option used in
EDIT in that it allows you to search for records which may not have
the information required in an index.  For instance, you might wish to
view only records which are older than a certain date which is stored
in your file.

When fiLter is selected, a "browse" screen is displayed.  This screen
will list any previously created "fiLters".  You may select any fiLter
that is listed or create a new one.  Again, like LOCATE, a fiLter is a
statement which instructs the database to use only those records which
meet a certain criteria.

To create or add a fiLter, you would press <A>.  The screen will then
allow you to choose a field from the database that you wish to use in
your filter.  Once the field is chosen, you are then given a second
menu which will allow you to select the desired logical operator
(i.e., <, >, =, etc.).  You are finally prompted to enter a value that
completes the fiLter expression.  You may exit at this point if your
fiLter has only one set of criteria or you may need to add extra
statements which would be used in conjunction with the first
expression built.  In this way, complex fiLters can be designed to
limit the database to a small subset of the whole.

The "Filter Notes" field may be used for you to place for future
reference any special information or situations regarding the usage or
the fiLter.

Edit:  Should you wish to modify an existing fiLter, highlight the
desired fiLter and press <E>.

Select:  Allows you to choose an existing fiLter by highlighting the
desired fiLter and pressing <S>.  The selected fiLter will then be
displayed at the bottom of the screen.

Count:  Once a fiLter is selected, you can use the Count option to
determine the number of records which meet the fiLter condition.  The
number of records will be displayed on the top left-hand side of the
screen.  To invoke Count, Select the fiLter you wish to use and press
<C>.

Clear:  Pressing <L> will clear the selected fiLter.

Delete:  Highlighting a fiLter and pressing <D> will remove that
fiLter from the file.

<Esc>:  Ends the fiLter operation and returns you to the previous
section.


DELETE:  To delete a record which is currently highlighted, you press
the <DELETE> key.  This option works identically to the DELETE option
as described in the "EDIT..." Section.  When in BROWSE, records that
have been marked for deletion will display an asterisk(*) or a
diamond() in the far left-hand column on the screen.

The escape key <Esc> will return you to the main menu.



"INDEX AND PACK" Option

It is advisable to back up your data files prior to performing this
operation so that, should there be any type of hardware or software
failure, the original file is saved.  If you are on a network, an
additional warning will be given before these operations start,
because no one else should be trying to access these files during an
index or pack operation.

In order to find specific records or to view the database in a
particular order, separate files are created which are used to control
how the file appears to be ordered.  These files are the "indexes" and
are analogous to a card file in a library.  The INDEX & PACK option is
used to maintain these files and the option is used for two major
purposes:

1.  To rebuild the index files so that they are consistent with the
data being stored in the files.  (INDEX)

Index files may become corrupted so that their information does not
match what it actually present in the database file.  This condition
will manifest itself when you are trying to find records that you know
are in the database, but the FIND routine is unable to locate them. 
Or, you may develop a runtime error which could result in an error
message on the screen and the system quitting prematurely.   

2.  To remove records marked for deletion.  (PACK)

When this operation is finished the deleted records are completely
erased from the files and are no longer accessible.


When INDEX & PACK is selected, you will be prompted whether you wish
to remove deleted records.  Whenever the integrity of the indexes is
in doubt (i.e., you suspect that the index is bad), you should select
"NO" to this prompt.  This will rebuild your indexes without trying to
pack them.



"EXPORT/IMPORT" Option

These options allow you to either create another file from your
database or to append another database file to your existing file. 
Possible reasons for using these options might be to use the
information with another product such as a spreadsheet or to create a
mail-merge file. 

When the EXPORT option is selected, you are prompted to select an
index.  This allows the export file to be written in a particular
order.  Use the cursor movement keys to highlight the desired index
and then press <Enter> to select.  After the index has been selected,
you are asked whether you wish to filter the export file with a
condition.  Selecting a condition enables you to export a limited
number of records which meet a particular criteria.  This selection
invokes the same routines which are used for the LOCATE routine. 
(Refer to the section discussing LOCATE).

Because you are creating a new file, the program next requests that
you enter the new filename and in what drive and directory it is to be
placed.  For instance, if you wish to have the export file placed in
your Lotus subdirectory, you might enter the following:

c:\LOTUS\export

The drive and directory must be on your machine and "legal" and the
export filename must also not exceed the eight characters available
for a proper DOS filename.

The prompt requests that the file extension not be entered, since
after you have filled in the filename you are presented with a menu
that provides you with the file types available for exporting.  Simply
highlight the type of file format you wish and press <Enter>.  The
selected extension will automatically be added to the filename.

The IMPORT option operates in a like manner, except you are not
requested to either select an index or filter condition.  The program
will prompt:  

ENTER THE IMPORT FILE WITH DRIVE, DIRECTORY, AND EXTENSION:

After you have entered this information, the program then places a
menu on the screen which will present you with the possible import
file formats.  Highlight the appropriate format and press <Enter> to
confirm.  The program will then perform the necessary operations to
import the file.

Once the operation is complete, it is necessary to go back to the main
menu and select the INDEX & PACK option to rebuild the indexes.  DO
NOT attempt to PACK the file when rebuilding the indexes after an
import.



"SELECT FILE" Option

This option allows you to select a specific database from which you
can perform necessary file maintenance functions.  Upon choosing
SELECT FILE, a second menu will be displayed.  This second menu will
give you the various databases selections available.



[REPORT] MAIN MENU OPTIONS


"VIEW DELETED RECORDS" Option

This option checks the file for records that are marked for deletion
and displays the records in a browse screen if any are found.

This is advisable to do prior to packing the file so that, should any
records have been marked for deletion in error, they can be recalled
or "undeleted".  Undeleting a record must be performed from either the
"Edit..." or "Browse" options in the [FILE] menu.

This report is slow on large databases, since it requires the program
to inspect every record in the file.

 
"RUN REPORT FORM" Option

This option will allow you to execute an existing report form. 
Selecting RUN REPORT FORM will display a second menu showing available
reports that may be run.

After choosing the desired report, you will be given another menu to
select the index.  The index selected will determine in what order the
records will be used. 

After selecting the index, you will next be asked:  "Specify Condition
on the Output?"  This enables you to filter the database so that only
records which meet a particular condition will be used in the report.

The next menu lets you choose the destination of the report.  This can
be either the Screen, Printer or a File.  Choosing Screen or File will
immediately start the report.  Choosing Printer will allow you to
select the output quality using the printer codes stored in the
"INSTALL" section.



"CREATE REPORT" Option


CREATE REPORT will prompt you to give your new report a name and then
will place you in Fox's Report Generator.  Consult Fox's reference
manual for further instructions on using the Report Generator.



"MODIFY REPORT" Option


This option allows you to change any and/or all parameters of an
existing report.  Once you have selected MODIFY REPORT, the screen
will display a menu giving you a list of existing reports available. 
Select the report you wish to modify.  The report will then be loaded
into the Report Generator, where it can then be modified.



"AD HOC REPORT" Option


This option will produce a simple columnar report for users who do not
require elaborate formatting or are unfamiliar with the Report
Generator.

Selecting this option will first allow you to choose the index from
which you wish to create your report.  Once you have selected the
appropriate index, a list will be displayed showing the available
database fields.  Highlighting the field and pressing <Enter> will
mark the field for inclusion on the listing.  Selecting the field a
second will remove it from the report.  As fields are selected, the
estimated width of the report is displayed in the upper left-hand
corner.  If you are using standard 8.5" x 11" paper, you should not
have the report exceed a width of 80.  After the fields have been
selected you may create a condition to filter the database.  This
operation is identical to the FILTER condition used in the "BROWSE"
option.

You will next be prompted to enter a "heading" for your report.  The
program allows four lines in which you may give a title or describe
the report contents.

Finally, you are prompted to have the report sent either to the Screen
or to the Printer.



[LABEL] MAIN MENU OPTION


"RUN LABELS" Option

This option will allow you to execute an existing label form. 
Selecting RUN LABELS will display a second menu showing available
labels that may be run.

After choosing the desired label, you will be given another menu to
select the index.  The index selected will determine in what order the
records will be used. 

After selecting the index, you will next be asked "Specify Condition
on the Output?"  This enables you to filter the database so that only
records which meet a particular condition will be used in the labels.

You are then prompted to select the output quality using the printer
codes stored in the INSTALL section.



"CREATE LABEL FORM" Option

CREATE LABEL FORM will prompt you to give your new labels a name and
then will place you in Fox's Label Generator.  Consult Fox's reference
manual for further instructions on using the Label Generator.



"MODIFY LABEL FORM" Option


This option allows you to change any and/or all parameters of an
existing label.  Once you have selected MODIFY LABEL FORM, the screen
will display a menu giving you a list of existing labels available. 
Select the label you wish to modify.  The label will then be loaded
into the Label Generator, where it can then be modified.



[SPECIAL] MAIN MENU OPTION


"INSTALL SYSTEM" Option

INSTALL SYSTEM allows you to modify system configurations.  These
configurations include screen colors, printer codes, client
information, data drive, and network.

IMPORTANT NOTE:  These settings should not be modified unless
instructed by the system designer.  Use of incorrect values may cause
the system to operate improperly.


After you have completed modifications in any section, you will be
asked "Are all entries correct?"  Answering "Yes" will save your
changes and return you to the INSTALL sub-menu.  Answering "No" will
allow you to re-enter your information as required.


Screen Colors:  If you are using a color monitor, your program has
default color settings already installed.  However, it is possible to
change the colors that are being used.

This option prompts you as to your monitor type (i.e., monochrome or
color).  When you answer "color" to the monitor type prompt you are
asked whether you wish to use the default color settings.  Answering
"Yes" will return you to the installation options menu. If you answer
"No", you are presented a screen which allows you to enter dBASE color
codes for various sections of the user interface.  It is advisable to
consult the developer or the Fox manuals for further instruction.


Printer Codes:  The printer code section allows you to enter the codes
necessary to enable various printing modes.  When this option is
selected, an entry screen is displayed where you may enter the codes
required for letter quality, condensed, elongated, printer reset, and
draft modes.  To modify the printer codes, you will need to refer to
the reference manual included with your particular printer.


Client Information:  When this option is selected, you will be given
an entry screen where you may place your company name and address. 
The information contained on the first line, which would usually be
your company name, will be displayed on the status bar of the main
screen when the program starts.


Data Drive:  Selecting this option will display an entry screen where
you would enter the drive letter where the data is residing.  In
addition, you are also given a place to enter the name of any backup
or restore program to be run from the [BACKUP] selection on the main
menu system.


Network:  If you are not on a network, this selection is inoperative. 
This option allows you to enter network printer queues which are
available used in the [REPORT] and [LABEL] sections for controlling
where the output is sent.



"SYSTEM DOCUMENTATION" Option

This selection will enable the FoxPro HELP system and allow you to
access any topic available in the HELP system.  FoxBase and Clipper do
not have a corresponding HELP system available, so the program instead
will display menu structures and the index keys that are used with the
system.



"PRINT DATABASE STRUCTURE" Option

This option will print the file structure of your database.  Since it
displays how the fields are ordered, it is a useful reference tool
when creating a mail-merge or export file.   Information will be
displayed by Field #, Field Name, and Field Type.

After selecting this option, you will be asked if the printer is
ready--a handy reminder!  The report is then printed and you are
prompted if you would like a form feed sent to the printer.  This will
advance the paper so that the report may be easily removed. 



"CHECK HARDWARE" Option

CHECK HARDWARE will run various system tests that may be helpful in
determining if the computer is having some type of hardware problem.

When this option is selected, it is necessary to have your printer
on.  If the printer is not usable, you are instructed to press
<Ctrl>-C to abort the option.  If the printer is ready, to  proceed
with the report you are instructed to press <Y> and then <Enter>.

The resulting printout will provide your PC specialist with valuable
information on the setup and condition of the machine.



"VERSION"

Selecting VERSION displays the version date of the program you are
currently using.  This information may be helpful in program
maintenance in situations where several workstations are used.



"CREDITS"

Selecting this option displays the name of the system designer.



[GRAPH] MAIN MENU OPTION


"FOXGRAPH" Option

If this option is available, it will allow you to run the FoxGraph
program from within your application.  Refer to your FoxGraph manual
for further information regarding usage of FoxGraph.  When you have
completed your work, exiting FoxGraph will automatically return you to
the FOXGRAPH option sub-menu.


"DEFINITION DIRECTORY" Option

FoxGraph creates its own graphing files which hold specific
information.  Selecting DEFINITION DIRECTORY allows you to enter
FoxGraph with a pre-defined graph.



[BACKUP] MAIN MENU OPTION


Both the "BACKUP DATABASE FILES" and "RESTORE DATABASE FILES" options
will execute the programs listed in the "INSTALL SYSTEM" section of
the [SPECIAL] option.  Consult your system specialist for additional
information on running these selections.


"ARCHIVE DELETED FILES" Option

This option will take any records which have been marked for deletion
and copy them to a backup diskette or diskettes.  It is possible with
the program to either use a new diskette each time records are
archived (which would enable you to keep separate sets of diskettes
for each time the operation is performed), or you can re-use the
archive diskettes and the current deleted records will be appended to
the existing copy that is on the diskette(s).

It is important to either have pre-formatted diskettes or your archive
diskettes available to place in your floppy drive when prompted.

Once this option is selected, you will be prompted that the program is
checking the file for deleted records.  If none are found, the program
automatically returns to the pull-down menu.  Depending on the size of
the file, this operation can be lengthy since each record in the file
may have to be accessed to determine if there are any deleted records.

You will next be instructed to place an archive diskette in Drive A. 
If you are using a new diskette, it will prompt you that a previous
backup was not located and ask whether you wish to create a new backup
file.  Responding "No" to the prompt will abort the operation and
return you to the sub-menu.  If you respond "Yes" to the prompt, you
will be reminded to have your backup diskettes ready.  The program
will then create the backup file and write the deleted records to the
backup diskette.  If more than one diskette is required for the backup
operation, you will be prompted to place an additional diskette in the
drive.

A message will appear on the screen that the operation is completed
and you can press any key to return to the sub-menu.

WARNING!!!  This section of the [BACKUP] option utilizes the DOS
Backup and Restore commands, which are not foolproof.  If it is
critical that your deleted files must stay in a usable form, it is
suggested that you run the option with two different sets of diskettes
or use an alternate method to save these files.



[QUIT] MAIN MENU OPTION


"EXIT PROGRAM" Option

Selecting this option simply ends the program.  You are reminded to
backup your files before exiting and are prompted to press the <Q> key
to Quit.


"RUN EXTERNAL PROGRAM" Option

Selecting this option allows you to run another program from within
the system.  When selected, you are given an entry box where you would
type the program you wish to execute.  When you  complete your work
and exit the program, you will be returned to the application.
