<* STEP_SWC.INC *>
<#
procedure STEP_SWC
begin

   <* Set Up 'Template Name' Variables *>
   fsplit(template,template_path,template_name,template_ext)

   tbl_chk = 0
   if not table
      input "Enter The Stage Table To Be Used For This Program" to tspec
      fsplit(tspec,fpath,fname,fext)
      if not fext
         fext = ".SW"
      endif
      load(fpath + fname + fext)
      tbl_chk = doserror
   endif

   fsplit(table,fpath,fname,fext)
   prog_file = fname

   main_table = table
   fsplit(main_table + 'C',fpath,fname,fext)
   swc_name = fpath + fname + fext
   swc_exist = file(swc_name)

   if swc_exist
      reset(swc_name)
      if doserror <> 0
         wait "DOS Error Reading Config File " + swc_name
         return
      endif

      <* Check For 'STEP' Header *>
      readln(swc_line)
      if swc_line <> '* <<<<< STEP >>>>>'
         wait "Error Reading Config File Header"
         tbl_chk = 1
         return
      endif

      <* Check For SWC Config File Name *>
      readln(swc_file)
      fsplit(swc_file,fpath,fname,fext)
      tmpconfig = fname
      fsplit(swc_name,fpath,fname,fext)

      if tmpconfig <> fname
         wait "Wrong Config File"
         tbl_chk = 1
         return
      endif

      <* Set Default For Swc_date *>
      readln(swc_line)
      swc_date = substr(swc_line,14,10)

      <* Set Default For Swc_time *>
      readln(swc_line)
      swc_date = substr(swc_line,14,11)

      <* Check For Current Version Number *>
      <* Future Versions Will Need To Do Additional Checking Here *>
      readln(swc_line)
      if upper(left(swc_line,17)) <> 'VERSION    = 1.00'
         wait "ERROR - Current Version is 1.00 - Config shows - " + substr(swc_line,14,4)
         tbl_chk = 1
         return
      endif

      <* Set Default For Autogen *>
      readln(swc_line)
      autogen = (upper(substr(swc_line,14,4)) = 'TRUE')

      <* Set Default For Push/Pop Margin *>
      readln(swc_line)
      indentspace = val(substr(swc_line,14,1))

      <* Set Default For BlankLines *>
      readln(swc_line)
      blanklines = not (upper(substr(swc_line,14,5)) = 'FALSE')

      <* Set Default For Comments *>
      readln(swc_line)
      comments = not (upper(substr(swc_line,14,5)) = 'FALSE')

      <* Set Default For Network *>
      readln(swc_line)
      network = (upper(substr(swc_line,14,4)) = 'TRUE')

      <* Set Default For Make_Giant *>
      readln(swc_line)
      make_giant = (upper(substr(swc_line,14,4)) = 'TRUE')

   endif

   if autogen
      set safety to false
   endif

   if (swc_exist and (not autogen)) or (not swc_exist)
      adv_user = yn_wait("Do you want to change any of the Default Options?","",false)
   else
      adv_user = false
   endif

   if adv_user

      network = yn_wait("Is this a multi user (network) application?","",network)

      make_giant = yn_wait("Do you want to generate individual program files?","YES generates individual PRG files   |   NO generates a procedure file",make_giant)

      comments = yn_wait("Do you want to include comment lines in program files?","",comments)

      blanklines = not yn_wait("Do you want to remove blank lines from the program files?","",not blanklines)

      emessage("Enter a number from 0 to 5. The default selection is " + str(indentspace) + " spaces.")
      wait "Enter The Number Of Spaces To Be Used For Program Indentation." to yesno
      emessage("")
      if yesno $ "012345"
         indentspace = val(yesno)
      endif

      if yn_wait("Do You Want To Create/Update The Default Configuration File?","Yes creates a 'Config' file based on your answers to the 'Default' options.",true)

         rewrite(main_table + 'C')
         if doserror <> 0
            return
         endif

         fsplit(main_table + 'C',fpath,fname,fext)
         genln('* <<<<< STEP >>>>>')
         genln(fpath+fname+fext)
         genln('Swc_date   = ',systemdate)
         genln('Swc_time   = ',systemtime)
         genln('Version    = 1.00')
         genln('Autogen    = FALSE')
         genln('Indentspac = ',str(indentspace))
         genln('Blanklines = ',iif(blanklines,'TRUE','FALSE'))
         genln('Comments   = ',iif(comments,'TRUE','FALSE'))
         genln('Network    = ',iif(network,'TRUE','FALSE'))
         genln('Make_giant = ',iif(make_giant,'TRUE','FALSE'))

      endif

   endif

end <* Step_Swc*>
#>
<* EOF:STEP_SWC.INC *>
