<* STEP_RPT.INC *>
<#
procedure Step_rpt
string tmpfile
string picstrg
string all_keys
integer ndxrow
integer loop_cnt
integer key_count
integer not_key_count
logical set_relations
begin
   tmpfile = fileprefix + "_RPT"
   if genheader( tmpfile,prog_file + " File Reports Program" )
      genblank
      genln('Parameters Compressed, Custm_expr, Filtr_desc, Custm_ndx, Ndx_desc')
      genblank
      gencomment('* Compressed | Logical: .T. For 16.6 cpi | .F. For 10 cpi')
      gencomment('* Custm_expr |    Char: Default Value For Custom Filter')
      gencomment('* Filtr_desc |    Char: Default Value For Custom Filter Description')
      gencomment('* Custm_ndx  |    Char: Default Value For Custom Index')
      gencomment('* Ndx_desc   |    Char: Default Value For Custom Index Description')
      genblank
      genln('Private Setfilter')
      genln('Private Rpt_modify')
      genln('Private Rpt_record')
      genln('Private Rpt_screen')
      genln('Private Rpt_bar')
      genln('Private Custm_for')
      genblank
      for loop_cnt = 1 to ndxtot
         all_keys = all_keys + ndx_list[loop_cnt]
      endfor
      select all
      select database 1
      select fields on (("," + upper(fldnam) + ",") $ all_keys) and (fldtyp $ 'CDN')
      key_count = fldtotal
      forall fields
         if forcount <= 10
            genln('Private Beg_rang',forcount,',End_rang',forcount)
         endif
      endfor
      select all
      select database 1
      select fields on ( not (("," + upper(fldnam) + ",") $ all_keys)) and (fldtyp $ 'CDN')
      not_key_count = fldtotal
      forall fields
         if key_count + forcount <= 10
            genln('Private Beg_rang',key_count + forcount,',End_rang',key_count + forcount)
         endif
      endfor
      genblank
      gencomment("* <<<<< Initialize 'Custom' User Variables >>>>>")
      genln('Store Left(M->Filtr_desc + Space(76),76) To Filtr_desc')
      genln('Store Left(M->Ndx_desc + Space(35),35) To Ndx_desc')
      genln('Store "" To Setfilter')
      genln('Store .F. To Rpt_modify')
      genln('Store Recno() To Rpt_record')
      genln('Save Screen To Rpt_screen')
      genln('Store 0 To Rpt_bar')
      genln('Store "" To Custm_for')
      genblank
      gencomment('* <<<<< Sort Order Popup Menu >>>>>')
      Select All
      Select Database 1
      ndxrow = 10 - (ndxtot / 2)
      genln("Define Popup Sort_ord From ",ndxrow,",18 To ",ndxrow + ndxtot + 3,",59 Message [Select A Sort Order For This Report           Press 'Esc' To Cancel] Color Scheme 3")
      genblank
      genln('Define Bar 1 Of Sort_ord Prompt " \<U - Custom Index Order"')
      genln('Define Bar 2 Of Sort_ord Prompt " \<0 - Listed By Record Number"')
      for loop_cnt = 3 to ndxtot + 2
         select index (loop_cnt - 2)
         gen('Define Bar ',loop_cnt,' Of Sort_ord Prompt " \<')
         if loop_cnt > 11
            gen(chr(loop_cnt + 53))
         else
            gen(loop_cnt - 2)
         endif
         gen(' - ')
         if ndxdes
            if len(ltrim(rtrim(ndxdes))) <= 25
               gen('Listed By ')
            endif
            genln(ltrim(rtrim(ndxdes)),'"')
         else
            if len(ltrim(rtrim(ndxkey))) <= 25
               gen('Listed By ')
            endif
            genln(ltrim(rtrim(ndxkey)),'"')
         endif
      endfor
      genblank
      genln('On Selection Popup Sort_ord Deactivate Popup')
      select all
      select database 1
      genblank
      if dbfdes
         genln('Do Rpt_clr With "',dbfdes,' Report"')
      else
         genln('Do Rpt_clr With "',prog_file,' File Report"')
      endif
      genblank
      genln('Select ',iif(dbfals,dbfals,dbfnam))
      genblank
      genln('Do Rpt_sort')
      genblank
      genln('Store (Set("Debug") = "ON") .AND. Getyn("Do You Want To Modify The Report?",12,.F.) To Rpt_modify')
      genblank
      genln('If .NOT. (M->Rpt_bar = 1)')
      pushmargin
      genln('Store "" To Custm_ndx')
      genln('Store Space(35) To Ndx_desc')
      popmargin
      genln('Endif')
      genblank
      select all
      select database 1
      genln('Do Case')
      pushmargin
      genln('Case M->Rpt_bar = 1')
      pushmargin
      genblank
      genln('If M->Rpt_modify')
      pushmargin
      gen('Erase ',fileprefix,'_RPT.FRV')
      linecomment('Delete Report "Environment" File')
      genln('Modify Report ',fileprefix,'_RPT')
      popmargin
      genln('Endif')
      genblank
      gen('Erase ',fileprefix,'_RPT.FRV')
      linecomment('Delete Report "Environment" File')
      genln('Do Rpt_cstm')
      genblank
      popmargin
      genln('Case M->Rpt_bar = 2')
      pushmargin
      genln('Set Index To')
      genblank
      genln('If M->Rpt_modify')
      pushmargin
      gen('Erase ',fileprefix,'_RPT0.FRV')
      linecomment('Delete Report "Environment" File')
      genln('Modify Report ',fileprefix,'_RPT0')
      popmargin
      genln('Endif')
      genblank
      gen('Erase ',fileprefix,'_RPT0.FRV')
      linecomment('Delete Report "Environment" File')
      genblank
      popmargin
      for loop_cnt = 3 to ndxtot + 2
         select index (loop_cnt - 2)
         genln('Case M->Rpt_bar = ',loop_cnt)
         pushmargin
         genln('Set Index To ',ndxnam)
         genblank
         genln('If M->Rpt_modify')
         pushmargin
         gen('Erase ',fileprefix,'_RPT')
         if (loop_cnt - 2) > 9
            gen(chr(loop_cnt + 53))
         else
            gen(loop_cnt - 2)
         endif
         gen('.FRV')
         linecomment('Delete Report "Environment" File')
         gen('Modify Report ',fileprefix,'_RPT')
         if (loop_cnt - 2) > 9
            genln(chr(loop_cnt + 53))
         else
            genln(loop_cnt - 2)
         endif
         popmargin
         genln('Endif')
         genblank
         gen('Erase ',fileprefix,'_RPT')
         if (loop_cnt - 2) > 9
            gen(chr(loop_cnt + 53))
         else
            gen(loop_cnt - 2)
         endif
         gen('.FRV')
         linecomment('Delete Report "Environment" File')
         genblank
         popmargin
      endfor
      genln('Otherwise')
      pushmargin
      genln('Do ',fileprefix,'_rset')
      genln('Return')
      popmargin
      popmargin
      genln('Endcase')
      genblank
      genln('Do Rpt_filt')
      genblank
      genln('If Empty(M->Custm_expr)')
      pushmargin
      select all
      select database 1
      select fields on (("," + upper(fldnam) + ",") $ all_keys) and (fldtyp $ 'CDN')
      forall fields
         if forcount <= 10
            if forcount = 1
               genblank
               gencomment('* <<<<< Select Range To Be Printed >>>>>')
               genln('Store "Range Selection" To ScrnTitle')
               genln('Do Rpt_scrn')
            elseif forcount = 6
               genblank
               gencomment('* <<<<< Select Range To Be Printed - Page 2 >>>>>')
               genln('Store "Range Selection - Page 2" To ScrnTitle')
               genln('Do Rpt_scrn')
            endif
            genblank
            <* Generate The 'STORE TO' Line For This Field *>
            if fldtyp = 'C'
               genln('Store Space(Len(',fldnam,')) To Beg_rang',forcount,',End_rang',forcount)
            elseif fldtyp = 'D'
               genln('Store {} To Beg_rang',forcount,',End_rang',forcount)
            elseif fldtyp = 'N'
               genln('Store 0 To Beg_rang',forcount,',End_rang',forcount)
            endif
            genblank
            gen('@  ',((iif(forcount > 5,forcount - 5,forcount) * 3) + 2),', 5 Say "')
            if fldusr
               gen(left(ljust(fldusr,24),24))
            elseif fldlab
               gen(left(ljust(fldlab,24),24))
            else
               gen(left(ljust(fldnam,24),24))
            endif
            gen(' - Start :" Get M->Beg_rang',forcount)
            genpicture
            user_comments
            gen('@  ',((iif(forcount > 5,forcount - 5,forcount) * 3) + 3),', 5 Say "                          Ending :" Get M->End_rang',forcount)
            genpicture
            user_comments
            if (forcount = 5) or (forcount = 10) or ((forcount = fldtotal) and (not_key_count = 0))
               genread
            endif
         endif
      endfor
      select all
      select database 1
      select fields on ( not (("," + upper(fldnam) + ",") $ all_keys)) and (fldtyp $ 'CDN')
      forall fields
         if key_count + forcount <= 10
            if key_count + forcount = 1
               genblank
               gencomment('* <<<<< Select Range To Be Printed >>>>>')
               genln('Store "Range Selection" To ScrnTitle')
               genln('Do Rpt_scrn')
            elseif key_count + forcount = 6
               genblank
               gencomment('* <<<<< Select Range To Be Printed - Page 2 >>>>>')
               genln('Store "Range Selection - Page 2" To ScrnTitle')
               genln('Do Rpt_scrn')
            endif
            genblank
            <* Generate The 'STORE TO' Line For This Field *>
            if fldtyp = 'C'
               genln('Store Space(Len(',fldnam,')) To Beg_rang',key_count + forcount,',End_rang',key_count + forcount)
            elseif fldtyp = 'D'
               genln('Store {} To Beg_rang',key_count + forcount,',End_rang',key_count + forcount)
            elseif fldtyp = 'N'
               genln('Store 0 To Beg_rang',key_count + forcount,',End_rang',key_count + forcount)
            endif
            genblank
            gen('@  ',((iif(key_count + forcount > 5,key_count + forcount - 5,key_count + forcount) * 3) + 2),', 5 Say "')
            if fldusr
               gen(left(ljust(fldusr,24),24))
            elseif fldlab
               gen(left(ljust(fldlab,24),24))
            else
               gen(left(ljust(fldnam,24),24))
            endif
            gen(' - Start :" Get M->Beg_rang',key_count + forcount)
            genpicture
            user_comments
            gen('@  ',((iif(key_count + forcount > 5,key_count + forcount - 5,key_count + forcount) * 3) + 3),', 5 Say "                          Ending :" Get M->End_rang',key_count + forcount)
            genpicture
            user_comments
            if (key_count + forcount = 5) or (key_count + forcount = 10) or (forcount = fldtotal)
               genread
            endif
         endif
      endfor
      popmargin
      genln('Endif')
      genblank
      genln('Do Rpt_misc')
      genln('Do Rpt_conf')
      genblank
      genln('If Empty(M->Custm_expr)')
      pushmargin
      select all
      select database 1
      select fields on (("," + upper(fldnam) + ",") $ all_keys) and (fldtyp $ 'CDN')
      forall fields
         if forcount <= 10
            if fldtyp = 'C'
               gen('Do Rpt_desc With ')
            elseif fldtyp = 'D'
               gen('Do Rpt_date With ')
            elseif fldtyp = 'N'
               gen('Do Rpt_numb With ')
            endif
            gen('"Beg_rang',forcount,'", "End_rang',forcount,'", "',fldnam,'", "Range Of ')
            if fldusr
               gen(ltrim(rtrim(fldusr)))
            elseif fldlab
               gen(ltrim(rtrim(fldlab)))
            else
               gen(fldnam)
            endif
            genln(':", ',(forcount + 5))
         endif
      endfor
      select all
      select database 1
      select fields on ( not (("," + upper(fldnam) + ",") $ all_keys)) and (fldtyp $ 'CDN')
      forall fields
         if key_count + forcount <= 10
            if fldtyp = 'C'
               gen('Do Rpt_desc With ')
            elseif fldtyp = 'D'
               gen('Do Rpt_date With ')
            elseif fldtyp = 'N'
               gen('Do Rpt_numb With ')
            endif
            gen('"Beg_rang',key_count + forcount,'", "End_rang',key_count + forcount,'", "',fldnam,'", "Range Of ')
            if fldusr
               gen(ltrim(rtrim(fldusr)))
            elseif fldlab
               gen(ltrim(rtrim(fldlab)))
            else
               gen(fldnam)
            endif
            genln(':", ',(key_count + forcount + 5))
         endif
      endfor
      popmargin
      genln('Endif')
      genblank
      genln('If .NOT. Getyn("OK to continue with this report?",22,.T.)')
      pushmargin
      genln('Do ',fileprefix,'_rset')
      genln('Return')
      popmargin
      genln('Endif')
      genblank
      genln('Do While .NOT. Printstatus()')
      pushmargin
      genln('If Getyn("Printer Is NOT Ready! Do You Want To Cancel The Report?",22,.F.)')
      pushmargin
      genln('Do ',fileprefix,'_rset')
      genln('Return')
      popmargin
      genln('Endif')
      popmargin
      genln('Enddo')
      genblank
      gencomment('* <<<<< Start Printing Report >>>>>')
      genblank
      genln('On Escape Do Rpt_abrt')
      genln('Set Escape On')
      genblank
      genln('If .NOT. Empty(M->Custm_ndx)')
      pushmargin
      genln('Clear')
      genln("@ 10,20 Say [Creating Custom Index - 'ESC' To Cancel]")
      genln('@ 12,0 Say "Indexing " + Alltrim(Str(Reccount(),6,0)) + " Record(s)"')
      genln('Set Talk On')
      genln('If Empty(M->Custm_for)')
      pushmargin
      genln('Index On &Custm_ndx To (M->Idx_file)')
      popmargin
      genln('Else')
      pushmargin
      genln('Index On &Custm_ndx For &Custm_for To (M->Idx_file)')
      popmargin
      genln('Endif')
      genln('Set Talk Off')
      popmargin
      genln('Endif')
      genblank
      genln('Clear')
      genln("@ 10,23 Say [Printing Report - 'ESC' To Cancel]")
      genblank
      genln('Set Console Off')
      genblank
      genln('Store "AFTER" To _peject')
      genln('Do Case')
      pushmargin
      genln('Case M->Rpt_bar = 1')
      pushmargin
      genblank
      if "COMPRESS" $ upper(tabflg) 
         genln('Store M->Pr_cond To _pscode')
      else
         genln('Store M->Pr_pica To _pscode')
      endif
      genblank
      popmargin
      genln('Case M->Rpt_bar = 2')
      pushmargin
      genblank
      if "COMPRESS" $ upper(dbfflg) 
         genln('Store M->Pr_cond To _pscode')
      else
         genln('Store M->Pr_pica To _pscode')
      endif
      genblank
      popmargin
      for loop_cnt = 3 to ndxtot + 2
         select index (loop_cnt - 2)
         genln('Case M->Rpt_bar = ',loop_cnt)
         pushmargin
         genblank
         if "COMPRESS" $ upper(ndxflg) 
            genln('Store M->Pr_cond To _pscode')
         else
            genln('Store M->Pr_pica To _pscode')
         endif
         genblank
         popmargin
      endfor
      popmargin
      genln('Endcase')
      genblank
      genln('Store M->Pr_pica To _pecode')
      genln('Store Step->Rpt_copies To _pcopies')
      genblank
      genln('Set Print On')
      gen('Go Top')
      linecomment('Make Sure Any Indexes Are Properly Positioned')
      genblank
      genln('If Step->Ej_before')
      pushmargin
      genln('Eject')
      popmargin
      genln('Endif')
      genblank
      genln('Printjob')
      pushmargin
      genln('If Step->Rpt_title')
      pushmargin
      genln('??? _pecode')
      genln('Do Rpt_titl')
      genln('??? _pscode')
      popmargin
      genln('Endif')
      genblank
      genln('Do Case')
      pushmargin
      genln('Case M->Rpt_bar = 1')
      pushmargin
      genln('Report Form ',fileprefix,'_RPT For &Setfilter Noeject')
      popmargin
      genln('Case M->Rpt_bar = 2')
      pushmargin
      genln('Report Form ',fileprefix,'_RPT0 For &Setfilter Noeject')
      popmargin
      select all
      select database 1
      forall indexes
         genln('Case M->Rpt_bar = ',forcount + 2)
         pushmargin
         gen('Report Form ',fileprefix,'_RPT')
         if forcount < 10
            gen(forcount)
         else
            gen(chr(forcount + 55))
         endif 
         genln(' For &Setfilter Noeject')
         popmargin
      endfor
      popmargin
      genln('Endcase')
      popmargin
      genln('Endprintjob')
      genblank
      genln('If Step->Ej_after')
      pushmargin
      genln('Eject')
      popmargin
      genln('Endif')
      genblank
      genln('Set Print Off')
      genblank
      genln('On Escape')
      genln('Set Escape Off')
      genln('Set Console On')
      genblank
      genln('Do ',fileprefix,'_rset')
      genprocfooter(tmpfile)
   endif
end Step_rpt
#>
<* EOF:STEP_RPT.INC *>
