<* STEP_DOC.INC *>
<#
procedure gendocument
string line
begin
   select all
   genln('Documentation For Stage File - ',table,'                                                      Printed On ',date,' At ',time)
   genblank
   forall databases
      genln('Database: ',dbfnam,'   -   ',dbfdes)
      genblank
      genln('                                                              Display                                                              ')
      genln('Field Description              Field Name Type Width Decimals Only    Picture              Comments                                ')
      genln('============================== ========== ==== ===== ======== ======= ==================== ========================================')
      genblank
      forall fldtyp $ 'CDLNM'
         if fldus1
            line = left(ljust(fldus1,30),30)
         elseif fldlab
            line = left(ljust(fldlab,30),30)
         else
            line = ljust(fldnam,30)
         endif
         line = line + ' ' + ljust(fldnam,10) + ' ' + fldtyp + '    ' 
         line = line + str(fldwid,5) + ' '
         line = line + iif(flddec = 0,'        ',str(flddec,8))
         if fldget = 1
            line = line + ' Yes    '
         elseif fldget = 2
            line = line + ' Hide   '
         else
            line = line + '        '
         endif
         line = line + ' ' + left(ljust(fldpic,20),20)
         line = line + ' ' + left(ljust(fldus2,40),40)
         genln(line)
      endfor
      genblank
      genblank
      genblank
      genblank
      genln('Index Files For Database: ',dbfnam,'   -   ',dbfdes)
      genblank
      genln('Index Name  Type  Unique  Fill  Key                                                 Comments                                     ')
      genln('==========  ====  ======  ====  ==================================================  =============================================')
      genblank
      forall indexes
         line = ljust(ndxnam,12) + ljust(ndxtyp,6)
         line = line + iif((ndxmod = 1) or (ndxmod = 3),'Yes     ','        ')
         line = line + iif((ndxmod = 2) or (ndxmod = 3),'Yes   ','      ')
         line = line + left(ljust(ndxkey,50),50) + '  ' + left(ljust(ndxdes,45),45)
         genln(line)
      endfor
   endfor
end gendocument
#>
<* EOF:STEP_DOC.INC *>
