<* RPT_DATE.INC *>
<#
procedure Rpt_date
string tmpfile
begin
   tmpfile = "RPT_DATE"
   if genheader( tmpfile,"Creates A 'Descriptive' Range Variable - For Report 'Date' Ranges" )
      genblank
      genln('Parameters Rng_beg, Rng_end, Rng_fld, Rng_com, Rng_line')
      genblank
      gencomment('*****************************************************************************')
      gencomment('* <<<<< Description Of Parameters >>>>>')
      gencomment('*')
      gencomment('* Rng_beg    - Name (NOT The Contents) Of The Memory Variable Used For The Lower Range Value')
      gencomment('* Rng_end    - Name (NOT The Contents) Of The Memory Variable Used For The Upper Range Value')
      gencomment('* Rng_fld    - Name (NOT The Contents) Of The Database Field For This Set Of Ranges')
      gencomment('* Rng_com    - Description Of This Range')
      gencomment("* Rng_line   - Screen Line To Display 'Description' On (Numeric Value)")
      gencomment('*')
      gencomment('* Good Example: Do Rangdesc With "Beg_rang", "End_rang", "Fld_name", "Range Of Entries:", 05')
      gencomment('*  Bad Example: Do Rangdesc With M->Beg_rang, M->End_rang, Fld_name, "Range Of Entries:", 05')
      gencomment('*****************************************************************************')
      genblank
      gencomment('*****************************************************************************')
      gencomment('* <<<<< Use Of Global Variables >>>>>')
      gencomment('*')
      gencomment('* All Variables MUST Be Defined Before Calling This Routine')
      gencomment('*')
      gencomment("* Setfilter  - Variable Used To Create A 'Filter' String")
      gencomment('*')
      gencomment('*****************************************************************************')
      genblank
      gencomment('* <<<<< Declare Private Variables >>>>>')
      genblank
      genln('Private Rng_desc')
      genln('Private Beg_rang')
      genln('Private End_rang')
      genblank
      gencomment("* <<<<< Create 'Descriptive' Range Variable >>>>>")
      genblank
      genln('If (Empty(M->&Rng_beg)) .AND. (Empty(M->&Rng_end))')
      pushmargin
      genln('Store "All" To Rng_desc')
      popmargin
      genln('Endif')
      genblank
      genln('If (.NOT. Empty(M->&Rng_beg)) .AND. (Empty(M->&Rng_end))')
      pushmargin
      genln('Store "Starting On " + DTOC(M->&Rng_beg) To Rng_desc')
      popmargin
      genln('Endif')
      genblank
      genln('If (Empty(M->&Rng_beg)) .AND. (.NOT. Empty(M->&Rng_end))')
      pushmargin
      genln('Store "Thru " + DTOC(M->&Rng_end) To Rng_desc')
      popmargin
      genln('Endif')
      genblank
      genln('If (.NOT. Empty(M->&Rng_beg)) .AND. (.NOT. Empty(M->&Rng_end))')
      pushmargin
      genln('Store DTOC(M->&Rng_beg) + " Thru " + DTOC(M->&Rng_end) To Rng_desc')
      popmargin
      genln('Endif')
      genblank
      genln('Store Alltrim(M->Rng_com) + " " + M->Rng_desc To Rng_desc')
      genblank
      gencomment("* <<<<< Display Range 'Description' On Screen >>>>>")
      genblank
      gen('Store Left(M->Rng_desc,76) To Rng_desc')
      linecomment('Trim Description To Fit On Screen')
      genln('@ M->Rng_line,39 - Int(Len(M->Rng_desc)/2) Say M->Rng_desc')
      genblank
      gencomment("* <<<<< Store 'Description' To The 'Parameters' File >>>>>")
      genln('Do Rpt_fill With M->Rng_desc')
      genblank
      gencomment("* <<<<< Update The 'Setfilter' String With The New Range(s) >>>>>")
      genblank
      genln('If .NOT. Empty(M->&Rng_beg)')
      pushmargin
      genln('Store DTOC(M->&Rng_beg) To Beg_rang')
      genln('Store M->Setfilter + " .and. &Rng_fld >= {&Beg_rang}" To Setfilter')
      popmargin
      genln('Endif')
      genblank
      genln('If .NOT. Empty(M->&Rng_end)')
      pushmargin
      genln('Store DTOC(M->&Rng_end) To End_rang')
      genln('Store M->Setfilter + " .and. &Rng_fld <= {&End_rang}" To Setfilter')
      popmargin
      genln('Endif')
      genprocfooter(tmpfile)
   endif
end Rpt_date
#>
<* EOF: RPT_DATE.INC *>
