<* NET_USE.INC *>
<#
procedure Net_Use
string tmpfile
begin
   if network
      tmpfile = "NET_USE"
      if genheader(tmpfile,"Open Files For Network Use")
         gencomment('*  Program: NET_USE.PRG')
         gencomment('*  Desc:                      FOR DBASE OR FOXBASE +')
         gencomment('*  Desc: USE PROGRAM FOR EXCL USE OR NON EXCL USE FOR DBASE OR FOXBASE +')
         gencomment('*  Desc: THIS IS NEEDED IF SOMEONE ELSE ON THE SYSTEM IS DOING A')
         gencomment('*  Desc: PACK, REINDEX, ZAP OR FOR SOME OTHER REASON HAS USED THE FILE')
         gencomment('*  Desc: UNDER EXCLUSIVE USE.')
         gencomment('***************************************************************************')
         genln('parameters f_name, ex_use')
         gen('private usekey')
         linecomment('used with inkey() if error')
         gen('private errnum')
         linecomment('number of error')
         gen('private idxfiles')
         linecomment('name of index files')
         gen('private alsname')
         linecomment('alias name for file')
         gen('private idx_pos')
         linecomment('position of "index" in f_name')
         gen('private als_pos')
         linecomment('position of "alias" in f_name')
         genln('private tempcnt')
         genln("idx_pos = at(' INDEX ',Upper(f_name))")
         genln("als_pos = at(' ALIAS ',Upper(f_name))")
         genln("alsname=''")
         genln('if als_pos>0')
         pushmargin
         genln('alsname=substr(f_name,als_pos+1)')
         genln("tempcnt = at(' INDEX ',Upper(alsname))")
         genln('if tempcnt>0')
         pushmargin
         genln('alsname=substr(alsname,1,tempcnt-1)')
         popmargin
         genln('endif')
         popmargin
         genln('endif')
         genln("idxfiles=''")
         genln('if idx_pos>0')
         pushmargin
         genln('idxfiles=substr(f_name,idx_pos+7)')
         genln("tempcnt = at(' ALIAS ',Upper(idxfiles))")
         genln('if tempcnt>0')
         pushmargin
         genln('idxfiles=substr(idxfiles,1,tempcnt-1)')
         popmargin
         genln('endif')
         popmargin
         genln('endif')
         genln('if (als_pos > 0) .and. (idx_pos = 0)')
         pushmargin
         genln('f_name=substr(f_name,1,als_pos-1)')
         popmargin
         genln('endif')
         genln('if (als_pos = 0) .and. (idx_pos > 0)')
         pushmargin
         genln('f_name=substr(f_name,1,idx_pos-1)')
         popmargin
         genln('endif')
         genln('if (als_pos > 0) .and. (idx_pos > 0) .and. (als_pos > idx_pos)')
         pushmargin
         genln('f_name=substr(f_name,1,idx_pos-1)')
         popmargin
         genln('endif')
         genln('if (als_pos > 0) .and. (idx_pos > 0) .and. (idx_pos > als_pos)')
         pushmargin
         genln('f_name=substr(f_name,1,als_pos-1)')
         popmargin
         genln('endif')
         gen('errnum=0')
         linecomment('set error number')
         gen('on error errnum=error()')
         linecomment('get error number')
         gen('if ex_use')
         linecomment('check for exclusive use')
         pushmargin
         gen('use &f_name &alsname exclusive')
         linecomment('use exclusive')
         popmargin
         genln('else')
         pushmargin
         gen('use &f_name &alsname')
         linecomment('use non exclusive')
         popmargin
         genln('endif')
         genln('if errnum=0')
         pushmargin
         genln('set index to &idxfiles')
         popmargin
         genln('endif')
         genln('on error')
         gen('if m->errnum>0')
         linecomment('could not use file')
         pushmargin
         gensetcolor('&SetColorO','')
         genln('clear')
         genln('if len(dbf())>0')
         pushmargin
         genln('@  5,5 say [Error trying to set index(s) - "]+m->idxfiles+["]')
         popmargin
         genln('else')
         pushmargin
         genln('@  5,5 say [Error trying to open file - "]+m->f_name+["]')
         popmargin
         genln('endif')
         genln("@  7,5 say 'ERROR: '+ltrim(str(errnum))+' - '+message()")
         genln('tempcnt=2')
         genln('do while .t.')
         pushmargin
         genln('do case')
         pushmargin
         genln("case len(sys(16,tempcnt))=0 .and. at(':',sys(16,tempcnt-2))=0")
         pushmargin
         genln("@ 9,5 say 'Calling procedure is - '+sys(16,tempcnt-2)")
         genln('exit')
         popmargin
         genln("case len(sys(16,tempcnt))=0 .and. at(':',sys(16,tempcnt-2))>0")
         pushmargin
         genln("@ 9,5 say 'Calling program is - '+sys(16,tempcnt-2)")
         genln('exit')
         popmargin
         popmargin
         genln('endcase')
         genln('tempcnt=tempcnt+1')
         popmargin
         genln('enddo')
         genln('close databases')
         genln('clear typeahead')
         gencomment('* check to see if net_use is the second program (called from main program)')
         genln('if len(sys(16,3))=0  ')
         pushmargin
         genln("@ 11,5 say 'Program will abort.'")
         genln("@ 13,5 say 'Press any key to continue...'")
         genln('usekey=inkey(0)')
         genln('Set Color To')
         gencursoron("","")
         genln('quit')
         popmargin
         genln('else')
         pushmargin
         genln("@ 11,5 say 'Program will return to menu.'")
         genln("@ 13,5 say 'Press any key to continue...'")
         genln('usekey=inkey(0)')
         genln('return to master')
         popmargin
         genln('endif')
         popmargin
         genln('endif')
         genprocfooter(tmpfile)
      endif
   endif
end Net_Use
#>
<* EOF:NET_USE.INC *>
