<* NET_LOCK.INC *>
<#
procedure Net_Lock
string tmpfile
begin
   if network
      tmpfile = "NET_LOCK"
      if genheader(tmpfile,"Network File / Record Locking")
         gencomment('* NET_LOCK   :  Written by Timothy Butterfield')
         gencomment('* DESCRIPTION:  Performs file / record locking')
         gencomment('* Modified By:  John Gardner - 06/12/89')
         genblank
         genln('parameters lock_what, lock_file')
         genblank
         gen('private lock_key')
         linecomment('variable for inkey()')
         gen('private lock_scr')
         linecomment('screen variable')
         gen('private lock_cnt')
         linecomment('tries counter')
         genblank
         genln('store upper(lock_what) + [lock("] + m->lock_file + [")] to lock_what')
         gencomment('* perform quick check')
         genln('if &lock_what')
         pushmargin
         genln('return .t.')
         popmargin
         genln('endif')
         genblank
         gencomment('* Perform an extended check')
         genln('lock_cnt=1')
         genln('do while (.not. &lock_what) .and. (lock_cnt<=25)')
         pushmargin
         genln('lock_cnt=lock_cnt+1')
         popmargin
         genln('enddo')
         genblank
         genln('do while .not. &lock_what')
         pushmargin
         gencomment('* Notify of failure and ask if a continual check should be done')
         genln('save screen to lock_scr')
         genblank
         genln("if getyn('Cannot Lock '+iif(lock_what='F','File','Record')+'.  Keep Trying?',12,.T.)")
         pushmargin
         gensetcolor('&SetColorO','')
         genln('clear')
         genln('@ 10,15 to 18,65 double')
         genln('@ 11,16 to 17,64 clear')
         genln("@ 12,17 say 'Trying to Lock '+iif(lock_what='F','File','Record')+'.  Press Escape to Abort.'")
         genln("@ 14,28 say 'Time Started: '+time()")
         genln("@ 16,28 say 'Current Time:'")
         genblank
         gencomment('* Try until success or further notice')
         genln('lock_key=0')
         genln('do while (.not. &lock_what) .and. (lock_key#27)')
         pushmargin
         genln('@ 16,42 say time()')
         genln('lock_key=inkey(1)')
         popmargin
         genln('enddo')
         genblank
         popmargin
         genln('else')
         pushmargin
         genblank
         genln('if getyn("Return To Menu?",15,.F.)')
         pushmargin
         genln('close databases')
         genln('return to master')
         popmargin
         genln('endif')
         genblank
         popmargin
         genln('endif')
         genblank
         genln('restore screen from lock_scr')
         genblank
         popmargin
         genln('enddo')
         genfuncfooter(tmpfile,".T.")
      endif
   endif
end Net_Lock
#>
<* EOF:NET_LOCK.INC *>
