<* GETYN.INC *>
<#
procedure GenGetYN
string tmpfile
begin
   tmpfile = "GETYN"
   if genheader(tmpfile,"Get Answer To A Yes Or No Question")
      genblank
      genln("Parameters Yn_msg,Yn_row,Yn_default")
      genblank
      gencomment('* Yn_msg 	 : Message To Be Displayed In The Window')
      gencomment('* Yn_row 	 : Physical Screen Display Row For Message ( Can NOT Be The First Or Last Screen Row )')
      gencomment("* Yn_default : Default Answer For This Question (Logical - .T. for 'Yes' / .F. for 'No')")
      genblank
      gen('Private Yn_msglen')
      linecomment('Total Message Length')
      gen('Private Yn_leftcol')
      linecomment('Screen Columns To Split')
      gen('Private Yn_col')
      linecomment("Column Position For The 'No' Prompt")
      gen("Private Yn_spaces")
      linecomment("Number Of Spaces To 'Fill' Prompt With")
      genblank
      gen("Private Yn_defmsg")
      linecomment("Programmer Defined Default Message")
      gen("Private Yn_delim_l")
      linecomment("Left 'Title' Delimiter")
      gen("Private Yn_delim_r")
      linecomment("Right 'Title' Delimiter")
      genblank
      gen("Private Yn_answer")
      linecomment("User Response Value")
      genblank
      gencomment('* <<<<< Adjust Parameter Values For Bad Input >>>>>')
      gen("Store Alltrim(M->Yn_msg) To Yn_msg")
      linecomment('Trim The Message')
      gen("Store IIF(M->Yn_row < 1,1,IIF(M->Yn_row >= (Srows() - 2),Srows() - 2,Int(M->Yn_row))) To Yn_row")
      linecomment("Check For Valid Row")
      genblank
      gencomment('* <<<<< Programmer Defined Defaults For Getyn >>>>>')
      genln("Store [Please Select 'Yes' or 'No'] To Yn_defmsg")
      genln('Store "[ " To Yn_delim_l')
      genln('Store " ]" To Yn_delim_r')
      genblank
      gencomment('* <<<<< Programmer Defined Color Settings >>>>>')
      gen("Set Color Of Scheme 1 To Scheme(3)")
      linecomment("Current System 'Menu Bar' Color Settings")
      gen("Set Color Of Scheme 2 To Scheme(3)")
      linecomment("Current System 'Menu Bar' Color Settings")
      genblank
      gencomment("* <<<<< 'Build' The Message String >>>>>")
      gen("Store IIF(Empty(M->Yn_msg),M->Yn_defmsg,M->Yn_msg) To Yn_msg")
      linecomment("Use 'Default' Message If None Passed")
      gen("Store Left(M->Yn_msg,Scols() - 6 - Len(M->Yn_delim_l + M->Yn_delim_r)) To Yn_msg")
      linecomment("Truncate Based On Current Screen Width / Delimiters")
      gen('Store IIF(Empty(M->Yn_msg),"",M->Yn_delim_l + M->Yn_msg + M->Yn_delim_r) To Yn_msg')
      linecomment('Add Delimiters')
      genblank
      gen("Store Len(M->Yn_msg) + 6 To Yn_msglen")
      linecomment("Adjust Length For 'Title' Borders")
      genblank
      gen("Store IIF(M->Yn_msglen > 14,M->Yn_msglen,14) To Yn_msglen")
      linecomment("Adjust For 'Short' Messages")
      genblank
      gen("Store Int((Scols() - M->Yn_msglen) / 2) To Yn_leftcol")
      linecomment('Window Left Column (Start)')
      genblank
      gencomment("* <<<<< Define Window For 'Getyn' >>>>>")
      genln("Define Window Getyn From (M->Yn_row - 1),M->Yn_leftcol To (M->Yn_row + 1),(M->Yn_leftcol + M->Yn_msglen - 1) Nogrow Nofloat Nozoom Noclose Double Title M->Yn_msg Shadows")
      genblank
      gencomment("* <<<<< Calculate 'No' Prompt Starting Column >>>>>")
      genln("Store 7 + (Int((M->Yn_msglen - 14)/ 4) * 2) + Mod(M->Yn_msglen - 14,4) To Yn_col")
      genblank
      gencomment("* <<<<< Calculate The Menu Pad 'Buffer' Spaces >>>>>")
      genln("Store Int((M->Yn_msglen - 14)/ 4) To Yn_spaces")
      genblank
      genln("Do While .T.")
      pushmargin
      genblank
      gencomment('* <<<<< Display Getyn Window / Message >>>>>')
      genln("Activate Window Getyn")
      genblank
      genln('@ 0,1 Prompt Space(M->Yn_spaces) + " Yes " + Space(M->Yn_spaces) Message "Answer Is YES"')
      genln('@ 0,M->Yn_col Prompt Space(M->Yn_spaces) + " No " + Space(M->Yn_spaces) Message "Answer Is NO"')
      genblank
      genln("Store IIF(M->Yn_default,1,2) to Yn_answer")
      genln("Menu To Yn_answer")
      genblank
      genln("If Between(M->Yn_answer,1,2)")
      pushmargin
      genln("Exit")
      popmargin
      genln("Endif")
      genblank
      popmargin
      genln("Enddo")
      genblank
      gencomment('* <<<<< Release Menu / Window >>>>>')
      genln("Release Window Getyn")
      genln("Activate Screen")
      genblank
      gencomment('* <<<<< Return Response >>>>>')
      genfuncfooter(tmpfile+"()","(M->Yn_answer = 1)")
   endif
end GenGetYN
#>
<* EOF: GETYN.INC *>
