<* FMTOPEN.INC *>
<#
procedure GenOpen
string tmpfile
string lndxdes
integer ndxptr
integer open_loop
integer menu_col
integer menu_col_empty
integer menu_col_offset
begin
   tmpfile = fileprefix + "_OPEN"
   if genheader(tmpfile,"Open File(s)")
      genblank
      gensetcolor('&SetColorF','')
      genln('@ 24,00')
      genln('@ 24,22 Say "Opening Files - *** Please Wait ***"')
      select all
      select fields on (fldtyp $ 'CDLN') and ((fldget = 1) or (fldget = 0))
      genblank
      gencomment('* <<<<< INITIALIZE MENU LINE VARIABLES >>>>>')
      genln('Private ',fileprefix,'_item')
      genln('Store 1 To ',fileprefix,'_item')
      genblank
      gencomment('* <<<<< INITIALIZE - EMPTY / INDEX / PAGE# - MEMORY VARIABLES >>>>>')
      if multi_page
         genln('Private ',fileprefix,'_Page')
         genln('Store 1 To ',fileprefix,'_Page')
      endif
      forall databases
         genblank
         genln('Private ',dbf_prefix[dbfcount],'_Empty')
         genln('Store .T. To ',dbf_prefix[dbfcount],'_Empty')
         genln('Private ',dbf_prefix[dbfcount],'_Ndx')
         genln('Store ',iif(ndxtotal = 0,0,1),' To ',dbf_prefix[dbfcount],'_Ndx')
      endfor
      forall databases
         WriteUse
      endfor
      genblank
      gencomment('* <<<<< Open File - STEP >>>>>')
      gen('Select 0')
      linecomment('Select Next Available Work Area')
      if network
         genln('Do Net_use With "&Rpt_file Alias STEP",.T.')
      else
         genln('Use (M->Rpt_file) Alias STEP')
      endif
      gen('Select 1')
      linecomment('Select Main File Work Area')
      forall databases
         WriteRelation
      endfor
      forall databases
         WriteFilter
      endfor
      forall databases
         WriteEmpty
      endfor
      select all
      forall databases
         select fields on (fldtyp $ 'CNDL') and ((fldget = 1) or (fldget = 0))
         if fldtotal > 0
            genblank
            gencomment('* <<<<< FIELD MEMORY VARIABLES FOR FILE - ' + dbfnam + ' >>>>>')
            fldlist( 'Private ' )
         endif
      endfor
      select all
      forall databases
         select fields on (fldtyp $ "CDLN") and ((fldget = 1) or (fldget = 0))
         if fldtotal > 0
            genblank
            gencomment('* <<<<< INITIALIZE VARIABLES FOR FILE - ' + dbfnam + ' >>>>>')
            forall fields 
               if fldtyp = 'C'
                  genln('Store Space(Len(',fldals,'->',fldnam,')) To ',fldnam)
               elseif fldtyp = 'D'
                  genln('Store {} To ',fldnam)
               elseif fldtyp = 'L'
                  genln('Store .F. To ',fldnam)
               elseif fldtyp = 'N'
                  genln('Store 0 To ',fldnam)
               endif
               if ((forcount mod 5) = 0) and (forcount <> fldtotal)
                  genblank
               endif
            endfor
         endif
      endfor
      select all
      select fields on (fldtyp $ 'CNDL') and ((fldget = 1) or (fldget = 0)) and (fldals = "M")
      if fldtotal > 0
         genblank
         gencomment('* <<<<< STAGE MEMORY VARIABLES >>>>>')
         FldList( 'Private ' )
      endif
      select all
      select fields on (fldtyp $ "CNDL") and ((fldget = 1) or (fldget = 0)) and (fldals = "M")
      if fldtotal > 0
         genblank
         gencomment('* <<<<< INITIALIZE STAGE MEMORY VARIABLES >>>>>')
         forall fields 
            if fldtyp = 'C'
               genln('Store "" To ',fldnam)
            elseif fldtyp = 'D'
               genln('Store {} To ',fldnam)
            elseif fldtyp = 'L'
               genln('Store .F. To ',fldnam)
            elseif fldtyp = 'N'
               genln('Store 0 To ',fldnam)
            endif
            if ((forcount mod 5) = 0) and (forcount <> fldtotal)
               genblank
            endif
         endfor
      endif
      select database 1
      genblank
      if multi_dbf
         genln('Select ',iif(dbfals,dbfals,dbfnam))
         gen('Go Bottom')
         linecomment('Reset All Related Files')
      endif
      gensetcolor('&SetColorH','')
      genln('@ 0,0')
      gensetcolor('&SetColorD','')
      genln('@ 1,0 Clear To 23,79')
      genln('Do ',fileprefix,'_SCRN')
      gensetcolor('&SetColorH','')
      genblank
      gen('If .NOT. M->',dbf_prefix[1],'_Empty')
      linecomment('Display Last Entry (If Any)')
      pushmargin
      genln('@ 0,62 Say Right(Space(18) + "Rec# " + Ltrim(Str(Recno(),6,0)) + "/" + Ltrim(Str(Reccount(),6,0)),18)')
      genln('Do ',fileprefix,'_GET With .T.,.T.')
      popmargin
      genln('Else')
      pushmargin
      genln('@ 0,62 Say "--- File Empty ---"')
      popmargin
      genln('Endif')
      if ndxtotal > 0
         genblank
         genln('Do Case')
         pushmargin
         genln('Case M->',dbf_prefix[1],'_Ndx=0')
         pushmargin
         genln('@ 0,0 Say "INDEXED BY: [0] Record Number                        "')
         forall indexes
            if ndxdes
               lndxdes = left(ljust(ndxdes,35),35)
            else
               lndxdes = left(ljust(ndxkey,35),35)
            endif
            popmargin
            genln('Case M->',dbf_prefix[1],'_Ndx=',ndxcount,'')
            pushmargin
            genln('@ 0,0 Say "INDEXED BY: [',ndxcount,'] ',lndxdes,'  "')
         endfor
         popmargin
         popmargin
         genln('EndCase')
      endif
      genblank
      genln('Do While .T.')
      pushmargin
      gen("If M->",dbf_prefix[1],"_Empty")
      linecomment("File Is Empty - Allow Only 'Cancel/Help/Add'")
      pushmargin
      genln('Do While .T.')
      pushmargin
      genblank
      genln('Set Color Of Scheme 1 To Scheme 3')
      genln('Set Color Of Scheme 2 To Scheme 3')
      genblank
      genln('@ 24,00')
      genblank
      menu_col_empty = 39 - (menu_len_empty / 2)
      for open_loop = 1 to menu_cnt_empty
         if menu_line[open_loop] = "Quit"
            gen('@ 24,',menu_col_empty,' Prompt "\<Quit"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col_empty = menu_col_empty + 5
         endif
         if menu_line[open_loop] = "Help"
            gen('@ 24,',menu_col_empty,' Prompt "\<Help"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col_empty = menu_col_empty + 5
         endif
         if menu_line[open_loop] = "Add"
            gen('@ 24,',menu_col_empty,' Prompt "\<Add"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col_empty = menu_col_empty + 4
         endif
      endfor
      genblank
      genln('Menu To ',fileprefix,'_item')
      genblank
      genln('If .NOT. Empty(M->',fileprefix,'_item)')
      pushmargin
      genln('Exit')
      popmargin
      genln('Endif')
      genblank
      popmargin
      genln('EndDo')
      popmargin
      genln('Else')
      pushmargin
      gencomment('* <<<<< Define Special Menu Keys >>>>>')
      genln('On Key Label Home Keyboard "F" Plain')
      genln('On Key Label End Keyboard "L" Plain')
      genln('On Key Label Pgup Keyboard "P" Plain')
      genln('On Key Label Pgdn Keyboard "N" Plain')
      genln('On Key Label Uparrow Keyboard "P" Plain')
      genln('On Key Label Dnarrow Keyboard "N" Plain')
      if multi_page
         select all
         forall pages
            if pagcount <= pag_total
               genln('On Key Label ',pagcount,' Keyboard "G',pagcount,'" Plain')
            endif
         endfor
      endif
      genblank
      genln('Do While .T.')
      pushmargin
      genblank
      genln('Set Color Of Scheme 1 To Scheme 3')
      genln('Set Color Of Scheme 2 To Scheme 3')
      genblank
      genln('@ 24,00')
      genblank
      menu_col = 39 - (menu_len / 2)
      for open_loop = 1 to menu_cnt
         if menu_line[open_loop] = "Quit"
            gen('@ 24,',menu_col,' Prompt "\<Quit"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Help"
            gen('@ 24,',menu_col,' Prompt "\<Help"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Add"
            gen('@ 24,',menu_col,' Prompt "\<Add"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 4
         endif
         if menu_line[open_loop] = "Edit"
            gen('@ 24,',menu_col,' Prompt "\<Edit"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Browse"
            gen('@ 24,',menu_col,' Prompt "\<Browse"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 7
         endif
         if menu_line[open_loop] = "Delete"
            gen('@ 24,',menu_col,' Prompt "\<Delete"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 7
         endif
         if menu_line[open_loop] = "Seek"
            gen('@ 24,',menu_col,' Prompt "\<Seek"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Index"
            gen('@ 24,',menu_col,' Prompt "\<Index"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 6
         endif
         if menu_line[open_loop] = "paGe#"
            gen('@ 24,',menu_col,' Prompt "pa\<Ge#"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 6
         endif
         if menu_line[open_loop] = "Memo"
            gen('@ 24,',menu_col,' Prompt "\<Memo"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Window"
            gen('@ 24,',menu_col,' Prompt "\<Window"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 7
         endif
         if menu_line[open_loop] = "User"
            gen('@ 24,',menu_col,' Prompt "\<User"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Report"
            gen('@ 24,',menu_col,' Prompt "\<Report"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 7
         endif
         if menu_line[open_loop] = "Prev"
            gen('@ 24,',menu_col,' Prompt "\<Prev"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "Next"
            gen('@ 24,',menu_col,' Prompt "\<Next"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
         if menu_line[open_loop] = "First"
            gen('@ 24,',menu_col,' Prompt "\<First"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 6
         endif
         if menu_line[open_loop] = "Last"
            gen('@ 24,',menu_col,' Prompt "\<Last"')
            linecomment('Prompt # ' + str(open_loop))
            menu_col = menu_col + 5
         endif
      endfor
      genblank
      genln('Menu To ',fileprefix,'_item')
      genblank
      genln('If .NOT. Empty(M->',fileprefix,'_item)')
      pushmargin
      genln('Exit')
      popmargin
      genln('Endif')
      genblank
      popmargin
      genln('Enddo')
      genblank
      gencomment('* <<<<< Release Special Menu Keys >>>>>')
      genln('On Key Label Home')
      genln('On Key Label End ')
      genln('On Key Label Pgup')
      genln('On Key Label Pgdn')
      genln('On Key Label Uparrow')
      genln('On Key Label Dnarrow')
      if multi_page
         select all
         forall pages
            if pagcount <= pag_total
               genln('On Key Label ',pagcount)
            endif
         endfor
      endif
      genblank
      popmargin
      genln('Endif')
      genblank
      gencomment('* <<<<< Release Menu >>>>>')
      genln('Release Menu ',fileprefix,'_menu')
      genln('Activate Screen')
      genblank
      gensetcolor('&SetColorF','')
      genln('@ 24,00')
      genblank
      genln('Do Case')
      pushmargin
      genblank
      for open_loop = 1 to menu_cnt
         if menu_line[open_loop] = "Quit"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Quit')
            pushmargin
            genln('@ 24,21 Say "Returning To Menu - *** Please Wait ***"')
            genln('Exit')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Help"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Help')
            pushmargin
            genln('@ 24,21 Say "Preparing Help - *** Please Wait ***"')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Add"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Add A New Entry')
            pushmargin
            genln('@ 24,18 Say "Preparing For New Entry - *** Please Wait ***"')
            genln('Do ',fileprefix,'_ADD')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Edit"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Edit Existing Entry')
            pushmargin
            genln('@ 24,20 Say "Preparing For Edit - *** Please Wait ***"')
            genln('Do ',fileprefix,'_EDIT')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Browse"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Browse File Display')
            pushmargin
            genln('@ 24,19 Say "Preparing For Browse - *** Please Wait ***"')
            <* genln('Do ',fileprefix,'_BROW') *>
            genln('Do ',fileprefix,'_BRWM')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Delete"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Delete Existing Entry')
            pushmargin
            genln('@ 24,18 Say "Preparing For Deletion - *** Please Wait ***"')
            genln('Do ',fileprefix,'_DEL')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Seek"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Search For Existing Entry')
            pushmargin
            genln('@ 24,19 Say "Preparing For Search - *** Please Wait ***"')
            genln('Do ',fileprefix,'_SEEK')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Index"
            if multi_ndx
               gen('Case M->',fileprefix,'_item = ',open_loop)
               linecomment('Set A New Controlling Index Order')
               pushmargin
               genln('@ 24,16 Say "Preparing For Index Change - *** Please Wait ***"')
               genln('Do ',fileprefix,'_IDXO')
               genblank
               popmargin
            endif
         endif
         if menu_line[open_loop] = "paGe#"
            if multi_page
               gen('Case M->',fileprefix,'_item = ',open_loop)
               linecomment('Select A New Page Number')
               pushmargin
               genln('@ 24,14 Say "Loading paGe# Selection Menu  - *** Please Wait ***"')
               genln('Do ',fileprefix,'_PAGE')
               genblank
               popmargin
            endif
         endif
         if menu_line[open_loop] = "Memo"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Edit Memo')
            pushmargin
            genln('@ 24,17 Say "Preparing For Memo Edit - *** Please Wait ***"')
            genln('Do ',fileprefix,'_MEMO')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Window"
         endif
         if menu_line[open_loop] = "User"
         endif
         if menu_line[open_loop] = "Report"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Run Reports')
            pushmargin
            genln('@ 24,18 Say "Preparing For Reports - *** Please Wait ***"')
            genln('Do ',fileprefix,'_RPT With .F.,[],[],[],[]')
            genln('Do ',fileprefix,'_GET With .T.,.T.')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Prev"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Up Or PgUp')
            pushmargin
            genln('@ 24,18 Say "Locating Previous Entry - *** Please Wait ***"')
            genln('Skip -1')
            genln('If BOF()')
            pushmargin
            genln('Go Top')
            genln('Do ERRORMSG With "This Is The First Record!"')
            popmargin
            genln('Else')
            pushmargin
            genln('Do ',fileprefix,'_GET With .T.,.T.')
            popmargin
            genln('Endif')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Next"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Down Or PgDn')
            pushmargin
            genln('@ 24,20 Say "Locating Next Entry - *** Please Wait ***"')
            genln('Skip 1')
            genln('If EOF()')
            pushmargin
            genln('Go Bottom')
            genln('Do ERRORMSG With "This Is The Last Record!"')
            popmargin
            genln('Else')
            pushmargin
            genln('Do ',fileprefix,'_GET With .T.,.T.')
            popmargin
            genln('Endif')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "First"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('Home')
            pushmargin
            genln('@ 24,19 Say "Locating First Entry - *** Please Wait ***"')
            genln('Go Top')
            genln('Do ',fileprefix,'_GET With .T.,.T.')
            genblank
            popmargin
         endif
         if menu_line[open_loop] = "Last"
            gen('Case M->',fileprefix,'_item = ',open_loop)
            linecomment('End')
            pushmargin
            genln('@ 24,20 Say "Locating Last Entry - *** Please Wait ***"')
            genln('Go Bottom')
            genln('Do ',fileprefix,'_GET With .T.,.T.')
            genblank
            popmargin
         endif
      endfor
      popmargin
      genln('EndCase')
      popmargin
      genln('EndDo')
      genblank
      genln('Close Databases')
      genln('Erase (M->Idx_file)')
      genprocfooter(tmpfile)
   endif
end GenOpen
#>
<* EOF:FMTOPEN.INC *>
