<* FMTMENU.INC *>
<#
procedure GenMenu
string tmpfile
begin
   tmpfile = "MENUS"
   if genheader( tmpfile,"Menu Display Program" )
      genblank
      gen('Parameter Menu_num')
      linecomment('Array Number Of The Menu To Be Displayed')
      genblank
      gencomment('* MENUS.PRG   :  Written by Timothy Butterfield & John Gardner')
      gencomment('* DESCRIPTION:  Provides a menu procedure with up to eight options that displays')
      gencomment('*                 a title and the date and allows use of the')
      gencomment('*                 number keys, and the arrow, space, home, and end keys with the')
      gencomment('*                 return key.')
      genblank
      gencomment('* uses public variables:  Menu_title          title for menu')
      gencomment('*                         array Menu_item()   items for each menu')
      gencomment('*                         array Menu_msg()    message for each menu item')
      gencomment('*                         array Menu_ptr()    item pointers for each menu')
      gencomment('*                         SetColorA  (SetColorA color)')
      gencomment('*                         SetColorB  (SetColorB color)')
      genblank
      gen('private sysdate')
      linecomment('system date')
      gen('private item_num')
      linecomment('current item number')
      gen('private num_opts')
      linecomment('maximum number of options')
      gen('private max_len')
      linecomment('maximum length of Menu_title or sysdate')
      gen('private menu_col')
      linecomment('determines the starting column for menu items')
      gen('private item_len')
      linecomment('length of longest menu item')
      genblank
      gencomment('* <<<<< Get the system date and time string >>>>>')
      genln('sysdate = cdow(date())+".  "+cmonth(date())+"  "+substr(dtoc(date()),4,2)+", "+str(year(date()),4)')
      genblank
      gencomment('* <<<<< Determines maximum length of Menu_title / sysdate >>>>>')
      genln('max_len=max(len(M->Menu_title),len(sysdate))')
      genblank
      gencomment('* <<<<< Determine the number of options and max_length >>>>>')
      genln('num_opts=1')
      genln('menu_col=0')
      genln('do while (num_opts<=8).and.(len(trim(Menu_item(menu_num,num_opts)))#0)')
      pushmargin
      genln('menu_col=max(menu_col,len(trim(Menu_item(menu_num,num_opts))))')
      genln('num_opts=num_opts+1')
      popmargin
      genln('enddo')
      genln('num_opts=num_opts-1')
      genln('item_len=menu_col')
      genln('menu_col=39-int(menu_col/2)')
      genblank
      gencomment('* <<<<< Display the menu >>>>>')
      gensetcolor('&SetColorA','')
      genln('clear')
      genln('@  0,39-int(max_len/2)-2 to 3,39-int(max_len/2)+max_len+1 double')
      genln('@  1,39-int(len(M->Menu_title)/2) say M->Menu_title')
      genln('@  2,39-int(len(sysdate)/2) say sysdate')
      genblank
      genln('For Menu_loop = 1 To M->Num_opts')
      pushmargin
      genln('@ (M->Menu_loop * 2) + 3,M->Menu_col Prompt Left(Menu_item(M->Menu_num,M->Menu_loop)+Space(80),M->Item_len) Message IIF(Empty(Menu_msg(M->Menu_loop)),"",Menu_msg(M->Menu_loop))')
      popmargin
      genln('Endfor')
      genblank
      gencomment('* <<<<< Display menu instructions >>>>>')
      genln("@ 21,18 say [Use the    keys to change selections - then]")
      genln('@ 22,13 say "Press     (Return) to choose the highlighted selection."')
      genln("@ 23,25 say [Press the 'ESCAPE' key to exit.]")
      genblank
      gensetcolor('&SetColorB','')
      genln('@ 21,26 say chr(24)+chr(25)')
      genln('@ 22,19 say "<"+chr(196)+chr(217)')
      genblank
      gen('Item_num=Menu_ptr(M->Menu_num)')
      linecomment('Menu Item To Be Initially Highlighted')
      genblank
      genln('Menu To Item_num')
      genblank
      genln('Store M->Item_num To Menu_ptr(M->Menu_num)')
      genblank
      gencomment('* <<<<< Release Menu >>>>>')
      genln('Activate Screen')
      genfuncfooter(tmpfile,"M->Item_num")
   endif
end GenMenu
#>
<* EOF: FMTMENU.INC *>
