* ProUILib.PRG
*
*  Standard Clipper utility UDFs used by the ProUI
*
*
*                        +---------------+
* = = = = = = = = = = =  |  N O T I C E  |  = = = = = = = = = = = = =
*                        +---------------+
*  ͻ
*   "This template code is provided at no charge as a training aid. 
*    No guarantee nor warrantee is given, neither explicitly nor    
*    implicitly, that this template will do anything, and this code 
*    does not infringe on the intellectual properties of others.    
*                                                                   
*    Anyone who uses this template in any manner assumes full       
*    responsibility for its use."                                   
*  ͼ
*
*  The disclaimer above is provided at the advice of legal counsel.
*  Basically, it says that what is provided herein is not entirely
*  original work. Much has been done using code provided by WallSoft
*  and other published sources. Credit to others is given were I have
*  incorporated another's idea as published or with modifications.
*  The section refering to "intellectual properties" means that
*  no copyright infringement is being claimed on any of this work.
*
*  Any material that I have previously released is marked with my
*  personal copyright notice and is released to public domain.
*
*  There is no fee due to anyone if you choose to use this code,
*  providing, of course, you are using a legitimate copy of UI2(R) by
*  WallSoft and, if applicable, a legitimate copy of Clipper(R) by
*  Nantucket Corp..
*
*                              Thank you, Rik Hess
* = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
*
* FUNCTIONS INCLUDED:
*
*    achbox(t-row, lf-col, b-row, rt-col, outline-str, box-color, shade-clr, shade)
*      draw the achoice box for control index selection
*    add_rec(wait, ask, msg)
*      appends a record to a fileand locks it
*    at_bof()
*      top of file process
*    at_eof()
*      end of file process
*    bot_tone()
*      sounds the end-of-file tone
*    calendar(date, outln, colr, colrs, shadow)
*      shows a calendar to select a date
*    center(msg, line, left-fill, right-fill)
*      centers text on line with optional fill characters
*    chk_colr(@color, default)
*      set a valid color for the box
*    chk_colrs(@color, default)
*      set a valid color for the box shadow
*    chk_pwd(pwd, num, titl, lc, br, rc, outln, colr, shadclr, shdw)
*      check the operator for password entry
*    color_num(s)
*      sets the color number equivalent for the character supplied
*    cvt_color(s)
*      converts a color description 'foreground/background' to a number
*    db_pick_key(mode)
*      handles user keys for dbedit() in 'pick' windows
*    fil_lock(wait, ask, msg)
*      locks the current shared file
*    inval_tone()
*      sounds the "invalid operation" tone
*    net_use(dbf, alias, mode, wait, ask, msg)
*      opens a network file for exclusive or shared use
*    no_append()
*      tests if user exits from append mode with no append
*    outliner(top-row, left-col, bot-row, right-col, outline-str, color)
*      draw an outline around a box
*    pad(msg, len, char)
*      pads character string to length with optional fill char or space on right
*    padl(msg, len, char)
*      pads character string to length with optional fill char or space on left
*    rec_lock(wait, ask, msg)
*      locks the current record
*    readit(max-field-count)
*      handles reads on dbf records
*    say_msg_c(s, outln, colr, colrs, shadow)
*      displays passed message in box based on cursor posotion
*    set_box_coord(crow, ccol, len, depth, @tr, @lc, @br, @rc)
*      sets the box coordinates based on cursor position and message
*    set_kb_key()
*      sets inkey() values for all keyboard keys
*    shader(top-row, left-col, bot-row, right-col, color)
*      shades a portion of the screen with a given color
*    shadowbox(top-row, left-col, bot-row, right-col, color)
*      draws the shadow around the box
*    times_sq(top-row, left-col, bot-row, right-col, direction)
*      marquis style box border
*    top_tone()
*      sounds the top-of-file tone
*    valid_date(date, var)
*      validates var to a date using the calendar
*    valid_stat(state-id, outln, colr, colrs, shdw)
*      insures a valid state id is entered
*    wait_msg(msg)
*      displays the message and waits for operator input
*    xit_gets()
*      exit the get function
*    yn_confirm(yn_msg, yn_def, tr, lc, br, rc, outln, colr, colrs, shdw)
*      displays message to user and gets confirmation
*
**********************************************************

**********************************************************
* ACHBOX(t-row, lf-col, b-row, rt-col, outline-str, boc-color, shade-clr, shade)
*   draw the ACHOICE box for Control index selection
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION achbox
param    tr, lc, br, rc, outln, colr, colrs, shdw

  if type('tr') <> 'N'
    tr = 5
  endif

  if type('lc') <> 'N'
    lc = 5
  endif

  if type('br') <> 'N'
    br = 20
  endif

  if type('rc') <> 'N'
    rc = 75
  endif

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  * draw the box
  setcolor(colr)

  if !empty(outln)
    @ tr - 3, lc - 1, br + 1, rc + 1 box outln
  endif

  if shdw
    shadowbox(tr - 3, lc - 1, br + 1, rc + 1, colrs)
  endif

  @ tr - 2, lc + 1 say "Order Records by"

  if !empty(outln)
    @ tr - 1, lc say replicate(substr(outln, 2, 1), rc - lc + 1)
  else
    @ tr - 1, lc say replicate("-", rc - lc + 1)
  endif

return .t.

**********************************************************
* ADD_REC(wait, ask, msg)
*   Appends a record.  The new record is current and locked.
*  Parameters:
*    1. Seconds to wait (0 = wait forever)
*    2. Request retry flag - if not wait forever (ask/do not ask)
*    3. Message to ask (null string to use default)
*                    (Default is 'File In Use. Continue Waiting? (Y/N)')
*---------------------------------------------------------
* Notice: Add_Rec, as used here, was modified from a
* library of network functions, LOCKS.PRG, which was
* included with the Autumn 86 release of Clipper.
* Although the original code has been modified,
* no infringement of any claim of copyright by Nantucket Corp.
* is intended. - Rik Hess
**********************************************************
FUNCTION add_rec
param    wait, askwait, msgwait
private  forever, nu_msg

  if type('wait')    <> 'N'
    wait = 30
  endif

  if type('askwait') =  'U'
    askwait = .t.
  endif

  if type('msgwait') <> 'C'
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if empty(msgwait)
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  forever  = (wait = 0)
  ask_wait = wait
  nu_msg   = .t.

  do while nu_msg
    nu_msg = askwait                  && This sets the timing loop

    if forever
      nu_msg = .f.
    else
      wait = ask_wait
    endif

    do while (forever .or. wait > 0)
      append blank

      if !neterr()
        return .t.
      endif

      inkey(.5)                       && wait 1/2 second
      wait = wait - .5
    enddo

    if askwait .and. !yn_confirm(msgwait, 'N')
      nu_msg = .f.
    endif

  enddo

return .f.                             && not locked

**********************************************************
* AT_BOF()
*   Top of file process
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION at_bof

  top_tone()
  say_msg_c('Beginning of file!', '', '', '', .t.)

return .t.

**********************************************************
* AT_EOF()
*   End of file process
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION at_eof

  bot_tone()
  say_msg_c('End of file!', '', '', '', .t.)

return .t.

**********************************************************
* BOT_TONE()
*   sounds the end-of-file tone
*  Author: Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION bot_tone

  tone(900, 2)
  tone(100, 2)

return .t.

**********************************************************************
* CALENDAR(date, outln, colr, colrs, shdw)
*   shows a calendar to select a date
*
*  This routine was modified by the addition of extra params.
*  This allows easy changes to the calendar apperance.
*  Also it now centers itself at the cursor.         - Rik Hess
*
*  'CALENDAR' is a utility downloaded from the Data Based Advisor Readers
*  Exchange BBS as a Clipper modification of the FoxBASE Calendar
*  in the August 1990 issue of Data Based Advisor (vol.8, no.8)
*  from an article by David G. Barnes.
*
*   Params: date      : Date to be checked on input and returned when done
*           outln     : Char string for calendar box, default ' '
*           colr      : Basic calendar color, default '+r/w, N/w' (Outline, Inside)
*           colrs     : Shadow color, default 'r/w'
*           shdw      : .t. if calendar is to be shadowed
*           todaycolr : Special color for system 'date()', default 'r/w'
**********************************************************************
FUNCTION calendar
param    _indate, outln, colr, colrs, shdw, todaycolr
private  m_lmit, m_days, t_nkey, t_crnt, t_date, _savcolor, calscr
private  t_tday, t_ofst, t_lday, t_titl, t_crow, t_ccol, t_temp
private  daycolr, cursr_colr, tcursr_colr
private  hcol, hrow, tr, lc, br, rc, bg, fg

  if type("_indate") <> "D"
    _indate = date()
  endif

  if type('outln') <> 'C'
*    outln = ' '
    outln = sysboxo
  endif

  if type('colr') <> 'C'
*    colr = 'r/w, N/w'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
*    colrs = '+r/w'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  if type('todaycolr') <> 'C'
*    todaycolr = '+r/w'
    todaycolr = 'N/w'
  else
    chk_colrs(@todaycolr, 'N/w')
  endif

  * kill blink on all colors
  if at('*', colr) > 0
    colr = strtran(colr, '*', '')
  endif

  if at('*', colrs) > 0
    colrs = strtran(colrs, '*', '')
  endif

  if at('*', todaycolr) > 0
    todaycolr = strtran(todaycolr, '*', '')
  endif

  if at(',', colr) > 0
    daycolr = substr(colr, at(',', colr) + 1)
    colr    = substr(colr, 1, at(',', colr) - 1)
  else
    daycolr = colr
  endif

  bg        = substr(daycolr,    at('/', daycolr) + 1)
  fg        = substr(daycolr, 1, at('/', daycolr) - 1)
  cursr_colr  = strtran(bg, '+', '') + '+/' + ;
                strtran(fg, '+', '')

  bg        = substr(todaycolr,    at('/', todaycolr) + 1)
  fg        = substr(todaycolr, 1, at('/', todaycolr) - 1)
  tcursr_colr = strtran(bg, '+', '') + '+/' + ;
                strtran(fg, '+', '')

  set cursor off
  _savcolor = setcolor(colr)
  hrow      = row()
  hcol      = col()
  tr        = 0
  lc        = 0
  br        = 0
  rc        = 0

  * adjust box to cursor position - '@param' can be modified by called function
  set_box_coord(hrow, hcol, 22, 9, @tr, @lc, @br, @rc)
  m_lmit    = ctod("01/01/1583")
  m_days    = " 1  2  3  4  5  6  7  8  9 "          + ;
              "10 11 12 13 14 15 16 17 18 19 "       + ;
              "20 21 22 23 24 25 26 27 28 29 30 31 "
  t_nkey    = "x"
  t_crnt    = date()
  t_date    = iif(dtoc(_indate) > " ", max(_indate, m_lmit), t_crnt)
  calscr    = savescreen(tr, lc, br + 1, rc + 2)
  @ tr, lc, br, rc box outln

  if shdw
    shadowbox(tr, lc, br, rc, colrs)
  endif

  @ tr + 2, lc + 1 say ""
  @ tr + 3, lc + 2 say  "Su Mo Tu We Th Fr Sa"

  do while ! t_nkey $ " 13 27"
    t_tday = day(t_date)
    t_last = t_date - t_tday + 32 - day(t_date - t_tday + 32)
    t_lday = day(t_last)
    t_ofst = dow(t_date - t_tday + 1) - 1
    t_days = stuff(space(111), t_ofst * 3 + 1, t_lday * 3, left(m_days, t_lday * 3))

    setcolor(daycolr)
    t_titl = cmonth(t_date) + str(year(t_date), 5)
    @ tr + 1, lc + 2 say stuff(space(20), (22 - len(t_titl)) / 2, len(t_titl), t_titl)
    @ tr + 4, lc + 2 say   left(t_days, 21)
    @ tr + 5, lc + 2 say substr(t_days, 22, 21)
    @ tr + 6, lc + 2 say substr(t_days, 43, 21)
    @ tr + 7, lc + 2 say substr(t_days, 64, 21)
    @ tr + 8, lc + 2 say substr(t_days, 85, 21)
    @ tr + 9, lc + 2 say  right(t_days, 6) + space(15)

    if month(t_date) = month(t_crnt) .and. year(t_date) = year(t_crnt)
      setcolor(todaycolr)
      @ int(tr + 4 + (day(t_crnt) + t_ofst) / 7.1), ;
        (lc + 2) + dow(t_crnt) * 3 - 3 say str(day(t_crnt), 2)
    endif

    do while ! t_nkey       $ " 13 27"      .and. ;
              month(t_date) = month(t_last) .and. ;
               year(t_date) =  year(t_last)
      t_tday = day(t_date)
      t_crow = int((tr + 4) + (t_tday + t_ofst) / 7.1)
      t_ccol = int((lc + 2) + dow(t_date) * 3 - 3)

      if t_date = t_crnt
        setcolor(tcursr_colr)
      else
        setcolor(cursr_colr)
      endif

      @ t_crow, t_ccol say str(t_tday, 2)
      t_nkey = str(inkey(0), 3)
      clear typeahead

      do case
      case t_nkey $ "127 19" .and. ;
           t_date > m_lmit   .or.  ;
           t_nkey $ "  4 32"
        t_date = t_date + iif(t_nkey $ "127 19", -1, 1)

      case t_nkey $ "  5"      .and. ;
           t_date > m_lmit + 6 .or.  ;
           t_nkey $ " 24"
        t_date = t_date + iif(t_nkey $ "  5", -7, 7)

      case t_nkey $ " 18" .and. ;
           t_date > m_lmit + 30
        t_date = t_date - max(t_tday, day(t_date - t_tday))

      case t_nkey $ "  3"
        t_temp = t_date + t_lday
        t_date = t_temp - iif(day(t_temp) < t_tday, day(t_temp), 0)

      case t_nkey $ "  1  6" .and. ;
           t_tday # iif(t_nkey = "  1", 1, day(t_last))
        t_date = iif(t_nkey = "  1", t_date - t_tday + 1, t_last)

      case t_nkey $ " 29 23" .and. ;
           dtoc(t_date) # iif(t_nkey = " 29", "01/01", "12/31")
        t_date = ctod(iif(t_nkey = " 29", "01/01/", "12/31/") + ;
                      str(year(t_date), 4))

      case t_nkey      $ " 26"      .and. ;
           dow(t_date) > 1          .and. ;
           t_date      > m_lmit + 1 .or. ;
           t_nkey      = "  2"      .and. ;
           dow(t_date) < 7
        t_date = t_date - dow(t_date) + iif(t_nkey = " 26", 1, 7)

      case t_nkey $ " 31"        .and. ;
           t_date > m_lmit + 365 .or. ;
           t_nkey = " 30"
        t_temp = left(dtoc(t_date), 6)
        t_date = ctod(iif(t_temp = "02/29", "02/28/", t_temp) + ;
                      str(year(t_date) + iif(t_nkey = " 31", -1, 1), 4))

      case t_nkey $ "100 68 84, 116" .and. ;
           t_date # t_crnt
        t_date = t_crnt

      case t_nkey = " 21"
        t_date = iif(type("_indate") = "D" .and. dtoc(_indate) > " ", _indate, t_crnt)

      otherwise
        clear typeahead
        loop
      endcase

      if upper(setcolor()) = upper(tcursr_colr)
        setcolor(todaycolr)
      else
        setcolor(daycolr)
      endif

      @ t_crow, t_ccol say str(t_tday, 2)

    enddo

  enddo

  restscreen(tr, lc, br + 1, rc + 2, calscr)
  setcolor(_savcolor)
  set cursor on
  clear typeahead

  if t_nkey = " 13" .and. type("_indate") = "D"
    _indate = t_date
    keyboard dtoc(_indate)
  endif

  if t_nkey = " 27"
    _indate = ctod("  /  /  ")
    keyboard(chr(0))
  endif

return(_indate) 																	     

**********************************************************************
* CENTER(msg, line, left-fill, rt-fill)
*   centers text on line with optional fill character
*  Author: Rik Hess
*  Copyright 1988, Rik Hess; Released to Public Domain
**********************************************************************
FUNCTION center
param    str, ln, lchr, rchr
private  s

  if type('str')  =  'U'
    return ''
  endif

  if type('ln')   <> 'N'
    ln = 80
  endif

  if type('lchr') <> 'C'
    lchr = ' '
  endif

  if type('rchr') <> 'C'
    rchr = lchr
  endif

  if len(trim(lchr)) + len(trim(rchr)) <> 0

    if substr(str, 1, 1) <> ' '        && try to pay the message with spaces

      if len(str) < ln - 4
        str = '  ' + str + '  '
      else

        if len(str) < ln - 2
          str = ' ' + str + ' '
        endif

      endif

    endif

  endif

  s = iif(len(str) >= ln, str, replicate(lchr, (ln - len(str))/2) + str)
  s = iif(len(str) <  ln, s + replicate(rchr, ln - len(s)), s)

return s

**********************************************************
* CHK_COLR(@color, default)
*   set a valid color for the box
**********************************************************
FUNCTION chk_colr
param    colr, defcolr

  if empty(colr)
    colr = defcolr
  endif

  if at('/', colr) = 0
    colr = defcolr
  endif

return .t.

**********************************************************
* CHK_COLRS(@color, default)
*   set a valid color for the box shadow
**********************************************************
FUNCTION chk_colrs
param    colr, defcolr

  chk_colr(colr, defcolr)

  if at(',', colr) <> 0           && remove other system colors
    colr = substr(colr, 1, at(',', colr) - 1)
  endif

return .t.

**********************************************************
* CHK_PWD(pwd, num, titl, lc, br, rc, outln, colr, shadclr, shdw)
*   validates password with 'num' tries
*   Defaulf Password box is centered on screen from lines 19 to 23
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION chk_pwd
param    str, num, titl, tr, lc, br, rc, outln, colr, colrs, shdw
private  pwd, pwdbox, pwbboxln, lastcolor, ok, pwd, colrs, lastcolor
private  pwdlin1, pwdlin2, pwdlin3, pwdlin1x, pwdlin2x, pwdlin3x

  if type('str') = 'U'
    return .f.
  endif

  if type('num') <> 'N'
    num = 3
  endif

  if type('titl') <> 'C'
    titl = 'this selection'
  endif

  if empty(titl)
    titl = 'this selection'
  endif

  if type('tr') <> 'N'
    tr = 19
  endif

  if type('lc') <> 'N'
    lc = 0
  endif

  if type('br') <> 'N'
    br = 23
  endif

  if type('rc') <> 'N'
    rc = 75
  endif

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  ok         = .f.
  pwdboxln   = max(33, len(titl))
  pwdlin1    = center("Enter the Password for", pwdboxln)
  pwdlin2    = center(titl, pwdboxln)
  pwdlin3    = center("<Enter> when done, <Esc> to abort", pwdboxln)
  pwdlin1x   = center("Invalid Password, Please Retry", pwdboxln)
  pwdlin2x   = replicate(' ', pwdboxln)
  pwdlin3x   = center("<Enter> to continue", pwdboxln)
  pwdlin2z   = center("Invalid Password", pwdboxln)
  lc         = ((80 - pwdboxln + 1) / 2) - 2
  rc         = lc + pwdboxln + 2
  pwdbox     = savescreen(tr, lc, br + 1, rc + 2)
  lastcolor  = setcolor(colr)

  if !empty(outln)
    @ tr, lc, br, rc box outln
  endif

  if shdw
    shadowbox(tr, lc, br, rc, colrs)
  endif

  for ix = 1 to num
    setcolor(colr)
    scroll(tr + 1, lc + 1, br - 1, (lc + pwdboxln + 1), 0)
    @ tr + 1, lc + 1 say pwdlin1
    @ tr + 2, lc + 1 say pwdlin2
    @ tr + 3, lc + 1 say pwdlin3
    setcolor('N/N, N/N')
    pwd = ""

    do while .t.
      lastkey = inkey(0)

      if lastkey = KB_Esc
        pwd = chr(255)
        ok  = .f.
        exit
      endif

      if lastkey = KB_Enter
        exit
      endif

      pwd = pwd + upper(chr(lastkey))
    enddo

    if pwd = chr(255)                  && <Escape> exit
      exit
    endif

    if pwd == str
      ok = .t.
      exit
    else
      scroll(tr + 1, lc + 1, br - 1, rc - 1, 0)

      if ix < num
        setcolor('*+R/N')              && try again
        @ tr + 1, lc + 1 say pwdlin1x
        @ tr + 2, lc + 1 say pwdlin2x
        setcolor('+R/N')
        @ tr + 3, lc + 1 say pwdlin3x
        inval_tone()
      else
        setcolor('+R/N')               && did not pass
        @ tr + 2, lc + 1 say pwdlin2z
        tone(75, 10)
      endif

      inkey(5)
    endif

  next

  restscreen(tr, lc, br + 1, rc + 2, pwdbox)
  setcolor(lastcolor)

return ok

***********************************************************
* COLOR_NUM(s)
*   sets the color number equivalent for the character supplied
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
***********************************************************
FUNCTION color_num
param    s

  do case
  case upper(s) == 'N'                           && black/grey+
    return  0
  case upper(s) == 'B'                           && blue
    return  1
  case upper(s) == 'G'                           && green
    return  2
  case upper(s) == 'BG'                          && cyan
    return  3
  case upper(s) == 'R'                           && red
    return  4
  case upper(s) == 'RB' .or. upper(s) == 'BR'    && magenta
    return  5
  case upper(s) == 'GR'                          && brown/yellow+
    return  6
  case upper(s) == 'W'                           && white
    return  7
  case upper(s) == 'I'                           && Inverse
    return  -2
  endcase

return -1

***********************************************************
* CVT_COLOR(s)
*   Converts a color description 'Foreground/Background' to a number
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
***********************************************************
FUNCTION cvt_color
param    s
private  chop_s, fore, back, foren, backn, blink, hi

  if type('s') <> 'C'
    s = setcolor()
  endif

  if empty(s)
    s = setcolor()
  endif

  if !empty(s)             .and. ;               && Check for quote marks
    (substr(s, 1, 1) = '"' .or.  ;
     substr(s, 1, 1) = "'")
    s = substr(s, 2)
  endif

  if !empty(s)                  .and. ;
    (substr(s, len(s), 1) = '"' .or.  ;
     substr(s, len(s), 1) = "'")
    s = substr(s, 1, len(s) - 1)
  endif

  chop_s = at('/', s)

  if chop_s = 0 .or. ;
     chop_s = 1 .or. ;
     chop_s = len(s)
    return -1                          && something is not right
  endif

  fore = substr(s, 1, chop_s - 1)
  back = substr(s, chop_s + 1)

  if at('*', fore) = 0                 && check for blinking requested
    blink = .f.
  else
    blink = .t.
    fore = strtran(fore, '*', '')
  endif

  if at('+', fore) = 0                 && check for highlight requested
    hi = .f.
  else
    hi = .t.
    fore = strtran(fore, '+', '')
  endif

  foren = color_num(fore)
  backn = color_num(back)

  if foren = -1 .or. backn = -1
    return -1                          && something is not right
  endif

  if foren = -2 .or. backn = -2        && inverse

    if foren = -2 .and. backn = -2
      foren = 7
      backn = 0
    else

      if foren = -2                         && foreground not specified

        if backn = 0
          foren = 7                              && white on black
        else
          foren = 0                              && black default
        endif

      else                                  && background not specified

        if foren = 7
          backn = 0
        else                                     && black on white
          backn = 7
        endif                                    && white default

      endif

    endif

  endif

return iif(hi, foren + 8, foren) + (backn * 16) + iif(blink, 128, 0)

**********************************************************
* DB_PICK_KEY(mode)
*   handles user keys for DBEdit() in 'PICK' windows
*  Author: Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION db_pick_key
param    mode
private  ret_val, key_val, a

  * assume normal return
  ret_val   = 1

  * save last keystroke
  keystroke = lastkey()

  do case
  case m->mode = 0             && Idle
    ret_val = 1
    key_val = 0

    do case
    case m->keystroke = KB_PgUp
      seekkey = ''

    case m->keystroke = KB_PgDn
      seekkey = ''

    case m->keystroke = KB_Home
      seekkey = ''
      ret_val = 2
      key_val = KB_cPgUp
      keyboard chr(key_val)

    case m->keystroke = KB_End
      seekkey = ''
      ret_val = 2
      key_val = KB_cPgDn
      keyboard chr(key_val)

    case m->keystroke = KB_Up
      seekkey = ''

    case m->keystroke = KB_Down
      seekkey = ''

    case m->keystroke = KB_Right
      seekkey = ''
      key_val = KB_Down
      keyboard chr(key_val)

    case m->keystroke = KB_Left
      seekkey = ''
      key_val = KB_Up
      keyboard chr(key_val)

    endcase

  case m->mode = 1             && BOF

    if .not. eof()
      at_bof()
    endif

  case m->mode = 2             && EOF

    if .not. eof()
      at_eof()
    endif

  case m->mode = 3             && Empty file
    ret_val = 0

  case m->mode = 4             && keystroke exception

    do case
    case m->keystroke = KB_Esc
      ret_val = 0

    case m->keystroke = KB_Enter
      ret_val = 0

    case m->keystroke = KB_F3
      seekkey = ''
      ret_val = 2

      if type('IndxProcName') = 'C' .and. !empty(IndxProcName)
        a = &IndxProcName
      endif

    case (chr(m->keystroke) >= 'A' .and. chr(m->keystroke) <= 'Z') .or. ;
         (chr(m->keystroke) >= 'a' .and. chr(m->keystroke) <= 'z') .or. ;
         (chr(m->keystroke) >= '0' .and. chr(m->keystroke) <= '9')
      seekkey = seekkey + upper(chr(m->keystroke))
      set softseek on
      seek seekkey
      set softseek off

    endcase

  endcase

return m->ret_val

**********************************************************
* FIL_LOCK(wait, ask, msg)
*   locks the current shared file
*  parameters:
*    1. Seconds to wait (0 = wait forever)
*    2. Request retry flag - if not wait forever (ask/do not ask)
*    3. Message to ask (null string to use default)
*                    (Default is 'File In Use. Continue Waiting? (Y/N)')
*---------------------------------------------------------
* Notice: Fil_lock, as used here, was modified from a
* library of network functions, LOCKS.PRG, which was
* included with the Autumn 86 release of Clipper.
* Although the original code has been modified,
* no infringement of any claim of copyright by Nantucket Corp.
* is intended. - Rik Hess
**********************************************************
FUNCTION fil_lock
param    wait, askwait, msgwait
private  forever, nu_msg

  if type('wait')    <> 'N'
    wait = 30
  endif

  if type('askwait') =  'U'
    askwait = .t.
  endif

  if type('msgwait') <> 'C'
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if empty(msgwait)
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if flock()
    return .t.                        && locked
  endif

  forever  = (wait = 0)
  ask_wait = wait
  nu_msg   = .t.

  do while nu_msg
    nu_msg = askwait

    if forever
      nu_msg = .f.
    else
      wait = ask_wait
    endif

    do while (forever .or. wait > 0)

      if flock()
        return .t.                   && locked
      endif

      inkey(.5)                       && wait 1/2 second
      wait = wait - .5
    enddo

    if askwait

      if !yn_confirm(msgwait, 'N')
        nu_msg = .f.
      endif

    endif

  enddo

return .f.                             && not locked

**********************************************************
* INVAL_TONE()
*   sounds the "invalid operation" tone
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION inval_tone

  tone(500, 1)
  tone(900, 1)
  tone(500, 1)

return .t.  

**********************************************************
* NET_USE(dbf, alias, mode, wait, ask, msg)
*   Opens a network file for exclusive or shared use
*  Parameters:
*    1. Name of the .DBF file to open
*    2. Alias of the .DBF (null string to ignore)
*    3. Mode (.t.=exclusive, .f.=shared)
*    4. Seconds to wait (0 = wait forever)
*    5. Request retry flag - if not wait forever (ask/do not ask)
*    6. Message to ask (null string to use default)
*                    (Default is 'File In Use. Continue Waiting? (Y/N)')
* Example:
*  if net_use('accounts','acct',.t.,5,.t.,'Accounts File is in use. Wait? (Y/N)')
*    set index to name
*  else
*    ? 'File not available'
*  endif
*---------------------------------------------------------
* Notice: Net_Use, as used here, was modified from a
* library of network functions, LOCKS.PRG, which was
* included with the Autumn 86 release of Clipper.
* Although the original code has been modified,
* no infringement of any claim of copyright by Nantucket Corp.
* is intended. - Rik Hess
**********************************************************
FUNCTION net_use
param    file1, file2, ex_use, wait, askwait, msgwait
private  forever, ask_wait, nu_msg

  if type('file1') <> 'C'
    return .f.
  endif

  if type('file2') <> 'C'
    file2 = file1
  endif

  if empty(trim(file2))
    file2 = file1
  endif

  if type('wait') <> 'N'
    wait = 30
  endif

  if type('askwait') = 'U'
    askwait = .t.
  endif

  if type('msgwait') <> 'C'
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if empty(msgwait)
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  forever  = (wait = 0)
  ask_wait = wait
  nu_msg   = .t.

  do while nu_msg
    nu_msg = askwait

    if forever
      nu_msg = .f.
    else
      wait = ask_wait                 && reset the wait time
    endif

    do while (forever .or. wait > 0)

      if ex_use
        use &file1 exclusive alias &file2   && alias exclusive
      else
        use &file1 alias &file2             && alias shared
      endif

      if !neterr()                          && use succeeds
        return .t.
      endif

      inkey(1)                              && wait 1 second
      wait = wait - 1
    enddo

    if askwait                              && check to continue waiting

      if !yn_confirm(msgwait, 'N')
        nu_msg = .f.
      endif

    endif

  enddo

return .f.                                  && use fails

**********************************************************
* NO_APPEND()
*   If user exits from append mode with <Esc>, or unchanged memvars,
*   or the request to APPEND BLANK fails - NO_APPEND reports .T.
*
* Author: Chuck Burfoot
*   This is needed as a result of the way Clipper S'87 evaluates
*   a series of '.or.' conditions. Clipper will evaluate all
*   conditions, then test for true/false. This means the ver 1 code:
*     ? 'if !changed .or. fxit = -99 .or. !add_rec(30)'
*   would add a blank record to the file every time it was executed.
**********************************************************
FUNCTION no_append

  if !changed .or. fxit = -99
    return .t.                            && check user exit status
  endif

return (!add_rec(30))                     && implied if not returned - append

**********************************************************
* OUTLINER(top-row, left-col, bot-row, right-col, outline-str, outln-clr)
*   draw an outline around a box
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION outliner
param    tr, lc, br, rc, outln, colr
private  scrsav, lastcolor

  if type('tr') <> 'N' .or. ;
     type('lc') <> 'N' .or. ;
     type('br') <> 'N' .or. ;
     type('rc') <> 'N'
    return .f.
  endif

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  * outline the box
  lastcolor = ''

  if type('colr')  = 'C' .and. at('/', colr) <> 0
    lastcolor = setcolor(colr)
  endif

  scrsav = savescreen(tr + 1, lc + 1, br - 1, rc - 1)     && save box insides
  @ tr, lc, br, rc box outln
  restscreen(tr + 1, lc + 1, br - 1, rc - 1, scrsav)      && restore the insides

  if !empty(lastcolor)
    setcolor(lastcolor)
  endif

return .t.

**********************************************************
* PAD(msg, len, char)
*   pads character string to length with optional fill char or space
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION pad
param    str, ln, chr

  if type('str') <> 'C'
    return ''
  endif

  if type('ln') <> 'N'
    return str
  endif

  if len(str) >= ln
    return substr(str, 1, ln)
  endif

  if type('chr') <> 'C'
    chr = ' '
  endif

return (str + replicate(chr, ln - len(str)))

**********************************************************
* PADL(msg, len, char)
*   pads character string to length with optional fill char or space on left
*  Author: Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION padl
param    str, ln, chr

  if type('str') <> 'C'
    return ''
  endif

  if type('ln') <> 'N'
    return str
  endif

  if len(str) >= ln
    return substr(str, 1, ln)
  endif

  if type('chr') <> 'C'
    chr = ' '
  endif

return (replicate(chr, ln - len(str)) + str)

**********************************************************
* REC_LOCK(wait, ask, msg)
*   Locks the current record
*  Parameters:
*    1. Seconds to wait (0 = wait forever)
*    2. Request retry flag - if not wait forever (ask/do not ask)
*    3. Message to ask (null string to use default)
*                    (Default is 'Record In Use. Continue Waiting? (Y/N)')
*---------------------------------------------------------
* Notice: Rec_Lock, as used here, was modified from a
* library of network functions, LOCKS.PRG, which was
* included with the Autumn 86 release of Clipper.
* Although the original code has been modified,
* no infringement of any claim of copyright by Nantucket Corp.
* is intended. - Rik Hess
**********************************************************
FUNCTION rec_lock
param    wait, askwait, msgwait
private  forever, nu_msg

  if type('wait') <> 'N'
    wait = 30
  endif

  if type('askwait') = 'U'
    askwait = .t.
  endif

  if type('msgwait') <> 'C'
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if empty(msgwait)
    msgwait = 'File In Use. Continue Waiting? (Y/N)'
  endif

  if rlock()
    return .t.                        && locked
  endif

  forever  = (wait = 0)
  ask_wait = wait
  nu_msg   = .t.

  do while nu_msg
    nu_msg = askwait

    if forever
      nu_msg = .f.
    else
      wait = ask_wait
    endif

    do while (forever .or. wait > 0)

      if rlock()
        return .t.                   && locked
      endif

      inkey(.5)                       && wait 1/2 second
      wait = wait - .5
    enddo

    if askwait

      if !yn_confirm(msgwait, 'N')
        nu_msg = .f.
      endif

    endif

  enddo

return .f.                             && not locked

**********************************************************
* READIT(max-field-count)
*   handles reads on DBF records
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION readit
param    fcmax
private  old_rdkey

  if type('fcmax') <> 'N'
    return .f.
  endif

  set key KB_F1  to help
  set key KB_F10 to xit_gets
  old_rdkey = readexit(.t.)
  set escape on
  set cursor on
  clear typeahead

  read
  rkey = inkey()

  if rkey = 0
    rkey = lastkey()
  endif

  set cursor off
  set escape off
  readexit(old_rdkey)
  set key KB_F10 to
  set key KB_F1  to

  if !changed                          && once set true, stays true
    changed = updated()
  endif

  do case
  case rkey = KB_Down .or. rkey = KB_Enter
    fc   = iif(fc = fcmax, 1, fc + 1)
  case rkey = KB_Up
    fc   = iif(fc = 1, fcmax, fc - 1)
  case rkey = KB_F10
    fxit = KB_F10                        && switch for "all done" exit
    fc   = iif(fc = fcmax, 1, fc + 1)
  case rkey = KB_Esc
    fxit = -99                           && switch for "abort" exit
  endcase

return .t.

**********************************************************
* SAY_MSG_C(s, outln, colr, colrs, shdw)
*   displays passed message in box based on cursor posotion
*  Author: Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION say_msg_c
param    s, outln, colr, colrs, shdw
private  oldcolor, hcol, hrow, lens, s0, s1, tr, lc, br, rc

  if type("s") <> "C"
    return .f.
  endif

  if empty(s)
    return .f.
  endif

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  s1       = "[Any key to continue]"
  s0       = alltrim(s)
  oldcolor = setcolor(colr)
  hrow     = row()
  hcol     = col()
  lens     = max(len(s0), len(s1)) + 2
  tr       = 0
  lc       = 0
  br       = 0
  rc       = 0

  if lens > 76
    s0   = substr(s0, 1, 76)
    lens = 76
  endif

  * adjust box to cursor position - '@param' can be modified by called function
  set_box_coord(hrow, hcol, lens, 2, @tr, @lc, @br, @rc)
  msg_scrn = savescreen(tr, lc, br + 1, rc + 2)
  @ tr, lc, br, rc box outln

  if shdw
    shadowbox(tr, lc, br, rc, colrs)
  endif

  @ tr + 1, lc + 1 say center(s0, lens)
  @ tr + 2, lc + 1 say center(s1, lens)
  inkey(0)

  clear typeahead                   && reset keyboard buffer to null
  keyboard(chr(0))
  inkey()

  restscreen(tr, lc, br + 1, rc + 2, msg_scrn)
  setcolor(oldcolor)
  @ hrow, hcol say ''               && reset the cursor

return .t.

**********************************************************
* SET_BOX_COORD(crow, ccol, len, depth, @tr, @lc, @br, @rc)
*   sets the box coordinates based on cursor position and message
*  NOTE: the parameters called with a '@' in front can be assigned
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION set_box_coord
param    hr, hc, ls, ds, tr, lc, br, rc

  if hr > 13                      && if working with bottom of screen
    tr = int(max(1, hr - ds - 3)) &&  show box on top of cursor
    br = int(hr - 2)
  else
    tr = int(hr + 1)              &&  else show box on bottom of cursor
    br = int(min(23, hr + ds + 2))
  endif

  if hc + (ls / 2) > 77           && position the box centered on cursor
    rc = 77                       &&  unless it would go off the screen
    lc = int(rc - ls - 1)
  else

    if hc - (ls / 2) < 3
      lc = 3
    else
      lc = int(hc - (ls / 2))
    endif

    rc = int(min(77, lc + ls + 1))
  endif

return .t.

**********************************************************
* SET_KB_KEY()
*   sets INKEY() values for all keyboard keys, includes Extended set
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION Set_KB_Key

*ͻ
* NOTE : Although all keys are given below, if you leave all keys    
*         defined in your application they will add about 7K to your 
*         run-time memory requirements.                              
*        If you are not using a dynamic memory linker, such as       
*         RTlink(R), I strongly advised that you consider commenting 
*         out the keys not needed.                                   
*        Please do not remove the key code from your listing as      
*         future development of your application may need to use one 
*         of these keys and it is handy to have the code available.  
*                                      - Rik Hess                    
*ͼ


Public KB_F1, KB_F2, KB_F3, KB_F4, KB_F5, KB_F6, KB_F7, KB_F8, KB_F9, KB_F10
  KB_F1     =   28                     && Function Keys
  KB_F2     =   -1
  KB_F3     =   -2
  KB_F4     =   -3
  KB_F5     =   -4
  KB_F6     =   -5
  KB_F7     =   -6
  KB_F8     =   -7
  KB_F9     =   -8
  KB_F10    =   -9

Public KB_sF1, KB_sF2, KB_sF3, KB_sF4, KB_sF5, KB_sF6, KB_sF7, KB_sF8, KB_sF9, KB_sF10
  KB_sF1    =  -10                     && Shifted Function Keys
  KB_sF2    =  -11
  KB_sF3    =  -12
  KB_sF4    =  -13
  KB_sF5    =  -14
  KB_sF6    =  -15
  KB_sF7    =  -16
  KB_sF8    =  -17
  KB_sF9    =  -18
  KB_sF10   =  -19

Public KB_cF1, KB_cF2, KB_cF3, KB_cF4, KB_cF5, KB_cF6, KB_cF7, KB_cF8, KB_cF9, KB_cF10
  KB_cF1    =  -20                     && Ctrl Function Keys
  KB_cF2    =  -21
  KB_cF3    =  -22
  KB_cF4    =  -23
  KB_cF5    =  -24
  KB_cF6    =  -25
  KB_cF7    =  -26
  KB_cF8    =  -27
  KB_cF9    =  -28
  KB_cF10   =  -29

Public KB_aF1, KB_aF2, KB_aF3, KB_aF4, KB_aF5, KB_aF6, KB_aF7, KB_aF8, KB_aF9, KB_aF10
  KB_aF1    =  -30                     && Alt Function Keys
  KB_aF2    =  -31
  KB_aF3    =  -32
  KB_aF4    =  -33
  KB_aF5    =  -34
  KB_aF6    =  -35
  KB_aF7    =  -36
  KB_aF8    =  -37
  KB_aF9    =  -38
  KB_aF10   =  -39

Public KB_One, KB_Two, KB_Three, KB_Four, KB_Five, ;
       KB_Six, KB_Seven, KB_Eight, KB_Nine, KB_Zero
  KB_One    =   49                     && Number Keys
  KB_Two    =   50
  KB_Three  =   51
  KB_Four   =   52
  KB_Five   =   53
  KB_Six    =   54
  KB_Seven  =   55
  KB_Eight  =   56
  KB_Nine   =   57
  KB_Zero   =   48

Public KB_Exclam, KB_At, KB_Number, KB_Dollar, KB_Percent, ;
       KB_Carat, KB_Amprsnd, KB_Astrisk, KB_LfParen, KB_RtParen
  KB_Exclam =   33                     && Shifted Number Keys
  KB_At     =   64
  KB_Number =   35
  KB_Dollar =   36
  KB_Percent=   37
  KB_Carat  =   94
  KB_Amprsnd=   38
  KB_Astrisk=   42
  KB_LfParen=   40
  KB_RtParen=   41

Public KB_cTwo, KB_cSix
  KB_cTwo   =  259                     && Ctrl Number Keys
  KB_cSix   =   30

Public KB_aOne, KB_aTwo, KB_aThree, KB_aFour, KB_aFive, ;
       KB_aSix, KB_aSeven, KB_aEight, KB_aNine, KB_aZero
  KB_aOne   =  376                     && Alt Number Keys
  KB_aTwo   =  377
  KB_aThree =  378
  KB_aFour  =  379
  KB_aFive  =  380
  KB_aSix   =  381
  KB_aSeven =  382
  KB_aEight =  383
  KB_aNine  =  384
  KB_aZero  =  385

Public KB_A, KB_B, KB_C, KB_D, KB_E, KB_F, KB_G, KB_H, ;
       KB_I, KB_J, KB_K, KB_L, KB_M, KB_N, KB_O, KB_P, ;
       KB_Q, KB_R, KB_S, KB_T, KB_U, KB_V, KB_W, KB_X, KB_Y, KB_Z
  KB_A      =   97                     && Letter Keys
  KB_B      =   98
  KB_C      =   99
  KB_D      =  100
  KB_E      =  101
  KB_F      =  102
  KB_G      =  103
  KB_H      =  104
  KB_I      =  105
  KB_J      =  106
  KB_K      =  107
  KB_L      =  108
  KB_M      =  109
  KB_N      =  110
  KB_O      =  111
  KB_P      =  112
  KB_Q      =  113
  KB_R      =  114
  KB_S      =  115
  KB_T      =  116
  KB_U      =  117
  KB_V      =  118
  KB_W      =  119
  KB_X      =  120
  KB_Y      =  121
  KB_Z      =  122

Public KB_sA, KB_sB, KB_sC, KB_sD, KB_sE, KB_sF, KB_sG, KB_sH, ;
       KB_sI, KB_sJ, KB_sK, KB_sL, KB_sM, KB_sN, KB_sO, KB_sP, ;
       KB_sQ, KB_sR, KB_sS, KB_sT, KB_sU, KB_sV, KB_sW, KB_sX, KB_sY, KB_sZ
  KB_sA     =   65                     && Shifted (Cap) Letter Keys
  KB_sB     =   66
  KB_sC     =   67
  KB_sD     =   68
  KB_sE     =   69
  KB_sF     =   70
  KB_sG     =   71
  KB_sH     =   72
  KB_sI     =   73
  KB_sJ     =   74
  KB_sK     =   75
  KB_sL     =   76
  KB_sM     =   77
  KB_sN     =   78
  KB_sO     =   79
  KB_sP     =   80
  KB_sQ     =   81
  KB_sR     =   82
  KB_sS     =   83
  KB_sT     =   84
  KB_sU     =   85
  KB_sV     =   86
  KB_sW     =   87
  KB_sX     =   88
  KB_sY     =   89
  KB_sZ     =   90

Public KB_cA, KB_cB, KB_cC, KB_cD, KB_cE, KB_cF, KB_cG, KB_cH, ;
       KB_cI, KB_cJ, KB_cK, KB_cL, KB_cM, KB_cN, KB_cO, KB_cP, ;
       KB_cQ, KB_cR, KB_cS, KB_cT, KB_cU, KB_cV, KB_cW, KB_cX, KB_cY, KB_cZ
  KB_cA     =    1                     && Ctrl Letter Keys
  KB_cB     =    2
  KB_cC     =    3
  KB_cD     =    4
  KB_cE     =    5
  KB_cF     =    6
  KB_cG     =    7
  KB_cH     =    8
  KB_cI     =    9
  KB_cJ     =   10
  KB_cK     =   11
  KB_cL     =   12
  KB_cM     =   13
  KB_cN     =   14
  KB_cO     =   15
  KB_cP     =   16
  KB_cQ     =   17
  KB_cR     =   18
  KB_cS     =   19
  KB_cT     =   20
  KB_cU     =   21
  KB_cV     =   22
  KB_cW     =   23
  KB_cX     =   24
  KB_cY     =   25
  KB_cZ     =   26

Public KB_aA, KB_aB, KB_aD, KB_aE, KB_aF, KB_aG, KB_aH, ;
       KB_aI, KB_aJ, KB_aK, KB_aL, KB_aM, KB_aN, KB_aO, KB_aP, ;
       KB_aQ, KB_aR, KB_aS, KB_aT, KB_aU, KB_aV, KB_aW, KB_aX, KB_aY, KB_aZ
  KB_aA     =  286                     && Alt Letter Keys
  KB_aB     =  304
  KB_cD     =    0
  KB_aE     =  274
  KB_aF     =  289
  KB_aG     =  290
  KB_aH     =  291
  KB_aI     =  279
  KB_aJ     =  292
  KB_aK     =  293
  KB_aL     =  294
  KB_aM     =  306
  KB_aN     =  305
  KB_aO     =  280
  KB_aP     =  281
  KB_aQ     =  272
  KB_aR     =  275
  KB_aS     =  287
  KB_aT     =  276
  KB_aU     =  278
  KB_aV     =  303
  KB_aW     =  273
  KB_aX     =  301
  KB_aY     =  277
  KB_aZ     =  300

Public KB_Up, KB_Down, KB_Right, KB_Left
  KB_Up     =    5                     && Arrow Keys
  KB_Down   =   24
  KB_Right  =    4
  KB_Left   =   19

Public KB_cRight, KB_cLeft
  KB_cRight =    2                     && Ctrl Arrow Keys
  KB_cLeft  =   26

Public KB_Ins, KB_Del, KB_Home, KB_End, KB_PgUp, KB_PgDn, ;
       KB_Enter, KB_LF, KB_Esc, KB_Tab, KB_BkSp, KB_PrtSc, KB_SoftCR
  KB_Ins    =   22                     && Other Keys
  KB_Del    =    7
  KB_Home   =    1
  KB_End    =    6
  KB_PgUp   =   18
  KB_PgDn   =    3
  KB_Enter  =   13
  KB_LF     =   10
  KB_Esc    =   27
  KB_Tab    =    9
  KB_BkSp   =    8
  KB_PrtSc  =   42
  KB_SoftCR =  141   && Not from the keyboard-used by Clipper MEMO fields

Public KB_Minus, KB_Equal, KB_LfQuot, KB_LfBrkt, KB_RtBrkt, ;
       KB_SColon, KB_RtQuot, KB_Comma, KB_Period, KB_Slash, ;
       KB_BkSlsh, KB_Space
  KB_Minus  =   45
  KB_Equal  =   61
  KB_LfQuot =   96
  KB_LfBrkt =   91
  KB_RtBrkt =   93
  KB_SColon =   59
  KB_RtQuot =   39
  KB_Comma  =   44
  KB_Period =   46
  KB_Slash  =   47
  KB_BkSlsh =   92
  KB_Space  =   32

Public KB_sTab, KB_UnderS, KB_Plus, KB_Tilde, KB_LfBrace, KB_RtBrace, ;
       KB_Colon, KB_D_Quote, KB_Lesser, KB_Greater, KB_Questn, KB_Pipe
  KB_sTab   =  271                     && Shifted Other Keys
  KB_UnderS =   95
  KB_Plus   =   43
  KB_Tilde  =  126
  KB_LfBrace=  123
  KB_RtBrace=  125
  KB_Colon  =   58
  KB_D_Quote=   34
  KB_Lesser =   60
  KB_Greater=   62
  KB_Questn =   63
  KB_Pipe   =  124

Public KB_cHome, KB_cEnd, KB_cPgUp, KB_cPgDn, ;
       KB_cEnter, KB_cBkSp, KB_cPrtSc, KB_cScroll
  KB_cHome  =   29                     && Ctrl Other Keys
  KB_cEnd   =   23
  KB_cPgUp  =   31
  KB_cPgDn  =   30
  KB_cEnter =   10
  KB_cEsc   =   27
  KB_cBkSp  =  127
  KB_cPrtSc =   16
  KB_cScroll=    3

Public KB_cMinus, KB_cLfBrkt, KB_cRtBrkt, KB_cBkSlsh, KB_cPause
  KB_cMinus =   31
  KB_cLfBrkt=   27
  KB_cRtBrkt=   29
  KB_cBkSlsh=   28
  KB_cPause =    3

Public KB_aMinus, KB_aEqual
  KB_aMinus =  386                     && Alt Other Keys
  KB_aEqual =  387

Public RKPgUp, RKPgDn
  RKPgUp    =    6                     && READKEY() values
  RKPgDn    =    7

return .t.

***********************************************************
* SHADER(top-row, left-col, bot-row, right-col, color)
*   Shades a portion of the screen with a given color.
*   Shade_color is a dBASE standard color definition (ie: 'F/B')
*    where F is the foreground color (any of those below)
*      and B is the background color (any color in the Normal column)
*
*            Color               Description
*           Desired           Normal   Highlight
*          ---------         --------  ----------
*            Black              N       +N  or N+ (Grey)
*            Blue               B       +B  or B+
*            Green              G       +G  or G+
*            Cyan               BG      +BG or BG+
*            Red                R       +R  or R+
*            Magenta            RB      +RB or RB+
*            Brown              GR      +GR or GR+ (Yellow)
*            White              W       +W  or W+
*
*   NOTE : If Blinking is desired in the Foreground, include an astrisk
*           ("*") with the color descriptor.
*
*   NOTE :  After testing three different methods in Clipper to perform this
*           transparent shading technique, the best result is used below.
*
*         1. The STUFF() instruction to insert the new attribute
*            in the existing savescreen() variable was the slowest.
*         2. Rebuilding the original string with LEFT() and RIGHT() substr's
*            while inserting the attribute byte was only slightly faster.
*     and 3. Building a second string variable, the technique used here,
*            was significantly faster, especially on long strings.
*
*           While this is okay for most faster systems, you may want to
*           consider a third party library or your own custom 'C' or
*           alternate routine if you are developing for a base of old slow PCs.
*           It's up to you.
*                            - Rik Hess
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
***********************************************************
FUNCTION shader
param    s_tr, s_lc, s_br, s_rc, s_color
private  color_num, s_box, s_chr, s0, i

  * find the area to be colored
  if type('s_tr') <> 'N' .or. ;
     type('s_lc') <> 'N' .or. ;
     type('s_br') <> 'N' .or. ;
     type('s_rc') <> 'N'
    wait_msg('Improper box coordinates Type() sent to SHADER()')
    return .f.
  endif

  * check the box coordinates for validity
  if s_tr > s_br .or. ;
     s_tr < 0    .or. ;
     s_br > 24   .or. ;
     s_lc > s_rc .or. ;
     s_lc < 0    .or. ;
     s_rc > 79
    wait_msg('Illegal box coordinates supplied to SHADER()')
    return .f.
  endif

  * Check for valid colors requested
  if type('s_color') = 'C'
    color_num = cvt_color(s_color)
  else
    wait_msg('No color supplied to SHADER()')
    return .f.
  endif

  if color_num = -1
    wait_msg('Function SHADER() did not receive a valid color:' + s_color + ':')
    return .f.
  endif

  s_tr  = int(s_tr)
  s_lc  = int(s_lc)
  s_br  = int(s_br)
  s_rc  = int(s_rc)
  s_chr = chr(color_num)

  * Save the area to be Shaded - this is the only real "trick" used
  * The area is saved as a string variable with two bytes per screen character
  *   the 1st is the text character and the 2nd is the attribute byte

  s_box = savescreen(s_tr, s_lc, s_br, s_rc)
  * shade the box by changing the attribute byte
  s0 = ''

  for i = 2 to len(s_box) step 2
    s0 = s0 + substr(s_box, i - 1, 1) + s_chr
  next

  * show the shaded area
  restscreen(s_tr, s_lc, s_br, s_rc, s0)

return .t.

**********************************************************
* SHADOWBOX(top-row, left-col, bot-row, right-col, color)
*   Draws the shadow around the box - bottom, right side
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION shadowbox
param    sb_tr, sb_lc, sb_br, sb_rc, sb_color
private  sb_rc0, lastcolor

  if type('sb_tr') <> 'N' .or. ;
     type('sb_br') <> 'N' .or. ;
     type('sb_lc') <> 'N' .or. ;
     type('sb_rc') <> 'N'
    return .f.
  endif

  if type('sb_color') <> 'C'
    sb_color = 'N/N'
  else
    chk_colrs(@sb_color, 'N/N')
  endif

  lastcolor = setcolor()
  sb_rc0 = sb_rc + 2

  if sb_rc < 79                           && Check that shadow is on screen

    if sb_rc > 76
      sb_rc0 = sb_rc + 1
    endif

    shader(sb_tr + 1, sb_rc + 1, sb_br, sb_rc0, sb_color)
  endif

  if sb_br < 24
    shader(sb_br + 1, sb_lc + 2, sb_br + 1, sb_rc0, sb_color)
  endif

  setcolor(lastcolor)

return .t.

**********************************************************
* TIMES_SQ(top-row, left-col, bot-row, right-col, direction)
*   Theatre Marquis Style Box Border
*  Author - Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION times_sq
param    tr, lc, br, rc, drct
private  ts_ct, ts_cl, ts_cb, ts_cr
private  ts_side, ts_tp, ts_lf, ts_bt, ts_rt

  * is this a valid box?
  if tr < 0  .or. ;
     tr > br .or. ;
     br > 24 .or. ;
     lc < 0  .or. ;
     lc > rc .or. ;
     rc > 79
    return .f.
  endif

  if type('drct') = 'U'
    drct = 'L'
  endif

  if type('drct')         <> 'C' .or.  ;
   !(left(upper(drct), 1) $ 'LR')
    drct = 'L'
  else
    drct = left(upper(drct), 1)
  endif

  * get the box side strings
  ts_side = .f.

  * get top and bottom
  * trim each to an even number of chars by removing any odd char at end
  ts_tp   = savescreen(tr, lc, tr, rc)               && save the top row
  ts_tp   = substr(ts_tp, 1, len(ts_tp) - (len(ts_tp) % 2))

  if tr <> br
    ts_bt = savescreen(br, lc, br, rc)               && save the bottom row
    ts_bt = substr(ts_bt, 1, len(ts_bt) - (len(ts_bt) % 2))

    if br - tr > 1                && is there at least 1 char in side columns?
      ts_side = .t.
      ts_lf = savescreen(tr + 1, lc, br - 1, lc)    && save the left col
      ts_rt = savescreen(tr + 1, rc, br - 1, rc)    && save the right col
      ts_lf = substr(ts_lf, 1, len(ts_lf) - (len(ts_lf) % 2))
      ts_rt = substr(ts_rt, 1, len(ts_rt) - (len(ts_rt) % 2))
    endif

    * now get char to rotate
    *  for drct='L' - 1st of top and right, last of left and bottom
    *  for drct='R' - last of top and right, 1st of left and bottom
    *  remove it from the original string
    *  then add the removed chars onto the new strings

    if drct = 'L'
      ts_ct =  left(ts_tp, 2)              && include the attribute byte
      ts_cb = right(ts_bt, 2)
      ts_tp = iif(len(ts_tp) > 2, substr(ts_tp, 3),              '')
      ts_bt = iif(len(ts_tp) > 2,   left(ts_bt, len(ts_bt) - 2), '')
    else
      ts_ct = right(ts_tp, 2)              && include the attribute byte
      ts_cb =  left(ts_bt, 2)
      ts_tp = iif(len(ts_tp) > 2,   left(ts_tp, len(ts_tp) - 2), '')
      ts_bt = iif(len(ts_tp) > 2, substr(ts_bt, 3),              '')
    endif

    if ts_side

      if drct = 'L'
        ts_cl = right(ts_lf, 2)
        ts_cr =  left(ts_rt, 2)
        ts_lf = iif(len(ts_lf) > 2,   left(ts_lf, len(ts_lf) - 2), '')
        ts_rt = iif(len(ts_lf) > 2, substr(ts_rt, 3),              '')
        ts_tp = ts_tp + ts_cr
        ts_lf = ts_ct + ts_lf
        ts_bt = ts_cl + ts_bt
        ts_rt = ts_rt + ts_cb
      else
        ts_cl =  left(ts_lf, 2)
        ts_cr = right(ts_rt, 2)
        ts_lf = iif(len(ts_lf) > 2, substr(ts_lf, 3),              '')
        ts_rt = iif(len(ts_lf) > 2,   left(ts_rt, len(ts_rt) - 2), '')
        ts_tp = ts_cl + ts_tp
        ts_lf = ts_lf + ts_cb
        ts_bt = ts_bt + ts_cr
        ts_rt = ts_ct + ts_rt
      endif

      restscreen(tr + 1, lc, br - 1, lc, ts_lf)
      restscreen(tr + 1, rc, br - 1, rc, ts_rt)
    else

      if drct = 'L'
        ts_tp = ts_tp + ts_cb
        ts_bt = ts_ct + ts_bt
      else
        ts_tp = ts_cb + ts_tp
        ts_bt = ts_bt + ts_ct
      endif

    endif

    restscreen(br, lc, br, rc, ts_bt)
  else

    if drct = 'L'
      ts_tp = substr(ts_tp, 3) + left(ts_tp,   2)
    else
      ts_tp = right(ts_tp,  2) + substr(ts_tp, 3)
    endif

  endif

  restscreen(tr, lc, tr, rc, ts_tp)

return .t.

**********************************************************
* TOP_TONE()
*   sounds the top-of-file tone
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION top_tone

  tone(900, 2)
  tone(500, 2)

return .t.

**********************************************************
* VALID_DATE(date)
*   validates var to a date using the calendar
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION valid_date
param    _indate
private  idate

  if empty(_indate)
    idate    = date()
    _indate  = calendar(idate)

    if ctod("  /  /  ") <> _indate
      changed  = .t.
    endif

  endif

return .t.

**********************************************************
* VALID_STAT(state-id, outln, colr, colrs, shdw)
*   Insures a valid State ID is entered
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
*  This routine will use two arrays; named c_StatesV[] and
*  c_StIdV[]. These are normally built as part of the
*  start-up process of a gen'ed 'main' program.
**********************************************************
FUNCTION valid_stat
param    _stid, outln, colr, colrs, shdw
private  status, i, dep, hcol, hrow, tr, lc, br, rc, bg, fg

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  if ascan(c_StIdV, _stid) > 0
    status = .t.
  else
    hrow = row()
    hcol = col()
    tr   = 0
    lc   = 0
    br   = 0
    rc   = 0

    if hrow > 13
      dep = hrow - 3
    else
      dep = 22 - hrow - 1
    endif

    * adjust box to cursor position - '@param' can be modified by called function
    set_box_coord(hrow, hcol, 29, dep, @tr, @lc, @br, @rc)

    status = .f.
    buffer    = savescreen(tr, lc, br + 1, rc + 2)
    lastcolor = setcolor(colr)
    @ tr, lc, br, rc box outln

    if shdw
      shadowbox(tr, lc, br, rc, colrs)
    endif

    i = achoice(tr + 1, lc + 2, br - 1, rc - 2, c_StatesV)

    if i <> 0
      _stid  = c_StIdV[i]
      status = .t.
    endif

    setcolor(lastcolor)
    restscreen(tr, lc, br + 1, rc + 2, buffer)
    buffer = ""
  endif

return status

**********************************************************
* WAIT_MSG(msg)
*   displays the message and waits
*  Author : Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION wait_msg
parameter msg
private say_scrn

  if type('msg') <> 'C'
    return .f.
  endif

  say_scrn = savescreen(0, 0, 24, 79)
  say_msg(msg, 24)
  inkey(0)
  restscreen(0, 0, 24, 79, say_scrn)

return .t.

**********************************************************
* XIT_GETS(a, b, c)
*   exit the get function
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION xit_gets
param    a, b, c           && default Clipper params- ignored

  clear gets

return .t.

**********************************************************
* YN_CONFIRM(yn_msg, yn_def, tr, lc, br, rc, outln, colr, colrs, shdw)
*   displays the message and gets a "Y/N" response
*  Author: Rik Hess
*  Copyright 1989, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION yn_confirm
param    yn_msg, yn_def, tr, lc, br, rc, outln, colr, colrs, shdw
private  c, yn_screen, lastcolor

  if type('yn_msg') <> 'C'
    return .f.
  endif

  if type('tr') <> 'N'
    tr = 19
  endif

  if type('lc') <> 'N'
    lc = 10
  endif

  if type('br') <> 'N'
    br = 21
  endif

  if type('rc') <> 'N'
    rc = 65
  endif

  if type('outln') <> 'C'
    outln = sysboxo
  endif

  if type('colr') <> 'C'
    colr = sysboxc
  else
    chk_colr(@colr,   sysboxc)
  endif

  if type('colrs') <> 'C'
    colrs = sysboxs
  else
    chk_colrs(@colrs, sysboxs)
  endif

  if type('shdw') <> 'L'
    shdw = sysboxd
  endif

  if len(yn_msg) < 76
    yn_msg = ' ' +  yn_msg
  endif

  lc        = (79 - (len(yn_msg) + 5)) / 2
  rc        = lc + len(yn_msg) + 5
  yn_screen = savescreen(tr, lc, br + 1, rc + 2)
  lastcolor = setcolor(colr)

  if !empty(outln)
    @ tr, lc, br, rc box outln
  endif

  if shdw
    shadowbox(tr, lc, br, rc, colrs)
  endif

  c = 'N'

  if type('yn_def') = 'C' .and. !empty(yn_def)
    c = yn_def
  endif

  clear typeahead
  @ tr + 1, lc + 1 say yn_msg + ' ' get c picture '@!' valid c $ 'YN'

  read
  restscreen (tr, lc, br + 1, rc + 2, yn_screen)
  setcolor(lastcolor)

  if c = 'Y'
    return .t.
  endif

return .f.

