
* MENU        : MAIN program
*
* Main Menu system with pull-downs.
* This is the system front-end. All system procedures are called
* from this module. All password protection is initiated here as well.
*
* Generated on      :   October 7, 1990 : 12:17:21
* Source .WW file   :   D:\UI2\PROUI\MENU.WW
* Target environment:   Clipper Summer 87
*

public appver
appver = "1.1"

public help_name, old_help
help_name = "menu"

private  main, sign_on, pwd0, tcolor, mainapp, v_menu

* Environment variables set here for the application
*  Cursor is set "ON" by the system for Reads
set bell       on                           && "Bell" is for std. Clipper
set century    off                          && "on"  uses 4 digit year
set confirm    off                          && "off"  skips to next field at end of field
set console    on
set cursor     off
set date       american                     && mm/dd/yy
set deleted    on                           && "on"  ignores recs marled as deleted
set decimals   to 2                         && for   dollars and cents
set escape     off                          && "on"  allows an <Esc> to exit a Read
set exact      off                          && "off" use "==" to check for exact string matches
set exclusive  off                          && "off" allows multiple network users to share file
set fixed      off                          && "off" only sets decimals in limited operations
set scoreboard off                          && "off" supresses line 0 msgs
set wrap       on                           && "on"  allows @...Prompt to cycle menus

public d_data, d_home                       && drive/path names for data and home
d_data = ""
d_home = ""

public sysboxo, sysboxc, sysboxs
sysboxo = "ͻȺ "
sysboxc = "GR+/N,N/GR"
sysboxs = "N/GR"
sysboxd = .t.

save screen to v_menu                      && save the input screen
save all like v_menu to &d_home.v_menu.mem
v_menu = ""

Set_KB_Key()

if file('&d_data.states.dbf')

  if net_use('&d_data.states', 'states', .f., 30, .t., 'File STATES is locked. Wait? (Y/N)')

    * check for a sort index
    if !file('&d_data.state_na.ntx')
      index on state_name to &d_data.state_na
    endif

    set index to &d_data.state_na
    go top

    public c_StatesV[lastrec()], c_StIdV[lastrec()]
    i = 0

    do while !eof()
      i            = i + 1
      c_StIdV[i]   = states->state
      c_StatesV[i] = states->state_name
      skip
    enddo

    close database
  else
    wait_msg("PROBLEM: The file STATES.DBF is needed and is not available. Quitting!")
    close database
    quit
  endif

endif

DO START_UP         && Call to Pre-Process code
help_name = "pass_wd_on"

if !chk_pwd("PROUI", 3, "Signing On")

  restore from &d_home.v_menu.mem additive
  restore screen from v_menu                 && do a tidy exit
  v_menu = ""
  erase &d_home.v_menu.mem

  set cursor on
  quit
endif


if file("&d_data.sign_on.mem")            && handle the SIGN-ON if file is present
  restore from &d_data.sign_on.mem additive
  restore screen from sign_on
  sign_on = ""
  inkey(0)                                && wait to show screen
endif

help_name = "menu"
clear

if file("&d_data.canvas.mem")               && fetch the background if present
  restore from &d_data.canvas.mem additive
  restore screen from canvas
  release canvas
endif

* ---- DISPLAY Vars in the box "CANVAS"
setcolor("+W/R")
VERSION        = M->APPVER
@  2, 75 say VERSION         picture 'XXX'
TITLE          = 'MENUS'
@  3, 70 say TITLE           picture 'XXXXX'
TODAY          = DATE()
@  4, 69 say TODAY           picture '@D'

mainapp = .t.

do while mainapp
  menumainmenu()                && process the main program

  ** Check if user means to quit
  if mainapp

    if yn_confirm("Do you wish to leave this application? (Y/N)", "N")
      exit
    endif

  endif

enddo

restore from &d_home.v_menu.mem additive
restore screen from v_menu                 && do a tidy exit
v_menu = ""
erase &d_home.v_menu.mem

set cursor on
quit

**********************************************************
* MENUMAINMENU()
*   main menu in MENU
**********************************************************
FUNCTION menumainmenu
private  opt_keys, num_opts, now_at, do_it, move_it, move_to, n_, i_
private  newadd, mkey

  * menu MAINMENU
  * -------------------- Drawing Box : "MAINMENU"
  setcolor("+BG/N")
  scroll(0, 0, 0, 33, 0)

  opt_keys = "MRQ"
  num_opts = 3
  do_it    = .f.
  newadd   = .f.
  now_at   = 1                           && the current selection
  mkey     = 0

  for i_ = 2 to num_opts
    mainmenu_lo(i_)                           && lolite the options
  next

  mainmenu_hi(1)                              && hilite option 1

  if !newadd
    * Set AUTO-START option
    clear typeahead
    keyboard 'M'                      && stuff trigger into keyboard buffer
    newadd = .t.
  endif


  do while .t.                           && main loop for "MAINMENU"

    if !do_it
      mkey = inkey(0)

      if mkey = KB_f1                    && HELP?
        do help with "menu"
        loop
      endif

    endif

    n_ = at(upper(chr(mkey)), opt_keys)

    do case                              && handle the key-press
    case mkey = KB_Esc
      mkey    = 0
      exit

    case mkey = KB_Enter
      move_it = .f.
      do_it   = .t.

    case n_ > 0                          && an option letter was pressed
      move_it = n_ <> now_at
      move_to = n_
      do_it   = .t.

    case mkey = KB_Left .or. mkey = KB_Up
      move_it = .t.
      move_to = iif(now_at = 1, num_opts, now_at - 1)

    case mkey = KB_Right .or. mkey = KB_Down
      move_it = .t.
      move_to = iif(now_at = num_opts, 1, now_at + 1)

    otherwise                            && ignore all others
      do_it = .f.
      loop

    endcase

    if move_it                           && reset hi-lite mainmenu
      mainmenu_lo(now_at)
      mainmenu_hi(move_to)
      now_at = move_to
    endif

    if do_it                             && perform action loop for "MAINMENU"

      do case
      case now_at = 1
        menum()
      case now_at = 2
        menur()
      case now_at = 3

        if mkey = KB_Enter .or. upper(chr(mkey)) = "Q"
          exit
        else

          do while .t.
            mkey = inkey(0)

            if mkey = KB_f1              && HELP?
              do help with "menu"
              loop
            else
              exit
            endif

          enddo

        endif
      endcase

      if do_it
        loop
      endif

      if mkey = KB_Esc
        mkey  = 0
        exit
      endif

      mainmenu_hi(now_at)
      do_it = .f.
    endif                                && end of action loop "MAINMENU"

  enddo                                  && end of main loop "MAINMENU"

return .t.

**********************************************************
* MAINMENU_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION mainmenu_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "0MAINTENANCE"
    say_msg('Database Maintenance (Add, Change, or Delete)')
    * -------------------- Drawing Box : "MAINTENANCE"
    setcolor("+GR/N")
    scroll(0, 1, 0, 13, 0)
    @  0,  2 say "MAINTENANCE"

  case choice = 2
    help_name = "0REPORTS"
    say_msg('Choose the report to produce.')
    * -------------------- Drawing Box : "REPORTS"
    setcolor("+GR/N")
    scroll(0, 16, 0, 24, 0)
    @  0, 17 say "REPORTS"

  case choice = 3
    help_name = "0QUIT"
    say_msg('Exit the application')
    * -------------------- Drawing Box : "QUIT"
    setcolor("+GR/N")
    scroll(0, 27, 0, 32, 0)
    @  0, 28 say "QUIT"

  endcase

return .t.

**********************************************************
* MAINMENU_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION mainmenu_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "MAINTENANCE"
    @  0,  2 say "Maintenance"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "REPORTS"
    @  0, 17 say "Reports"
    setcolor(lastcolor)

  case choice = 3
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "QUIT"
    @  0, 28 say "Quit"
    setcolor(lastcolor)

  endcase

return .t.

**********************************************************
* MENUM()
*   a level 1 pull-down menu
**********************************************************
FUNCTION menum
private  opt_keys, num_opts, now_at, do_it, move_it, move_to, n_, i_
private  newadd, v_m

  * menu M
  * -------------------- Drawing Box : "M"
  v_m = savescreen(1, 0, 7, 18)
  outliner(1, 0, 6, 16, "ͻȺ ", "BG+/N")
  setcolor("+BG/N")
  scroll(2, 1, 5, 15, 0)
  shadowbox(1, 0, 6, 16, "N/N")

  opt_keys = "GI"
  num_opts = 2
  do_it    = .f.
  newadd   = .f.
  now_at   = 1                           && the current selection
  mkey     = 0

  for i_ = 2 to num_opts
    m_lo(i_)                           && lolite the options
  next

  m_hi(1)                              && hilite option 1

  do while .t.                           && main loop for "M"

    if !do_it
      mkey = inkey(0)

      if mkey = KB_f1                    && HELP?
        do help with "menu"
        loop
      endif

    endif

    n_ = at(upper(chr(mkey)), opt_keys)

    do case                              && handle the key-press
    case mkey = KB_Esc
      mkey    = 0
      exit

    case mkey = KB_Enter
      move_it = .f.
      do_it   = .t.

    case n_ > 0                          && an option letter was pressed
      move_it = n_ <> now_at
      move_to = n_
      do_it   = .t.

    case mkey = KB_Up
      mkey = 0
      move_it  = .t.
      move_to  = iif(now_at = 1, num_opts, now_at - 1)

    case mkey = KB_Down
      mkey = 0
      move_it  = .t.
      move_to  = iif(now_at = num_opts, 1, now_at + 1)

    case mkey = KB_Left .or. mkey = KB_Right
      exit

    otherwise                            && ignore all others
      do_it = .f.
      loop

    endcase

    if move_it                           && reset hi-lite mainmenu
      m_lo(now_at)
      m_hi(move_to)
      now_at = move_to
    endif

    if do_it                             && perform action loop for "M"
      outliner(1, 0, 6, 16, "Ŀ ", "BG/N")

      do case
      case now_at = 1
        do gdbf
      case now_at = 2

        if !chk_pwd("DO IT", 3, "System Maintenance : Password=>Do It")
          exit
        endif

        do reindex
      endcase

      outliner(1, 0, 6, 16, "ͻȺ ", "BG+/N")
      if mkey = KB_Esc
        mkey  = 0
        exit
      endif

      m_hi(now_at)
      do_it = .f.
    endif                                && end of action loop "M"

  enddo                                  && end of main loop "M"

  restscreen(1, 0, 7, 18, v_m)
  v_m = ''

return .t.

**********************************************************
* M_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION m_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "MDATABASE"
    say_msg('General Maintenance on Database files')
    * -------------------- Drawing Box : "DATABASE"
    setcolor("+GR/N")
    scroll(2, 2, 3, 14, 0)
    @  2,  3 say "DATABASE"
    @  3,  3 say "MAINTENANCE"

  case choice = 2
    help_name = "MINDEX DATA"
    say_msg('Reset the database index pointers')
    * -------------------- Drawing Box : "INDEX DATA"
    setcolor("+GR/N")
    scroll(5, 2, 5, 14, 0)
    @  5,  3 say "INDEX DATA"

  endcase

return .t.

**********************************************************
* M_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION m_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "DATABASE"
    @  2,  3 say "Database"
    @  3,  3 say "Maintenance"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "INDEX DATA"
    @  5,  3 say "Index Data"
    setcolor(lastcolor)

  endcase

return .t.

**********************************************************
* MENUR()
*   a level 1 pull-down menu
**********************************************************
FUNCTION menur
private  opt_keys, num_opts, now_at, do_it, move_it, move_to, n_, i_
private  newadd, v_r

  * menu R
  * -------------------- Drawing Box : "R"
  v_r = savescreen(1, 15, 5, 35)
  outliner(1, 15, 4, 33, "ͻȺ ", "BG+/N")
  setcolor("+BG/N")
  scroll(2, 16, 3, 32, 0)
  shadowbox(1, 15, 4, 33, "N/N")

  opt_keys = "DM"
  num_opts = 2
  do_it    = .f.
  newadd   = .f.
  now_at   = 1                           && the current selection
  mkey     = 0

  for i_ = 2 to num_opts
    r_lo(i_)                           && lolite the options
  next

  r_hi(1)                              && hilite option 1

  do while .t.                           && main loop for "R"

    if !do_it
      mkey = inkey(0)

      if mkey = KB_f1                    && HELP?
        do help with "menu"
        loop
      endif

    endif

    n_ = at(upper(chr(mkey)), opt_keys)

    do case                              && handle the key-press
    case mkey = KB_Esc
      mkey    = 0
      exit

    case mkey = KB_Enter
      move_it = .f.
      do_it   = .t.

    case n_ > 0                          && an option letter was pressed
      move_it = n_ <> now_at
      move_to = n_
      do_it   = .t.

    case mkey = KB_Up
      mkey = 0
      move_it  = .t.
      move_to  = iif(now_at = 1, num_opts, now_at - 1)

    case mkey = KB_Down
      mkey = 0
      move_it  = .t.
      move_to  = iif(now_at = num_opts, 1, now_at + 1)

    case mkey = KB_Left .or. mkey = KB_Right
      exit

    otherwise                            && ignore all others
      do_it = .f.
      loop

    endcase

    if move_it                           && reset hi-lite mainmenu
      r_lo(now_at)
      r_hi(move_to)
      now_at = move_to
    endif

    if do_it                             && perform action loop for "R"
      outliner(1, 15, 4, 33, "Ŀ ", "BG/N")

      do case
      case now_at = 1
        menurd()
      case now_at = 2
        menurm()
      endcase

      outliner(1, 15, 4, 33, "ͻȺ ", "BG+/N")
      if mkey = KB_Esc
        mkey  = 0
        exit
      endif

      r_hi(now_at)
      do_it = .f.
    endif                                && end of action loop "R"

  enddo                                  && end of main loop "R"

  restscreen(1, 15, 5, 35, v_r)
  v_r = ''

return .t.

**********************************************************
* R_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION r_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "RDAILY REPORTS"
    say_msg('Run Daily Reports')
    * -------------------- Drawing Box : "DAILY REPORTS"
    setcolor("+GR/N")
    scroll(2, 16, 2, 32, 0)
    @  2, 17 say "DAILY REPORTS"

  case choice = 2
    help_name = "RMONTHLY REPORTS"
    say_msg('Run Monthly Reports')
    * -------------------- Drawing Box : "MONTHLY REPORTS"
    setcolor("+GR/N")
    scroll(3, 16, 3, 32, 0)
    @  3, 17 say "MONTHLY REPORTS"

  endcase

return .t.

**********************************************************
* R_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION r_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "DAILY REPORTS"
    @  2, 17 say "Daily Reports"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "MONTHLY REPORTS"
    @  3, 17 say "Monthly Reports"
    setcolor(lastcolor)

  endcase

return .t.

**********************************************************
* MENURD()
*   a level 2 pull-down menu
**********************************************************
FUNCTION menurd
private  opt_keys, num_opts, now_at, do_it, move_it, move_to, n_, i_
private  newadd, v_rd

  * menu RD
  * -------------------- Drawing Box : "RD"
  v_rd = savescreen(3, 15, 7, 36)
  outliner(3, 15, 6, 34, "ͻȺ ", "BG+/N")
  setcolor("+BG/N")
  scroll(4, 16, 5, 33, 0)
  shadowbox(3, 15, 6, 34, "N/N")

  opt_keys = "DE"
  num_opts = 2
  do_it    = .f.
  newadd   = .f.
  now_at   = 1                           && the current selection
  mkey     = 0

  for i_ = 2 to num_opts
    rd_lo(i_)                           && lolite the options
  next

  rd_hi(1)                              && hilite option 1

  do while .t.                           && main loop for "RD"

    if !do_it
      mkey = inkey(0)

      if mkey = KB_f1                    && HELP?
        do help with "menu"
        loop
      endif

    endif

    n_ = at(upper(chr(mkey)), opt_keys)

    do case                              && handle the key-press
    case mkey = KB_Esc
      mkey    = 0
      exit

    case mkey = KB_Enter
      move_it = .f.
      do_it   = .t.

    case n_ > 0                          && an option letter was pressed
      move_it = n_ <> now_at
      move_to = n_
      do_it   = .t.

    case mkey = KB_Left .or. mkey = KB_Up
      move_it = .t.
      move_to = iif(now_at = 1, num_opts, now_at - 1)

    case mkey = KB_Right .or. mkey = KB_Down
      move_it = .t.
      move_to = iif(now_at = num_opts, 1, now_at + 1)

    otherwise                            && ignore all others
      do_it = .f.
      loop

    endcase

    if move_it                           && reset hi-lite mainmenu
      rd_lo(now_at)
      rd_hi(move_to)
      now_at = move_to
    endif

    if do_it                             && perform action loop for "RD"
      outliner(3, 15, 6, 34, "Ŀ ", "BG/N")

      do case
      case now_at = 1
        menurdd()
      case now_at = 2
        menurde()
      endcase

      outliner(3, 15, 6, 34, "ͻȺ ", "BG+/N")
      if mkey = KB_Esc
        mkey  = 0
        exit
      endif

      rd_hi(now_at)
      do_it = .f.
    endif                                && end of action loop "RD"

  enddo                                  && end of main loop "RD"

  restscreen(3, 15, 7, 36, v_rd)
  v_rd = ''

return .t.

**********************************************************
* RD_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION rd_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "RDDAILY ACTIVITY"
    say_msg('List all transactions for one day')
    * -------------------- Drawing Box : "DAILY ACTIVITY"
    setcolor("+GR/N")
    scroll(4, 16, 4, 33, 0)
    @  4, 17 say "DAILY ACTIVITY"

  case choice = 2
    help_name = "RDEXCEPTION REPORT"
    say_msg('Report all Unusual Activity')
    * -------------------- Drawing Box : "EXCEPTION REPORT"
    setcolor("+GR/N")
    scroll(5, 16, 5, 33, 0)
    @  5, 17 say "EXCEPTION REPORT"

  endcase

return .t.

**********************************************************
* RD_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION rd_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "DAILY ACTIVITY"
    @  4, 17 say "Daily Activity"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "EXCEPTION REPORT"
    @  5, 17 say "Exception Report"
    setcolor(lastcolor)

  endcase

return .t.

**********************************************************
* MENURM()
*   a level 2 pull-down menu
**********************************************************
FUNCTION menurm
private  opt_keys, num_opts, now_at, do_it, move_it, move_to, n_, i_
private  newadd, v_rm

  * menu RM
  * -------------------- Drawing Box : "RM"
  v_rm = savescreen(4, 16, 8, 35)
  outliner(4, 16, 7, 33, "ͻȺ ", "BG+/N")
  setcolor("+BG/N")
  scroll(5, 17, 6, 32, 0)
  shadowbox(4, 16, 7, 33, "N/N")

  opt_keys = "NS"
  num_opts = 2
  do_it    = .f.
  newadd   = .f.
  now_at   = 1                           && the current selection
  mkey     = 0

  for i_ = 2 to num_opts
    rm_lo(i_)                           && lolite the options
  next

  rm_hi(1)                              && hilite option 1

  do while .t.                           && main loop for "RM"

    if !do_it
      mkey = inkey(0)

      if mkey = KB_f1                    && HELP?
        do help with "menu"
        loop
      endif

    endif

    n_ = at(upper(chr(mkey)), opt_keys)

    do case                              && handle the key-press
    case mkey = KB_Esc
      mkey    = 0
      exit

    case mkey = KB_Enter
      move_it = .f.
      do_it   = .t.

    case n_ > 0                          && an option letter was pressed
      move_it = n_ <> now_at
      move_to = n_
      do_it   = .t.

    case mkey = KB_Left .or. mkey = KB_Up
      move_it = .t.
      move_to = iif(now_at = 1, num_opts, now_at - 1)

    case mkey = KB_Right .or. mkey = KB_Down
      move_it = .t.
      move_to = iif(now_at = num_opts, 1, now_at + 1)

    otherwise                            && ignore all others
      do_it = .f.
      loop

    endcase

    if move_it                           && reset hi-lite mainmenu
      rm_lo(now_at)
      rm_hi(move_to)
      now_at = move_to
    endif

    if do_it                             && perform action loop for "RM"
      outliner(4, 16, 7, 33, "Ŀ ", "BG/N")

      do case
      case now_at = 1
        menurmn()
      case now_at = 2
        menurms()
      endcase

      outliner(4, 16, 7, 33, "ͻȺ ", "BG+/N")
      if mkey = KB_Esc
        mkey  = 0
        exit
      endif

      rm_hi(now_at)
      do_it = .f.
    endif                                && end of action loop "RM"

  enddo                                  && end of main loop "RM"

  restscreen(4, 16, 8, 35, v_rm)
  v_rm = ''

return .t.

**********************************************************
* RM_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION rm_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "RMNAMES/ACCOUNTS"
    say_msg('Report all Customers by Name and Account Balance')
    * -------------------- Drawing Box : "NAMES/ACCOUNTS"
    setcolor("+GR/N")
    scroll(5, 17, 5, 32, 0)
    @  5, 18 say "NAMES/ACCOUNTS"

  case choice = 2
    help_name = "RMSTATEMENTS"
    say_msg('Prepare Monthly Statements')
    * -------------------- Drawing Box : "STATEMENTS"
    setcolor("+GR/N")
    scroll(6, 17, 6, 32, 0)
    @  6, 18 say "STATEMENTS"

  endcase

return .t.

**********************************************************
* RM_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION rm_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "NAMES/ACCOUNTS"
    @  5, 18 say "Names/Accounts"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "STATEMENTS"
    @  6, 18 say "Statements"
    setcolor(lastcolor)

  endcase

return .t.


**********************************************************
* MENURDD()
*   displays a box
**********************************************************
FUNCTION menuRDD
private  v_rdd

  * pop-up the box
  * -------------------- Drawing Box : "RDD"
  v_rdd = savescreen(7, 33, 17, 63)
  outliner(7, 33, 17, 63, "ͻȺ ", "+GR/N")
  setcolor("+R/N")
  scroll(8, 34, 16, 62, 0)
  @  8, 35 say "Daily Activity Report"
  @  9, 37 say "is not working yet."
  @ 10, 34 say replicate(' ', 29)
  @ 11, 35 say "When we are ready to build"
  @ 12, 37 say "this process, we will add"
  @ 13, 37 say '"DO RACTV" to the action'
  @ 14, 37 say "block for this option and"
  @ 15, 37 say "remove this box - named"
  @ 16, 37 say "'RDD'."

  do while .t.
    mkey = inkey(0)

    if mkey = KB_f1                    && HELP?
      do help with "menu"
      loop
    else
      exit
    endif

  enddo

  if mkey = KB_Esc                   && do not return an escape
    mkey  = 0
  endif

  restscreen(7, 33, 17, 63, v_rdd)
  v_rdd = ''


return .t.


**********************************************************
* MENURDE()
*   displays a box
**********************************************************
FUNCTION menuRDE
private  v_rde

  * pop-up the box
  * -------------------- Drawing Box : "RDE"
  v_rde = savescreen(8, 34, 18, 64)
  outliner(8, 34, 18, 64, "ͻȺ ", "+GR/N")
  setcolor("+BR/N")
  scroll(9, 35, 17, 63, 0)
  @  9, 36 say "Daily Exception Report"
  @ 10, 38 say "is not working yet."
  @ 11, 35 say replicate(' ', 29)
  @ 12, 36 say "When we are ready to build"
  @ 13, 38 say "this process, we will add"
  @ 14, 38 say '"DO REXCP" to the action'
  @ 15, 38 say "block for this option and"
  @ 16, 38 say "remove this box - named"
  @ 17, 38 say "'RDE'."

  do while .t.
    mkey = inkey(0)

    if mkey = KB_f1                    && HELP?
      do help with "menu"
      loop
    else
      exit
    endif

  enddo

  if mkey = KB_Esc                   && do not return an escape
    mkey  = 0
  endif

  restscreen(8, 34, 18, 64, v_rde)
  v_rde = ''


return .t.


**********************************************************
* MENURMN()
*   displays a box
**********************************************************
FUNCTION menuRMN
private  v_rmn

  * pop-up the box
  * -------------------- Drawing Box : "RMN"
  v_rmn = savescreen(8, 33, 19, 65)
  outliner(8, 33, 18, 63, "ͻȺ ", "+GR/N")
  setcolor("+G/N")
  scroll(9, 34, 17, 62, 0)
  shadowbox(8, 33, 18, 63, "N/N")
  @  9, 35 say "Monthly Name/Account List"
  @ 10, 37 say "is not working yet."
  @ 11, 34 say replicate(' ', 29)
  @ 12, 35 say "When we are ready to build"
  @ 13, 37 say "this process, we will add"
  @ 14, 37 say '"DO RNANES" to the action'
  @ 15, 37 say "block for this option and"
  @ 16, 37 say "remove this box - named"
  @ 17, 37 say "'RMN'."

  do while .t.
    mkey = inkey(0)

    if mkey = KB_f1                    && HELP?
      do help with "menu"
      loop
    else
      exit
    endif

  enddo

  if mkey = KB_Esc                   && do not return an escape
    mkey  = 0
  endif

  restscreen(8, 33, 19, 65, v_rmn)
  v_rmn = ''


return .t.


**********************************************************
* MENURMS()
*   displays a box
**********************************************************
FUNCTION menuRMS
private  v_rms

  * pop-up the box
  * -------------------- Drawing Box : "RMS"
  v_rms = savescreen(10, 29, 20, 59)
  outliner(10, 29, 20, 59, "ͻȺ ", "+GR/N")
  setcolor("GR/N")
  scroll(11, 30, 19, 58, 0)
  @ 11, 31 say "Monthly Statements List"
  @ 12, 33 say "is not working yet."
  @ 13, 30 say replicate(' ', 29)
  @ 14, 31 say "When we are ready to build"
  @ 15, 33 say "this process, we will add"
  @ 16, 33 say '"DO RSTMT" to the action'
  @ 17, 33 say "block for this option and"
  @ 18, 33 say "remove this box - named"
  @ 19, 33 say "'RMS'."

  do while .t.
    mkey = inkey(0)

    if mkey = KB_f1                    && HELP?
      do help with "menu"
      loop
    else
      exit
    endif

  enddo

  if mkey = KB_Esc                   && do not return an escape
    mkey  = 0
  endif

  restscreen(10, 29, 20, 59, v_rms)
  v_rms = ''


return .t.


**********************************************************
* SAY_MSG(s, line)
*   displays passed message on desired line
**********************************************************
FUNCTION say_msg
param    s, ln
private  oldcolor

if type("s") <> "C"
  return .f.
endif

if type("ln") <> "N"
  ln = 24
endif

oldcolor = setcolor('+BG/N')

if empty(trim(s))
  @ ln,  0 say replicate(" ", 80)
else
  @ ln,  0 say center(s, 80)
endif

setcolor(oldcolor)

return .t.

*******************************************************************
* HELP.PRG
* Purpose              : Routine to display user defined Help screens
* Original Author      : Don L. Powells
* Version              : Clipper Summer '87
* Copyright (c) 1988 Nantucket Corp.
*
* Modified & annotated : Rik Hess
*
* Called with - name of calling program "h_prg"
*             - line number             "h_lin_"
*         and - variable to be read     "h_mvar_"
*
* Uses HELP.DBF with index file HELP.NTX, and memo file HELP.DBT
*   The index for this HELP consists of the calling program name
*   and a public memvar, Help_Name, which must be set by the calling program.
*
*   With these templates, there are only two calling programs;
*   1. the Main Menu from MENUPULL.TEM, or
*   2. the call 'ReadIt' which is the only Read in the program.
*
*   The templates generate a 'Help_Name' which is :
*   1. a unique id for menu option calls - this means two same named
*      options in different menus will access different Help screens,
*   2. the variable or field name being read - this means that all same
*      named fields or variables will access the same Help screen.
*
* The display window for the HELP is dynamically determined as a result
* of the cursor position on the screen. Although the Help window may
* appear at different places for a same named variable on different
* screens, the text inside the window will be properlly formatted to
* the current screen size.
*******************************************************************
*
*                        +---------------+
* = = = = = = = = = = =  |  N O T I C E  |  = = = = = = = = = = = = =
*                        +---------------+
*  ͻ
*   "This code is provided at no charge as a training aid.          
*    No guarantee nor warrantee is given, neither explicitly nor    
*    implicitly, that this code will do anything. This code         
*    does not infringe on the intellectual properties of others.    
*                                                                   
*    Anyone who uses this code in any manner assumes full           
*    responsibility for its use."                                   
*  ͼ
*
*  The disclaimer above is provided at the advice of legal counsel.
*  Basically, it says that what is provided herein is not entirely
*  original work. Much has been done using code provided by WallSoft
*  and other published sources. Credit to others is given were I have
*  incorporated another's idea as published or with modifications.
*  The section refering to "intellectual properties" means that
*  no copyright infringement is being claimed on any of this work.
*
*  Any material that I have previously released is marked with my
*  personal copyright notice and is released to public domain.
*
*  There is no fee due to anyone if you choose to use this code,
*  providing, of course, you are using a legitimate copy of UI2(R) by
*  WallSoft and, if applicable, a legitimate copy of Clipper(R) by
*  Nantucket.
*
*                              Thank you, Rik Hess
*
*  If you have any questions or constructive comments, you can reach me at:
*              6212 Aires Drive, Arlington, Texas  76017
*
**************************************************************************
PROCEDURE help
parameters h_prg, h_lin_, h_mvar_
private incolor, wkarea, hrow, hcol, helpscrn, sought, good_help, helpwork
private p1, p2, tr, lc, br, rc, lens, deeps

  set key KB_f1 to                     && disable so HELP can't call itself

  incolor   = setcolor()               && save input pointers
  wkarea    = select()
  hrow      = row()
  hcol      = col()
  h_prg     = upper(h_prg)
  help_name = upper(help_name)

  if len(help_name) > 10               && set current 'Help_Name' to 10 char max
    help_name = substr(help_name, 1, 10)
  endif

  p1        = pad(h_prg, 10)
  p2        = pad(help_name, 10)

  if h_prg  = 'READIT'
    clear gets
    set cursor off
    set escape off
    readexit(old_rdkey)
    set key KB_f10 to
  endif

  * HELP.DBF indexed on h_prg + help_name - 'help_name' is public var
  select 0

  if net_use('help','help', .f., 5, .t., 'HELP file is in use. Wait? (Y/N)')
    set index to help

    * Draw Help display box
    *  The technique of using the active cursor position allows
    *  drawing the largest corner box possible

    if hrow > 13                       && if working with bottom of screen
      topr = 1                         &&  show box on top half of screen
      botr = hrow - 1
    else
      topr = hrow + 1                  &&  else show box on bottom half of screen
      botr = 22
    endif

    if hcol > 40                       && if working with left side of screen
      lfcl = 2
      rtcl = hcol - 4                  &&  show box on right
    else
      lfcl = hcol                      && else show box on left
      rtcl = 76
    endif

    if type('colorhelp') = 'U'         && check for color set
      colorhelp = '+w/r'               &&  default is hi white on red
    endif

    if type('colorh_sh') = 'U'         && check for color shadow
      colorh_sh = 'w/r'                &&  default is white on red
    endif

    if type('colorh_ed') = 'U'         && check for color set
      colorh_ed = 'r/N'                &&  red on black for Edit Mode
    endif

    setcolor(colorhelp)

    * save window portion of screen and draw box
    helpscrn = savescreen(topr, lfcl, botr + 1, rtcl + 2)
    @ topr, lfcl, botr, rtcl box 'Ŀ '
    @ topr, (lfcl +  5) say ' HELP SCREEN '
    @ topr, (rtcl - 10) say ' PgUp  '
    @ botr, (rtcl - 10) say ' PgDn  '
    @ botr, (lfcl +  5) say ' Press <Esc> when done '
    shadowbox(topr, lfcl, botr, rtcl, colorh_sh)

    sought    = p1 + p2
    good_help = .f.
    seek sought

    if found()

      * check if this rec is cross referenced to another as 'SEE:xxxxxxxxxx'
      if upper(substr(help_memo, 1, 4)) = 'SEE:'
        sought = upper(substr(help_memo, 5, 10)) + p2
        seek sought

        if found()
          good_help = .t.
        else
          good_help = .f.
        endif

      else
        good_help = .t.
      endif

    endif

    * check if there is a 'global' entry for the help_name
    if !good_help
      sought = replicate(' ', 10) + p2
      seek sought

      if found()
        good_help = .t.
      endif

    endif


    if good_help
      * display the message
      helpwork = memotran(help_memo, ' ', ' ')
    else
      sought   = p1 + p2
      helpwork = 'No HELP is available for "' + ;
                 trim(p2) + '" at this time. ' + ;
                 'Press <Alt F1> to add HELP text.'
      helpwork = memotran(helpwork, ' ', ' ')
    endif

    clear typeahead
    set key KB_aF1 to helprite         && assigns <Alt F1> to HELPRITE
    memoedit(helpwork, topr + 1, lfcl + 2, botr - 1, rtcl - 2, .f.)
    set key KB_aF1 to                  && deassigns <Alt F1>
    restscreen(topr, lfcl, botr + 1, rtcl + 2, helpscrn)
    helpscrn = ''
    use
  endif

  keyboard(chr(0))                     && resets the 'lastkey()' value from Esc
  inkey()
  select(wkarea)                       && reset active work area
  setcolor(incolor)
  @ hrow, hcol say ''                  && reset the cursor
  clear typeahead
  set key KB_f1 to help                && reassign the <F1> key to help

  if upper(h_prg) = 'READIT'
    set key KB_f10 to xit_gets
    old_rdkey = readexit(.t.)
    set escape on
    set cursor on
    read
  endif

return

*******************************************************************
* HELPRITE.PRG
* Purpose              : Routine to create user defined Help screens
* Author               : Don L. Powells
* Version              : Clipper Summer '87
* Copyright (c) 1988 Nantucket Corp.
*
* Modified & annotated : Rik Hess
*
* Called from HELP.PRG with HELP.DBF open
*******************************************************************
PROCEDURE helprite
parameters prg_, lin_, mvar_
private svhelpt, svhelpb, helpwk

  set key KB_aF1 to                    && deassigns <Alt-F1>

  if !good_help
    helpwork = replicate(' ', 100)
  endif

  * save the top and bottom rows of HELP
  svhelpt = savescreen(topr, lfcl, topr, rtcl)
  svhelpb = savescreen(botr, lfcl, botr, rtcl)

  @ topr, lfcl, botr, rtcl box 'Ŀ '
  @ topr, lfcl + 2 say ' HELP EDIT SCREEN '
  @ botr, lfcl + 2 say ' Press <F10> when done '

  if lastkey() = KB_Esc
    return
  endif

  if !good_help

    if add_rec(10, .t., 'HELP file is locked. Wait? (Y/N)')
      replace help_prg  with p1
      replace help_name with p2
    else
      return
    endif

  else

    if !rec_lock(10, .t., 'HELP file is locked. Wait? (Y/N)')
      return
    endif

  endif

  setcolor(colorh_ed)
  set function 10 to chr(KB_cW)       && quit edit key
  set cursor on
  helpwk = memoedit(helpwork, topr + 1, lfcl + 2, botr - 1, rtcl - 2, .t.)
  set cursor off
  set function 10 to ''

  setcolor(colorhelp)
  helpwork = trim(helpwk)

  if len(helpwork) = 0
    delete
  else
    replace help_memo with helpwork
    commit
  endif

  unlock

  restscreen(topr, lfcl, topr, rtcl, svhelpt)
  restscreen(botr, lfcl, botr, rtcl, svhelpb)
return



                    ***  END OF PROC : MENU  ***


