*******************************************************************
* HELP.PRG
* Purpose              : Routine to display user defined Help screens
* Original Author      : Don L. Powells
* Version              : Clipper Summer '87
* Copyright (c) 1988 Nantucket Corp.
*
* Modified & annotated : Rik Hess
*
* Called with - name of calling program "h_prg"
*             - line number             "h_lin_"
*         and - variable to be read     "h_mvar_"
*
* Uses HELP.DBF with index file HELP.NTX, and memo file HELP.DBT
*   The index for this HELP consists of the calling program name
*   and a public memvar, Help_Name, which must be set by the calling program.
*
*   With these templates, there are only two calling programs;
*   1. the Main Menu from MENUPULL.TEM, or
*   2. the call 'ReadIt' which is the only Read in the program.
*
*   The templates generate a 'Help_Name' which is :
*   1. a unique id for menu option calls - this means two same named
*      options in different menus will access different Help screens,
*   2. the variable or field name being read - this means that all same
*      named fields or variables will access the same Help screen.
*
* The display window for the HELP is dynamically determined as a result
* of the cursor position on the screen. Although the Help window may
* appear at different places for a same named variable on different
* screens, the text inside the window will be properlly formatted to
* the current screen size.
*******************************************************************
*
*                        +---------------+
* = = = = = = = = = = =  |  N O T I C E  |  = = = = = = = = = = = = =
*                        +---------------+
*  ͻ
*   "This code is provided at no charge as a training aid.          
*    No guarantee nor warrantee is given, neither explicitly nor    
*    implicitly, that this code will do anything. This code         
*    does not infringe on the intellectual properties of others.    
*                                                                   
*    Anyone who uses this code in any manner assumes full           
*    responsibility for its use."                                   
*  ͼ
*
*  The disclaimer above is provided at the advice of legal counsel.
*  Basically, it says that what is provided herein is not entirely
*  original work. Much has been done using code provided by WallSoft
*  and other published sources. Credit to others is given were I have
*  incorporated another's idea as published or with modifications.
*  The section refering to "intellectual properties" means that
*  no copyright infringement is being claimed on any of this work.
*
*  Any material that I have previously released is marked with my
*  personal copyright notice and is released to public domain.
*
*  There is no fee due to anyone if you choose to use this code,
*  providing, of course, you are using a legitimate copy of UI2(R) by
*  WallSoft and, if applicable, a legitimate copy of Clipper(R) by
*  Nantucket.
*
*                              Thank you, Rik Hess
*
*  If you have any questions or constructive comments, you can reach me at:
*              6212 Aires Drive, Arlington, Texas  76017
*
**************************************************************************
PROCEDURE help
param     h_prg, h_lin_, h_mvar_
private   incolor, wkarea, hrow, hcol, helpscrn, sought, good_help, helpwork
private   p1, p2, tr, lc, br, rc, lens, deeps

  set key KB_f1 to                     && disable so HELP can't call itself

  incolor   = setcolor()               && save input pointers
  wkarea    = select()
  hrow      = row()
  hcol      = col()
  h_prg     = upper(h_prg)
  help_name = upper(help_name)

  if len(help_name) > 10               && set current 'Help_Name' to 10 char max
    help_name = substr(help_name, 1, 10)
  endif

  p1        = pad(h_prg, 10)
  p2        = pad(help_name, 10)

  if h_prg  = 'READIT'
    clear gets
    set cursor off
    set escape off
    readexit(old_rdkey)
    set key KB_f10 to
  endif

  * HELP.DBF indexed on h_prg + help_name - 'help_name' is public var
  select 0

  if net_use('help','help', .f., 5, .t., 'HELP file is in use. Wait? (Y/N)')
    set index to help

    * Draw Help display box
    *  The technique of using the active cursor position allows
    *  drawing the largest corner box possible

    if hrow > 13                       && if working with bottom of screen
      topr = 1                         &&  show box on top half of screen
      botr = hrow - 1
    else
      topr = hrow + 1                  &&  else show box on bottom half of screen
      botr = 22
    endif

    if hcol > 40                       && if working with left side of screen
      lfcl = 2
      rtcl = hcol - 4                  &&  show box on right
    else
      lfcl = hcol                      && else show box on left
      rtcl = 76
    endif

    if type('colorhelp') = 'U'         && check for color set
      colorhelp = '+w/r'               &&  default is hi white on red
    endif

    if type('colorh_sh') = 'U'         && check for color shadow
      colorh_sh = 'w/r'                &&  default is white on red
    endif

    if type('colorh_ed') = 'U'         && check for color set
      colorh_ed = 'r/N'                &&  red on black for Edit Mode
    endif

    setcolor(colorhelp)

    * save window portion of screen and draw box
    helpscrn = savescreen(topr, lfcl, botr + 1, rtcl + 2)
    @ topr, lfcl, botr, rtcl box 'Ŀ '
    @ topr, (lfcl +  5) say ' HELP SCREEN '
    @ topr, (rtcl - 10) say ' PgUp  '
    @ botr, (rtcl - 10) say ' PgDn  '
    @ botr, (lfcl +  5) say ' Press <Esc> when done '
    shadowbox(topr, lfcl, botr, rtcl, colorh_sh)

    sought    = p1 + p2
    good_help = .f.
    seek sought

    if found()

      * check if this rec is cross referenced to another as 'SEE:xxxxxxxxxx'
      if upper(substr(help_memo, 1, 4)) = 'SEE:'
        sought = upper(substr(help_memo, 5, 10)) + p2
        seek sought

        if found()
          good_help = .t.
        else
          good_help = .f.
        endif

      else
        good_help = .t.
      endif

    endif

    * check if there is a 'global' entry for the help_name
    if !good_help
      sought = replicate(' ', 10) + p2
      seek sought

      if found()
        good_help = .t.
      endif

    endif


    if good_help
      * display the message
      helpwork = memotran(help_memo, ' ', ' ')
    else
      sought   = p1 + p2
      helpwork = 'No HELP is available for "' + ;
                 trim(p2) + '" at this time. ' + ;
                 'Press <Alt F1> to add HELP text.'
      helpwork = memotran(helpwork, ' ', ' ')
    endif

    clear typeahead
    set key KB_aF1 to helprite         && assigns <Alt F1> to HELPRITE
    memoedit(helpwork, topr + 1, lfcl + 2, botr - 1, rtcl - 2, .f.)
    set key KB_aF1 to                  && deassigns <Alt F1>
    restscreen(topr, lfcl, botr + 1, rtcl + 2, helpscrn)
    helpscrn = ''
    use
  endif

  keyboard(chr(0))                     && resets the 'lastkey()' value from Esc
  inkey()
  select(wkarea)                       && reset active work area
  setcolor(incolor)
  @ hrow, hcol say ''                  && reset the cursor
  clear typeahead
  set key KB_f1 to help                && reassign the <F1> key to help

  if upper(h_prg) = 'READIT'
    set key KB_f10 to xit_gets
    old_rdkey = readexit(.t.)
    set escape on
    set cursor on
    read
  endif

return

*******************************************************************
* HELPRITE.PRG
* Purpose              : Routine to create user defined Help screens
* Author               : Don L. Powells
* Version              : Clipper Summer '87
* Copyright (c) 1988 Nantucket Corp.
*
* Modified & annotated : Rik Hess
*
* Called from HELP.PRG with HELP.DBF open
*******************************************************************
PROCEDURE helprite
param     prg_, lin_, mvar_
private   svhelpt, svhelpb, helpwk

  set key KB_aF1 to                    && deassigns <Alt-F1>

  if !good_help
    helpwork = replicate(' ', 100)
  endif

  * save the top and bottom rows of HELP
  svhelpt = savescreen(topr, lfcl, topr, rtcl)
  svhelpb = savescreen(botr, lfcl, botr, rtcl)

  @ topr, lfcl, botr, rtcl box 'Ŀ '
  @ topr, lfcl + 2 say ' HELP EDIT SCREEN '
  @ botr, lfcl + 2 say ' Press <F10> when done '

  if lastkey() = KB_Esc
    return
  endif

  if !good_help

    if add_rec(10, .t., 'HELP file is locked. Wait? (Y/N)')
      replace help_prg  with p1
      replace help_name with p2
    else
      return
    endif

  else

    if !rec_lock(10, .t., 'HELP file is locked. Wait? (Y/N)')
      return
    endif

  endif

  setcolor(colorh_ed)
  set function 10 to chr(KB_cW)       && quit edit key
  set cursor on
  helpwk = memoedit(helpwork, topr + 1, lfcl + 2, botr - 1, rtcl - 2, .t.)
  set cursor off
  set function 10 to ''

  setcolor(colorhelp)
  helpwork = trim(helpwk)

  if len(helpwork) = 0
    delete
  else
    replace help_memo with helpwork
    commit
  endif

  unlock

  restscreen(topr, lfcl, topr, rtcl, svhelpt)
  restscreen(botr, lfcl, botr, rtcl, svhelpb)
return

