
* GDBF        : SUBMODULE version.
*
*  Actions    : PICKREC, EDIT, NEXT, PREVIOUS, FIRST, LAST, ADD, ERASE,
*             : MORE, EXIT
*
* Generated on      :   October 7, 1990 : 12:49:34
* Source .WW file   :   D:\UI2\PROUI\GDBF.WW
* Target environment:   Clipper Summer 87
*

help_name = "gdbf"

private  files_ok, changed, dbfcnt, dbfilt, dbfiltv, dbfiltx, p_name
private  autoadd, newadd, currow, currec, fc, fxit, rkey, rec4wait
private  IndxProcName, v_gdbf, v_showmast, v_showacco, v_showacct

save screen to v_gdbf                      && save the input screen
save all like v_gdbf to &d_home.v_gdbf.mem
v_gdbf = ""

* Initalize private variables
autoadd  = .f.
newadd   = .f.
files_ok = 0
changed  = 0
dbfcnt   = 0
dbfilt   = 0
dbfiltv  = 0
dbfiltx  = 0
currow   = 0
currec   = 0
fc       = 0
fxit     = 0
p_name   = ""
rkey     = 0
rec4wait = 600             && if more recs in file, show "Please Wait"

if !file("&d_data.MASTNAME.ntx")
  wait_msg('PROBLEM: Indexes are missing - Index the Files first. - Any key to continue')
  return
endif

files_ok = .t.

* create memvar duplicates for fields in SHOWMAST
private  L_NAME, F_NAME, SSN, ADDRESS, CITY, STATE, ZIP, PHONE, ACCT_TOTAL
private  IndxMast

* Open database MASTER
*   Control Indexes used:
*   1 : MASTNAME ('l_name + f_name')
*                Called : Last Name
*   2 : MASTSSN ('ssn')
*                Called : Social Security Number
*   3 : MASTSNDX ('soundex(l_name) + f_name')
*                Called : Sound-Alike Last Names
select 0

if !net_use("&d_data.MASTER","MASTER", .f., 30, .t., "File MASTER is locked. Wait? (Y/N)")
  files_ok = .f.
else
  set index to &d_data.MASTNAME, &d_data.MASTSSN, &d_data.MASTSNDX, &d_data.MASTZIP, &d_data.MASTCITY
endif

* create memvar duplicates for fields in SHOWACCO
private  SSN, ACCTTYPE, DATEOPENED, OPEN_BAL, LASTUPDATE, ACCTNUM
private  BALANCE, HIGH_BAL, LOW_BAL
private  indxacco

* Open database ACCOUNT
*   Control Indexes used:
*   1 : ACCTTYPE ('ssn + accttype + acctnum')
*                Called : Account Type And Number
*   2 : ACCTBAL ('ssn + str(balance,10,2)')
*                Called : Current Balance
*   3 : ACCTNUM ('ssn + acctnum')
*                Called : Account Number
select 0

if !net_use("&d_data.ACCOUNT","ACCOUNT", .f., 30, .t., "File ACCOUNT is locked. Wait? (Y/N)")
  files_ok = .f.
else
  set index to &d_data.ACCTTYPE, &d_data.ACCTBAL, &d_data.ACCTNUM, &d_data.ACCTOPEN, &d_data.ACCTUPDT
endif

* create memvar duplicates for fields in SHOWACCT
private  TXNTYPE, ACCTNUM, TXNDATE, ITEM_NUM, AMOUNT, SSN
private  indxacct, xACCT_TOTAL, xACCTTYPE

* Open database ACCTTXNS
*   Control Indexes used:
*   1 : TXNACCT ('accttype + acctnum + descend(dtos(txndate))')
*                Called : Transactions By Date
*   2 : TXNAMT ('accttype + acctnum + str(amount,10,2)')
*                Called : Transaction Amount
select 0

if !net_use("&d_data.ACCTTXNS","ACCTTXNS", .f., 30, .t., "File ACCTTXNS is locked. Wait? (Y/N)")
  files_ok = .f.
else
  set index to &d_data.TXNACCT, &d_data.TXNAMT, &d_data.TXNDAY, &d_data.TXNSSN
endif

if !files_ok
  say_msg('Cannot continue until files are free.')
  close database
  return
endif

* initalize all field-dupe memvars
for dbfcnt = 1 to 3
  gdbfinit_vars()
next

select MASTER
dbfcnt = 1

* Set up pointers to control "SET ORDER TO" and build the index name arrays
* "cindexN" arrays hold the names of the control indexes
private  nidxmast, cindex1[3]
private  nidxacco, cindex2[3]
private  nidxacct, cindex3[2]

gdbfindxsetup()
IndxProcName = "gdbfchgindx()"    && set here for "db_pick_key" in ProUILib

DO DBF_1ST         && Call to Pre-Process code

if file("&d_data.canvas.mem")               && fetch the background if present
  restore from &d_data.canvas.mem additive
  restore screen from canvas
  release canvas
endif

* ---- DISPLAY Vars in the box "CANVAS"
setcolor("+W/R")
VERSION        = M->APPVER
@  2, 75 say VERSION         picture 'XXX'
setcolor("+W/R")
TITLE          = 'MAINTENANCE'
@  3, 67 say TITLE           picture 'XXXXXXXXXXX'
TODAY          = DATE()
@  4, 69 say TODAY           picture '@D'

* -------------------- Drawing Box : "MENU"
setcolor("G/N")
@  0,  0,  2, 62 box "Ŀ "
* -------------------- Drawing Box : "MESSAGE"
setcolor("+G/N")
scroll(24, 0, 24, 79, 0)

gdbfmenu()                        && process the menu program

close database

restore from &d_home.v_gdbf.mem additive
restore screen from v_gdbf                 && do a tidy exit
v_gdbf = ""
erase &d_home.v_gdbf.mem

return

**********************************************************
* GDBFMENU
*   displays and performs menu actions.
**********************************************************
FUNCTION gdbfmenu
private  lastcolor, oldact, newact, key, ikey, oldrec, optkeys, gdbfmenu
private  oldmsg

  * menu initialization
  dbfilt  = ""
  oldact  = 0
  newact  = 1
  oldrec  = recno()

  gdbfshowbox(dbfcnt)

  if gdbfset_filt(.t.)
    newact = 1
    gdbfsets_proc()
    gdbfrecdisp()

    if !autoadd .and. !empty(dbfilt) .or. dbfcnt = 1   && check if filter set

      if !newadd
        * Set AUTO-START option
        clear typeahead
        keyboard 'U'                      && stuff trigger into keyboard buffer
      else
        autoadd = .f.
      endif

      newadd = .t.
    endif

  endif

  * -------------------- Drawing Box : "MENU"
  outliner(0, 0, 2, 62, "ͻȺ ", "G+/N")
  setcolor("G/N")
  scroll(1, 1, 1, 61, 0)

  * declare string of uppercase of all trigger characters
  optkeys = 'UENPFLADMX'

  * display all options in unselected color
  for i = 1 to 10
    gdbfmenu_lo(i)
  next

  do while .t.                              && action loop

    do while .t.                            && menu choice loop
      gdbfreset_optio()          && check if menu option changed

      * get key input
      key = inkey(0)

      if key = KB_f1                        && HELP?
        do help with "gdbfmenu"
        loop
      endif

      if key = KB_f3                      && Change the control index?

        if gdbfchgindx()
          loop
        endif

      endif

      ikey = at(upper(chr(key)), optkeys)

      if key = KB_Esc                    && set "BACK" option trigger
        ikey = at('X', optkeys)
      endif

      if ikey <> 0
        newact = ikey
        gdbfreset_optio()
      endif

      * update choice number based on key response
      do case
      case ikey > 0 .or. key = KB_Enter         && key is a trigger
        exit

      case key = KB_Down .or. key = KB_Right
        newact = iif(oldact = 10, 1, oldact + 1)

      case key = KB_Up   .or. key = KB_Left
        newact = iif(oldact = 1, 10, oldact - 1)

      endcase

    enddo                                   && end of menu selection loop

    oldmsg = savescreen(24, 0, 24, 79)
    say_msg("")

    do case                                   && perform selected option
    case newact = 1
      outliner(0, 0, 2, 62, "Ŀ ", "G/N")
      gdbfPICKREC()
      outliner(0, 0, 2, 62, "ͻȺ ", "G+/N")

    case newact = 2

      if !chk_pwd("EDIT", 3, "Edit Password => EDIT")
        exit
      endif

      outliner(0, 0, 2, 62, "Ŀ ", "G/N")
      gdbfEDITREC()
      outliner(0, 0, 2, 62, "ͻȺ ", "G+/N")

    case newact = 3
      gdbfNEXTREC()

    case newact = 4
      gdbfPREVREC()

    case newact = 5
      gdbfFIRSTREC(.t.)                 && (.t.) forces rec display

    case newact = 6
      DO LAST_1ST         && Call to Pre-Process code
      gdbfLASTREC(.t.)                 && (.t.) forces rec display
      DO LAST_AFT         && Call to Post-Process code

    case newact = 7
      outliner(0, 0, 2, 62, "Ŀ ", "G/N")
      gdbfADDREC()
      outliner(0, 0, 2, 62, "ͻȺ ", "G+/N")

    case newact = 8
      gdbfDELREC()

    case newact = 9
      gdbfMORE()

    case newact = 10
      gdbfBACK()

    endcase

    restscreen(24, 0, 24, 79, oldmsg)

    if oldrec = -1                          && flag set to exit
      exit
    endif

    newadd = .f.
    oldrec = recno()
  enddo

return .t.

**********************************************************
* GDBFRESET_OPTIO
*   if menu option changed, show it
**********************************************************
FUNCTION gdbfreset_optio

  if oldact <> newact                       && if option changed

    if oldact <> 0
      gdbfmenu_lo(oldact)
    endif

    setcolor('+G/N')             && highlight current option
    gdbfmenu_hi(newact)
    oldact = newact                         && reset oldact for another pass
  endif

return .t.

**********************************************************
* GDBFMENU_HI(choice)
*   writes hilited option
**********************************************************
FUNCTION gdbfmenu_hi
param    choice

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    help_name = "gdbfLOOKUP"
    say_msg('Scroll through the records in the file')
    * -------------------- Drawing Box : "LOOKUP"
    setcolor("+G/N")
    scroll(1, 2, 1, 7, 0)
    @  1,  2 say "lookUp"

  case choice = 2
    help_name = "gdbfEDIT"
    say_msg('Edit the current entry')
    * -------------------- Drawing Box : "EDIT"
    setcolor("+G/N")
    scroll(1, 10, 1, 13, 0)
    @  1, 10 say "Edit"

  case choice = 3
    help_name = "gdbfNEXT"
    say_msg('Display the next entry')
    * -------------------- Drawing Box : "NEXT"
    setcolor("+G/N")
    scroll(1, 16, 1, 19, 0)
    @  1, 16 say "Next"

  case choice = 4
    help_name = "gdbfPREV"
    say_msg('Show the previous entry')
    * -------------------- Drawing Box : "PREV"
    setcolor("+G/N")
    scroll(1, 22, 1, 25, 0)
    @  1, 22 say "Prev"

  case choice = 5
    help_name = "gdbfFIRST"
    say_msg('Go to first entry')
    * -------------------- Drawing Box : "FIRST"
    setcolor("+G/N")
    scroll(1, 28, 1, 32, 0)
    @  1, 28 say "First"

  case choice = 6
    help_name = "gdbfLAST"
    say_msg('Go to last entry')
    * -------------------- Drawing Box : "LAST"
    setcolor("+G/N")
    scroll(1, 35, 1, 38, 0)
    @  1, 35 say "Last"

  case choice = 7
    help_name = "gdbfADD"
    say_msg('Add a new master entry')
    * -------------------- Drawing Box : "ADD"
    setcolor("+G/N")
    scroll(1, 41, 1, 43, 0)
    @  1, 41 say "Add"

  case choice = 8
    help_name = "gdbfDEL"
    say_msg('Delete the current entry')
    * -------------------- Drawing Box : "DEL"
    setcolor("+G/N")
    scroll(1, 46, 1, 48, 0)
    @  1, 46 say "Del"

  case choice = 9
    help_name = "gdbfMORE"
    say_msg('Change to see more details')
    * -------------------- Drawing Box : "MORE"
    setcolor("+G/N")
    scroll(1, 51, 1, 54, 0)
    @  1, 51 say "More"

  case choice = 10
    help_name = "gdbfEXIT"
    say_msg('Quit working at this level')
    * -------------------- Drawing Box : "EXIT"
    setcolor("+G/N")
    scroll(1, 57, 1, 60, 0)
    @  1, 57 say "eXit"

  endcase

return .t.

**********************************************************
* GDBFMENU_LO(choice)
*   writes lolited option
**********************************************************
FUNCTION gdbfmenu_lo
param    choice
private  lastcolor

  do case
  case type("choice") <> "N"
    return .f.

  case choice = 1
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "LOOKUP"
    @  1,  2 say "lookUp"
    setcolor("+G/N")
    @  1,  6 say "U"
    setcolor(lastcolor)

  case choice = 2
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "EDIT"
    @  1, 10 say "Edit"
    setcolor("+G/N")
    @  1, 10 say "E"
    setcolor(lastcolor)

  case choice = 3
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "NEXT"
    @  1, 16 say "Next"
    setcolor("+G/N")
    @  1, 16 say "N"
    setcolor(lastcolor)

  case choice = 4
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "PREV"
    @  1, 22 say "Prev"
    setcolor("+G/N")
    @  1, 22 say "P"
    setcolor(lastcolor)

  case choice = 5
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "FIRST"
    @  1, 28 say "First"
    setcolor("+G/N")
    @  1, 28 say "F"
    setcolor(lastcolor)

  case choice = 6
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "LAST"
    @  1, 35 say "Last"
    setcolor("+G/N")
    @  1, 35 say "L"
    setcolor(lastcolor)

  case choice = 7
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "ADD"
    @  1, 41 say "Add"
    setcolor("+G/N")
    @  1, 41 say "A"
    setcolor(lastcolor)

  case choice = 8
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "DEL"
    @  1, 46 say "Del"
    setcolor("+G/N")
    @  1, 46 say "D"
    setcolor(lastcolor)

  case choice = 9
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "MORE"
    @  1, 51 say "More"
    setcolor("+G/N")
    @  1, 51 say "M"
    setcolor(lastcolor)

  case choice = 10
    lastcolor = setcolor('BG/N')
    * -------------------- Drawing Box : "EXIT"
    @  1, 57 say "eXit"
    setcolor("+G/N")
    @  1, 58 say "X"
    setcolor(lastcolor)

  endcase

return .t.

**********************************************************
* GDBFADDREC
*   append new record
**********************************************************
FUNCTION gdbfaddrec

  currec  = recno()
  changed = .f.
  autoadd = .f.
  p_name  = "addrec"

  gdbfinit_vars()
  gdbfrecdisp()
  say_msg('Add new information, <F10> when Done, <Esc> to Abort')

  gdbfgets_proc()

  * if not changed or user abort or can not append new rec
  if no_append()
    goto currec
    gdbfsets_proc()
    gdbfrecdisp()
    return .f.
  endif

  if !gdbflock_test()
    return .f.
  endif

  gdbfcalc()
  gdbfrepl_recs()

  do case
  case dbfcnt = 2
    keyboard "MA"                 && keys to automatically add 1st detail
    autoadd  = .t.
  endcase

return .t.

**********************************************************
* GDBFEDITREC
*   edit current record
**********************************************************
FUNCTION gdbfeditrec

  * lock the file
  if !gdbflock_test()
    return .f.
  endif

  p_name  = "editrec"
  changed = .f.
  currec  = recno()
  say_msg('Edit the record, <F10> when Done, <Esc> to Abort')

  gdbfgets_proc()

  if !changed .or. fxit = -99                 && not changed or user abort
    gdbfunlk_recs()
    goto currec
    gdbfsets_proc()
    gdbfrecdisp()
    return .f.
  endif

  gdbfcalc()
  gdbfrepl_recs()                   && replace the fields

return .t.

**********************************************************
* GDBFGETS_PROC
*   @..GETs for addrec & editrec
**********************************************************
FUNCTION gdbfgets_proc

  * get input fields into memvar duplicates
  fc       = 1
  fxit     = 1
  rkey     = 1
  old_help = help_name

  * show fields in the Clipper "unselected field color"
  do case
  case dbfcnt = 1                        &&  get fields for MASTER
    setcolor("+N/BG")
    @ 10, 17 say m->L_NAME       picture "@!"
    @ 10, 34 say m->F_NAME       picture "@!"
    @ 10, 58 say m->SSN          picture "999-99-9999"
    @ 12, 17 say m->ADDRESS      picture 'XXXXXXXXXXXXXXXXXXXX'
    @ 12, 39 say m->CITY         picture 'XXXXXXXXXXXXXXX'
    @ 12, 55 say m->STATE        picture "@!"
    @ 12, 58 say m->ZIP          picture "99999-9999"
    @ 14, 17 say m->PHONE        picture "(999) 999-9999 XXXXXXXXXXXXXXX"
    outliner(5, 3, 17, 71, "ͻȺ ", "BG+/N")

    * set Clipper "unselected field color" for GET

    * set "ok" for field reads, used to check all validity checks later
    ok1 = .f.
    ok2 = .f.
    ok3 = .f.
    ok4 = .f.
    ok5 = .f.
    ok6 = .f.
    ok7 = .f.
    ok8 = .f.

    do while .t.


      if rkey <> KB_Up .and. rkey <> 0

        * Pre Proc calls
        do case
        case fc = 1
          DO NAME_1ST         && Call to Pre-Process code
        endcase

      endif

      do case
      case fc = 1
        help_name = "L_NAME"
        @ 10, 17 get m->L_NAME       picture "@!"
      case fc = 2
        help_name = "F_NAME"
        @ 10, 34 get m->F_NAME       picture "@!"
      case fc = 3
        help_name = "SSN"
        @ 10, 58 get m->SSN          picture "999-99-9999"
      case fc = 4
        help_name = "ADDRESS"
        @ 12, 17 get m->ADDRESS      picture 'XXXXXXXXXXXXXXXXXXXX'
      case fc = 5
        help_name = "CITY"
        @ 12, 39 get m->CITY         picture 'XXXXXXXXXXXXXXX'
      case fc = 6
        help_name = "STATE"
        @ 12, 55 get m->STATE        picture "@!" ;
                     valid valid_stat(@STATE)
      case fc = 7
        help_name = "ZIP"
        @ 12, 58 get m->ZIP          picture "99999-9999"
      case fc = 8
        help_name = "PHONE"
        @ 14, 17 get m->PHONE        picture "(999) 999-9999 XXXXXXXXXXXXXXX"
      endcase

      readit(8)

      do case
      case fc = 2
        ok1 = .t.

        if changed
          DO NAME_AFT         && Call to Post-Process code
        endif

      case fc = 3
        ok2 = .t.

      case fc = 4
        ok3 = .t.

      case fc = 5
        ok4 = .t.

      case fc = 6
        ok5 = .t.

      case fc = 7
        ok6 = .t.
        @ 12, 55 say m->STATE        picture "@!"

      case fc = 8
        ok7 = .t.

      case fc = 1
        ok8 = .t.

      endcase

      if fxit = KB_F10

        * Validity checks on any unread fields
        if !ok6

          if !valid_stat(@STATE)
            fxit = 0
            fc   = 6
          endif

        endif

      endif

      if fxit < 0
        outliner(5, 3, 17, 71, "Ŀ ", "BG/N")
        exit
      endif

    enddo

  * show fields in the Clipper "unselected field color"
  case dbfcnt = 2                        &&  get fields for ACCOUNT
    setcolor("+N/BG")
    @ 13, 19 say m->ACCTTYPE     picture "@!"
    @ 16, 19 say m->ACCTNUM      picture "99-9999999-9"
    outliner(7, 4, 18, 74, "ͻȺ ", "BG+/N")

    * set Clipper "unselected field color" for GET

    * set "ok" for field reads, used to check all validity checks later
    ok1 = .f.
    ok2 = .f.

    do while .t.

      do case
      case fc = 1
        help_name = "ACCTTYPE"
        @ 13, 19 get m->ACCTTYPE     picture "@!" ;
                     valid m->ACCTTYPE $ "CSD"
      case fc = 2
        help_name = "ACCTNUM"
        @ 16, 19 get m->ACCTNUM      picture "99-9999999-9"
      endcase

      readit(2)

      do case
      case fc = 2
        ok1 = .t.
        @ 13, 19 say m->ACCTTYPE     picture "@!"

      case fc = 1
        ok2 = .t.

      endcase

      if fxit = KB_F10

        * Validity checks on any unread fields
        if !ok1

          if !(m->ACCTTYPE $ "CSD")
            fxit = 0
            fc   = 1
          endif

        endif

      endif

      if fxit < 0
        outliner(7, 4, 18, 74, "Ŀ ", "BG/N")
        exit
      endif

    enddo

  * show fields in the Clipper "unselected field color"
  case dbfcnt = 3                        &&  get fields for ACCTTXNS
    setcolor("+N/BG")
    @ 15, 40 say m->TXNTYPE      picture "@!"
    @ 17, 40 say m->TXNDATE      picture '@D'
    @ 18, 40 say m->ITEM_NUM     picture 'XXXXXXXXXX'
    @ 19, 40 say m->AMOUNT       picture "9,999,999.99"
    outliner(9, 5, 20, 75, "ͻȺ ", "BG+/N")

    * set Clipper "unselected field color" for GET

    * set "ok" for field reads, used to check all validity checks later
    ok1 = .f.
    ok2 = .f.
    ok3 = .f.
    ok4 = .f.

    do while .t.

      do case
      case fc = 1
        help_name = "TXNTYPE"
        @ 15, 40 get m->TXNTYPE      picture "@!" ;
                     valid m->TXNTYPE $ "DWFA"
      case fc = 2
        help_name = "TXNDATE"
        @ 17, 40 get m->TXNDATE      picture '@D' ;
                     valid valid_date(@TXNDATE)
      case fc = 3
        help_name = "ITEM_NUM"
        @ 18, 40 get m->ITEM_NUM     picture 'XXXXXXXXXX'
      case fc = 4
        help_name = "AMOUNT"
        @ 19, 40 get m->AMOUNT       picture "9,999,999.99" ;
                     valid ckadjamt(@AMOUNT)
      endcase

      readit(4)

      do case
      case fc = 2
        ok1 = .t.
        @ 15, 40 say m->TXNTYPE      picture "@!"

      case fc = 3
        ok2 = .t.
        @ 17, 40 say m->TXNDATE      picture '@D'

      case fc = 4
        ok3 = .t.

      case fc = 1
        ok4 = .t.
        @ 19, 40 say m->AMOUNT       picture "9,999,999.99"

      endcase

      if fxit = KB_F10

        * Validity checks on any unread fields
        if !ok1

          if !(m->TXNTYPE $ "DWFA")
            fxit = 0
            fc   = 1
          endif

        endif

        if !ok2

          if !valid_date(@TXNDATE)
            fxit = 0
            fc   = 2
          endif

        endif

        if !ok4

          if !ckadjamt(@AMOUNT)
            fxit = 0
            fc   = 4
          endif

        endif

      endif

      if fxit < 0
        outliner(9, 5, 20, 75, "Ŀ ", "BG/N")
        exit
      endif

    enddo

  endcase

  help_name = old_help
  say_msg('')

return .t.

**********************************************************
* GDBFCALC
*   used by edit and add to do calc fields
**********************************************************
FUNCTION gdbfcalc

  if dbfcnt >= 3                       && calc fields for ACCTTXNS
    * ----- Calculated fields in box SHOWACCT
    m->AMOUNT      = IIF((M->TXNTYPE="W".OR.M->TXNTYPE="F").AND.M->AMOUNT>0,M->AMOUNT*-1,M->AMOUNT)
    m->BALANCE     = M->BALANCE+M->AMOUNT-IIF(ACCOUNT->ACCTTYPE+ACCOUNT->ACCTNUM=ACCTTXNS->ACCTTYPE+ACCTTXNS->ACCTNUM,ACCTTXNS->AMOUNT,0)
    m->LASTUPDATE  = MAX(M->LASTUPDATE,M->TXNDATE)
    * ----- Calculated memory variables in box SHOWACCT
    xACCT_TOTAL    = IIF(XACCT_TOTAL<>0,XACCT_TOTAL-ACCOUNT->BALANCE+M->BALANCE,M->ACCT_TOTAL)
  endif


  if dbfcnt >= 2                       && calc fields for ACCOUNT
    * ----- Calculated fields in box SHOWACCO
    m->ACCT_TOTAL  = MASTER->ACCT_TOTAL-ACCOUNT->BALANCE+M->BALANCE
    m->DATEOPENED  = MIN(M->TXNDATE,M->DATEOPENED)
    m->OPEN_BAL    = IIF(ACCOUNT->OPEN_BAL=0.AND.ACCOUNT->DATEOPENED<=DATE(),M->BALANCE,M->OPEN_BAL)
    m->LASTUPDATE  = M->TXNDATE
    m->BALANCE     = M->BALANCE
    m->HIGH_BAL    = MAX(ACCOUNT->HIGH_BAL,M->BALANCE)
    m->LOW_BAL     = IIF(ACCOUNT->LOW_BAL=0.AND.ACCOUNT->DATEOPENED<=DATE(),M->BALANCE,MIN(ACCOUNT->LOW_BAL,M->BALANCE))
  endif

return .t.

**********************************************************
* GDBFREPL_RECS
*   Procedure to replace DBF fields
**********************************************************
FUNCTION gdbfrepl_recs

** WARNING : ProUI does not generate the code to handle relational integrity.
*            Master & details must be checked by the developer.
*            The 'AddCode_Repl('file')' provides a flexible approach to this problem.

* Included in from "GdbfRepl.INC"
* - - - - - - - - - - - - - - - - - - - - - -  Start: GdbfRepl.INC

  * if SSN changed, update Account.DBF and Accttxns.DBF
  if dbfcnt = 1 .and. p_name = "editrec" .and. master->SSN <> m->SSN
    select account

    if fil_lock(30)
      replace all account->SSN with m->SSN for account->SSN = master->SSN
      unlock
    endif

    select accttxns

    if fil_lock(30)
      replace all accttxns->SSN with m->SSN for accttxns->SSN = master->SSN
      unlock
    endif

    select master
  endif

  * if ACCTTYPE or ACCTNUM changed, update Accttxns.DBF
  if dbfcnt = 2 .and. p_name = "editrec" .and. ;
    (account->ACCTTYPE <> m->ACCTTYPE    .or.  ;
     account->ACCTNUM  <> m->ACCTNUM)
    select accttxns

    if fil_lock(30)
      replace all accttxns->ACCTTYPE with m->ACCTTYPE ;
              for (accttxns->SSN + accttxns->ACCTTYPE) = ;
                   (account->SSN + account->ACCTTYPE)
      replace all accttxns->ACCTNUM with m->ACCTNUM ;
              for (accttxns->SSN + accttxns->ACCTNUM) = ;
                   (account->SSN + account->ACCTNUM)
      unlock
    endif

    select account
  endif
* - - - - - - - - - - - - - - - - - - - - - -  End: GdbfRepl.INC

  if dbfcnt >= 1                         && repl fields for MASTER
    replace MASTER->L_NAME         with m->L_NAME
    replace MASTER->F_NAME         with m->F_NAME
    replace MASTER->SSN            with m->SSN
    replace MASTER->ADDRESS        with m->ADDRESS
    replace MASTER->CITY           with m->CITY
    replace MASTER->STATE          with m->STATE
    replace MASTER->ZIP            with m->ZIP
    replace MASTER->PHONE          with m->PHONE
    replace MASTER->ACCT_TOTAL     with m->ACCT_TOTAL
  endif

  if dbfcnt >= 2                         && repl fields for ACCOUNT
    replace ACCOUNT->SSN           with m->SSN
    replace ACCOUNT->ACCTTYPE      with m->ACCTTYPE
    replace ACCOUNT->ACCTNUM       with m->ACCTNUM
    replace ACCOUNT->DATEOPENED    with m->DATEOPENED
    replace ACCOUNT->OPEN_BAL      with m->OPEN_BAL
    replace ACCOUNT->HIGH_BAL      with m->HIGH_BAL
    replace ACCOUNT->LOW_BAL       with m->LOW_BAL
    replace ACCOUNT->BALANCE       with m->BALANCE
    replace ACCOUNT->LASTUPDATE    with m->LASTUPDATE
  endif

  if dbfcnt >= 3                         && repl fields for ACCTTXNS
    replace ACCTTXNS->SSN          with m->SSN
    replace ACCTTXNS->ACCTTYPE     with m->ACCTTYPE
    replace ACCTTXNS->ACCTNUM      with m->ACCTNUM
    replace ACCTTXNS->TXNDATE      with m->TXNDATE
    replace ACCTTXNS->AMOUNT       with m->AMOUNT
    replace ACCTTXNS->TXNTYPE      with m->TXNTYPE
    replace ACCTTXNS->ITEM_NUM     with m->ITEM_NUM
  endif

  commit

  gdbfunlk_recs()
  gdbfrecdisp()

return .t.

**********************************************************
* GDBFDELREC
*   delete record w/confirm
**********************************************************
FUNCTION gdbfdelrec

** WARNING : ProUI does not generate the code to handle relational integrity.
*            Master & details must be checked by the developer.
*            The 'AddCode_Del('file')' provides a flexible approach to this problem.

  if !gdbflock_test()
    return .f.
  endif

  p_name  = "delrec"
  changed = .f.

  if yn_confirm('Delete this Record (Y/N)', 'N')
* - - - - - - - - - - - - - - - - - - - - - -  Start: GdbfDel.INC

    * if on Master.DBF, delete child recs in Account.DBF and Accttxns.DBF
    if dbfcnt = 1
      select account

      if fil_lock(30)
        delete all for ssn = master->ssn
        unlock
      endif

      select accttxns

      if fil_lock(30)
        delete all for ssn = master->ssn
        unlock
      endif

      select master
    endif

    * if on Account.DBF, delete child recs in Accttxns.DBF
    if dbfcnt = 2
      select accttxns

      if fil_lock(30)
        delete all for accttype = account->accttype .and. ;
                        acctnum = account->acctnum
        unlock
      endif

      select account
    endif

* - - - - - - - - - - - - - - - - - - - - - -  End: GdbfDel.INC

    gdbfinit_vars()           && set mem-dupes to 0
    gdbfcalc()

    delete
    changed = .t.                       && set as flag for use by Post-Proc

    if !gdbfnxfltrec(-1)
      gdbffirstrec(.t.)
    else
      gdbfsets_proc()
      gdbfrecdisp()
    endif

  endif

  gdbfunlk_recs()

return .t.

**********************************************************
* GDBFFIRSTREC
*   go to first record
**********************************************************
FUNCTION gdbffirstrec
param    disp

  if type("disp") <> "L"
    disp = .f.
  endif

  p_name = "firstrec"
  say_msg('')

  if !empty(trim(dbfilt))
    seek &dbfilt
  else
    goto top
  endif

  if !eof()

    if disp
      gdbfsets_proc()
      gdbfrecdisp()
    endif

  else
    say_msg_c("No records currently exist.")
  endif

return .t.

**********************************************************
* GDBFLASTREC
*   go to last record
**********************************************************
FUNCTION gdbflastrec
param    disp

  if type("disp") <> "L"
    disp = .f.
  endif

  p_name = "lastrec"
  say_msg('')

  if !empty(trim(dbfilt))
    seek &dbfilt

    if !eof()

      do while &dbfiltx .and. !eof()          && same key as master
        skip
      enddo

      if eof() .or. !&dbfiltx
        skip -1
      endif

    endif

  else
    goto bottom
  endif

  if !eof()

    if disp
      gdbfsets_proc()
      gdbfrecdisp()
    endif

  else
    say_msg_c("No records currently exist.")
  endif

return .t.

**********************************************************
* GDBFNEXTREC
*   go to next record
**********************************************************
FUNCTION gdbfnextrec
private  say_scrn

  * Check for an empty file
  currec = recno()
  goto top

  if eof()
    gdbfchk_addit()
    goto currec
    return .f.
  endif

  goto currec

  p_name = "nextrec"

  if !gdbfnxfltrec(1)             && find next rec in filter
    goto currec
    at_eof()
  else
    gdbfsets_proc()
    gdbfrecdisp()
  endif

return .t.

**********************************************************
* GDBFPREVREC
*   go to previous record
**********************************************************
FUNCTION gdbfprevrec
private  say_scrn

  * Check for an empty file
  currec = recno()
  goto top

  if eof()
    gdbfchk_addit()
    goto currec
    return .f.
  endif

  goto currec

  p_name = "prevrec"

  if !gdbfnxfltrec(-1)            && find previous rec in filter
    goto currec
    at_bof()
  else
    gdbfsets_proc()
    gdbfrecdisp()
  endif

return .t.

**********************************************************
* GDBFMORE
*   select "more" details from a related data file
**********************************************************
FUNCTION gdbfmore

  p_name = "more"

  do case                           && Going Down - are we at the bottom level?
  case dbfcnt = 1                          && from MASTER
    gdbfshowbox(2)
    select ACCOUNT

  case dbfcnt = 2                          && from ACCOUNT
    gdbfshowbox(3)
    select ACCTTXNS

  case dbfcnt = 3                      && from ACCTTXNS
    bot_tone()
    say_msg_c("No further detail files available")
    return .f.
  endcase

  dbfcnt = dbfcnt + 1                         && set DBF pointer to next level down

  if gdbfset_filt(.t.)
    newact = 1
    gdbfsets_proc()
    gdbfrecdisp()

    if !autoadd .and. !empty(dbfilt) .or. dbfcnt = 1   && check if filter set

      if !newadd
        * Set AUTO-START option
        clear typeahead
        keyboard 'U'                      && stuff trigger into keyboard buffer
      else
        autoadd = .f.
      endif

      newadd = .t.
    endif

  endif

return .t.

**********************************************************
* GDBFBACK
*   returns from "more" details to a master data file
**********************************************************
FUNCTION gdbfback

p_name = "back"

  do case                           && Going Up - are we at the top level?
  case dbfcnt = 1                             && from MASTER
    oldrec = -1                               &&  set a flag that we are finished
    return .f.

  case dbfcnt = 2                          && from ACCOUNT
    restscreen(7, 4, 19, 76, v_ShowAcco)
    v_ShowAcco = ''

    gdbfshowbox(1)
    select MASTER

  case dbfcnt = 3                          && from ACCTTXNS
    restscreen(9, 5, 21, 77, v_ShowAcct)
    v_ShowAcct = ''

    gdbfshowbox(2)
    select ACCOUNT

  endcase

  dbfcnt = dbfcnt - 1                         && set DBF pointer to next level up
  gdbfset_filt(.f.)
  gdbfrecdisp()                     && return from detail- active rec is current

return .t.

**********************************************************
* GDBFSET_FILT
*   sets "filter" condition for dbf
* NOTE: assumes filter is on records active key
**********************************************************
FUNCTION gdbfset_filt
param    findit

  if type('findit') <> 'L'
    findit = .f.
  endif

  do case                                       && check for filter
  case dbfcnt = 1                          && set filter for MASTER
    dbfilt  = ''
    dbfiltx = ''
    dbfiltv = ''

  case dbfcnt = 2                          && set filter for ACCOUNT
    dbfilt  = 'MASTER->SSN'
    dbfiltx = 'SSN=MASTER->SSN'
    dbfiltv = MASTER->SSN

  case dbfcnt = 3                          && set filter for ACCTTXNS
    dbfilt  = 'ACCOUNT->ACCTTYPE + ACCOUNT->ACCTNUM'
    dbfiltx = 'ACCTTYPE=ACCOUNT->ACCTTYPE .and. ACCTNUM=ACCOUNT->ACCTNUM'
    dbfiltv = ACCOUNT->ACCTTYPE + ACCOUNT->ACCTNUM

  endcase

  if findit                                     && only when going to detail level
    goto top

    if dbfcnt > 1 .and. !empty(trim(dbfilt))      && check if a filter is set
      seek &dbfilt

      if eof()
        clear typeahead
        gdbfchk_addit()
        return .f.
      endif

      set filter to &dbfiltx
    endif

  endif

return .t.

**********************************************************
* GDBFNXFLTREC
*   finds nn-th record using (optional) filter conditions
**********************************************************
FUNCTION gdbfnxfltrec
param    nn
private  n2, xn, i

  if type("nn") <> "N"
    nn = 1
  endif

  * Check for an empty file
  currec = recno()
  goto top

  if eof()
    gdbfchk_addit()
    goto currec
    return .f.
  endif

  goto currec

  if nn > 0                                     && set up the loop counters
    n2 = nn                                     &&  num to skip
    xn = 1                                      &&  direction to skip
  else
    n2 = abs(nn)
    xn = -1
  endif

  for i = 1 to n2
    skip xn

    if bof() .or. eof()                         && check if beyond file limits
      exit
    endif

    if !empty(trim(dbfilt))                    && now check if there is a "filter"

      if !&dbfiltx                              &&  if not same key as master
        skip xn * -1                            &&  back up a rec
        exit
      endif

    endif

  next

  if xn > 0 .and. eof()
    gdbflastrec(.f.)                  &&  show last rec
    return .f.
  endif

  if xn < 0 .and. bof()
    gdbffirstrec(.f.)                 &&  showfirst rec
    return .f.
  endif

return (iif(recno() = currec, .f., .t.))      && if some recs skipped it is ok

**********************************************************
* GDBFCHK_ADDIT
*   checks to see if ok to add records and set trigger
**********************************************************
FUNCTION gdbfchk_addit
private  msg_err, add_yn

  if chr(nextkey()) <> "A"           && if not already set to Add
    bot_tone()
    clear typeahead

    newadd  = .t.
    msg_err = 'No records currently exist'

    if dbfcnt > 1
      msg_err = msg_err + ' for this master'
    endif

    msg_err = msg_err + '. Add them now?'

    if yn_confirm(msg_err, "Y")
      keyboard "A"             && stuff the Add  trigger
    else
      keyboard "X"             && stuff the Back trigger
    endif
  endif


return .t.

**********************************************************
* GDBFSHOWBOX
*   shows dbf show-filename boxes
**********************************************************
FUNCTION gdbfshowbox
param    n

  if type("n") <> "N"
    return .f.
  endif

  do case
  case n = 1                               &&  set box for MASTER
    * -------------------- Drawing Box : "SHOWMAST"
    v_ShowMast = savescreen(5, 3, 18, 73)
    setcolor("BG/N")
    @  5,  3, 17, 71 box "Ŀ "
    shadowbox(5, 3, 17, 71, "N/N")
    setcolor("+BG/N")
    @  6,  4 say replicate(' ', 20)
    @  6, 52 say replicate(' ', 19)
    @  7,  4 say replicate(' ', 22)
    @  7, 36 say replicate(' ', 35)
    @  8,  4 say replicate('', 23)
    @  8, 49 say replicate('', 22)
    @  9,  4 say replicate(' ', 67)
    @ 10, 11 say "Name:"+replicate(' ', 37)+"SSN:"
    @ 11, 17 say "(Last)"+replicate(' ', 11)+"(First)"
    @ 12,  8 say "Address:"
    @ 13, 39 say "(City)"+replicate(' ', 9)+"(ST)(ZIP)"
    @ 14, 10 say "Phone:"
    @ 16,  4 say " "
    @ 16, 16 say replicate(' ', 11)
    setcolor("+GR/N")
    @  6, 24 say "NAME Master File Maintenance"
    setcolor("BG/N")
    @  7, 26 say "Ordered by"
    @ 15,  4 say replicate('', 67)
    @ 16,  5 say "Acct-Total:"
    @ 16, 27 say replicate(' ', 43)
    setcolor("GR/N")
    @  8, 27 say " "
    @  8, 48 say " "
    setcolor("+G/N")
    @  8, 28 say "<F3>"
    setcolor("G/N")
    @  8, 33 say "to Change Order"

  case n = 2                               &&  set box for ACCOUNT
    * -------------------- Drawing Box : "SHOWACCO"
    v_ShowAcco = savescreen(7, 4, 19, 76)
    setcolor("BG/N")
    @  7,  4, 18, 74 box "Ŀ "
    shadowbox(7, 4, 18, 74, "N/N")
    setcolor("+BG/N")
    @  8,  5 say replicate(' ', 23)
    @  8, 52 say replicate(' ', 22)
    @  9,  5 say replicate(' ', 22)
    @  9, 37 say replicate(' ', 37)
    @ 10,  5 say replicate('', 24)
    @ 10, 51 say replicate('', 23)
    @ 11,  6 say replicate(' ', 15)
    @ 11, 22 say replicate(' ', 10)
    @ 11, 37 say replicate(' ', 11)
    @ 11, 54 say " "
    @ 11, 60 say replicate(' ', 14)
    @ 13,  6 say "Account Type"
    @ 13, 31 say " "
    @ 13, 33 say " "
    @ 13, 50 say replicate(' ', 8)
    @ 13, 60 say replicate(' ', 10)
    @ 14,  5 say replicate(' ', 17)
    @ 14, 31 say " "
    @ 14, 33 say replicate(' ', 40)
    @ 15,  5 say replicate(' ', 17)
    @ 15, 31 say " "
    @ 15, 33 say " "
    @ 15, 49 say replicate(' ', 24)
    @ 16,  6 say "Acct"
    @ 16, 11 say "Number"
    @ 16, 34 say "   "
    @ 16, 55 say "  "
    @ 16, 58 say "  "
    @ 16, 70 say "   "
    @ 17, 17 say replicate(' ', 14)
    @ 17, 46 say replicate(' ', 11)
    @ 17, 64 say "    "
    @ 17, 69 say "     "
    setcolor("+GR/N")
    @  8, 28 say "ACCOUNT File Maintenance"
    setcolor("BG/N")
    @  9, 27 say "Ordered by"
    @ 11,  5 say " "
    @ 11, 21 say " "
    @ 11, 33 say "SSN"
    @ 11, 49 say "Accts"
    @ 11, 55 say "Total"
    @ 12,  5 say replicate('', 27)+""+replicate('', 41)
    @ 13, 32 say ""
    @ 13, 34 say "Date Opened"
    @ 13, 59 say "$"
    @ 13, 70 say "    "
    @ 14, 32 say ""
    @ 15, 32 say ""
    @ 15, 34 say "Last Updated"
    @ 16, 10 say " "
    @ 16, 32 say ""
    @ 16, 37 say replicate(' ', 18)
    @ 16, 57 say " "
    @ 16, 60 say replicate(' ', 10)
    @ 17,  6 say "Current Bal"
    @ 17, 32 say " High/Low Bal"
    @ 17, 60 say "lOW"
    @ 17, 68 say " "
    setcolor("GR/N")
    @ 10, 29 say " "
    @ 13, 20 say ""
    setcolor("+G/N")
    @ 10, 30 say "<F3>"
    setcolor("G/N")
    @ 10, 35 say "to Change Order"
    setcolor("G/GR")
    @ 13, 22 say ""
    @ 14, 22 say " "
    @ 15, 22 say " "
    @ 15, 28 say "   "
    setcolor("+G/GR")
    @ 13, 23 say "C"
    @ 14, 23 say "S"
    @ 15, 24 say "D"
    setcolor("N/GR")
    @ 13, 24 say "hecking"
    @ 14, 24 say "avings "
    @ 15, 23 say "C"
    @ 15, 25 say "   "

  case n = 3                               &&  set box for ACCTTXNS
    * -------------------- Drawing Box : "SHOWACCT"
    v_ShowAcct = savescreen(9, 5, 21, 77)
    setcolor("BG/N")
    @  9,  5, 20, 75 box "Ŀ "
    shadowbox(9, 5, 20, 75, "N/N")
    setcolor("+BG/N")
    @ 10,  6 say replicate(' ', 18)
    @ 10, 35 say " "
    @ 10, 52 say replicate(' ', 23)
    @ 11,  6 say replicate(' ', 21)
    @ 11, 30 say replicate(' ', 45)
    @ 12,  6 say replicate('', 23)
    @ 12, 51 say replicate('', 24)
    @ 13,  6 say replicate(' ', 16)
    @ 13, 23 say replicate(' ', 10)
    @ 13, 38 say replicate(' ', 11)
    @ 13, 55 say " "
    @ 13, 61 say replicate(' ', 14)
    @ 15,  6 say replicate(' ', 26)
    @ 15, 33 say " "
    @ 15, 35 say "Type"
    @ 15, 40 say " "
    @ 15, 72 say " "
    @ 16, 20 say replicate(' ', 12)
    @ 16, 33 say replicate(' ', 19)
    @ 16, 72 say " "
    @ 17,  6 say " "
    @ 17, 20 say replicate(' ', 12)
    @ 17, 35 say "Date"
    @ 17, 40 say "  "
    @ 17, 43 say replicate(' ', 9)
    @ 17, 72 say " "
    @ 18,  6 say replicate(' ', 26)
    @ 18, 34 say "Item#"
    @ 18, 44 say replicate(' ', 6)
    @ 19,  6 say replicate(' ', 26)
    @ 19, 33 say "Amount"
    @ 19, 60 say replicate(' ', 11)
    @ 19, 72 say "  "
    setcolor("+GR/N")
    @ 10, 24 say "TRANSACTION"
    @ 10, 36 say "File Maintenance"
    setcolor("BG/N")
    @ 11, 27 say "By"
    @ 13, 22 say " "
    @ 13, 34 say "SSN"
    @ 13, 50 say "Accts"
    @ 13, 56 say "Total"
    @ 14,  6 say replicate('', 26)+""+replicate('', 42)
    @ 15, 32 say ""
    @ 15, 34 say " "
    @ 15, 39 say " "
    @ 15, 41 say " "
    @ 16,  6 say "Account Type"
    @ 16, 32 say ""
    @ 17,  7 say "Acct Number"
    @ 17, 32 say ""
    @ 17, 39 say " "
    @ 17, 42 say " "
    @ 18, 32 say ""
    @ 18, 42 say "  "
    @ 18, 50 say "  "
    @ 19, 32 say ""
    @ 19, 53 say "Balance"
    @ 19, 71 say " "
    setcolor("GR/N")
    @ 12, 29 say " "
    @ 15, 42 say ""+replicate('', 10)
    @ 15, 73 say " "
    @ 16, 52 say " "
    @ 16, 73 say " "
    @ 17, 52 say " "
    @ 17, 73 say " "
    @ 18, 52 say replicate(' ', 22)
    setcolor("+G/N")
    @ 12, 30 say "<F3>"
    setcolor("G/N")
    @ 12, 35 say "to Change Order"
    setcolor("N/GR")
    @ 15, 53 say " "
    @ 15, 55 say "eposit"+replicate(' ', 7)
    @ 16, 53 say " "
    @ 16, 55 say "ithdrawl,"
    @ 16, 65 say "ee "
    @ 17, 55 say "djustment  "
    setcolor("+G/GR")
    @ 15, 54 say "D"
    @ 16, 54 say "W"
    @ 16, 64 say "F"
    @ 17, 54 say "A"
    setcolor("+W/GR")
    @ 15, 68 say "[+] "
    @ 16, 68 say "[-] "
    @ 17, 68 say "+,- "
    setcolor("G/GR")
    @ 17, 53 say " "
    @ 17, 66 say "  "

  endcase

  gdbfndxname(n)

return .t.

**********************************************************
* GDBFRECDISP
*   displays current memory dupes for record
**********************************************************
FUNCTION gdbfrecdisp

  * Check for an empty file
  currec = recno()
  goto top

  if eof()
    gdbfchk_addit()
    goto currec
    return .f.
  endif

  goto currec

  do case
  case dbfcnt = 1                            && show record for MASTER
    * ---- DISPLAY Vars in the box "SHOWMAST"
    setcolor("+R/N")
    @ 16, 17 say m->ACCT_TOTAL   picture "9,999,999.99"
    * ---- INPUT   fields in the box "SHOWMAST"
    setcolor("+N/BG")
    @ 10, 17 say m->L_NAME       picture "@!"
    @ 10, 34 say m->F_NAME       picture "@!"
    @ 10, 58 say m->SSN          picture "999-99-9999"
    @ 12, 17 say m->ADDRESS      picture 'XXXXXXXXXXXXXXXXXXXX'
    @ 12, 39 say m->CITY         picture 'XXXXXXXXXXXXXXX'
    @ 12, 55 say m->STATE        picture "@!"
    @ 12, 58 say m->ZIP          picture "99999-9999"
    @ 14, 17 say m->PHONE        picture "(999) 999-9999 XXXXXXXXXXXXXXX"

  case dbfcnt = 2                            && show record for ACCOUNT
    * ---- DISPLAY Vars in the box "SHOWACCO"
    setcolor("+R/N")
    @ 11,  6 say m->L_NAME       picture "@!"
    @ 11, 22 say m->F_NAME       picture "@!"
    @ 11, 37 say m->SSN          picture "999-99-9999"
    @ 11, 60 say m->ACCT_TOTAL   picture "9,999,999.99"
    @ 13, 50 say m->DATEOPENED   picture '@D'
    @ 13, 60 say m->OPEN_BAL     picture "9,999,999.99"
    @ 15, 50 say m->LASTUPDATE   picture '@D'
    @ 17, 19 say m->BALANCE      picture "9,999,999.99"
    @ 17, 46 say m->HIGH_BAL     picture "9,999,999.99"
    @ 17, 60 say m->LOW_BAL      picture "9,999,999.99"
    * ---- INPUT   fields in the box "SHOWACCO"
    setcolor("+N/BG")
    @ 13, 19 say m->ACCTTYPE     picture "@!"
    @ 16, 19 say m->ACCTNUM      picture "99-9999999-9"

  case dbfcnt = 3                            && show record for ACCTTXNS
    * ---- DISPLAY Vars in the box "SHOWACCT"
    setcolor("+R/N")
    @ 13,  7 say m->L_NAME       picture "@!"
    @ 13, 23 say m->F_NAME       picture "@!"
    @ 13, 38 say m->SSN          picture "999-99-9999"
    @ 13, 62 say XACCT_TOTAL     picture "9,999,999.99"
    @ 16, 19 say IIF(M->ACCTTYPE='C','CHECKING',IIF(M->ACCTTYPE='S','SAVINGS','CD')) picture 'XXXXXXXX'
    @ 17, 19 say m->ACCTNUM      picture "99-9999999-9"
    @ 19, 61 say m->BALANCE      picture "9,999,999.99"
    * ---- INPUT   fields in the box "SHOWACCT"
    setcolor("+N/BG")
    @ 15, 40 say m->TXNTYPE      picture "@!"
    @ 17, 40 say m->TXNDATE      picture '@D'
    @ 18, 40 say m->ITEM_NUM     picture 'XXXXXXXXXX'
    @ 19, 40 say m->AMOUNT       picture "9,999,999.99"

  endcase

return .t.

**********************************************************
* GDBFSETS_PROC
*   sets memvar field dupes
**********************************************************
FUNCTION gdbfsets_proc

  * Set field dupes
  do case
  case dbfcnt = 1                          &&  set fields for MASTER
    m->L_NAME       = MASTER->L_NAME
    m->F_NAME       = MASTER->F_NAME
    m->SSN          = MASTER->SSN
    m->ADDRESS      = MASTER->ADDRESS
    m->CITY         = MASTER->CITY
    m->STATE        = MASTER->STATE
    m->ZIP          = MASTER->ZIP
    m->PHONE        = MASTER->PHONE
    m->ACCT_TOTAL   = MASTER->ACCT_TOTAL

  case dbfcnt = 2                          &&  set fields for ACCOUNT
    m->SSN          = ACCOUNT->SSN
    m->ACCTTYPE     = ACCOUNT->ACCTTYPE
    m->DATEOPENED   = ACCOUNT->DATEOPENED
    m->OPEN_BAL     = ACCOUNT->OPEN_BAL
    m->LASTUPDATE   = ACCOUNT->LASTUPDATE
    m->ACCTNUM      = ACCOUNT->ACCTNUM
    m->BALANCE      = ACCOUNT->BALANCE
    m->HIGH_BAL     = ACCOUNT->HIGH_BAL
    m->LOW_BAL      = ACCOUNT->LOW_BAL

  case dbfcnt = 3                          &&  set fields for ACCTTXNS
    XACCT_TOTAL     = M->ACCT_TOTAL
    m->TXNTYPE      = ACCTTXNS->TXNTYPE
    m->ACCTNUM      = ACCTTXNS->ACCTNUM
    m->TXNDATE      = ACCTTXNS->TXNDATE
    m->ITEM_NUM     = ACCTTXNS->ITEM_NUM
    m->AMOUNT       = ACCTTXNS->AMOUNT
    m->SSN          = ACCTTXNS->SSN

  endcase

return .t.

**********************************************************
* GDBFINIT_VARS
*   initialize memvars for field dupes
**********************************************************
FUNCTION gdbfinit_vars

  * Initialize memvar duplicates for all fields at this level
  do case
  case dbfcnt = 1                            &&  initalize fields for MASTER
    m->L_NAME       = replicate(" ", 15)
    m->F_NAME       = replicate(" ", 10)
    m->SSN          = replicate(" ", 11)
    m->ADDRESS      = replicate(" ", 20)
    m->CITY         = replicate(" ", 15)
    m->STATE        = replicate(" ", 2)
    m->ZIP          = replicate(" ", 10)
    m->PHONE        = replicate(" ", 30)
    m->ACCT_TOTAL   = 0.0

  case dbfcnt = 2                            &&  initalize fields for ACCOUNT
    m->SSN          = MASTER->SSN
    m->ACCTTYPE     = "C"
    m->DATEOPENED   = DATE()
    m->OPEN_BAL     = 0.0
    m->LASTUPDATE   = DATE()
    m->ACCTNUM      = replicate(" ", 12)
    m->BALANCE      = 0.0
    m->HIGH_BAL     = 0.0
    m->LOW_BAL      = 0.0

    * also initalize field dupes for ACCTTXNS for calculations
    XACCT_TOTAL     = M->ACCT_TOTAL
    m->TXNTYPE      = "D"
    XACCTTYPE       = replicate(" ", 8)
    m->TXNDATE      = ctod("  /  /  ")
    m->ITEM_NUM     = replicate(" ", 10)
    m->AMOUNT       = 0.0

  case dbfcnt = 3                            &&  initalize fields for ACCTTXNS
    XACCT_TOTAL     = M->ACCT_TOTAL
    m->TXNTYPE      = "D"
    XACCTTYPE       = replicate(" ", 8)
    m->ACCTNUM      = ACCOUNT->ACCTNUM
    m->TXNDATE      = ctod("  /  /  ")
    m->ITEM_NUM     = replicate(" ", 10)
    m->AMOUNT       = 0.0
    m->SSN          = ACCOUNT->SSN

  endcase

return .t.

**********************************************************
* GDBFPICKREC
*   show PICK-filename pick box
**********************************************************
FUNCTION gdbfpickrec
private  saverec, xkey, lastcolor, currec, seekkey

* WARNING: With release of version 1.1, ProUI uses the DBEDIT function
*          to handle scrolling pick lists. Unlike the earlier version
*          which attempted its own record counting, and was subject
*          to missing changes made by other users in a multi-user
*          environment, this method scrolls through live data records.
*          When a filter is in use, as with a child database, there may
*          be some lag time as Clipper processes through the file.
*                                       - Rik Hess

  * Check for an empty file
  currec = recno()
  goto top

  if eof()
    gdbfchk_addit()
    goto currec
    return .f.
  endif

  goto currec

  seekkey = ""
  goto top

  if dbfcnt <> 1 .and. !empty(dbfilt)
    seek &dbfilt

    if eof()
      goto currec
      return .f.
    endif

    seekkey = dbfiltv
  endif

  old_help  = help_name
  help_name = "PICKIT"
  lastcolor = setcolor()

  * set up PICK window
  do case
  case dbfcnt = 1                      && pop the pick window for MASTER
    * -------------------- Drawing Box : "PICKMAST"
    v_PickMast = savescreen(9, 17, 21, 60)
    outliner(9, 17, 20, 58, "ͻȺ ", "+BG/B")
    setcolor("+BG/N")
    scroll(10, 18, 19, 57, 0)
    shadowbox(9, 17, 20, 58, "N/N")
    setcolor("+BG/B")
    @ 10, 18 say "  LAST NAME"+replicate(' ', 6)+"FIRST"+replicate(' ', 6)+"SSN"+replicate(' ', 9)
    @ 11, 18 say replicate('', 40)
    private fld1names[1]
    fld1names[1] = '" " + L_NAME + " " + F_NAME + " " + SSN'

    setcolor("+BG/N, +R/BG")

    dbedit(11, 18, 19, 56, fld1names, "db_pick_key", "", "","")

    restscreen(9, 17, 21, 60, v_PickMast)
    v_PickMast = ''

  case dbfcnt = 2                      && pop the pick window for ACCOUNT
    * -------------------- Drawing Box : "PICKACCO"
    v_PickAcco = savescreen(12, 28, 23, 77)
    outliner(12, 28, 22, 75, "ͻȺ ", "+BG/B")
    setcolor("+BG/N")
    scroll(13, 29, 21, 74, 0)
    shadowbox(12, 28, 22, 75, "N/N")
    @ 15, 29 say replicate(' ', 46)
    @ 16, 29 say replicate(' ', 46)
    @ 17, 29 say replicate(' ', 46)
    @ 18, 29 say replicate(' ', 46)
    @ 19, 29 say replicate(' ', 46)
    @ 20, 29 say replicate(' ', 46)
    @ 21, 29 say replicate(' ', 46)
    setcolor("+BG/B")
    @ 13, 29 say "Account#   Type   Balance    Updated  Opened  "
    @ 14, 29 say replicate('', 46)
    private fld2names[1]
    fld2names[1] = 'ACCTNUM + " " + ACCTTYPE + " " + str(BALANCE, 10, 2) + "  " + dtoc(LASTUPDATE) + "  " + dtoc(DATEOPENED)'

    setcolor("+BG/N")

    dbedit(14, 29, 21, 73, fld2names, "db_pick_key", "", "","")

    restscreen(12, 28, 23, 77, v_PickAcco)
    v_PickAcco = ''

  case dbfcnt = 3                      && pop the pick window for ACCTTXNS
    * -------------------- Drawing Box : "PICKACCT"
    v_PickAcct = savescreen(12, 0, 24, 42)
    outliner(12, 0, 23, 40, "ͻȺ ", "+BG/B")
    setcolor("+BG/N")
    scroll(13, 1, 22, 39, 0)
    shadowbox(12, 0, 23, 40, "N/N")
    setcolor("+BG/B")
    @ 13,  1 say " Type  Date   Item#"+replicate(' ', 11)+"Amount   "
    @ 14,  1 say replicate('', 39)
    private fld3names[1]
    fld3names[1] = '" " + iif(TXNTYPE="D","Dep",iif(TXNTYPE="W","Wdl",iif(TXNTYPE="F","Fee","Adj"))) + " " + dtoc(TXNDATE) + " " + ITEM_NUM + " " + str(AMOUNT, 10, 2) + "   "'

    setcolor("+BG/N")

    dbedit(14, 1, 22, 39, fld3names, "db_pick_key", "", "","")

    restscreen(12, 0, 24, 42, v_PickAcct)
    v_PickAcct = ''

  endcase

  setcolor(lastcolor)
  help_name = old_help

  if recno() <> currec
    gdbfsets_proc()
    gdbfrecdisp()
  endif

return .t.

**********************************************************
* GDBFINDXSETUP
*   set up arrays for index order selection
**********************************************************
FUNCTION gdbfindxsetup

  nidxmast   = 1
  cindex1[1] = "Last Name" + replicate(" ", 13)
  cindex1[2] = "Social Security Number"
  cindex1[3] = "Sound-Alike Last Names"

  nidxacco   = 1
  cindex2[1] = "Account Type And Number"
  cindex2[2] = "Current Balance" + replicate(" ", 8)
  cindex2[3] = "Account Number" + replicate(" ", 9)

  nidxacct   = 1
  cindex3[1] = "Transactions By Date"
  cindex3[2] = "Transaction Amount" + replicate(" ", 2)

return .t.

**********************************************************
* GDBFCHGINDX
*   change to alternate index
**********************************************************
FUNCTION gdbfchgindx
private  i, tr, rc, br, lc, thisbuff, lastcolor, ndxx

  old_help  = help_name
  help_name = "chgindx"
  thisbuff  = ''

  * setup the ACHOICE window - top & bottom rows, left & right cols
  do case
  case dbfcnt = 1
    tr = 11       && set index window for MASTER
    br = 13
    lc = 28
    rc = 49
    lastcolor = setcolor()
    thisbuff  = savescreen(tr - 3, lc - 1, br + 2, rc + 3)
    achbox(tr, lc, br, rc)
    ndxx = achoice(tr, lc, br, rc, cindex1, "", "", nidxmast, nidxmast)

    if ndxx <> 0
      nidxmast = ndxx
      set order to nidxmast
    endif

    setcolor(lastcolor)
    restscreen(tr - 3, lc - 1, br + 2, rc + 3, thisbuff)
    gdbfndxname(dbfcnt)

  case dbfcnt = 2
    tr = 11       && set index window for ACCOUNT
    br = 13
    lc = 28
    rc = 50
    lastcolor = setcolor()
    thisbuff  = savescreen(tr - 3, lc - 1, br + 2, rc + 3)
    achbox(tr, lc, br, rc)
    ndxx = achoice(tr, lc, br, rc, cindex2, "", "", nidxacco, nidxacco)

    if ndxx <> 0
      nidxacco = ndxx
      set order to nidxacco
    endif

    setcolor(lastcolor)
    restscreen(tr - 3, lc - 1, br + 2, rc + 3, thisbuff)
    gdbfndxname(dbfcnt)

  case dbfcnt = 3
    tr = 11       && set index window for ACCTTXNS
    br = 12
    lc = 29
    rc = 48
    lastcolor = setcolor()
    thisbuff  = savescreen(tr - 3, lc - 1, br + 2, rc + 3)
    achbox(tr, lc, br, rc)
    ndxx = achoice(tr, lc, br, rc, cindex3, "", "", nidxacct, nidxacct)

    if ndxx <> 0
      nidxacct = ndxx
      set order to nidxacct
    endif

    setcolor(lastcolor)
    restscreen(tr - 3, lc - 1, br + 2, rc + 3, thisbuff)
    gdbfndxname(dbfcnt)

  endcase

  help_name = old_help

return .t.

**********************************************************
* GDBFNDXNAME(dbfcnt)
*   set index name
**********************************************************
FUNCTION gdbfndxname
param    n
private  lastcolor

  lastcolor = setcolor()

  do case
  case n = 1                       && set control indexes for MASTER
    setcolor("+BG/N")
    @  7, 37 say cindex1[nidxmast]

  case n = 2                       && set control indexes for ACCOUNT
    setcolor("+BG/N")
    @  9, 38 say cindex2[nidxacco]

  case n = 3                       && set control indexes for ACCTTXNS
    setcolor("+BG/N")
    @ 11, 30 say cindex3[nidxacct]

  endcase

  setcolor(lastcolor)

return .t.

**********************************************************
* GDBFLOCK_TEST
*   This function locks all lower level dbf recs
*   before proceeding.
**********************************************************
FUNCTION gdbflock_test
private  fil

  fil = alias()

  if dbfcnt >= 1
    select MASTER

    if !rec_lock(30, .t., 'Record on MASTER is in use. Wait? (Y/N)')
      gdbfunlk_recs()
      select &fil
      return .f.
    endif

  endif

  if dbfcnt >= 2
    select ACCOUNT

    if !rec_lock(30, .t., 'Record on ACCOUNT is in use. Wait? (Y/N)')
      gdbfunlk_recs()
      select &fil
      return .f.
    endif

  endif

  if dbfcnt >= 3
    select ACCTTXNS

    if !rec_lock(30, .t., 'Record on ACCTTXNS is in use. Wait? (Y/N)')
      gdbfunlk_recs()
      select &fil
      return .f.
    endif

  endif

return .t.

**********************************************************
* GDBFUNLK_RECS
*   this procedure will unlock records in all active dbfs in this screen.
**********************************************************
FUNCTION gdbfunlk_recs

  unlock all

return .t.

**********************************************************
* CKADJAMT.PRG - confirms the AMOUNT to be positive on an Adjustment
* Hand coded routine to show the field post-process capability of ProUI.
*  Author : Rik Hess
*  Copyright 1990, Rik Hess; Released to Public Domain
**********************************************************
FUNCTION ckadjamt
param    amt
private  oldcolor, oldscreen, tr, lf, br, rt, confirm, ok

  clear gets
  ok = .t.

  if m->TXNTYPE = "A" .and. amt <> 0
    tr = 9
    lf = 15
    br = tr + 5
    rt = lf + 42

    oldscreen = savescreen(tr, lf, br + 1, rt + 2)
    oldcolor  = setcolor('+rb/N')

    @ tr, lf, br, rt box "ͻȺ "
    shadowbox(tr, lf, br, rt, 'rb/N')

    @ tr + 1, lf + 2 say "Adjustment Amount was entered Positive."
    @ tr + 2, lf + 2 say "Confirm that this amount is to be Added"
    @ tr + 3, lf + 2 say "   to the Account Balance:"
    @ tr + 4, lf + 2 say "  ('Y'es, 'N'egative, 'X' to re-enter)"

    clear typeahead
    confirm = "Y"
    @ tr + 3, lf + 30 get confirm picture "!" valid confirm $ "YNX"

    read

    do case
    case confirm = "N"
      amt = amt * -1
      keyboard chr(KB_cC)

    case confirm = "X"
      amt = 0
      ok  = .f.

    otherwise
      keyboard chr(KB_cC)

    endcase

    setcolor(oldcolor)
    restscreen(tr, lf, br + 1, rt + 2, oldscreen)
  endif

return ok



                    ***  END OF PROC : GDBF  ***
