**********************************************************************
*--- Header ---------------------------------------------------------------
*    Program . DMSERROR.PRG
*    Version . 1.00
*    Date .... September 15, 1988
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Runtime error system to replace Nantucket's ERRORSYS.PRG
*    Notice .. Copyright 1988, Data Management Systems. All Rights Reserved
*--------------------------------------------------------------------------
*    Minor modifications added to conform to my standards - Rik Hess
*
*--- Ops Notes ------------------------------------------------------------
*
*    Functions included:
*         EXPR_ERROR()   expression error
*         UNDEF_ERROR()  undefined error
*         MISC_ERROR()   miscellaneous error
*         OPEN_ERROR()   open errors
*         DB_ERROR()     database error
*         PRINT_ERROR()  printer error
*         ETOC()         returns a character expression for any type of input 
*                         (numeric, date, character, or logical) expression
*         DMSOOPS()      standard "dialog" box error reporting routine,
*                         also written by Data Management Systems
*
*    The following external routines are also required:
*         EXXTEND.OBJ    C routines that return the status of some SET
*                         commands. Written by J. Scott Emerich.
*         PRT_SCRN.OBJ   CALLable print screen routine by Ray Love
*
*    Parameters passed by Clipper to error functions:
*         _NAME     C    Procedure name in which error occured
*         _LINE     N    Line number (in _NAME) at which error occured
*         _INFO     C    Type of error encountered
*         _MODEL    C    Fragment of source code that caused error
*         _1        Any  Value supplied to the failed operation
*         _2        Any  Value supplied to the failed operation
*         _3        Any  Value supplied to the failed operation
*
*
*    Private memvars used by DMSERROR, requiring functions in EXXTEND.OBJ
*         CURR_CON  L    GETCONSOLE()
*                        .T. = CONSOLE is SET ON
*                        .F. = CONSOLE is SET OFF
*         CURR_DEV  L    GETDEVICE_()
*                        .T. = DEVICE = PRINT
*                        .F. = DEVICE = SCREEN
*         CURR_PRN  L    GETPRINT()
*                        .T. = PRINT is SET ON
*                        .F. = PRINT is SET OFF
*
*    Memvars used by DMSOOPS, set in DMSERROR
*         OOPS_TITL      C    Title to display on top line of box
*         INSTRUCTION    C    Instructions to display on bottom line of box
*         OOPS_MSG[]     C    Message lines to display in box
*         OOPS_RESP[]    C    Valid responses to instruction line prompts
*         OOPS_ACTION    C    Validated response returned from DMSOOPS
*         OOPS_SCRN      C    Screen saved before DMSOOPS is called
*         REST_SCRN      L    Flag to have DMSOOPS restore screen before returning
*--------------------------------------------------------------------------

**********************************************************************
* EXPR_ERROR()
*    expr_error(_name, _line, _info, _model, _1, _2, _3)
**********************************************************************
FUNCTION expr_error
parameters _name, _line, _info, _model, _1, _2, _3
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action

* Divide by zero error
if m->_info = "zero divide"
  if "%" $ m->_model                    && error from modulus operation (%)
    return m->_1                       && return the dividend
  else
    return 0                           && return 0
  endif
endif

set_to_screen()

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Expression"
rest_scrn    = .f.
instruction  = "Print Screen For Programmer  (Y/N)"
oops_scrn    = ' '
oops_action  = ' '

declare oops_resp[2]
oops_resp[1] = "Y"
oops_resp[2] = "N"

declare oops_msg[14]
oops_msg[1]  = "An error has occured while running this program."
oops_msg[2]  = "Following is information that the programmer will"
oops_msg[3]  = "require to correct this problem:"
oops_msg[4]  = " "
oops_msg[5]  = "     Procedure  = " + _name
oops_msg[6]  = "     Line #     = " + Ltrim(Str(_line))
oops_msg[7]  = "     Error Type = " + _info
oops_msg[8]  = "     Expression = " + _model
oops_msg[9]  = "         _1 (" + type("_1") + ") = " + if(type("_1") <> "U", etoc(_1), ' ')
oops_msg[10] = "         _2 (" + type("_2") + ") = " + if(type("_2") <> "U", etoc(_2), ' ')
oops_msg[11] = "         _3 (" + type("_3") + ") = " + if(type("_3") <> "U", etoc(_3), ' ')
oops_msg[12] = " "
oops_msg[13] = "This program cannot continue, though a printout of"
oops_msg[14] = "this screen should be saved for the programmer."

dmsoops()

* Print screen if desired
if oops_action = "Y"
  prterrscrn()
endif

quit

return .t.

**********************************************************************
* UNDEF_ERROR()
*    undef_error(_name, _line, _info, _model, _1)
**********************************************************************
FUNCTION undef_error
parameters _name, _line, _info, _model, _1
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action

set_to_screen()

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Undefined"
rest_scrn    = .F.
instruction  = "Print Screen For Programmer  (Y/N)"
oops_scrn    = ' '
oops_action  = ' '

declare oops_resp[2]
oops_resp[1] = "Y"
oops_resp[2] = "N"

declare oops_msg[12]
oops_msg[1]  = "An error has occured while running this program."
oops_msg[2]  = "Following is information that the programmer will"
oops_msg[3]  = "require to correct this problem:"
oops_msg[4]  = " "
oops_msg[5]  = "     Procedure  = " + _name
oops_msg[6]  = "     Line #     = " + Ltrim(Str(_line))
oops_msg[7]  = "     Error Type = " + _info
oops_msg[8]  = "     Expression = " + _model
oops_msg[9]  = "         _1 (" + TYPE("_1") + ") = " + IF(TYPE("_1") <> "U", etoc(_1), ' ')
oops_msg[10] = " "
oops_msg[11] = "This program cannot continue, though a printout of"
oops_msg[12] = "this screen should be saved for the programmer."

dmsoops()

* Print screen if desired
if oops_action = "Y"
  prterrscrn()
endif

quit

return .t.

**********************************************************************
* MISC_ERROR()
*   misc_error(_name, _line, _info, _model)
**********************************************************************
FUNCTION misc_error
parameters _name, _line, _info, _model
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action

set_to_screen()

if _info = "type mismatch"
   _info = _info + " in field REPLACE"
endif

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Miscellaneous"
rest_scrn    = .F.
instruction  = "Print Screen For Programmer  (Y/N)"
oops_scrn    = ' '
oops_action  = ' '

declare oops_resp[2]
oops_resp[1] = "Y"
oops_resp[2] = "N"

DECLARE oops_msg[10]
oops_msg[1]  = "An error has occured while running this program."
oops_msg[2]  = "Following is information that the programmer will"
oops_msg[3]  = "require to correct this problem:"
oops_msg[4]  = " "
oops_msg[5]  = "     Procedure  = " + _name
oops_msg[6]  = "     Line #     = " + Ltrim(Str(_line))
oops_msg[7]  = "     Error Type = " + _info
oops_msg[8]  = " "
oops_msg[9]  = "This program cannot continue, though a printout of"
oops_msg[10] = "this screen should be saved for the programmer."

dmsoops()

* Print screen if desired
if oops_action = "Y"
  prterrscrn()
endif

quit

return .t.

**********************************************************************
* OPEN_ERROR()
*   open_error(_name, _line, _info, _model, _1)
**********************************************************************
FUNCTION open_error
parameters _name, _line, _info, _model, _1
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action
private curr_dev, curr_prn, curr_con   && private to this function

* Allow local handling of network error
if Neterr() .and. _model == "USE"
   return .f.
end

* Open errors could be recovered, save current output devices
curr_dev = getdevice_()
curr_prn = getprint()
curr_con = getconsole()

set_to_screen()

* Run DMSOOPS first time, try to recover

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Open"
instruction  = "R = Retry   P = Print Screen and Quit   Q = Quit"
oops_action  = ' '

DECLARE oops_resp[3]
oops_resp[1] = "R"
oops_resp[2] = "P"
oops_resp[3] = "Q"

DECLARE oops_msg[14]
oops_msg[1]  = "An Open Error has occured. Some causes of this are:"
oops_msg[2]  = "     A file is missing"
oops_msg[3]  = "     A disk drive door is open"
oops_msg[4]  = "     A diskette is not in place"
oops_msg[5]  = "     A serial printer is not responding"
oops_msg[6]  = ""
oops_msg[7]  = "If it helps, the computer is trying to:"
oops_msg[8]  = ""
oops_msg[9]  = "    " + _model + " " + if(type("_1") <> "U", etoc(_1), ' ')
oops_msg[10] = ""
oops_msg[11] = "If the problem can be corrected, please do so and"
oops_msg[12] = "press R (Retry). Otherwise this program cannot"
oops_msg[13] = "continue, though a printout of this screen should be"
oops_msg[14] = "saved for the programmer."

dmsoops()

do case
case oops_action = "R"                 && retry (recover)
  * Reset output devices first
  if curr_dev
    set device to print
  endif
  if curr_prn
    set print on
  endif
  if .not. curr_con
    set console off
  endif
  return .t.                           && .t. = retry operation
otherwise                              && quit
  quit
endcase

* Show actual error message, print screens - OOPS_ACTION = "P"

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Open"
rest_scrn    = .F.
instruction  = "Runtime Error - Open"
oops_scrn    = ' '
oops_action  = ' '

declare oops_msg[12]
oops_msg[1]  = "An error has occured while running this program."
oops_msg[2]  = "Following is information that the programmer will"
oops_msg[3]  = "require to correct this problem:"
oops_msg[4]  = " "
oops_msg[5]  = "     Procedure  = " + _name
oops_msg[6]  = "     Line #     = " + Ltrim(Str(_line))
oops_msg[7]  = "     Error Type = " + _info
oops_msg[8]  = "     Expression = " + _model
oops_msg[9]  = "         _1 (" + TYPE("_1") + ") = " + IF(TYPE("_1") <> "U", etoc(_1), ' ')
oops_msg[10] = " "
oops_msg[11] = "This program cannot continue, though a printout of"
oops_msg[12] = "this screen should be saved for the programmer."

keyboard chr(13)                       && simulate key press in OOPS
dmsoops()

prterrscrn()

quit

return .t.

**********************************************************************
* DB_ERROR()
*   db_error(_name, _line, _info)
**********************************************************************
FUNCTION db_error
parameters _name, _line, _info
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action

set_to_screen()

* Setup DMSOOPS parameters & memvars
oops_titl    = "Runtime Error - Database"
rest_scrn    = .F.
instruction  = "Print Screen For Programmer  (Y/N)"
oops_scrn    = ' '
oops_action  = ' '

declare oops_resp[2]
oops_resp[1] = "Y"
oops_resp[2] = "N"

declare oops_msg[10]
oops_msg[1]  = "An error has occured while running this program."
oops_msg[2]  = "Following is information that the programmer will"
oops_msg[3]  = "require to correct this problem:"
oops_msg[4]  = " "
oops_msg[5]  = "     Procedure  = " + _name
oops_msg[6]  = "     Line #     = " + Ltrim(Str(_line))
oops_msg[7]  = "     Error Type = " + _info
oops_msg[8]  = " "
oops_msg[9]  = "This program cannot continue, though a printout of"
oops_msg[10] = "this screen should be saved for the programmer."

dmsoops()

* Print screen if desired
if oops_action = "Y"
  prterrscrn()
endif

quit

return .t.

**********************************************************************
* PRINT_ERROR()
*   print_error(_name, _line)
**********************************************************************
FUNCTION print_error
parameters _name, _line
private oops_titl, rest_scrn, instruction, oops_scrn, oops_action
private curr_dev, curr_prn, curr_con   && private to this function

* Save current output devices
curr_dev = getdevice_()
curr_prn = getprint()
curr_con = getconsole()

set_to_screen()

* Setup DMSOOPS parameters & memvars
oops_titl    = "Printer Error"
instruction  = "Retry Printout (Y/N)"
oops_action  = ' '

declare oops_resp[2]
oops_resp[1] = "Y"
oops_resp[2] = "N"

declare oops_msg[11]
oops_msg[1]  = "The printer does not respond. Any of the following"
oops_msg[2]  = "may be causing this problem:"
oops_msg[3]  = " "
oops_msg[4]  = "     The power is off"
oops_msg[5]  = "     It is out of paper"
oops_msg[6]  = "     The Online or Select light is not on"
oops_msg[7]  = "     The cable is disconnected at the printer"
oops_msg[8]  = "      or the computer"
oops_msg[9]  = " "
oops_msg[10] = "If you can correct the problem, do so. Otherwise"
oops_msg[11] = "the printout will be aborted."

dmsoops()

if oops_action = "Y"                   && retry
  * restore output devices first
  if curr_dev
    set device to print
  endif
  if curr_prn
    set print on
  endif
  if .not. curr_con
    set console off
  endif
  return(.t.)                          && .t. = retry failed print operation
endif

return .f.

**********************************************************************
* ETOC()
*   etoc(expression)
*   any expression to character conversion
**********************************************************************
FUNCTION etoc
parameters expression
private expc                           && private to this function

do case
case type("expression") == "C"         && character
  expc = expression
case type("expression") == "D"         && date
  expc = Dtoc(expression)
case type("expression") == "L"         && logical
  if expression
    expc = ".T."
  else
    expc = ".F."
  endif
case type("expression") == "N"         && numeric
  expc = ltrim(str(expression))        && decimal places not important
case type("expression") == "M"         && memo field
  expc = "<Memo field>"
case type("expression") == "A"         && array
  expc = "<array>"
case type("expression") == "U"         && undefined
  expc = "<undefined>"
case type("expression") == "UE"        && syntax error
  expc = "<syntax error>"
case type("expression") == "UI"        && indeterminate error
  expc = "<indeterminate error>"
endcase

return expc


*--- Header ---------------------------------------------------------------
*    Function. DMSOOPS.PRG
*    Version . 1.10
*    Date .... August 18, 1988
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... Displays an error message box in custom or default
*               configuration
*    Notice .. Copyright 1988, Data Management Systems. All Rights Reserved
*--------------------------------------------------------------------------
*    Modifications added and many options deleted to work with ProUI easily.
*        Rik Hess
*
*--- Ops Notes ------------------------------------------------------------
*
*    Requires the following external routines:
*         EXXTEND.OBJ    C routines that return the status of some SET
*                         commands. Written by J. Scott Emerich.
*    Syntax - complete
*         DMSOOPS([oops_titl], [frame], [instruction], [location], ;
*                 [rest_scrn], [explode, [implode]], [shad_show], ;
*                 [shad_char], [shad_side]])
*
*    Syntax - default
*         DMSOOPS()
*
*    Parameters
*         oops_titl          C    title to display on top line of box
*                              default = "OOPS"
*         frame          N    0 = no characters in border
*                             1 = single line box
*                             2 = double line box
*                             3 = double line top/bottom, single line sides
*                             4 = single line top/bottom, double line sides
*                        C    custom frame, include all eight characters as
*                              outlined for @...BOX command
*                              default = 1
*         instruct       C    instructions to display on bottom line of box
*                              default = "Press Any Key to Continue"
*         location       C    UR = upper right corner of screen
*                             UL = upper left corner of screen
*                             LL = lower left corner of screen
*                             LR = lower right corner of screen
*                             C  = center of screen
*                              default = C
*         rest_scrn      L    .T. = restore screen upon RETURN to calling .PRG
*                             .F. = screen not restored
*                              default = .T.
*         explode        L    .T. = exploding box
*                             .F. = no explosion
*                              default = .T.
*         implode        L    .T. = implode screen before restore
*                             .F. = no implosion
*                              default = .T.
*                              must explode box to implode on restore
*         shad_show      L    .T. = shadow
*                             .F. = no shadow
*                              default = .T.
*
*    Public memvars
*         OOPS_MSG[]     C    each line of message to display in box
*         OOPS_RESP[]    C    valid responses to instruction line prompts
*         OOPS_ACTION    C    validated response returned to calling prg
*         M_COOPSFR    * C    color for box frame
*         M_COOPSTIT   * C    color for oops_titl
*         M_COOPSTXT   * C    color for messages (text)
*         M_COOPSINS   * C    color for instruction
*         M_COOPSSHD   * C    color for shadow
*         OOPS_SCRN    * C    screen saved prior to calling OOPS.
*                      *      if these memvars are not initialized by the
*                              calling prg, they will become PRIVATE
*
*    Private memvars
*         OOPS_TITLE     C    title parameter
*         OOPS_FRAME     C    frame for box derived from frame parameter
*         OOPS_INS       C    instruction parameter
*         OOPS_SCRN      C    screen saved prior to calling OOPS. PRIVATE if
*                              not initialized by calling .PRG
*         OOPS_LEN       N    length of box
*         OOPS_TOP       N    top row of box
*         OOPS_LEFT      N    left column of box
*         OOPS_BOTT      N    bottom row of box
*         OOPS_RIGHT     N    right column of box
*         EXP_TOP        N    top row of exploding box
*         EXP_LEFT       N    left column of exploding box
*         EXP_BOTT       N    bottom row of exploding box
*         EXP_RIGHT      N    right column of exploding box
*         LIMIT_TOP      N    lowest value allowed for OOPS_TOP
*         LIMIT_LEFT     N    lowest value allowed for OOPS_LEFT
*         LIMIT_BOTT     N    highest value allowed for OOPS_BOTT
*         LIMIT_RIGHT    N    highest value allowed for OOPS_RIGHT
*         MSG[]          C    OOPS_MSG[] used in this routine
*         MSG_NO         N    # of messages (LEN(OOPS_MSG))
*         MSG_LEN        N    length of messages
*         EXP_SCRN[]     C    screens of each step of exploding box
*         EXP_NO         N    # of steps in exploding box
*         T_EXP_NO       N    temp used to find EXP_NO
*         COL_POS        N    column position for @...SAY
*         ROW_POS        N    row position for @...SAY
*         ADJUST         N    adjustment factor for COL_POS
*         CURR_COLOR     C    current SETCOLOR() before calling DMSOOPS
*         CURR_ROW       N    current cursor row before calling DMSOOPS
*         CURR_COL       N    current cursor column before calling DMSOOPS
*         CURR_CURSOR    L    current cursor on/off state before calling DMSOOPS
*         VALID_RESP     N    flag to validate OOPS_RESP[]
*         ACTION         N    INKEY(0) for OOPS_RESP[] validation
*         X              N    FOR...NEXT memvar
*
*    Setup example - custom
*
*         DECLARE OOPS_MSG[2]
*         OOPS_MSG[1] = "Printer is not ready. Make sure"
*         OOPS_MSG[2] = "it is on-line and has paper"
*         DECLARE OOPS_RESP[2]
*         OOPS_RESP[1] = "R"
*         OOPS_RESP[2] = "A"
*         OOPS_ACTION = ' '
*         OOPS("Printer Not Ready", 1, "R = Retry   A = Abort", "UL", .T., .T., .T., .T., "", "R")
*
*              [ Printer Not Ready ]Ŀ
*                                               
*               Printer is not ready. Make sure 
*               it is on-line and has paper     
*                                               
*              [ R = Retry   A = Abort ]ٱ
*               
*
*    Setup example - default
*         DECLARE OOPS_MSG[2]
*         OOPS_MSG[1] = "This customer has sales"
*         OOPS_MSG[2] = "Cannot delete at this time"
*         OOPS()
*
*              [ OOPS ]Ŀ
*                                           
*               This customer has sales     
*               Cannot delete at this time  
*                                           
*              [ Press Any Key to Continue ]
*
*    Misc.
*         All message lengths need not be the same. Widest message
*         is found and spaces added to shorter messages.
*
*--------------------------------------------------------------------------
*
*--- Updates --------------------------------------------------------------
*    09/15/88  Added check for mono systems when setting default colors
*    v.1.10    Added implode parameter & code
*              Added ASCAN() function to validate OOPS_RESP[]
*              Added check for cursor on/off state, restores original state
*               on exit (function GETCURS() from EXXTEND.OBJ)
*              Added save of cursor position, restore on exit
*              Corrected bug in explosion code. Exploding box was sometimes
*               larger than final display box.
*--------------------------------------------------------------------------

**********************************************************************
* DMSOOPS()
*
**********************************************************************
FUNCTION dmsoops

if pcount() <> 0                       && check if parameters passed
  parameters oops_titl, frame, instruct, location, rest_scrn, ;
             explode, implode, shad_show
endif

private oops_title, oops_frame, oops_ins, oops_len
private oops_top, oops_left, oops_bott, oops_right
private msg_no, msg_len, row_pos, col_pos, adjust
private exp_top, exp_left, exp_bott, exp_right
private exp_no, t_exp_no, exp_scrn
private curr_color, curr_row, curr_col, curr_cursor
private x, valid_resp, action
private limit_top, limit_left, limit_bott, limit_right

* Parameter validation & default assignments
if type("oops_titl")     = "U"
  oops_titl = "OOPS"
endif
if type("frame")     = "U"
  frame = 1
endif
if type("location")  = "U"
  location = "C"
endif
if type("rest_scrn") = "U"
  rest_scrn = .t.
endif
if type("explode")   = "U"
  explode = .t.
endif
if type("implode")   = "U"
  implode = .t.
endif
if .not. explode
  implode = .f.                        && cannot implode if not exploding
endif
if type("shad_show") = "U"
  shad_show = .t.
endif

* Check other memvars assigned by calling .prg, assign defaults
if type("oops_resp") = "A"           && check if it's an array
  valid_resp = .t.
else
  valid_resp = .f.
endif
if type("instruct")  = "U"
  instruct = "Press Any Key to Continue"
  valid_resp = .f.
endif

if type("m_coopsfr") = "U"                       && box frame color
  m_coopsfr = if(iscolor(), "+W/R", "+W/N")      && hi white on black
endif
if type("m_coopstit") = "U"                      && box title color
  m_coopstit = if(iscolor(), "+W/R", "+W/N")      && red on black or black on white
endif
if type("m_coopstxt") = "U"                      && box text (messages) color
  m_coopstxt = if(iscolor(), "+W/R", "W/N")      && white on red or black
endif
if type ("m_coopsins") = "U"                     && box instructions color
  m_coopsins = if(iscolor(), "+GR/R", "N/W")     && yellow on red or black on white
endif
if type ("m_coopsshd") = "U"                     && shadow color
  m_coopsshd = if(iscolor(), "R/N", "W/N")       && red or white on black
endif


* Setup for display
curr_color  = setcolor()     && save color setting from calling .prg
curr_row    = row()          && save current row position from calling .prg
curr_col    = col()          && save current column position from calling .prg
curr_cursor = getcurs()      && save cursor on/off state - routine from GETSTAT.OBJ
save screen to oops_scrn     && save screen from calling .prg
set cursor off

* Initialize private memvars
limit_top   = 4
limit_left  = 1
limit_bott  = 22
limit_right = 79
action      = 0
x           = 0

* Assign private memvars from parameters passed
oops_title  = ' ' + oops_titl + ' '
oops_ins    = ' ' + instruct + ' '

msg_no      = len(oops_msg)
declare msg[msg_no]
for x = 1 to msg_no
  msg[x] = oops_msg[x]
next

if type("frame") = "N"                 && passed a numeric choice for frame
  do case
  case frame = 0
    oops_frame = "         "
  case frame = 2
    oops_frame = "ͻȺ "
  case frame = 3
    oops_frame = "͸Գ "
  case frame = 4
    oops_frame = "ķӺ "
  otherwise
    oops_frame = "Ŀ "            && frame = 1 or not 0, 2, 3, 4
  endcase
else
  oops_frame = frame                    && char string was passed
endif

* find msg_len
msg_len = len(msg[1])
for x = 1 to msg_no                     && make sure all messages are same len
  if len(msg[x]) > msg_len
    msg_len = len(msg[x])
  endif
next

* make all msg[] the same length, add spaces to end of each to match
for x = 1 to msg_no
  msg[x] = msg[x] + replicate(' ', msg_len - len(msg[x]))
next

* make sure msg_len >= length of oops_title & oops_ins
if msg_len < len(oops_title)
  msg_len = len(oops_title)
endif
if msg_len < len(oops_ins)
  msg_len = len(oops_ins)
endif

* pad both ends of all msg[] with spaces if msg_len has changed
do while .t.
  if len(msg[1]) < msg_len
    for x = 1 to msg_no
      msg[x] = ' ' + msg[x] + ' '
    next
  else
    exit
  endif
enddo
msg_len   = len(msg[1])
oops_len  = msg_len + 4                 && " " + " "

oops_top  = 12 - int((msg_no + 4) / 2)
oops_left = 40
if (oops_len / 2) <> int(oops_len / 2)
  oops_left = oops_left - (int(oops_len / 2) + 1)
else
  oops_left = oops_left - (oops_len / 2)
endif
oops_bott  = oops_top + 1 + msg_no + 2
oops_right = oops_left + oops_len - 1

* Begin display
setcolor(m_coopsfr)
if explode
  exp_top   = round((oops_bott  - oops_top)  / 2 + (oops_top  - 1), 0)
  exp_left  = round((oops_right - oops_left) / 2 + (oops_left - 1), 0)
  exp_bott  = round(exp_top  + 1, 0)
  exp_right = round(exp_left + 1, 0)
   
  * Determine # of steps to explode box
  * (needed for Implode, allows explode to occur faster)
  exp_no    = round((exp_top     - oops_top  + 1), 0)
  t_exp_no  = round(((oops_right - exp_right + 1) / 3), 0)
  exp_no    = if(exp_no < t_exp_no, t_exp_no, exp_no)
   
  if implode
    declare exp_scrn[exp_no]
  endif
   
  for x = 1 to exp_no
    @ exp_top, exp_left, exp_bott, exp_right box oops_frame
    if implode
      * save box as explodes for implode
      exp_scrn[x] = savescreen(oops_top, oops_left, oops_bott + 1, oops_right + 2)
    endif
      
    if exp_top > oops_top
      exp_top   = exp_top   - 1
    endif
    if (exp_left - 3) > oops_left
      exp_left  = exp_left  - 3
    endif
    if exp_bott < oops_bott
      exp_bott  = exp_bott  + 1
    endif
    if (exp_right + 3) < oops_right
      exp_right = exp_right + 3
    endif
  next
endif
@ oops_top, oops_left, oops_bott, oops_right box oops_frame

* Shadow
if shad_show
  shadowbox(oops_top, oops_left, oops_bott, oops_right, m_coopsshd)
endif

* Title
adjust = (oops_len - len(oops_title))
adjust = int(adjust / 2)

setcolor(m_coopsfr)
@ oops_top, (oops_left + adjust - 1) say "["
@ oops_top, (oops_left + adjust + len(oops_title)) say  "]"
setcolor(m_coopstit)
@ oops_top, (oops_left + adjust) say oops_title

* Messages
setcolor(m_coopstxt)
@ (oops_top + 1), (oops_left + 1) say replicate(' ', msg_len + 2)
row_pos = oops_top + 2
for x = 1 to msg_no
  @ row_pos, (oops_left + 1) say ' ' + msg[x] + ' '
  row_pos = row_pos + 1
next
@ (oops_bott - 1), (oops_left + 1) say replicate(' ', msg_len + 2)

* Instructions
adjust = (oops_len - len(oops_ins))
adjust = int(adjust / 2)

setcolor(m_coopsfr)
@ oops_bott, (oops_left + adjust - 1) say "["
@ oops_bott, (oops_left + adjust + len(oops_ins)) say  "]"
setcolor(m_coopsins)
@ oops_bott, (oops_left + adjust) say oops_ins

* ======================================================================
* The following code adds a error transaction record to a file
* named "Error.Txt". The file is created if it does not already
* exist. This code was found on a BBS with the credit to
* Greg Lief, 8/89 - 9/89, and Kevin Harrison 9/30/89.
*     Thanks - Rik Hess

do while .t.

  if ! file('Error.Txt')
    handle = fcreate('Error.Txt')

    if ferror() = 4    && if out of handles close databases,loop and retry
      close databases
      loop
    endif

    exit
  else

    handle = fopen('Error.Txt', 2)

    if ferror() = 4
      close databases
      loop
    endif

    fseek(handle, 0, 2)   && move to end of file
    exit
  endif

enddo

buffer = 'System Error: ' + oops_titl  + chr(KB_Enter) + chr(KB_LF)
fwrite(handle, buffer)

* This line of code was modified from Jim Ross 1/10/90.
* It looks for a string menory variable "AppVer". If it is found,
* the contents of the var are added to the "Error.Txt" file.
*     Thanks - Rik Hess
if type("m->appver") = "C"
    buffer = "   Application Version: " + m->appver + chr(KB_Enter) + chr(KB_LF)
    fwrite(handle, buffer)
endif

buffer = '   Date: ' + dtoc(date()) + ;
         '   Time: ' + time()       + ;
         '   User: ' + netname()    + chr(KB_Enter) + chr(KB_LF) + ;
         replicate('-',70)          + chr(KB_Enter) + chr(KB_LF)
fwrite(handle, buffer)
fclose(handle)
* ======================================================================

* get response (action)
if valid_resp
  do while .t.
    tone(920, 3)
    action = inkey(0)
    oops_action = upper(chr(action))   && alpha/numeric

    if !valid_resp .or. ascan(oops_resp, oops_action) <> 0
      exit
    endif
  enddo
else
  tone(920, 3)
  inkey(0)
endif


* Implode screen if set
if implode .and. rest_scrn
  for x = exp_no to 1 step -1
    restscreen(oops_top, oops_left, oops_bott + 1, oops_right + 2, exp_scrn[x])
  next
endif

setcolor(curr_color)                   && restore color setting

if curr_cursor
  set cursor on                        && turn cursor on if was on
endif

@ curr_row, curr_col say ''            && restore cursor positions

if rest_scrn
  restore screen from oops_scrn
endif

return .t.

**********************************************************************
* SET_TO_SCREEN()
*   insures device is set to screen
**********************************************************************
FUNCTION set_to_screen
  * Make sure output is to screen
  set device to screen
  set print   off
  set console on
return .t.

**********************************************************************
* PRTERRSCRN
*   prints the error screen
**********************************************************************
FUNCTION prterrscrn
  call prt_scrn                        && print DMSOOPS screen
  restore screen from oops_scrn
  call prt_scrn                        && print screen of app @ point of error
  eject
return .t.

