/*
  Ŀ
 ݳ                                                                         
 ݳ   Program : VIEW                                                        
 ݳ   Purpose : View text files on any drive                                
 ݳ   Usage   : VIEW  [cStartDrive] <enter>                                 
 ݳ                                                                         
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1988-1992, dLESKO INC. All Rights reserved.   
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
  
 
*/

#include "max.ch"               // Include aControl settings maxchoice() uses

#define DOUBLE    "ͻȺ"
#define DEFAULT -2              // Default value for FUNCky video functions
                                // tells it to use standard()/enhanced
#define PALETTECOLOR 5          // Color we're using for changing palettes
                                // All other colors are set inside the Startup()
                                // function.

// Variables we'll be using

STATIC mem1 := "", mem2 := "", mem3 := "", tempscrn := "", temp := "", ;
       mainchoice := 1, filename := "", status := "", tempdir, tempdrive, ;
       popcount := 1, pselect := 1, stype := 3, pcolor := 3, fspec := "*.*"

STATIC olddir, olddrive, oldscreen, dirrow1, dircol1, dirrow2, dircol2, ;
       filrow1, filcol1, filrow2, filcol2, frow1, fcol1, frow2, fcol2, ;
       mrow1, mcol1, mrow2, mcol2, wcolor, bcolor, drrow1, drcol1, ;
       drrow2, drcol2, prow1, pcol1, prow2, pcol2, tcolor, srow1, scol1, ;
       srow2, scol2 

// Arrays we'll be using

STATIC patterns:= { "^p^n", ;
                    "^p^n", ;
                    "^p  ^n", "^p ۲^n", "^p ^n", ;
                    "^p^n", "^p^n", "^p^n", "^p^n", "^p^r ^n", ;
                    "^p^r^n", ;
                    "^p^rClipper                                           ^n", ;
                    "^p^rFUNCky II                                                 ^n"}

STATIC maincols := {1,8,22,28,34,40,52,61}
STATIC mainrows := {0,0,0,0,0,0,0,0}
STATIC vmodes   := {3,43,28,50}
STATIC mainmenu := {" ^zD^nrive ", " ^zS^nubdirectory ", " ^zF^nile ", " ^zV^niew ", " ^zM^node ", " ^zB^nackground ", " ^zP^nalette ", " ^zQ^nuit "}
STATIC modemenu := {"^y80x25 Row^n  - ^bCGA EGA VGA^n only", ;
                    "^y80x43 Row^n  - ^bEGA & VGA^n only",;
                    "^y80x28 Row^n  - ^bVGA^n only",;
                    "^y80x50 Row^n  - ^bVGA^n only",;
                    "^tReset Font to Normal",;
                    "^mDigital Font",;
                    "^cAvante Garde",;
                    "^g3270 Font",;
                    "^gBroadway Font",;
                    "^yCyrillic",;
                    "^tPercy",;
                    "^mLegend",;
                    "^cCalligraphy",;
                    "^gScript"}

// This array will be used as the options jumptable

STATIC JUMPTABLE[ 7 ]

// This is the FONT setting jumptable, have to ignore the first 3 settings

STATIC FONTTABLE[14]

// This array holds the sort methods when the FILE menu is displayed
STATIC SortMethods[4]


FUNCTION view()

        /*
        * Reset the mouse
        */
        m_reset()

        /*
        * Install arrow cursor if valid
        */
        IF( fontValid(1) )
                m_install(1)
        ENDIF

        /*
        * Setup default values, and save the current
        * drive and subdirectory                       
        * First check for EGA/VGA capability for palettes
        */
        IF( vidtype() > 1)
                IF( ! ("/P" $ upper(command())))
                        palette(PALETTECOLOR, pcolor)
                ENDIF
        ENDIF

        olddir     := curdir()
        olddrive   := curdrive()

        /*
        * This inits our option jump table
        */
        JUMPTABLE[1] := { || SelectDrive() }
        JUMPTABLE[2] := { || SelectDir() }
        JUMPTABLE[3] := { || SelectFile() }
        JUMPTABLE[4] := { || DisplayFile() }
        JUMPTABLE[5] := { || SelectVideo() }
        JUMPTABLE[6] := { || SelectPattern() }

        /*
        * Dynamic Menu selection adds an option if EGA/VGA
        */
        IF( vidtype() > 1)
                JUMPTABLE[7] := { || SetPalette() }
                AAdd(JUMPTABLE,  { || ByeBye() } )
        ELSE
                ASize(mainmenu, 7 )
                mainmenu[7]  := " Quit "
                JUMPTABLE[7] := { || ByeBye() }
        ENDIF

        /*
        * This inits our FONT jump table, first 4 selections are ignored
        */
        FONTTABLE[5 ]:= { || FLreset() }
        FONTTABLE[6 ]:= { || FLdigital() }
        FONTTABLE[7 ]:= { || FLavantgrd() }
        FONTTABLE[8 ]:= { || FL3270() }
        FONTTABLE[9 ]:= { || FLbroadway() }
        FONTTABLE[10]:= { || FLcyrillic() }
        FONTTABLE[11]:= { || FLpercy() }
        FONTTABLE[12]:= { || FLlegend() }
        FONTTABLE[13]:= { || FLcalligra() }
        FONTTABLE[14]:= { || FLscript2() }

        /*
        * This inits our sort jump table to be used if fhe 
        * file menu is displayed and the user hits F1
        */
        SortMethods[1] := { |x, y| SortName(x, y ) }
        SortMethods[2] := { |x, y| SortExt(x, y ) }
        SortMethods[3] := { |x, y| SortSize(x, y ) }
        SortMethods[4] := { |x, y| SortDate(x, y ) }

        /*
        * Switch to the specified drive if any
        */
        SetDrive(argv(1))
        chdir("\")

        tempdir    := curdir()
        tempdrive  := curdrive()

        /*
        * Setup starting menu values, and initialize the display
        */
        StartUp()

        /*
        * Main loop
        */
        DO WHILE (.T.)
        
                status := untrim("Drive: "+tempdrive,10)+chr(179) +;
                          untrim("Directory: "+tempdir,50)+chr(179) +;
                          untrim("File: "+filename,20)
        
                /*
                * Display the status line
                */
                m_csroff()
                print(lastrow(), 0, status, enhanced(), lastcol()+1)
                m_csron()
        
                /*
                * Get the users selection
                */
                mainchoice := m_aprompt(.F.,mainchoice,mainrows,maincols, ;
                                          mainmenu, enhanced())

                /*
                * Fixup zero return and use our jump table
                */
                IF (mainchoice == 0)
                        mainchoice := len(Jumptable)
                ENDIF

                EVAL( JumpTable[ mainchoice ])

        ENDDO

return NIL
        
STATIC FUNCTION StartUp()

        csron()                 // keep internal flags in sync
        csroff()                // just in case the MODE or FONT was changed
        m_csron()
        m_csroff()

        IF (! iscolor()) .or. ("/M" $ upper(command()))
                standard(7)
                enhanced(roloc(standard()))
                wcolor := 7
                bcolor := 7
                tcolor := 15
                                                // Turn attributes off
                setattrib("t", -1)		// Red
                setattrib("y", -1)		// Yellow
                setattrib("g", -1)		// Green
                setattrib("c", -1)		// Cyan
                setattrib("m", -1)		// Magenta
                setattrib("p", -1)		// Palette color
                setattrib("q", -1)		// Palette color
                setattrib("z", -1)		// Prompt HOT KEY color

        ELSE
                standard(23)
                enhanced(roloc(standard()))
                wcolor := 23
                tcolor := 30

                IF( vidtype() > 1 )
                        IF( ! ( "/P" $ upper(command())))
                                bcolor := PALETTECOLOR // Color used if palette()
                        ELSE
                                bcolor := 1
                        ENDIF
                ELSE
                        bcolor := 1
                ENDIF
                                                // embedded attributes on
                setattrib("t", 12+16)		// Red
                setattrib("y", 14+16)		// Yellow
                setattrib("g", 10+16)		// Green
                setattrib("c", 11+16)		// Cyan
                setattrib("m", 13+16)		// Magenta
                setattrib("p", PALETTECOLOR*16) // Palette color
                setattrib("q", PALETTECOLOR*16) // Palette color
                setattrib("z", 126)             // Prompt HOT KEY color 
                                                // bright Yellow on white

        ENDIF

        /*
        * Use thin vertical shadow if in any mode that has
        * more than 25 rows so that the horizontal and
        * vertical shadow size stay about the same
        */
        IF( lastrow() > 25 )
                shadowtype(stype, 7, "  ")
        ELSE
                shadowtype(stype, 7, "   ")
        ENDIF

        /*
        * Save starting screen and display the desktop
        */
        oldscreen := savevideo(0,0, lastrow(), lastcol())

        DisplayDesk()

        /*
        * Mouse message data controls the workings of the
        * built in mouse controlled windows.
        */
        m_data(3,1)                     // return if they click outside the window
        m_data(8,1)                     // top virtual row
        m_data(10, lastrow()-2)         // bottom virtual row account for shadow
        m_data(22,1)                    // autosave on exit

        /*
        * Dynamically load our coordinate variables so that all we need
        * do is change the array definitions and all the popups will
        * move themselves to the right positions
        */
        drrow1   := mainrows[1]+3
        drcol1   := maincols[1]+4
        drrow2   := mainrows[1]+ IF((drives()+ mainrows[1] + 6) > (lastrow()-1),;
                                     lastrow()-2, drives()+6)
        drcol2   := maincols[1]+25
        
        dirrow1   := mainrows[2]+3
        dircol1   := maincols[2]+3
        dirrow2   := mainrows[2]+22
        dircol2   := maincols[2]+29
        
        filrow1   := mainrows[3]+4
        filcol1   := maincols[3]+3
        filrow2   := mainrows[3]+18
        filcol2   := maincols[3]+42
        
        prow1   := mainrows[6]+4
        pcol1   := lastcol()-64
        prow2   := mainrows[6]+21
        pcol2   := lastcol()-16
        
        frow1     := 5       
        fcol1     := 5
        frow2     := lastrow()-6
        fcol2     := lastcol()-5

        mrow1     := mainrows[5]+3
        mrow2     := mainrows[5]+21
        mcol1     := maincols[5] 
        mcol2     := maincols[5]+33
        
return NIL        
        
STATIC FUNCTION vidset(vmode)

LOCAL os
        
        IF (vmode > 4)
                IF (vidtype() < 2)
                        os := setshadow(.F.)
                        m_display("EGA or VGA compatible card required to set fonts", wcolor)
                        setshadow(os)
                        return NIL
                ELSE
                        SetFont(vmode)
                        StartUp()
                        return NIL
                ENDIF
        ENDIF

        IF (vidtype() == 0)
                os := setshadow(.F.)
                m_display("Can't change modes on a Monochrome monitor", wcolor)
                setshadow(os)
                return NIL
        ENDIF

        IF (vmode == 2)
                IF (vidtype() < 2)
                        os := setshadow(.F.)
                        m_display("EGA compatible adaptor required to display 43 lines", wcolor)
                        setshadow(os)
                        return NIL
                ENDIF
        ENDIF
        IF (vmode == 3 .or. vmode == 4)
                IF (vidtype() < 3)
                        os := setshadow(.F.)
                        m_display("VGA compatible adaptor required to display 28/50 lines", wcolor)
                        setshadow(os)
                        return NIL
                ENDIF
        ENDIF

        m_csroff()
        m_install(0)
        unclock12()
        cls(7, " ")
        videomode(vmodes[vmode])

        /*
        * The mouse is not automatically updated by videomode()!
        * mouseinit() resets the row/col boundaries that the mouse
        * can access.
        */
        mouseinit()

        /*
        *       Reinstall mouse if mode changed
        */
        IF( fontValid(1))
                m_install(1)
        ENDIF

        m_csron()

        /*
        * Update the palette since it gets reset on a Mode change
        */
        IF( vidtype() > 1)
                IF( ! ("/P" $ upper(command())))
                        palette(PALETTECOLOR, pcolor)
                ENDIF
        ENDIF

        StartUp()
        
return NIL

STATIC FUNCTION SetFont(vfont)

        m_install(0)
        m_csroff()

        /*
        * Use the jump table
        */
        EVAL(FONTTABLE[vfont])

        /*
        * Update the palette since it gets reset on a FONT change
        */
        IF( vidtype() > 1)
                IF( ! ("/P" $ upper(command())))
                        palette(PALETTECOLOR, pcolor)
                ENDIF
        ENDIF

        IF( fontValid(1))
                m_install(1)
        ENDIF
        m_csron()

return NIL

STATIC FUNCTION popanother(d1,d2,d3)

        IF (popcount == 4)
                return NIL
        ENDIF

        popcount++
        temp := maxview(@frow1, @fcol1, @frow2, @fcol2, filename, wcolor)
        popcount--

return NIL

STATIC FUNCTION SelectDrive()

LOCAL os

        mem3 := maxpopdrive(@drrow1, @drcol1, @drrow2, @drcol2,"", wcolor)
        IF (lastkey() == 27 .or. m_data(4) == 1)
                return NIL
        ENDIF
        IF ( tempdrive == mem3 )
                m_data(31,0)
                return NIL
        ENDIF

        /*
        * Check that the drive selected is ready
        */
        IF (! isdrive(mem3))
                m_squeak()
                os := setshadow(.F.)
                m_display("The Drive You Have Selected is Not Ready", wcolor)
                setshadow(os)
                return NIL
        ENDIF

        /*
        * Change to the new drive directory and reset default values
        */
        setdrive(mem3)
        filename := ""
        tempdir  := curdir()
        tempdrive:= mem3

return NIL

STATIC FUNCTION SelectDir()

LOCAL os

        mem1 := maxpopdir(@dirrow1, @dircol1, @dirrow2, @dircol2, "", wcolor)
        IF (lastkey() == 27 .or. m_data(4) == 1)
                return NIL
        ENDIF
        IF (empty(mem1) )
                m_squeak()
                os := setshadow(.F.)
                m_display("No Directories Found", wcolor)
                setshadow(os)
                return NIL
        ENDIF

        /*
        * Change to the new directory and reset default values
        */
        chdir(mem1)
        filename := ""
        tempdir  := curdir()

return NIL

STATIC FUNCTION SelectFile()

LOCAL t, os

        /*
        * Set up hot key for sorting and scanning
        * the file menu. SET MAXKEY is defined in max.ch
        * and allows maxchoice to pass our popup its internal
        * array it is using for any modifications we might dream up.
        */
        set maxkey 28 to PopUpSort

        /*
        * Get a file to display. Set title for F1 options
        */
        t := m_title("F1 For Options")

        mem2 := maxpopfile(@filrow1, @filcol1, @filrow2, @filcol2, fspec, wcolor)

        // restore title and nuke hot key
        m_title(t)
        setkey(28, NIL)

        // check return val
        IF (lastkey() == 27 .or. m_data(4) == 1)
                return NIL
        ENDIF

        mem2 := alltrim(mem2)
        IF ( empty(mem2) )
                m_squeak()
                os := setshadow(.F.)
                m_display("No Files Found in Directory", wcolor) 
                setshadow(os)
                return NIL
        ENDIF

        IF (filename != mem2)
                m_data(31,0)
        ENDIF

        filename := mem2

return NIL

STATIC FUNCTION DisplayFile()

LOCAL isdbf, os

        IF (empty(filename))
                m_squeak()
                os := setshadow(.F.)
                m_display("File to Display Not Selected", wcolor)
                setshadow(os)
                return NIL
        ENDIF

        isdbf := (strextract(filename, ".", 2) = "DBF")
        settitle("[ "+filename+" ]", 1, tcolor)

        IF( isdbf )
                BrowseDBF(filename)
        ELSE
                set key 28 to popanother
                m_title("ALT/O open file, ALT/S search, ALT/G Goto line")
                maxview(@frow1, @fcol1, @frow2, @fcol2, filename, wcolor)
                m_title("")
                set key 28 to
        ENDIF

        settitle("")

return NIL

STATIC FUNCTION SelectVideo()

LOCAL title := m_title()

        m_title("Select a Video Mode")
        mem2 := amaxchoice(@mrow1, @mcol1, @mrow2, @mcol2, modemenu, wcolor)
        m_title(title)

        IF (mem2 < 1 .or. m_data(4) == 1)
                return NIL
        ENDIF

        vidset(mem2)

return NIL        

STATIC FUNCTION ByeBye()

        setshadow(.F.)

        IF ( m_query("Do You Want To Exit This Application?", wcolor))
                m_install(0)
                unclock12()
                setdrive(olddrive)
                chdir(olddir)
                cls(7, " ")
                m_reset()
                fontReset()
                csron()
                quit
        ENDIF

        setshadow(.T.)

return NIL

STATIC FUNCTION SelectPattern()

LOCAL title := m_title()

        m_title("Select a Pattern")
        mem2 := amaxchoice(@prow1, @pcol1, @prow2, @pcol2, patterns, wcolor)
        m_title(title)

        IF (mem2 < 1 .or. m_data(4) == 1)
                return NIL
        ENDIF

        pselect := mem2
        DisplayDesk()

return NIL        

STATIC FUNCTION DisplayDesk()

        m_csroff()
        csroff()

        cls( bcolor, stripattrib(patterns[pselect]))
        print(0, 0, "", enhanced(), lastcol()+1)
        status := untrim("Drive: "+tempdrive, 10)+chr(179) +;
                  untrim("Directory: "+tempdir, 50)+chr(179) +;
                  untrim("File: "+filename, 20)

        print(lastrow(), 0, "", enhanced(), lastcol()+1)
        tempscrn := savevideo(1, 0, lastrow()-1, lastcol())

        clock12(0, lastcol()-8, enhanced())
        m_csron()

return NIL

STATIC FUNCTION SetPalette()

LOCAL ikey, scr, x := pcolor, os

        IF( "/P" $ upper(command()))
                m_display("You Turned Off The Palette Option", wcolor)
                return NIL
        ENDIF

        IF( "/M" $ upper(command()))
                m_display("No Palette Available When Viewing in Mono Mode", wcolor)
                return NIL
        ENDIF

        m_csroff()
        scr     := savevideo(1,0,lastrow()-1, lastcol())
        print(lastrow(), 0, "Use UP/DOWN Arrow Keys to Change Background Color Palettes", enhanced(), lastcol()+1)
        m_csron()

        os := setshadow(.F.)               // no shadows while this happens

        DO WHILE (.T.)
                m_message("Background Palette: "+str(x,3)+" - Enter to Set or ESCape", wcolor)

                ikey := waitkey(0)

                IF (ikey == 24)
                        x := IIF( x == 0, 63, x-1)
                ELSEIF (ikey == 5)
                        x := IIF(x == 63, 0, x+1)
                ELSEIF (ikey == 27)
                        x := pcolor
                        exit
                ELSEIF (ikey == 13)
                        exit
                ENDIF

                palette( PALETTECOLOR, x)
        ENDDO

        m_csroff()
        restvideo(1,0,lastrow()-1, lastcol(), scr)
        print(lastrow(), 0, status, enhanced(), lastcol()+1)
        m_csron()

        pcolor := x
        palette(PALETTECOLOR, x)
        setshadow(os)                   // shadows back on

return NIL

STATIC FUNCTION BrowseDBF(filename)

LOCAL os, name, x, y, fields := {}, titles := {}

        /*
        * Use the file. Nuke the extension
        */
        name := strswap(filename, ".", 2, "")
        use (filename)

        /*
        * Check it
        */
        IF (! used() )
                m_squeak()
                os := setshadow(.F.)
                m_display("Error Opening Selected DBF file", wcolor)
                setshadow(os)
                return NIL
        ENDIF

        /*
        * Setup titles and fields - Afields() is not recommended
        * and DBstruct is just too ambitious for this
        */
        titles := array(fcount())
        fields := array(fcount())

        FOR x = 1 to fcount()
                titles[x] := fieldname(x)

                y := type( titles[x] )
                IF( y = "M" )
                        fields[x] := ["MEMO"]
                ELSEIF ( y = "C" )
                        fields[x] := titles[x]
                ELSEIF ( y = "N" )
                        fields[x] := "str(" + titles[x] + ")"
                ELSEIF ( y = "D" )
                        fields[x] := "dtoc(" + titles[x] + ")"
                ELSEIF ( y = "L" )
                        fields[x] := "iif(" + titles[x] + ", [.T.], [.F.] )"
                ELSE
                        fields[x] := ["Unknown Field Type"]
                ENDIF

        NEXT

        m_title("ALT/G to Goto Record Number")
        maxdbfview(@frow1, @fcol1, @frow2, @fcol2, titles, fields, wcolor)

        /*
        * Close file
        */
        use
        m_title("")

return NIL        

        /*
        * When the POPUP key (F1) is pressed while in the
        * FILES menu, the following is executed and maxchoice()
        * Passes its control array to use here. Then we can instruct
        * maxchoice() what to do next, and modify the array it is
        * working on. The return value of this popup routine
        * intructs maxchoice() to do nothing or to refresh itself.
        * If anything we may do will cause maxchoice() to resize itself,
        * Then we must restore the screen contained in _tempscrn as defined
        * in max.ch before returning so that window droppings arent left
        * by maxchoice(). aControl MUST be the name of the fourth parameter
        * we receive so that the defines in max.ch match properly to the
        * elements it contains.
        */

FUNCTION PopUpSort(d1,d2,d3, aControl)    // aControl sent to us by maxchoice()

LOCAL options := {"Sort by Name", "Sort by Extension", "Sort by Size", ;
                  "Sort by Date" , "Scan for a Text String", "Specify New File Pattern"}

LOCAL r := NIL, s, k, b, choice, title, mtitle, lrow := lastrow()
LOCAL lcol := lastcol(), lastline

        /*
        * If popup coords not defined, then define them.
        * _trow, _tcol are defined in max.ch
        */
        IF( srow1 == NIL )
                s     := 27                     // length to fit stuff in window
                k     := len(options)+4
                srow1 := _trow+1
                scol1 := _tcol+1
                srow2 := IIF( _trow+k > m_data(10), m_data(10), _trow+k)
                scol2 := IIF( _tcol+s > lcol, lcol, _tcol+s)

                // Verify coordinates
                IF( scol2 <= scol1 )
                        scol1 := scol2 - s
                ENDIF

                IF( srow2 <= srow1 )
                        srow1 := srow2 - s - 4
                ENDIF
        ENDIF

        /*
        * Save incoming last keypress and set key to block
        * Then turn off whatever key activated us
        */
        k := lastkey()
        b := setkey(k, NIL)

        /*
        * save incoming automatic restore value from m_data()
        * Add turn it on so that maxchoice() restores the screen
        */
        mtitle := m_title("Select Option")
        s      := m_data(22,1)

        /*
        * Use the values passed to us to display a menu
        * _pcolor is defined in max.ch
        */
        choice := maxchoice( @srow1, @scol1, @srow2, @scol2, options, _pcolor)
        m_wait(1)       // wait till they release!

        IF ( choice > 0 )

                IF( choice == 5 )               // handle the oddballs
                        r := ScanFile(aControl)
                ELSEIF (choice == 6 )
                        r := NewFileSpec(aControl)
                        
                ELSE                            // handle the rest, _prompt
                                                // is defined in max.ch

                        // save the last row since it gets printed on!
                        m_csroff()
                        lastline := savevideo(lrow, 0, lrow, lcol)
                        m_csron()

                        // use our jump table for the sorting methods
                        Eval( { || asort( _prompt ,,, SortMethods[choice]) } )

                        // restore the last row since it gets printed on!
                        m_csroff()
                        restvideo(lrow, 0, lrow, lcol, lastline)
                        m_csron()

                        r := 0                  // YO, do an update

                ENDIF
        ENDIF

        /*
        * Restore all incoming values
        */
        setkey(k, b)
        m_data(22, s )
        m_title(mtitle)

return(r)                               // r contains the return method

STATIC FUNCTION SortName( x, y )

        print(lastrow(), 0, "Sorting: "+ left( x, 12) , enhanced(), lastcol()+1)

return( left(x,12) < left(y,12) )

STATIC FUNCTION SortExt( x, y )

        print(lastrow(), 0, "Sorting: "+ left( x, 12) , enhanced(), lastcol()+1)

return( strextract(x, ". ", 1) < strextract(y, ". ", 1) )

STATIC FUNCTION SortSize( x, y )

        print(lastrow(), 0, "Sorting: "+ left( x, 12) , enhanced(), lastcol()+1)

return( val(substr(x, 14, 8)) < val(substr(y, 14, 8)))

STATIC FUNCTION SortDate( x, y )

        print(lastrow(), 0, "Sorting: "+ left( x, 12) , enhanced(), lastcol()+1)

return( ctod(substr(x, 23, 8)) < ctod(substr(y, 23, 8)))

STATIC FUNCTION NewFileSpec( aControl )

LOCAL   filearr := {}, numfiles := 0, temp, ;
        temp2, temp3, temp4, temp5, x, filespec

        IF( _width < 7 )
                m_display("Window is Not Wide Enough to Allow Data Entry", _pcolor)
                m_wait(1)       // wait till they release that button!
                return NIL
        ENDIF

        filespec := space( _width-6 )
        m_csroff()
        print(_brow-1, _tcol+1, "Spec: ", _phigh)       // _phigh is defined
        csron()                                         // in max.ch
        reads(_brow-1,_tcol+7, @filespec ,_phigh)
        m_csron()
        csroff()

        /*
        * If they ESCaped out, just return
        */
        IF (lastkey() = 27)
                return NIL
        ENDIF

        /*
        * If filespec empty, revert back to normal
        */
        filespec := alltrim(filespec)
        IF (empty( filespec ))
                filespec := "*.*"
        ENDIF

        /*
        * Grab the first files information. 
        * Use the Inclusive attribute.
        */
        temp  := findfirst(filespec, 0+1+32+128)

        /*
        * Here's the loop that reads the filenames into the array.
        */
        DO WHILE ( ! empty( temp ))
                numfiles++
                temp2 := str(findsize(),8)
                temp3 := untrim(finddate(), 9)
                temp4 := findtime()
                temp5 := iif(test(findattr(),1),"Read Only","Archive")

                AAdd( filearr, untrim(temp,13)+temp2+" "+temp3+" "+ ;
                                      temp4+" "+temp5)

                temp := findnext()
        ENDDO

        /*
        * Verify that there are indeed some files. If none, display
        * a message to that effect
        */
        IF (numfiles < 1)
                m_display("No Matching Files Were Found, Press Any Key", _pcolor)
                m_wait(1)       // wait till they release that button!
                return 0        // Need to update always after changing the window
        ENDIF

        /*
        * Store the filenames into the array that maxchoice() is using
        * I hope Clippers garbage collection works!. _prompt is defined
        * in max.ch. Also reload _start and _pactive so that the display
        * matches the active element
        */
        _prompt  := aclone(filearr)
        _pactive := 1
        _pactive := 1
        _start   := 1

        /*
        * store the new file spec into fspec so that it stays
        * in use until changed again
        */
        fspec := filespec

        /*
        * Repaint the original screen so if the original maxchoice()
        * window has to resize itself we don't leave old remnants
        * lying around. _tempscrn is contained in aControl and it is the
        * original screen maxchoice() saved before putting the window up.
        * _tempscrn is defined in max.ch.
        */
        m_csroff()
        restvideo( _tempscrn )
        m_csron()

return (0)              // 0 causes an update with the new files

STATIC FUNCTION ScanFile( aControl )

LOCAL   filespec, x

        IF( _width < 7 )
                m_display("Window is Not Wide Enough to Allow Data Entry", _pcolor)
                m_wait(1)       // wait till they release that button!
                return NIL
        ENDIF

        filespec := space( _width-6 )
        m_csroff()
        print(_brow-1, _tcol+1, "Scan: ", _phigh)       // _phigh defined
        csron()                                         // in max.ch
        reads(_brow-1,_tcol+7, @filespec ,_phigh)
        m_csron()
        csroff()

        /*
        * If they ESCaped out, just return and do nothing
        */
        filespec := alltrim(filespec)
        IF (lastkey() = 27) .or. ( empty(filespec) )
                return 0
        ENDIF

        /*
        * Scan the array for the string starting at current 
        * offset. If not found, then start over at the top. _prompt
        * is defined in max.ch
        */
        x := ascan( _prompt, { |x| upper(filespec) $ x }, _start + _pactive )

        IF( x < 1 )
                x := ascan( _prompt, { |x| upper(filespec) $ x } )
        ENDIF

        /*
        * See if anything matched, if so, store it into _pactive
        * and _start so that the window updates correctly. _start and
        * _pactive and _plast are defined in max.ch. Whenever the display
        * array changes these three have to be updated!
        */
        IF( x > 0 )

                _start   := x
                _pactive := 1
                _plast   := 1
        ENDIF

return(0)
