#include "FUNCky.h"

#ifdef __TURBO__
extern int _stklen = 8000;
#endif

char * filespec = "*.ico                                                    ";
int dithers[16] = { 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 176, 192, 208, 224, 240, 256 };

void main(void)
{

   int neg = 0, h;
   char ** filename = NULL;
   int nKey, x, y, r, c, numfiles, start = 0, color;
   ICON * icons[16];
   char font_chars[256], command[128];

   IF( _argc() GT 0 )
      _argv(1, filespec);
      IF( filespec[0] EQ '/' )
         filespec[0] = '*';
         filespec[1] = '.';
         filespec[2] = 'i';
         filespec[3] = 'c';
         filespec[4] = 'o';
         filespec[5] = 0;
      ENDIF
   ENDIF

   /*
   *  Get the command line to check for /EGA /VGA
   */
   _command( command );

   color = 31;

   /*
   *  Check for Icon files
   */
   numfiles = _filecount( filespec, A_NORMAL);
   IF( ! numfiles )   
      _stdoutline( "No Icon files found...");
      return;
   ENDIF

   /*
   *  Allocate memory for icons
   */
   filename = _malloc( numfiles * sizeof(char *));
   IF( ! filename )
         _stdoutline("Memory allocation error...");
         return;
   ENDIF

   /*
   *  This holds the file names
   */
   FOR( x=0; x < numfiles; x++)
      filename[x] = (char *) _malloc(66);
      IF( ! filename[x] )
         numfiles = x-1;
         EXIT;
      ENDIF
   NEXT

   /*
   *  Create the icon mapping characters
   */
   FOR( x = 0; x < 256; x++)
      font_chars[x] = (unsigned char) x;
   ENDIF

   /*
   *  starting video coordinates
   */
   r = 7;
   c = 0;

   _settitle("[ FUNCky II Text Mode Windows ICON Viewer ]", 2, 113);
   _shadowtype( 3, 0, "\0xFF\0xFF\0xFF");

   /*
   *  This'll nuke the ninth bit on VGA adapters,
   *  Causes some adapters to be screwey
   */
   IF( _ati( "/EGA", command) NE ERROR)
      _scanlines(350, 0);
   ELSEIF( _ati( "/VGA", command) NE ERROR)
      _scanlines(400, 0);
   ELSE
      _scanlines(350, 0);
   ENDIF

   /*
   *  Setup icons to display from the second font table
   */
   _fontDefine(1, 2);

   /*
   *  Create some empty icons
   */
   _cls(71, "");
   _printn(0,0,"",113,_maxcol()+1);
   _print(0,0,"Loading icon files...",113);

   FOR( x = 0; x <= 15; x++) 
      IF( (x % 8) == 0)
         r += 5;
         c = 0;
      ENDIF

      c += 8;

      icons[x] = _iconCreate( r, c, &font_chars[x * 16], 2, color); 

   NEXT

   /*
   *  Load the file names
   */
   _floadfile(filename, filespec, A_NORMAL, numfiles);

   /*
   *  Display them.
   */
   _printn(0,0,"",113,_maxcol()+1);
   _print(0,0,"Current icon: ", 113);

   DOWHILE( TRUE )

      _box( 8, 6, 22, 74, "", 23);

      DOWHILE (TRUE)

         IF( ! neg )
            FOR( x = 0; x < 16; x++) 
               h = _fopen( filename[start], O_READONLY);
               _iconRead(icons[x], h, dithers[x]);
               _iconLoad(icons[x]);
               _fclose(h);
            NEXT
         ELSE
            FOR( x = 0; x < 16; x++) 
               h = _fopen( filename[start], O_READONLY);
               _iconRead(icons[x], h, 0-dithers[x]);
               _iconLoad(icons[x]);
               _fclose(h);
            NEXT
         ENDIF
   
         FOR( y = 0; y < x; y++)
      
            _iconDisplay( icons[y] );
      
         NEXT
            
         _printn(0,14,filename[start], 113, 20);
         _printn(0,34, "\x1A \x1B To invert,  \x18\x19 Next/Previous Icon", 113, 40);
   
         nKey = _inkey(0);
   
         DOCASE
   
            CASE( nKey EQ ESC )
               _fontReset();
               return;
   
            CASE( nKey EQ DOWNARROW)
               start = start - IIF( start == 0, 0, 1);
               LOOP;
   
            CASE( nKey EQ UPARROW)
               start = start + IIF( start == numfiles-1, 0, 1);
               LOOP;
   
            CASE( nKey EQ RIGHTARROW)
               neg = 0;
               LOOP;
   
            CASE( nKey EQ LEFTARROW)
               neg = 1;
               LOOP;
   
         ENDCASE
      ENDDO
   ENDDO

}



