/*
  Ŀ
 ݳ                                                                         
 ݳ   Program : Patterns                                                    
 ݳ   Purpose : Display some interesting background patterns using the      
 ݳ             new pattern feature of cls()                                
 ݳ   Usage   : PATTERNS <enter>                                            
 ݳ                                                                         
 ݳ   Program : FUNCky                                                      
 ݳ   Author  : Copyright (C) 1990, dLESKO INC. All Rights reserved.        
 ݳ   Switches: /m/n/w                                                      
 ݳ                                                                         
 ݳ   Comments: This source code may be freely used and distributed         
 ݳ             provided that the affixed copyright notice is not removed.  
 ݳ                                                                         
  
 
*/
 
#define PALETTECOLOR 1          // Color we're using for changing palettes
#define PATTERNCOUNT 23         // Number of patterns in the array
#define MONOCOLOR    112        // Black on White
#define COLORCOLOR   32+11      // Light Cyan on Green
#define DEFAULT      -2         // Tells print to use default standard() color

STATIC paletteUsed := .F.
STATIC patterns:= { "", ;
                    "", ;
                    "۲", ;
                    "۲", ;
                    "", ;
                    "", ;
                    "۲", ;
                    "", ;
                    "", ;
                    "", ;
                    " ۲", ;
                    "  ", ;
                    " ", ;
                    "", ;
                    "", ;
                    "", ;
                    "", ;
                    "", ;
                    " ", ;
                    "..'.'.'", ;
                    ".,'.';    ", ;
                    "Clipper                                           ", ;
                    "FUNCky II                                                 " } 

FUNCTION patterns()

LOCAL tempscrn, pselect := 1, bcolor := PALETTECOLOR, ikey := 0, ;
      pcolor := PALETTECOLOR, lrow := lastrow(), lcol := lastcol()

        IF (! iscolor()) .or. ("/M" $ upper(command()))
                standard(MONOCOLOR)
                bcolor := 7
        ELSE
                standard(COLORCOLOR)
                IF( vidtype() > 1 )
                        palette(PALETTECOLOR, pcolor)
                        paletteUsed := .T.
                ENDIF
        ENDIF

        csroff()

        tempscrn := savevideo(0, 0, lrow, lcol)

        DO WHILE (.T.)
                cls( bcolor, patterns[pselect])
                print(0, 0, " Pattern Demonstration", DEFAULT, lcol+1)
                print(lrow, 0, "Press a Key to Cycle Patterns, or UP/DOWN arrows to change color PALETTE", DEFAULT, lcol+1)
                print(0,lcol-24, "Pattern: "+str(pselect,2)+ " Palette: "+str(pcolor,2), DEFAULT)

                ikey := inkey(0)

                IF (ikey == 24)
                        IF( paletteUsed )
                                pcolor := IIF( pcolor == 0, 63, pcolor-1)
                        ELSE
                                bcolor := IIF( bcolor == 0, 15, bcolor-1)
                                pcolor := bcolor
                        ENDIF
                ELSEIF (ikey == 5)
                        IF( paletteUsed )
                                pcolor := IIF( pcolor == 63, 0, pcolor+1)
                        ELSE
                                bcolor := IIF( bcolor == 15, 0, bcolor+1)
                                pcolor := bcolor
                        ENDIF
                ELSEIF (ikey == 27)
                        FLreset()
                        restvideo(0,0,lrow, lcol, tempscrn)
                        csron()
                        return NIL
                ELSE
                        pselect := IIF( pselect == PATTERNCOUNT, 1, pselect + 1)
                ENDIF

                IF( paletteUsed )
                        palette( PALETTECOLOR, pcolor)
                ENDIF
        ENDDO

return NIL
