#include "FUNCky.h"

#define NUMICONS 6

char buff[32];
int nKey, color = 0;
int bmColors[5] = {4, 2, 24, 63, 1};
char * bmFile2   = "dLESKO.lgo";
char * bmFile    = "FUNCky.bmp";
char * icFiles[] = { "NOTEPAD.ico", "MAIL.ico", "ROLODEX.ico", 
							"FLOPPY.ico", "FIXED.ico", "PHONE.ico" };
int dithers[]    = {192, 128, -128, -128, -128, -128};

unsigned char leftcheckbox[]     = { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00 };
unsigned char rightcheckbox[]    = { 0x01,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0x00 };

unsigned char leftcheckedbox[]   = { 0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x0D,0x07,0x02,0x00,0x00,0x7F,0x00 };
unsigned char rightcheckedbox[]  = { 0x01,0x06,0x06,0x16,0x36,0x66,0xC6,0x86,0x06,0x06,0x06,0x06,0xFE,0x00 };

unsigned char leftcheckbox2[]    = { 0x00,0x00,0x7F,0x7F,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x7F,0x7F,0x00 };
unsigned char rightcheckbox2[]   = { 0x00,0x00,0xFE,0xFE,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0xFE,0x00 };
unsigned char midcheckbox2[]     = { 0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00 };

unsigned char leftcheckedbox2[]  = { 0x00,0x00,0x7F,0x7F,0x7C,0x6E,0x67,0x63,0x67,0x6E,0x7C,0x7F,0x7F,0x00 };
unsigned char rightcheckedbox2[] = { 0x00,0x00,0xFE,0xFE,0x3E,0x76,0xE6,0xC6,0xE6,0x76,0x3E,0xFE,0xFE,0x00 };

unsigned char leftbutton[]       = { 0x00,0x00,0x0F,0x3F,0x30,0x60,0x60,0x60,0x60,0x60,0x30,0x3F,0x0F,0x00 };
unsigned char rightbutton[]      = { 0x00,0x00,0xF0,0xFC,0x0C,0x06,0x06,0x06,0x06,0x06,0x0C,0xFC,0xF0,0x00 };
unsigned char midbutton[]        = { 0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00 };

unsigned char leftpushedbutton[] = { 0x00,0x00,0x0F,0x3F,0x30,0x63,0x67,0x67,0x67,0x63,0x30,0x3F,0x0F,0x00 };
unsigned char rightpushedbutton[]= { 0x00,0x00,0xF0,0xFC,0x0E,0xC6,0xE6,0xE6,0xE6,0xC6,0x0E,0xFC,0xF0,0x00 };
unsigned char midpushedbutton[]  = { 0x00,0x00,0xFF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0x00 };

unsigned char leftfloppy[]       = { 0xFF,0x80,0x80,0xFF,0xFF,0xFC,0xF8,0xF8,0xFC,0xFF,0xFE,0xFE,0xFE,0xFE };
unsigned char rightfloppy[]      = { 0xFF,0x3F,0x3C,0xFF,0xFF,0x7F,0x3F,0x3F,0x7F,0xFF,0xFF,0xFF,0xFF,0xFF };

unsigned char leftharddrive[]    = { 0x00,0x00,0x7F,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7F,0x3F,0x00,0x00 };
unsigned char rightharddrive[]   = { 0x00,0x00,0xFC,0x06,0x06,0x06,0x06,0x06,0xF6,0x06,0xFE,0xFE,0x00,0x00 };

unsigned char leftdirectory[]    = { 0x00,0x1E,0x21,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7F,0x3F };
unsigned char rightdirectory[]   = { 0x00,0x00,0xF8,0x04,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0xFE };

unsigned char leftprogram[]      = { 0x00,0x7F,0x40,0x40,0x7F,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7F,0x3F };
unsigned char rightprogram[]     = { 0x00,0xFC,0x06,0x06,0xFE,0x06,0x06,0x06,0x06,0x06,0x06,0x06,0xFE,0xFE };

unsigned char leftdocument[]     = { 0x00,0x7F,0x40,0x5D,0x40,0x56,0x40,0x5B,0x40,0x5A,0x40,0x40,0x7F,0x3F };
unsigned char rightdocument[]    = { 0x00,0xC0,0x60,0x50,0x48,0x7C,0x06,0xB6,0x06,0x56,0x06,0x06,0xFE,0xFE };

unsigned char boxtopleft[]       = { 0xFF,0xE0,0xB0,0x98,0x8C,0x86,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83 };
unsigned char boxtop[]           = { 0xFF,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF };
unsigned char boxtopright[]      = { 0xFE,0x02,0x06,0x0E,0x1E,0x3E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E };
unsigned char boxrightcol[]      = { 0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E };
unsigned char boxbotright[]      = { 0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x3E,0x9E,0xCE,0xE6,0xF2,0x00 };
unsigned char boxbottom[]        = { 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x00,0xFF,0xFF,0xFF,0xFF,0x00 };
unsigned char boxbotleft[]       = { 0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x80,0x87,0x8F,0x9F,0xBF,0x00 };
unsigned char boxleftcol[]       = { 0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83 };
unsigned char boxfill[]          = { 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF };

unsigned char leftdoc[]          = { 0x7F,0x40,0x40,0x5D,0x40,0x57,0x5A,0x40,0x4E,0x5B,0x40,0x5D,0x40,0x7F };
unsigned char rightdoc[]         = { 0xC0,0x70,0x78,0x7E,0x7F,0x01,0x91,0xDD,0x01,0xED,0x01,0x9D,0x01,0xFF };

unsigned char leftfloppy2[]      = { 0x00,0x00,0x7F,0x40,0x43,0x42,0x4E,0x42,0x43,0x40,0x7F,0x3F,0x00,0x00 };
unsigned char rightfloppy2[]     = { 0x00,0x00,0xFC,0x06,0x86,0x86,0xE6,0x86,0x86,0x06,0xFE,0xFE,0x00,0x00 };

unsigned char lefttrash[]        = { 0x03,0xFF,0xC0,0xFD,0x69,0x69,0x69,0x69,0x69,0x69,0x69,0x6D,0x60,0x3F };
unsigned char righttrash[]       = { 0xC0,0xFE,0x06,0x7E,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x6C,0x0C,0xF8 };

unsigned char leftmail[]         = { 0x07,0x0C,0x18,0x30,0x7F,0xC0,0xDC,0xC0,0xC0,0xC3,0xC0,0xC3,0xC0,0xFF };
unsigned char rightmail[]        = { 0xF0,0x18,0x0C,0x06,0xFF,0x03,0x1B,0x03,0x03,0xF3,0x03,0xF3,0x03,0xFF };

unsigned char hourglass[]        = { 0xFF,0x81,0xAD,0xD7,0x7E,0x2C,0x18,0x18,0x3C,0x66,0xD3,0xDB,0xBD,0xFF };
unsigned char leftarrow[]        = { 0x00,0x02,0x06,0x0E,0x1E,0x3E,0x7E,0x7E,0x1E,0x36,0x30,0x20,0x60,0x60 };
unsigned char rightarrow[]       = { 0x00,0x40,0x60,0x70,0x78,0x7C,0x7E,0x7E,0x78,0x4C,0x0C,0x04,0x06,0x06 };
unsigned char checkmark[]        = { 0x00,0x01,0x03,0x02,0x06,0x04,0x0C,0x88,0xD8,0x50,0x70,0x20,0x00,0x00 };

unsigned char leftdirectory2[]   = { 0x00,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF };
unsigned char rightdirectory2[]  = { 0x00,0xE0,0x70,0x78,0x7C,0x7E,0x7E,0x02,0x02,0x02,0x02,0x02,0x02,0xFE };

unsigned char leftdirectory3[]   = { 0x00,0x1F,0x20,0x40,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF };
unsigned char rightdirectory3[]  = { 0x00,0x80,0x40,0x20,0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF };

unsigned char leftuparrow[]      = { 0xFF,0x80,0x81,0x83,0x87,0x8F,0x9F,0x83,0x83,0x83,0x83,0x83,0x80,0xFF };
unsigned char rightuparrow[]     = { 0xFF,0x01,0x81,0xC1,0xE1,0xF1,0xF9,0xC1,0xC1,0xC1,0xC1,0xC1,0x01,0xFF };

unsigned char leftdownarrow[]    = { 0xFF,0x80,0x83,0x83,0x83,0x83,0x83,0x9F,0x8F,0x87,0x83,0x81,0x80,0xFF };
unsigned char rightdownarrow[]   = { 0xFF,0x01,0xC1,0xC1,0xC1,0xC1,0xC1,0xF9,0xF1,0xE1,0xC1,0x81,0x01,0xFF };

unsigned char leftbigcheck[]     = { 0x00,0xFF,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xFF,0xFF };
unsigned char midbigcheck[]      = { 0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF };
unsigned char rightbigcheck[]    = { 0x00,0xFF,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0xFF,0xFF };
unsigned char midbigcheckedbox[] = { 0x00,0xFF,0x00,0x06,0x06,0x0C,0x0C,0x98,0xD8,0xF0,0x70,0x00,0xFF,0xFF };

unsigned char sqrtopleft[]       = { 0xFF,0xFF,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 };
unsigned char sqrtop[]           = { 0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 };  
unsigned char sqrtopright[]      = { 0xFF,0xFF,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03 };
unsigned char sqrrightcol[]      = { 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03 };
unsigned char sqrbotright[]      = { 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0xFF,0xFF };
unsigned char sqrbottom[]        = { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF };
unsigned char sqrbotleft[]       = { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFF,0xFF };
unsigned char sqrleftcol[]       = { 0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0 };

void main(void)
{

	int handle, x;
	BITMAP * bm1, * bm2;
	ICON * icons[12];

	/*
	*	Verify adaptor accepts EGA/VGA fonts
	*/
	IF( ! _fontValid(1))
		_stdoutline("EGA or VGA adaptor required...");
		return;
	ENDIF

	_cls(7, " ");

	/*
	*	EGA mode to eliminate 9th bit
	*/
	_scanlines(350, 1); 

	/*
	*	Put the bitmap in table 2
	*/
	_fontDefine(1, 2);
	_shadowtype(1, 0, "   ");
   
	/*
	*	Open FUNCky bitmaps
	*/
   IF(( handle = _fopen( bmFile, O_READONLY)) EQ ERROR)
		_stdoutline("Can't find FUNCky.bmp!!");
		return;
	ENDIF

   bm1 = _bmpCreate( 140, 200, 3, 47, "\x0", 2, 96 + 15 );
   _bmpRead( bm1, handle, -128);
   _fclose(handle);
	_bmpLoad(bm1);

   IF(( handle = _fopen( bmFile2, O_READONLY)) EQ ERROR)
		_stdoutline("Can't find dLESKO.lgo!!");
		return;
	ENDIF

   bm2 = _bmpCreate( 32, 88, 23, 69, "\xE8\xE9\xEA\xEB\xEC\xED\xEE\xEF\xF0\xF1\xF2\xF3\xF4\xF5\xF6\xF7\xF8\xF9\xFA\xFB\xFC\xFD\xFE\xFF", 2, 15);
   _bmpRead( bm2, handle, -128);
   _fclose(handle);
	_bmpLoad(bm2);

	/*
	*	Open Icon Files
	*/
   icons[0] = _iconCreate( 16, 2, "\x80", 1, 21);
   icons[2] = _iconCreate( 16, 12, "\x90", 1, 21);
   icons[4] = _iconCreate( 16, 22, "\xA0", 1, 21);

   icons[1] = _iconCreate( 19, 7, "\x88", 1, 21);
   icons[3] = _iconCreate( 19, 17, "\x98", 1, 21);
   icons[5] = _iconCreate( 19, 27, "\xA8", 1, 21);

	_palette(4, bmColors[0]);
	_palette(2, bmColors[1]);
	_palette(1, bmColors[2]);
	_palette(5, bmColors[3]);
	_palette(6, bmColors[4]);

	FOR( x = 0; x LT NUMICONS; x++)
	   IF(( handle = _fopen( icFiles[x], O_READONLY)) EQ ERROR)
			_stdoutline("Can't find an ICON file!!");
			return;
		ENDIF

	   _iconRead( icons[x], handle, dithers[x]);
	   _fclose(handle);
		_iconLoad(icons[x]);
	NEXT

	/*
	*	Load box characters and dingbats for table 1
	*/
	_fontPut( 0xC0, 14, 1, boxtopleft);
	_fontPut( 0xC1, 14, 1, boxtop);
	_fontPut( 0xC2, 14, 1, boxtopright);
	_fontPut( 0xC3, 14, 1, boxrightcol);
	_fontPut( 0xC4, 14, 1, boxbotright);
	_fontPut( 0xC5, 14, 1, boxbottom);
	_fontPut( 0xC6, 14, 1, boxbotleft);
	_fontPut( 0xC7, 14, 1, boxleftcol);
	_fontPut( 0xC8, 14, 1, boxfill);

	/*
	*	Load first check box type
	*/
	_fontPut( 0xC9, 14, 1, leftcheckbox);
	_fontPut( 0x01, 14, 1, rightcheckbox);

	_fontPut( 0xCA, 14, 1, leftcheckedbox);
	_fontPut( 0x02, 14, 1, rightcheckedbox);

	/*
	*	Load first push button type
	*/
	_fontPut( 0xCB, 14, 1, leftbutton);
	_fontPut( 0x03, 14, 1, rightbutton);
	_fontPut( 0xCE, 14, 1, midbutton);

	_fontPut( 0xCC, 14, 1, leftpushedbutton);
	_fontPut( 0x04, 14, 1, rightpushedbutton);
	_fontPut( 0xCD, 14, 1, midpushedbutton);

	_fontPut( 0xCF, 14, 1, leftcheckbox2);
	_fontPut( 0x05, 14, 1, rightcheckbox2);

	_fontPut( 0xD0, 14, 1, leftcheckedbox2);
	_fontPut( 0x06, 14, 1, rightcheckedbox2);
	_fontPut( 0xD1, 14, 1, midcheckbox2);

	_fontPut( 0xD2, 14, 1, leftdoc);
	_fontPut( 0x07, 14, 1, rightdoc);

	_fontPut( 0xD3, 14, 1, lefttrash);
	_fontPut( 0x08, 14, 1, righttrash);

	_fontPut( 0xD4, 14, 1, leftfloppy);
	_fontPut( 0x09, 14, 1, rightfloppy);

	_fontPut( 0xD5, 14, 1, leftmail);
	_fontPut( 0x0A, 14, 1, rightmail);

	_fontPut( 0x0B, 14, 1, hourglass);

	_fontPut( 0xD6, 14, 1, leftfloppy2);
	_fontPut( 0x0C, 14, 1, rightfloppy2);

	_fontPut( 0xD7, 14, 1, leftharddrive);
	_fontPut( 0x0D, 14, 1, rightharddrive);

	_fontPut( 0x0E, 14, 1, leftarrow);
	_fontPut( 0x0F, 14, 1, rightarrow);
	_fontPut( 0x10, 14, 1, checkmark);

	_fontPut( 0xD8, 14, 1, leftdirectory);
	_fontPut( 0x11, 14, 1, rightdirectory);

	_fontPut( 0xD9, 14, 1, leftdirectory2);
	_fontPut( 0x12, 14, 1, rightdirectory2);

	_fontPut( 0xDA, 14, 1, leftdirectory3);
	_fontPut( 0x13, 14, 1, rightdirectory3);

	_fontPut( 0xDB, 14, 1, leftuparrow);
	_fontPut( 0x14, 14, 1, rightuparrow);

	_fontPut( 0xDC, 14, 1, leftdownarrow);
	_fontPut( 0x15, 14, 1, rightdownarrow);

	_fontPut( 0xDD, 14, 1, leftbigcheck);
	_fontPut( 0xDE, 14, 1, midbigcheck);
	_fontPut( 0x16, 14, 1, rightbigcheck);
	_fontPut( 0xDF, 14, 1, midbigcheckedbox);

   /*
   *  Load the square box
   */
   _fontPut( 0xE0, 14, 1, sqrtopleft);
   _fontPut( 0xE1, 14, 1, sqrtop);
   _fontPut( 0xE2, 14, 1, sqrtopright);
   _fontPut( 0xE3, 14, 1, sqrrightcol);
   _fontPut( 0xE4, 14, 1, sqrbotright);
   _fontPut( 0xE5, 14, 1, sqrbottom);
   _fontPut( 0xE6, 14, 1, sqrbotleft);
   _fontPut( 0xE7, 14, 1, sqrleftcol);

	/*
	*	Make a pretty screen showing dingbats
	*/
   _csroff();
   _border( bmColors[2]);
	_cls(16, " ");

   _setshadow(FALSE);
	_box(1, 46, 12, 72, "\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8", 118);
   _setshadow(TRUE);
   _print(2, 47, " Windows 3.0 BITMAP File ", 96 + 7);
	_bmpDisplay(bm1);

	_box(2, 3, 11, 40, "\xE0\xE1\xE2\xE3\xE4\xE5\xE6\xE7 ", 69);
   _print(2, 39, "\xDB\x14", 69);
   _print(11, 39, "\xDC\x15", 69);
   _print(2, 3, "      Create Custom Symbol Sets     ", 112);
   _vreplicate(3,39, " ", -8, 116);
   _vreplicate(3,40, " ", -8, 116);

	_print(5, 5, "\xC9\x01", 84);
	_print(5, 8, "\xCA\x02", 84);
			 
	_print(5, 11, "\xCB\x03", 69);
	_print(5, 14, "\xCC\x04", 69);

	_print(5, 17, "\xCC\xCD\xCD\x04", 69);
	_print(5, 22, "\xCB\xCE\xCE\x03", 69);

	_print(5, 27, "\xCF\x05", 69);
	_print(5, 30, "\xD0\x06", 69);

	_print(5, 33, "\xCF\xD1\xD1\x05", 69);

	_print(7, 5, "\xD2\x07", 69);
	_print(7, 8, "\xD3\x08", 69);

	_print(7, 11, "\xD4\x09", 69);
	_print(7, 14, "\xD5\x0A", 69);

	_print(7, 17, "\x0B", 69);

	_print(7, 19, "\xD6\x0C", 69);
	_print(7, 22, "\xD7\x0D", 69);

	_print(7, 26, "\x0E", 69);
	_print(7, 28, "\x0F", 69);
	_print(7, 30, "\x10", 69);

	_print(7, 32, "\xD8\x11", 69);
	_print(7, 35, "\xD9\x12", 69);

	_print(9, 5, "\xDA\x13", 69);

	_print(9, 8, "\xDB\x14", 69);
	_print(9, 11, "\xDC\x15", 69);

	_print(9, 14, "\xDD\xDE\x16", 69);
	_print(9, 18, "\xDD\xDF\x16", 69);

   _setshadow(FALSE);
	_box(14, 35, 21, 77, "\xC0\xC1\xC2\xC3\xC4\xC5\xC6\xC7\xC8", 114);
   _setshadow(TRUE);
	_print(15, 38, "FUNCky II's highly advanced text mode", 37);
	_print(16, 38, "font management system allows you  to", 37);
	_print(17, 38, "create the most  advanced  text  mode", 37);
	_print(18, 38, "displays. Display  special  character", 37);
	_print(19, 38, "sets, symbols  and even  Windows  3.0", 37);
	_print(20, 38, "ICONS and BITMAPS in TEXT MODE!.    ", 37);
                       
   _print(14, 29, "\xDB\x14", 7);
   _print(14, 29, "\xDC\x15", 7);
   _print(14, 3, "  Windows 3.0 ICON Files  ", 112);

	FOR( x = 0; x LT NUMICONS; x++)
	   _iconDisplay( icons[x] );
	NEXT
  
   _print(23, 0, "                                                                     ", 240);
   _print(24, 0, "                                                                     ", 240);
	_bmpDisplay(bm2);

   nKey = _inkey(0);

	_fontReset();
   _csron();

}
