.LP
.ta 6iR
.nf
Network Working Group	R. Nelson
Request for Comments: XXXX	Clarkson University
\0	G. Arnold
\0	Sun Technology Enterprises
\0	XXXX 1991


.fi
.ds CH
.ds CF
.ds LF Nelson & Arnold
.ds RF [Page %]
.ds LH RFC XXXX
.ds RH XXXX 1991

.DS C
Message Send Protocol 2
.DE
.sp 2
.SH
Status of this Memo
.IP
This RFC obsoletes RFC 1159, "Message Send Protocol".  It suggests
an Experimental Protocol for the Internet community.  Hosts on the
Internet that choose to implement a Message Send Protocol may
experiment with this protocol.  Please refer to the current edition
of the "IAB Official Protocol Standards" for the standardization
state and status of this protocol.  Distribution of this memo is
unlimited.
.sp 2
.SH
Discussion
.IP
The Message Send Protocol is used to send a short message to a given
user on a given terminal on a given host.  Unix's write
command offers a limited form of this service through its host-local
write command.  This service is also known on some hosts as "SEND".
.IP
As the Internet grows, more and more people are using hosts that do
not run Internet protocols at all times.  These hosts may be able
to use a simple protocol that can be implemented using UDP and IP.
The Message Send Protocol is one such protocol.
.IP
Note that a message sending protocol is already defined using TCP.
The SMTP protocol includes a "SEND" command that will direct mail
to a user's terminal.  SMTP's SEND is not useful in this instance
because SMTP's SEND is not implemented by the majority of vendors
at this time, and is difficult to use by unskilled users.  For the
purposes of standardization, we will include a TCP based Message
Send Service.
.sp 1
.SH
Message Syntax
.IP
The message consists of several parts, all of which must be  
present The first part is a single octet indicating the protocol 
revision, currently decimal 66, 'B'. The remaining parts are  
null-terminated sequences of eight-bit characters in the
ISO 8859/1 alphabet. Some parts may be empty. All comparisons of
parts (e.g. recipient, cookie, etc.) are case-insensitive. 
The parts are as follows:
.IP RECIPIENT 1.5i
The name of the user that the message is directed to.  
If this part is empty, the message may be delivered
to any user of the destination system.
.IP RECIP-TERM
The name of the terminal to which the message is             
to be delivered. The syntax and semantics of
terminal names are outside the scope of this
specification. If this part is empty, the "right"
terminal is chosen. This is a system-dependent function.
If this part consists of the string "*", all terminals
on the destination system are implied.
If the RECIPIENT part is empty but the RECIP-TERM is
not, the message is written on the specified terminal.
If both the RECIPIENT and RECIP-TERM parts are empty,
the message should be written on the "console", which
is defined as some play where the message is most
likely to be seen by a human operator or administrator.
.IP MESSAGE
The actual message. The server need not preserve the 
formatting and white-space content of the message if 
this is necessary to display it.  New lines should be
represented using the usual Netascii CR + LF. (Following the
Internet tradition, a server should probably be prepared
to accept a message in which some other end-of-line
convention is followed, but a conforming client must
use CR + LF.)
.IP
The message text may only contain printable
characters from the ISO 8859/1 set, which is upward 
compatible from USASCII, plus CR, LF and TAB. No other control
codes or escape sequences may be included: the client should strip them
from the message before it is transmitted, and the server must
check each incoming message for illegal codes. (A server may choose to
display the message after stripping out such codes, or 
may reject the entire message.) If the MESSAGE part is empty, the message
may be discarded by the server.
.IP SENDER
The username of the sender. (This and subsequent
parts were not present in version 1 of the Message Send
Protocol.) This part should not be empty. A server may
choose to accept, reject or ignore messages in which
the SENDER part is empty.
.IP SENDER-TERM
The name of the sending user's terminal. This part may
be empty. The intention is that a recipient may
reply to a message by sending the reply to the user
SENDER at terminal SENDER-TERM on the originating
system. (The sender's hostname should be retrieved 
from the transport software.)
.IP COOKIE
A magic cookie. This part must be present in all
messages, but is only of significance for the UDP
service. The combination of the sender's UDP port
number and this cookie should be unique. A client
may elect to transmit a particular message several
times to increase the chances of its reception; a 
server may use the cookie and port to identify
duplicate messages and discard them. A reasonable
cookie is the time of day represented in a readable
format. The maximum length of a cookie is 32 octets,
excluding the terminating null.
.LP
.IP
The total length of the message shall be less than 512 octets.  This
includes all seven parts, and any terminating nulls.  UDP packets
are limited to 512 octets.
.IP
If this protocol is changed, the revision number will be changed.
.sp 2
.SH
TCP Based Message Send Service
.IP
One Message Send Service is defined as a connection based application
on TCP.  A server listens for TCP connections on TCP port 18.  Once a
connection is established a message is sent by the client over the
connection.
.IP
The server replies with a single character indicating positive ("+")
or negative ("-") acknowledgment, immediately followed by an
optional message of explanation, terminated with a null.  The
positive acknowledgement means that the message was successfully
delivered to some user/terminal, and that the negative
acknowledgement means that the message was NOT delivered to
any terminal.
.IP
The positive acknowledgement message can contain information about
what user and terminal the message was delivered to in the case of
incomplete user/terminal fields in the message.  The negative 
acknowledgement can contain information about WHY the message was not
delivered (no such user/terminal, system failure, user doesn't
accept messages, etc).
.IP
Multiple messages can be sent over the same channel.  The client
should close first (the server may/should not close directly after
the acknowledgement is sent) and the server may close after some
timeout on the order of minutes. If the sever is unable to decode
a message, or no message is received within a suitable timeout, it
may close the channel (on the assumption that the sender may have
formatted the data incorrectly).
.sp 2
.SH
UDP Based Message Send Service
.IP
Another Message Send Service is defined as a datagram based
application on UDP.  A server listens for UDP datagrams on UDP port
18.  When a datagram is received by the server, an answering datagram
may be sent back to the client.  If the message was addressed to
a particular user (i.e. the RECIPIENT part was non-empty) and was
successfully delivered to that user, a positive acknowledgement should
be sent (as described above). If the message was directed at any user
(i.e. the RECIPIENT part is empty), or if the message could not be 
delivered for some reason, no reply is sent.
.IP
The reason for this policy is that the UDP service may be used
to broadcast messages addressed to a particular user on an unknown
system or all users on all systems. In either case, it is inappropriate
for all servers to send replies. An alternative approach might have
been to require that a server only send a reply if a message was
addressed explicitly to that system and was not broadcast. Unfortunately,
the most popular network programming API does not provide an easy
way for an application to determine this; furthermore such a policy
would provide no feedback to the sender of a broadcast message to a
particular recipient. The approach adopted here provides a reasonable
compromise.
.sp 2
.SH
Example of Message Encoding
.IP
Consider a situation in which the user "sandy" is logged into the
console of system "alpha", and wishes to send a message to
the user "chris". "chris" is known to be logged in on the system
"beta" but the exact terminal is unknown. The message consists
of two lines of text, "Hi" followed by "How about lunch?".
.IP
The message would be encoded as follows:
.DS L

          +--------+---------+---------+---------+
        0 |    B   |    c    |    h    |    r    |
          +--------+---------+---------+---------+
        4 |    i   |    s    |  <NULL> |  <NULL> |
          +--------+---------+---------+---------+
        8 |    H   |    i    |   <CR>  |   <LF>  |
          +--------+---------+---------+---------+
       12 |    H   |    o    |    w    |         |
          +--------+---------+---------+---------+
       16 |    a   |    b    |    o    |    u    |
          +--------+---------+---------+---------+
       20 |    t   |         |    l    |    u    |
          +--------+---------+---------+---------+
       24 |    n   |    c    |    h    |    ?    |
          +--------+---------+---------+---------+
       28 |  <NULL>|    s    |    a    |    n    |
          +--------+---------+---------+---------+
       32 |    d   |    y    |  <NULL> |    c    |
          +--------+---------+---------+---------+
       36 |    o   |    n    |    s    |    o    |
          +--------+---------+---------+---------+
       40 |    l   |    e    |  <NULL> |    9    |
          +--------+---------+---------+---------+
       44 |    1   |    0    |    8    |    0    |
          +--------+---------+---------+---------+
       48 |    6   |    1    |    2    |    1    |
          +--------+---------+---------+---------+
       52 |    3   |    2    |    5    |  <NULL> |
          +--------+---------+---------+---------+

.DE
.IP
Note that the RECIP-TERM part is empty. The COOKIE is the 
string "910806121325", which in this implementation indicates
that the message was sent at 12:13:25 on the 6th of August, 1991.
The identity if the sending and
receiving systems is not included in the message; the server must
obtain this information from the transport service.
.sp 2
.SH
Advisories
.IP
Client and server implementations must follow the character
set restrictions noted in the MESSAGE part description. Failure to
do so may have undesirable effects on the operation of the
receiver's terminal; more seriously, it may open up a significant
security "hole". The checks must be made on any part of the message
which may be displayed, including the sender's name and terminal.
This is one case where the admonition to "be liberal
in what you accept" is not applicable. A server may chose to apply
additional checks to an incoming message, and to reject any message
which may pose a security risk. For example, a system using
a PostScript-based display may reject a message which might
be interpreted as an executable PostScript program.
.IP
The underlying transport, whether TCP or UDP, is expected to provide
checksums for the message and any response.
.IP
The semantics of the various RECIPIENT and RECIP-TERM combinations
may be confusing. The introduction of the "*" wildcard designation
in the RECIP-TERM part makes it possible to send a message to all
terminals on the designated system (if RECIPIENT is empty), or to
all terminals at which a particular recipient has logged in.
.IP
A positive acknowledgement may indicate only that the Message Send server
was able to successfully invoke a local message delivery service. It
may not be possible for true end-to-end semantics to be inferred.
.IP
For example, a Message Send server may employ a local delivery mechanism 
which calls upon the services of a window system to display the
message in a pop-up window. This process may take some significant time
to complete, and it is unclear whether it is useful for the server to
wait for an indeterminate period before returning an acknowledgement.
Therefore, this specification does not prescribe
whether the acknowledgement is associated with delivery of the message
to the local service, the display of the message, or confirmation
by the user that the message has been read by, e.g., dismissing
the pop-up window.
.sp 2
.SH
Security Considerations
.IP
Security issues related to the message text content are
discussed above. Other security issues are not addressed in this memo.
.sp 2
.SH
Acknowledgements
.IP
PostScript is a trademark of Adobe Systems, Inc.
.sp 2
.LP
.nf
Authors' Addresses

Russell Nelson
Educational Resource Center
Clarkson University
Potsdam, NY 13699-5585

Phone:  (315) 268-2292

EMail:  nelson@sun.soe.clarkson.edu

Geoff Arnold
Sun Technology Enterprises, Inc.
2 Federal Street
Billerica, MA 01821

Phone:  (508) 671-0317

EMail:  geoff@east.sun.com
