/**[f******************************************************************
 * rocky.ctl - PC installer (aldsetup) control file for PageMaker 4.0
 *
 * Copyright (C) 1990 Aldus Corporation.  All rights reserved.
 * Company confidential.
 *
 * ABSTRACT:
 * This is the PC installer (aldsetup) control file for PageMaker 4.0.
 *
 * All product-specific text goes in the .CTL file.  Nothing in the .RC
 * file should be product-specific.  Both the .CTL and the .RC files
 * must be localized.
 *
 * When localizing, only text in "double quotes" need be translated.
 * (Although, if the names of files on the distribution diskettes have
 * been changed, they'll have to be changed in this control file too.)
 *
 * $Revision:   1.20  $
 * $Date:   13 Nov 1990 16:03:36  $
 **f]*****************************************************************/
 
/* The PRODUCT command is required.
 */
PRODUCT "PageAhead"

VERSIONREQ "1.03"     /* minimum installer version required */

/* There is one DISK statement for each distribution disk.  It gives
 * the name by which the user will be asked for the disk, and a list
 * of the files on the disk.  In addition to the file names, the list
 * of files contains the sizes of the files (uncompressed, in bytes)
 * and the subdirectories in which the files can be found.  If the
 * file is in the root, the subdirectory can be left off.  The options
 * CHECKDATE or NOREPLACE can be specified after the subdirectory.  Lines
 * are separated by commas.
 *
 * This part of the control file will be created automatically by the
 * Disk Builder Utility.
 */

DISK "Disk 1"
   {
   (C)ALDUS.'91         62,
   README.TXT        12740,
   aldsetup.exe     170048  CHECKDATE,
   aldsetrs.rsl      30208  CHECKDATE,
   pa112.ctl          7554,
   PAIMP4.FL~        31840  "ALDUS\FILTERS"  CHECKDATE,
   TU.ex~           211888,
   PADBF.DL~        115920  CHECKDATE,
   PAhelp.hl~       197958,
   PAsort.dl~        51015  CHECKDATE,
   PAtokpm4.dl~      25648  CHECKDATE,
   default.wt~        2297,
   default.st~        1347,
   PAstyles.dl~       1776  CHECKDATE,
   PAfont.fo~         9728,
   PAtext.dl~        30004  CHECKDATE,
   PA.ex~           896144,
   cat_lj2.pt~       11648,
   cat_lj2.pm~       19392,
   cat_lj3.pt~        8768,
   cat_lj3.pm~       19904,
   cat_ps.pt~         9536,
   cat_ps.pm~        21440,
   courses.db~        3515,
   tutorial.pa~       1576,
   profs.db~          3516
   }

/* Specify the initial values for installer variables.  The lines of
 * text are the prompts to be used in CONFIRMDIR commands.
 */

INITIAL PADir "C:\PM4\PA"
    {
    "Type the name of the drive and directory where"
    "you want to install PageAhead files."
    " "
    "If this is the directory you want, click OK."
    }


PACKAGE PROLOGUE "" SELECTED INVISIBLE
    {
    /* Initialize the var MustReboot.  It is later set to TRUE if the user
     * chooses to have the installer modify his or her system files
     */
    SET MustReboot "FALSE"

    SET ReadmeMenu "FALSE"      /* Set to TRUE when menu item added */
    GETALDDIR AldDir
    }   /* end of Prologue pkg */


/* The quoted strings on the DIALOG command line the labels for one or
 * two dialog buttons.
 */

DIALOG PMInstalled "&Yes" "&No"
{
    CAPTION "Is PageMaker installed?"
    TEXT
        {
        "For PageAhead to be installed, you must have"
        "previously installed Aldus PageMaker 4.0."
        "If you do not have PageMaker 4.0 installed, quit this"
        "installation, then install Aldus PageMaker 4.0 from the"
	"origional program disks. "
        ""
        "Is PageMaker already installed?"
        }
}

DIALOG ChangeSystem "&Yes" "&No"
{
    CAPTION "Modify your system files?"
    TEXT
        {
        "For PageAhead to be optimally installed, Setup"
        "needs to include references to your PageAhead"
        "directory in the PATH statement of your"
        "AUTOEXEC.BAT file. Setup can modify this file now,"
	"or you can modify it yourself after installation."
        ""
        "Do you want Setup to modify your AUTOEXEC.BAT?"
        }
}


PACKAGE PageAhead "PageAhead" SELECTED
    {

    DISPLAY PMInstalled PMAnswer
    IF PMAnswer EQS "&No"
	{
	CANCEL
	}

    WININI
	{
	"Extensions" "PA1" "pa.exe ^.PA1",
	"PageAhead" "DefImport" "dBASEFile",
	"PACONNECT" "dBASEFile" "PADBF",
	"PACONNECT" "TextFile" "PADBF"
	}

    CONCAT AldDir "USENGLSH\FILTERS" FiltDir
    FILES FiltDir
	{
	PAIMP4.FL~
	}  
	ALDUSINI
        {
   	"AldusImports" "PageAhead Import" "PAIMP4.FLT,PA1"
        }

    CONFIRMDIR PADir
    CONCAT PADir "SETUP" SetupDir
/*    FILES SetupDir
        {
        ALDSETUP.EXE
        ALDSETRS.RSL
	PA112.CTL
        }	     */


    GETPERSONAL                 /* ask user for personalization info */

    /* Use a FILES statement or a SELECTx statement to tell the installer
     * what files to copy for this package.  If the FILES statement is
     * used, all the listed files will be copied during the installation.
     * If SELECTx is used, only files selected by the user will be copied.
     */
    FILES PADir
        {
	   README.TXT  
	   PADBF.DL~   
	   PAhelp.hl~  
	   PA.ex~      
	   PAsort.dl~  
	   PAtokpm4.dl~
	   TU.ex~      
	   default.wt~ 
	   default.st~ 
	   PAstyles.dl~
	   PAfont.fo~  
	   PAtext.dl~  
	}
    CONCAT PADir "Tutorial" TutDir
    FILES TutDir
        {

	   cat_lj2.pt~
	   cat_lj2.pm~
	   cat_lj3.pt~
	   cat_lj3.pm~
	   cat_ps.pt~
	   cat_ps.pm~
	   courses.db~   
	   tutorial.pa~  
	   profs.db~  
	}
	    
    CONCAT PADir "PA.exe" FullAppName
    CONCAT PADir "TU.exe" TUAppName
    ONINSTALL
        {
        ADDPROGRAMITEM "Aldus" FullAppName "PageAhead" FullAppName 0
        ADDPROGRAMITEM "Aldus" TUAppName "Table Utility" TUAppName 0
        }


    ONINSTALL                
        {
        PERSONALIZE PADir "PA.EXE" 

    /* Ask the user if they want their system files checked and
     * updated if necessary.  Record their answer in the variable
     * Answer.
     */
	DISPLAY ChangeSystem Answer
    	IF Answer EQS "&Yes"
        {
        GETBOOTDRIVE BootDrive
        SET MustReboot "TRUE"
        MODIFY "AUTOEXEC.BAT" BootDrive
                {
                PATH "path" PADir
                PATH "path" AldDir
                }
/*            MODIFY "CONFIG.SYS" BootDrive
                {
                ATLEAST "files" 20
                ATLEAST "buffers" 10
                }      */
        } /* end if */
    }  /* end oninstall */


    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
        {
        if ReadmeMenu EQS "FALSE"
            {
            WINDOWSMENU PADir "README.TXT" "&README.TXT" 
            SET ReadmeMenu "TRUE"
            }
        }


    }   /* end of PageMaker pkg */





DIALOG Successful "OK"
{
    TEXT
    {
    "Installation complete."
    "Exit Windows and restart your computer."
    }
}

PACKAGE Last "" SELECTED INVISIBLE
    {
    ONINSTALL
        {
        DISPLAY Successful
        }
    }


DIALOG RebootReminder "Continue"
{
    TEXT
        {
        "Your AUTOEXEC.BAT file has been changed. Please"
        "restart your computer so that these changes can"
        "take effect."
        }
}

PACKAGE EPILOGUE "" UNSELECTED INVISIBLE
    {
    IF MustReboot EQS "TRUE"
        {
        DISPLAY RebootReminder
        }
    }
