Program MenuTTT5_Demo_2;

Uses CRT, FastTTT5, DOS, WinTTT5, KeyTTT5, MenuTTT5;

var
  M : menu_record;
  Choice, Retcode : integer;
  Ch : char;


  Procedure Display_Help_Text(L1,L2,L3:string);
  {}
  const
      X1 = 1;
      Y1 = 15;
      X2 = 40;
      Y2 = 21;
      F1  = white;
      F2  = yellow;
      B  = blue;
  begin
      MkWin(X1,Y1,X2,Y2,F1,B,1);
      WriteBetween(X1,X2,Y1,yellow,B,' H E L P ');
      WriteBetween(X1,X2,Y1+2,F2,B,L1);
      WriteAt(X1+2,Y1+3,F1,B,L2);
      WriteAt(X1+2,Y1+4,F1,B,L3);
      WriteBetween(X1,X2,Y2,F1,B,' press any key ... ');
      DelayKey(20000);   {wait 20 seconds or user presses key}
      Rmwin;
  end; {of proc Display_Help_Text}



{$F+}
  Procedure Topic_Sensitive_Help(var Ch:char; Choice:integer; var Ecode:integer);
  {this procedure is Hooked into the menu}
  begin
      If Ch = #187 then   {F1}
      begin
          case Choice of
          1 :Display_Help_Text(
             'Authorization',
             'Select this option before loading',
             'any databases - must enter password.'   
             );
          2 :Display_Help_Text(
             'Load DataBase',
             'Select this option to retrieve a',
             'missile database from disk.'   
             );
          3 :Display_Help_Text(
             'Re-Index Database',
             'Select this option to reorganize',
             'the database and improve performance.'   
             );
          4 :Display_Help_Text(
             'New Data',
             'Select this option to add new miss-',
             'ile site, or change existing one.'   
             );
          5 :Display_Help_Text(
             'Save Database',
             'Select this option to store new',
             'data back to the disk drive.'   
             );
          6 :Display_Help_Text(
             'Print Reports',
             'Select this option to print the',
             'missile summary for Europe/USA.'   
             );
          7 :Display_Help_Text(
             'QUIT',
             'If you don''t know what quit',
             'means why are you in the army?'   
             );
          end;  {Case}
      end;
  end; {of proc Topic_Sensitive_Help}
{$F-}

Procedure Define_M;
begin
    Menu_Set(M);
    With M do
    begin
        Heading1 := 'Missile Sites';
        Heading2 := 'Main Menu';
        Topic[1]  := '  Authorization';
        Topic[2]  := '  Load Database';
        Topic[3]  := '  Re-index Database ';
        Topic[4]  := '  Input new Data';
        Topic[5]  := '  Save Database';
        Topic[6]  := '  Print Reports';
        Topic[7]  := '  Quit';
        TotalPicks := 7;
        PicksPerLine := 1;
        AddPrefix := 4;
        TopleftXY[1] := 0;        {auto center}
        TopLeftXY[2] := 4;
        BoxType := 5;
        Margins := 5;
        Colors[1] := white;
        Colors[2] := blue;
        Colors[3] := lightgray;
        Colors[4] := red;
        Colors[5] := cyan;
        AllowEsc := true;
        Hook := Topic_Sensitive_Help;
    end;
end;

begin
    Fillscreen(1,1,80,22,white,blue,chr(177));
    ClearText(1,23,80,25,white,blue);
    WriteCenter(24,yellow,blue,'TechnoJock''s Turbo Toolkit');
    WriteCenter(2,yellow,blue,'Press F1 for menu help');
    Choice := 1;
    Define_M;
    DisplayMenu(M,true,Choice,Retcode);
    writeln;
    GotoXY(1,20);
    If Retcode = 0 then
       Writeln('You chose option ',Choice)
    else
       Writeln('You escaped!');
    DelayKey(3000);
    Reset_StartUp_Mode;
    Clrscr;
    WriteAT(1,1,white,black,'Run DemoTTT.exe for the main demo program');
    WriteAT(1,2,white,black,'TechnoJock''s Turbo Toolkit v5.0');
    GotoXY(1,5);
end.

