/***********************************************************************
 *
 *      Program   : perffunc.c
 *
 *      Comments  : PerFORM PRO custom function template
 *
 **********************************************************************/

#include "windows.h"
#include "perffunc.h"

#include "stdlib.h"     /* required for the atof() functions */

/***********************************************************************
 *
 *      Procedure : LibMain (HANDLE, WORD, WORD, LPSTR)
 *
 *      Comments  :
 *         Is called by LibEntry.  LibEntry is called by Windows when
 *         the DLL is loaded.  The LibEntry routine is provided in
 *         the LIBENTRY.OBJ in the SDK Link Libraries disk.  (The
 *         source LIBENTRY.ASM is also provided.)  
 * 
 *         LibEntry initializes the DLL's heap, if a HEAPSIZE value is
 *         specified in the DLL's DEF file.  Then LibEntry calls
 *         LibMain.  The LibMain function below satisfies that call.
 *         
 *         The LibMain function should perform additional initialization
 *         tasks required by the DLL.  In this example, no initialization
 *         tasks are required.  LibMain should return a value of 1 if
 *         the initialization is successful.
 *
 **********************************************************************/
int FAR PASCAL LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine)
HANDLE  hModule;
WORD    wDataSeg;
WORD    cbHeapSize;
LPSTR   lpszCmdLine;
{
    return 1;
}

/***********************************************************************
 *
 *      Procedure : WEP (int)
 *
 *      Comments  :
 *          Performs cleanup tasks when the DLL is unloaded.  WEP() is
 *          called automatically by Windows when the DLL is unloaded
 *          (no remaining tasks still have the DLL loaded).  It is
 *          strongly recommended that a DLL have a WEP() function,
 *          even if it does nothing but return, as in this example.
 *
 **********************************************************************/
VOID FAR PASCAL WEP (bSystemExit)
int  bSystemExit;
{
    return;
}

/***********************************************************************
 *
 *      Procedure : PerformStrFunc
 *
 *      Comments  :
 *              This is the user function that performs the calculation.
 *              The routine is passed the maximum number of characters 
 *              ('maxsize') that can be stored in the resulting string
 *              (which is pointed to by the long pointer 'result'). All
 *              the parameters ('parm1' to 'parm4') are all strings,
 *              The designer need not utilize all of the parameters
 *
 *      Return Value :
 *              The application can return an integer status indicator
 *                  0 - success
 *                  1 - failure
 *              PerFORM will assume that no valid calculation data exists
 *              if a return code of 1 is received
 *
 **********************************************************************/
int FAR PASCAL PerformStrFunc (int maxsize, LPSTR result, LPSTR parm1, 
                LPSTR parm2, LPSTR parm3, LPSTR parm4)
{
/*
 *  this sample simply concatenates the first and second parameters and 
 *  stores the result string in the at 'result'
 */
    if (lstrlen(parm1) + lstrlen(parm2) > maxsize) {
        return (1);
    }
    lstrcpy (result, parm1);
    lstrcat (result, parm2);
    return (0);
}

/***********************************************************************
 *
 *      Procedure : PerformNumFunc
 *
 *      Comments  :
 *              This is the user function that performs the calculation.
 *              This function takes up to 4 string parameters and returns
 *              a numeric result at the address pointed to by the 
 *              'result' pointer. 
 *              The parameters ('parm1' to 'parm4') are all strings,
 *              The designer need not utilize all of the available
 *              parameters.
 *
 *      Return Value :
 *              The application can return an integer status indicator
 *                  0 - success
 *                  1 - failure
 *              PerFORM will assume that no valid calculation data exists
 *              if a return code of 1 is received
 *
 **********************************************************************/
int FAR PASCAL PerformNumFunc (double far *result, LPSTR parm1, 
                LPSTR parm2, LPSTR parm3, LPSTR parm4)
{
    *result = lstrlen(parm1) + lstrlen(parm2);
    return (0);
}

