/* Copyright (c) 1988-1990 Sun Microsystems, Inc.   Billerica, MA   */
/*  @(#)slattach.c	9.2 	3/23/90    */

#include <stdio.h>
#include <sys/types.h>
#include <sgtty.h>
#include <fcntl.h>
#include <signal.h>


char devname[32];
int huphandler();
extern char *attach_error_message;

main(argc,argv)
int argc;
char *argv[];
{
	int speed;
	register char *dev = argv[1];
	int fd;
	int wantbaud = 9600;	/* default speed */

	if (argc < 2 || argc > 5){
		fprintf(stderr,"usage: %s ttyname source-name destination-name [baudrate]\n", argv[0]);
		exit(1);
	}
	signal(SIGHUP,huphandler);
	if (argc == 5)
		wantbaud = atoi(argv[4]);

	speed = findspeed(wantbaud);
	if (speed == 0){
		fprintf(stderr,"%s: %s is not a valid baud rate\n",
			argv[0], argv[4]);
		exit(1);
	}
	if (strncmp("/dev/",dev,5)) {
		sprintf(devname,"/dev/%s",dev);
		dev = devname;
	}
	if ((fd=open(dev,O_RDWR|O_NDELAY)) < 0 ){
		perror(dev);
		exit(1);
	}
	if(slattach(fd, argv[2], argv[3], speed) < 0) {
		fprintf(stderr, "%s: %s\n", argv[0], attach_error_message);
		exit(1);
	}
	for (;;)
		pause();
/* NOTREACHED */
	exit(0);
}

struct sg_spds {int sp_val, sp_name;} spds[] = {
#ifdef B50
	{  50,	 B50},
#endif
#ifdef B75
	{  75,	 B75},
#endif
#ifdef B110
	{ 110,	B110},
#endif
#ifdef B150
	{ 150,	B150},
#endif
#ifdef B200
	{ 200,	B200},
#endif
#ifdef B300
	{ 300,  B300},
#endif
#ifdef B600
	{600,	B600},
#endif
#ifdef B1200
	{1200, B1200},
#endif
#ifdef B1800
	{1800, B1800},
#endif
#ifdef B2000
	{2000, B2000},
#endif
#ifdef B2400
	{2400, B2400},
#endif
#ifdef B3600
	{3600, B3600},
#endif
#ifdef B4800
	{4800, B4800},
#endif
#ifdef B7200
	{7200, B7200},
#endif
#ifdef B9600
	{9600, B9600},
#endif
#ifdef EXTA
	{19200,EXTA},
#endif
	{0, 0}
};

findspeed(wantbaud)
register int wantbaud;
{
	register struct sg_spds *sp;

	sp = spds;

	while ( sp->sp_val && sp->sp_val != wantbaud)
		sp++;

	return sp->sp_name;
}


huphandler()
{
exit(0);
}
