/*	@(#)if_sl.c 9.3 90/08/16 SMI; from UCB 7.1 6/4/86	*/
#define visibility /* was static */

/*
 * Serial Line interface
 *
 * Rick Adams
 * Center for Seismic Studies
 * 1300 N 17th Street, Suite 1450
 * Arlington, Virginia 22209
 * (703)276-7900
 * rick@seismo.ARPA
 * seismo!rick
 *
 * Pounded on heavily by Chris Torek (chris@mimsy.umd.edu, umcp-cs!chris).
 * N.B.: this belongs in netinet, not net, the way it stands now.
 * Should have a link-layer type designation, but wouldn't be
 * backwards-compatible.
 *
 * Converted to 4.3BSD Beta by Chris Torek.
 * Other changes made at Berkeley, based in part on code by Kirk Smith.
 *
 * Streamified by Guy Harris (guy@sun.com, sun!guy).
 * Further streamified by Geoff Arnold (garnold@sun.com, sun!garnold)
 * Added timeout to "kick" slstart() -- Tom Dinger (sun!tdinger)
 */

/* $Header: if_sl.c,v 1.12 85/12/20 21:54:55 chris Exp $ */
/* from if_sl.c,v 1.11 84/10/04 12:54:47 rick Exp */

#include "sl.h"
#if NSL > 0

#include <sys/param.h>
#include <sys/mbuf.h>
#include <sys/dk.h>
#include <sys/socket.h>
#include <sys/stropts.h>
#include <sys/stream.h>
#include <sys/user.h>
#include <sys/kernel.h>
#include <sys/ioctl.h>
#include <net/if.h>
/* This should really be in if.h */		/* TD */
#define IF_QNOTEMPTY(ifq) ((ifq)->ifq_len)	/* TD */
#include <net/netisr.h>
#include <net/route.h>
#ifdef INET
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#endif

#ifndef SIOCGUNIT
/* SLIP - get unit number */
#define SIOCGUNIT       _IOR(i, 51, int)                /* get unit number */
#endif


#ifdef vax
#include <vax/mtpr.h>
#endif vax

/*
 * N.B.: SLMTU is now a hard limit on input packet size.
 * SLMTU must be <= CLBYTES - sizeof(struct ifnet *).
 */
#define	SLMTU	1006
#define SL_CHUNK 128
#define	SLIP_HIWAT	1000	/* don't start a new packet if HIWAT on queue */
#define	CLISTRESERVE	1000	/* Can't let clists get too low */

/* the following is needed by the mbuf macros */

extern char mclrefcnt[];

struct sl_softc {
	struct	ifnet sc_if;	/* network-visible interface */
	short	sc_flags;	/* see below */
	short	sc_ilen;	/* length of input-packet-so-far */
	short	sc_timer_count;	/* number of timeout() calls pending -- TD */
	queue_t *sc_writeq;	/* pointer to write queue */
	queue_t *sc_readq;	/* pointer to read queue */
	char	*sc_mp;		/* pointer to next available buf char */
	char	*sc_buf;	/* input buffer */
	mblk_t	*sc_iocpending;	/* "ioctl" pending reply */
} sl_softc[NSL];

int slip_has_been_set_up = 0;
int sl_printfs = 1;

/* flags */
#define	SC_ESCAPED	0x0001	/* saw a FRAME_ESCAPE */
#define	SC_OACTIVE	0x0002	/* output tty is active */
#define	SC_SKIPPING	0x0004	/* bad data seen - waiting for a FRAME_END */

#define SL_TIMEOUT	(hz * 3)		/* 3 seconds  -- TD */

#define FRAME_END	 	0300		/* Frame End */
#define FRAME_ESCAPE		0333		/* Frame Esc */
#define TRANS_FRAME_END	 	0334		/* transposed frame end */
#define TRANS_FRAME_ESCAPE 	0335		/* transposed frame esc */

visibility int	slattach();
visibility int	sloutput(/*struct ifnet *ifp, struct mbuf *m,
    struct sockaddr *dst*/);
visibility int	slioctl(/*struct ifnet *ifp, int cmd, caddr_t data*/);

visibility int	slopen(/*queue_t *q, int dev, int oflag, int sflag*/);
visibility int	slclose(/*queue_t *q*/);
visibility int	slrput(/*queue_t *q, mblk_t *mp*/);
visibility int	slwput(/*queue_t *q, mblk_t *mp*/);
visibility int	locc(/*char c, int n, char *cp*/); 
visibility int	zap_addressing(/*struct ifnet *ifp*/);
visibility int	remove_from_in_ifaddr_chain(/*struct in_ifaddr *ia*/);
visibility int	remove_from_if_addrlist_chain(/*struct ifnet *ifp,
	struct in_ifaddr *ia*/);


visibility struct module_info slmiinfo = {
	0,
	"slip",
	0,
	INFPSZ,
	2048,	/* XXX */
	128	/* XXX */
};

visibility struct qinit slrinit = {
	slrput,
	/* for now, make this null slrserv */  NULL,
	slopen,
	slclose,
	NULL,
	&slmiinfo
};

visibility struct module_info slmoinfo = {
	0,
	"slip",
	0,
	INFPSZ,
	2048,	/* XXX */
	128	/* XXX */
};

visibility struct qinit slwinit = {
	slwput,
	NULL,
	slopen,
	slclose,
	NULL,
	&slmoinfo
};

struct streamtab sl_info = {
	&slrinit,
	&slwinit,
	NULL,
	NULL,
	NULL
};

visibility int	sltreioctl(/*long dev*/);
visibility void	sltioctl(/*queue_t *q, mblk_t *mp*/);
visibility int	slinit(/*struct sl_softc *sc*/);
visibility struct mbuf *sl_btom(/*struct sl_softc *sc, int len,
    struct ifnet *ifp*/);

/* forward reference */					/* TD */
slrestart( /*register struct sl_softc *sc*/ );		/* TD */

/*
 * Called from boot code to establish sl interfaces.
 */
visibility int
slattach()
{
	register struct sl_softc *sc;
	register int i = 0;

if(slip_has_been_set_up++)
	return(0);

	printf("SLIP serial line IP pseudo-device\n");

	for (sc = sl_softc; i < NSL; sc++) {
		sc->sc_readq = NULL;
		sc->sc_flags = 0;
		sc->sc_ilen = 0;
		sc->sc_timer_count = 0;			/* TD */
		sc->sc_writeq = NULL;
		sc->sc_buf = NULL;
		sc->sc_if.if_name = "sl";
		sc->sc_if.if_unit = i++;
		sc->sc_if.if_mtu = SLMTU;
		sc->sc_if.if_flags = IFF_POINTOPOINT | IFF_NOTRAILERS;
		sc->sc_if.if_ioctl = slioctl;
		sc->sc_if.if_output = sloutput;
		sc->sc_if.if_snd.ifq_maxlen = 10 /* was IFQ_MAXLEN */;
		sc->sc_if.if_addrlist = NULL;
		if_attach(&sc->sc_if);
	}
}

/*
 * Line specific open routine.
 * Attach the given tty to the first available sl unit.
 */
/*ARGSUSED*/
visibility int
slopen(q, dev, oflag, sflag)
	queue_t *q;
	int dev, oflag, sflag;
{
	register struct sl_softc *sc;
	register int nsl;


	if (!suser()) {
		u.u_error = EPERM;
		return (OPENFAIL);
	}

	if(!slip_has_been_set_up)
		slattach();

	if (q->q_ptr != NULL) {
		u.u_error = EBUSY;
		return (OPENFAIL);
	}

	for (nsl = 0, sc = sl_softc; nsl < NSL; nsl++, sc++) {
		if (sc->sc_readq == NULL) {
			sc->sc_flags = 0;
			sc->sc_ilen = 0;

			sc->sc_timer_count = 0;		/* TD */

			if (slinit(sc) == 0) {
				u.u_error = ENOBUFS;
				return (OPENFAIL);
			}
			sc->sc_readq = q;
			sc->sc_writeq = WR(q);
			q->q_ptr = (caddr_t)sc;
			WR(q)->q_ptr = (caddr_t)sc;
			(void) putctl1(WR(q), M_FLUSH, FLUSHRW);
			return (0);
		}
	}

	u.u_error = ENXIO;
	return (OPENFAIL);
}

/*
 * Line specific close routine.
 * Detach the tty from the sl unit.
 * Mimics part of ttyclose().
 */
visibility int
slclose(q)
	register queue_t *q;
{
	register struct sl_softc *sc;
	struct mbuf *tmp;
	struct ifnet *ifp;
	int s;

	s = splimp();		/* paranoid; splnet probably ok */
	sc = (struct sl_softc *)q->q_ptr;
	if (sc != NULL) {
		ifp = &sc->sc_if;
		if_down(ifp);
		(void) zap_addressing(ifp);
		while(1) {
			IF_DEQUEUE(&ifp->if_snd, tmp);
			if (tmp == NULL)
				break;
			m_freem(tmp); /* free this packet */
		}
		sc->sc_readq = NULL;
		sc->sc_writeq = NULL;
		q->q_ptr = NULL;
/*		MCLFREE((struct mbuf *)sc->sc_buf); */
		if(sc->sc_buf != NULL)
#if 0
			MFREE((struct mbuf *)sc->sc_buf, tmp);
#endif
/*
 * I tried MFREE, but the problem is that we've grabbed a cluster
 * and misused and abused it for our own purposes. We have
 * persuade the mbuf system to take it back. Here's how:
 */
		{
			tmp = (struct mbuf *) sc->sc_buf;
			if(--mclrefcnt[mtocl(tmp)] == 0) {
				tmp->m_next = mclfree;
				mclfree = tmp;
				mbstat.m_clfree++;
			}
		}
		sc->sc_buf = 0;
	}
	(void) splx(s);
}

/*
 * Read queue put procedure.
 */
visibility int
slrput(q, mp)
	register queue_t *q;
	register mblk_t *mp;
{
	register struct sl_softc *sc;
	register struct mbuf *m;
	register mblk_t *bp;
	register unsigned char *readp;
	register unsigned char c;
	int s;

	int bug_bytes = 0;
	int bug_esc = 0;


	sc = (struct sl_softc *)q->q_ptr;
	if (sc == NULL) {
		freemsg(mp);
		return;
	}

	switch (mp->b_datap->db_type) {

	case M_FLUSH:
		if (*mp->b_rptr & FLUSHW)
			flushq(WR(q), FLUSHDATA);
		if (*mp->b_rptr & FLUSHR)
			flushq(q, FLUSHDATA);

	default:
		putnext(q, mp);
		return;

	case M_DATA:
		break;
	}

	/*
	 * A data message, consisting of bytes from the serial line.
	 * Process each byte.
	 */
	bp = mp;

	do {
		readp = bp->b_rptr;
		while (readp < bp->b_wptr) {
			tk_nin++;
			c = *readp++;
			if(sc->sc_flags & SC_SKIPPING) {
				if(c == FRAME_END)
					sc->sc_flags &= ~SC_SKIPPING;
				continue;
			} else
			if (sc->sc_flags & SC_ESCAPED) {
				sc->sc_flags &= ~SC_ESCAPED;
				switch (c) {

				case TRANS_FRAME_ESCAPE:
					c = FRAME_ESCAPE;
					break;

				case TRANS_FRAME_END:
					c = FRAME_END;
					break;

				default:
if(sl_printfs)
	printf("?recvd an ESCAPE followed by 0x%2x with ilen=%d\n", c, sc->sc_ilen);
					sc->sc_if.if_ierrors++;
					sc->sc_mp = sc->sc_buf
					    + sizeof(struct ifnet *);
					sc->sc_ilen = 0;
					if(c != FRAME_END)
						sc->sc_flags |= SC_SKIPPING;
					continue;
				}
			} else {
				switch (c) {

				case FRAME_END:
					if (sc->sc_ilen == 0) {	/* ignore */
					/*
					 * In the old days, we'd return
					 * at this point. However, the
					 * lower streams module may have
					 * run several datagrams into a
					 * single message or message list,
					 * so instead we must...
					 */
						continue;	/* while... */
					}
					m = sl_btom(sc, sc->sc_ilen,
					    &sc->sc_if);
					if (m == NULL) {
if(sl_printfs)
	printf("?sl_btom() returned null\n");
						sc->sc_if.if_ierrors++;
						continue;
					}
					sc->sc_mp = sc->sc_buf
					    + sizeof(struct ifnet *);
					sc->sc_ilen = 0;
					sc->sc_if.if_ipackets++;
					s = splimp();
					if (IF_QFULL(&ipintrq)) {
						IF_DROP(&ipintrq);
if(sl_printfs)
	printf("IF_QFULL - trashing frame\n");
						sc->sc_if.if_ierrors++;
						m_freem(m);
					} else {
						IF_ENQUEUE(&ipintrq, m);
						schednetisr(NETISR_IP);
					}
					(void) splx(s);
					continue;

				case FRAME_ESCAPE:
					sc->sc_flags |= SC_ESCAPED;
					continue;
				}
			}
			if (++sc->sc_ilen > SLMTU) {
if(sl_printfs)
	printf("?packet overrun - > %d bytes\n", SLMTU);
				sc->sc_if.if_ierrors++;
				sc->sc_mp = sc->sc_buf
				    + sizeof(struct ifnet *);
				sc->sc_ilen = 0;
				sc->sc_flags |= SC_SKIPPING;
				continue;
			}
			*sc->sc_mp++ = c;
		}
		bp->b_rptr = (unsigned char *)readp;
	} while ((bp = bp->b_cont) != NULL);	/* next block, if any */

	freemsg(mp);
}

/*
 * Write queue put procedure: handles M_IOCTL messages.
 */
visibility int
slwput(q, mp)
	register queue_t *q;
	register mblk_t *mp;
{
	/*
	 * Process M_FLUSH, and some M_IOCTL, messages here; pass
	 * everything else down.
	 */
	switch (mp->b_datap->db_type) {

	case M_FLUSH:
		if (*mp->b_rptr & FLUSHW)
			flushq(q, FLUSHDATA);
		if (*mp->b_rptr & FLUSHR)
			flushq(RD(q), FLUSHDATA);

	default:
		putnext(q, mp);	/* pass it down the line */
		break;

	case M_IOCTL:
		sltioctl(q, mp);
		break;
	}
}

visibility int
sltreioctl(dev)
	long dev;
{
	struct sl_softc *sc = &sl_softc[dev];
	register queue_t *q;
	register mblk_t *mp;

	if ((q = sc->sc_readq) == 0)
		return;
	if ((mp = sc->sc_iocpending) != NULL) {
		sc->sc_iocpending = NULL;	/* not pending any more */
		sltioctl(WR(q), mp);
	}
}

/*
 * ioctl routine.
 * Provide a way to get the sl unit number.
 */
visibility void
sltioctl(q, mp)
	queue_t *q;
	mblk_t *mp;
{
	register mblk_t *datap;
	register struct iocblk *iocp;
	struct sl_softc *sc;
	int pri, ioctlrespsize;
	struct ifnet *ifp;
	struct sockaddr_in *sin;
	int error;
	struct rtentry route;

	iocp = (struct iocblk *)mp->b_rptr;

	sc = (struct sl_softc *)q->q_ptr;
	if (sc == NULL) {
		iocp->ioc_rval = 0;
		iocp->ioc_error = EINVAL;
		mp->b_datap->db_type = M_IOCNAK;
		qreply(q, mp);
		return;
	}

	switch (iocp->ioc_cmd) {
	case SIOCGUNIT:
		/*
		 * Get the unit number.
		 */
		if ((datap = allocb(sizeof (int), BPRI_HI)) == NULL) {
			/*
			 * We needed to allocate something to handle this
			 * "ioctl", but couldn't; save this "ioctl" and arrange
			 * to get called back when it's more likely that we can
			 * get what we need.  If there's already one being
			 * saved, throw it out, since it must have timed out.
			 */
			ioctlrespsize = sizeof (int);
			pri = splstr();
			if (sc->sc_iocpending != NULL)
				freemsg(sc->sc_iocpending);
			sc->sc_iocpending = mp;
			(void) splx(pri);
			(void) bufcall(ioctlrespsize, BPRI_HI, sltreioctl,
			    (long)(sc - sl_softc));
		} else {
			*(int *)datap->b_wptr = sc->sc_if.if_unit;
			datap->b_wptr += sizeof (int);
			mp->b_cont = datap;
			iocp->ioc_count = sizeof (int);
			iocp->ioc_rval = 0;
			iocp->ioc_error = 0;	/* brain rot */
			mp->b_datap->db_type = M_IOCACK;
			qreply(q, mp);
		}
		break;
	default:
		putnext(q, mp);	/* pass it down the line */
	}
}

/*
 * Queue a packet.  Start transmission if not active.
 */
visibility int
sloutput(ifp, m, dst)
	register struct ifnet *ifp;
	register struct mbuf *m;
	struct sockaddr *dst;
{
	register struct sl_softc *sc;
	int s;
	int out_of_sync = 0;

if(0 && sl_printfs)
	printf("sloutput()\n");
	/*
	 * `Cannot happen' (see slioctl).  Someday we will extend
	 * the line protocol to support other address families.
	 */
	if (dst->sa_family != AF_INET) {
		printf("sl%d: af%d not supported\n", ifp->if_unit,
			dst->sa_family);
		m_freem(m);
		return (EAFNOSUPPORT);
	}

	sc = &sl_softc[ifp->if_unit];
	if (sc->sc_writeq == NULL) {
		m_freem(m);
		return (ENETDOWN);	/* sort of */
	}
#ifdef notdef
	if ((sc->sc_ttyp->t_state & TS_CARR_ON) == 0) {
		m_freem(m);
		return (EHOSTUNREACH);
	}
#endif
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
if(sl_printfs)
	printf("... q full - dropping packet\n");
		IF_DROP(&ifp->if_snd);
		out_of_sync = !(sc->sc_flags & SC_OACTIVE);
		(void) splx(s);
		m_freem(m);
		sc->sc_if.if_oerrors++;
		if(out_of_sync) {
if(sl_printfs)
	printf("sloutput restart\n");
			slstart(sc);
		}
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	if ((sc->sc_flags & SC_OACTIVE) == 0) {
if(0 && sl_printfs)
	printf("... inactive - starting transmission\n");
		(void) splx(s);
		slstart(sc);
	} else {
if(0 && sl_printfs)
	printf("... already active\n");
		(void) splx(s);
	}
	return (0);
}

/*
 * Start output on interface.  Get another datagram
 * to send from the interface queue and map it to
 * the interface before starting output.
 */
slstart(sc)
	register struct sl_softc *sc;
{
	register struct mbuf *m;
	register int len;
	register u_char *cp;
	int flush, nd, np, n, s, mblklen, ncopy;
	struct mbuf *m2;
	register mblk_t *bp = NULL;
	queue_t *downstream = sc->sc_writeq;

if(0 && sl_printfs) 
	printf("slstart()\n");
	flush = 1; /* force an extra frame char first time */

	for (;;) {
		if (!canput(downstream->q_next)) {
if(0 && sl_printfs) 
	printf("... canput() returned FALSE\n");
		    /* New Code -- TD */
		    /* We might need to start a timer -- see if the
		     * queue is non-empty.
		     */
		    s = splimp();
		    if (   (sc->sc_timer_count++ == 0)
			&& IF_QNOTEMPTY(&sc->sc_if.if_snd) )
		    {
			/* Here there are no other pending timeouts,
			 * and there is a packet in the queue.
			 * Start a timeout.
			 */
			timeout( slrestart, (caddr_t)sc, SL_TIMEOUT );
if(0 && sl_printfs) 
	printf("slstart(): Starting timeout for slrestart()\n");
		    } else {
			/* no timeout set -- decrement count */
			--sc->sc_timer_count;	/* fix our change */
		    }
		    (void) splx(s);
		    /* End New Code -- TD */
		    return;
		}
		/*
		 * This happens briefly when the line shuts down.
		 */
		if (sc == NULL)
			return;

		/*
		 * Get a packet and send it to the interface.
		 */

		s = splimp();
		IF_DEQUEUE(&sc->sc_if.if_snd, m);
		if (m == NULL) {
if(0 && sl_printfs)
	printf("...queue empty\n");
			sc->sc_flags &= ~SC_OACTIVE;
			(void) splx(s);
			return;
		}
if(0 && sl_printfs)
	printf("...got a packet to work on\n");
		sc->sc_flags |= SC_OACTIVE;
		(void) splx(s);

		/*
		 * The extra FRAME_END will start up a new packet, and thus
		 * will flush any accumulated garbage.  We do this whenever
		 * the line may have been idle for some time.
		 */
		if (flush) {
			if ((bp = allocb(m->m_len + 8, BPRI_MED)) != NULL)
				*bp->b_wptr++ = FRAME_END;
		} else 
			bp = allocb(m->m_len, BPRI_MED);

		flush = 0;
		if (bp != NULL)
			mblklen = bp->b_datap->db_lim - bp->b_wptr;
		else
			mblklen = 0;


		while (bp && m) {
			cp = mtod(m, u_char *);
			len = m->m_len;
if(0 && sl_printfs)
	printf("... len = %d\n", len);
			while (len > 0) {
				/*
				 * Find out how many bytes in the string we can
				 * handle without doing something special.
				 */
				nd = locc(FRAME_ESCAPE, len, cp);
				np = locc(FRAME_END, len, cp);
				n = len - MAX(nd, np);
				while (n) {
					if (mblklen == 0) {
						if (bp != NULL) {
if(0 && sl_printfs)
	printf("...passing %d byte message buffer downstream(1)\n", bp->b_wptr -
		bp->b_datap->db_base);
							putnext(downstream, bp);
						}
						bp = allocb(SL_CHUNK, BPRI_MED);
						if(bp == NULL)
							goto aborted;
						mblklen = bp->b_datap->db_lim
						    - bp->b_wptr;
					}
					ncopy = n;
					if (ncopy > mblklen)
						ncopy = mblklen;
					/*
					 * Put ncopy characters at once
					 * into the tty output queue.
					 */
					bcopy((char *)cp, bp->b_wptr, ncopy);
					bp->b_wptr += ncopy;
					mblklen -= ncopy;
					cp += ncopy;
					len -= ncopy;
					n -= ncopy;
if(0 && sl_printfs)
	printf("...copy %d bytes; len now %d\n", ncopy, len);
				}
				/*
				 * If there are characters left in the mbuf,
				 * the first one must be special.
				 * Put it out in a different form.
				 */
				if (len) {
					if (mblklen < 2) {
						if (bp != NULL) {
if(0 && sl_printfs)
	printf("...passing %d byte message buffer downstream(2)\n", bp->b_wptr -
		bp->b_datap->db_base);
							putnext(downstream, bp);
						}
						bp = allocb(SL_CHUNK, BPRI_MED);
						if(bp == NULL)
							goto aborted;
						mblklen = bp->b_datap->db_lim
						    - bp->b_wptr;
					}
					*bp->b_wptr++ = FRAME_ESCAPE;
					*bp->b_wptr++ = *cp == FRAME_ESCAPE ?
					   TRANS_FRAME_ESCAPE :
					   TRANS_FRAME_END;
					mblklen -= 2;
					cp++;
					len--;
				}
			}
			MFREE(m, m2);
			m = m2;
		}

		if (mblklen == 0) {
			if (bp != NULL)
				putnext(downstream, bp);
			bp = allocb(SL_CHUNK, BPRI_MED);
			if(bp == NULL)
				goto aborted;
			mblklen = bp->b_datap->db_lim
			    - bp->b_wptr;
		}
		*bp->b_wptr++ = FRAME_END;
			sc->sc_if.if_opackets++;
if(0 && sl_printfs)
	printf("...passing %d byte message buffer downstream(3)\n", bp->b_wptr -
		bp->b_datap->db_base);
		putnext(downstream, bp);
aborted:

if(sl_printfs && bp == NULL && m == NULL)
	printf("oops - alloc failed, but (unexpectedly) m is NULL???\n");

		while(m) {
if(sl_printfs)
	printf("oops - allocb() must have failed - trashing mbuf chain\n");
			sc->sc_if.if_collisions++;
			MFREE(m, m2);	/* flush the data */
			m = m2;		/* can only happen if allocb fails */
		}
		sc->sc_flags &= ~SC_OACTIVE;
	}
}

/* New Function -- TD
 *
 * Try to restart output on the interface, after a timeout.
 * The timeout was generated when there was a packet in the queue, but
 * the stream was busy.  This may not still be true, or another
 * timeout may have been queued.
 */
slrestart(sc)
	register struct sl_softc *sc;
{
	/* The condition that we restart the line with
	 * a call to slstart():
	 * 1. The line has not been closed (if it has, sc_readq == NULL),
	 * 2. There is not another unexpired timer waiting.
	 */
	if (   (sc->sc_readq != NULL)
	    && (--sc->sc_timer_count == 0) )
	{
		 /* this was the last pending timer -- call slstart() */
if(0 && sl_printfs) 
	printf("slrestart(): Calling slstart()\n");
		slstart( sc );	/* restart the line */
	}
/* end slrestart() */
}

visibility int
slinit(sc)
	register struct sl_softc *sc;
{
	struct mbuf *p;

	if (sc->sc_buf == (char *) 0) {
		MCLALLOC(p, 1);
		if (p) {
			sc->sc_buf = (char *)p;
			sc->sc_mp = sc->sc_buf + sizeof(struct ifnet *);
		} else {
			printf("sl%d: can't allocate buffer\n", sc - sl_softc);
			sc->sc_if.if_flags &= ~IFF_UP;
			return (0);
		}
	}
	return (1);
}

/* placeholder */

visibility int
slioctl(ifp, cmd, data)
struct ifnet *ifp;
int cmd;
caddr_t data;
{return(0);}


/*
 * Copy data buffer to mbuf chain; add ifnet pointer ifp.
 */
visibility struct mbuf *
sl_btom(sc, len, ifp)
	struct sl_softc *sc;
	register int len;
	struct ifnet *ifp;
{
	register caddr_t cp;
	register struct mbuf *m, **mp;
	register unsigned count;
	struct mbuf *top = NULL;


	cp = sc->sc_buf + sizeof(struct ifnet *);
	mp = &top;
	while (len > 0) {
		MGET(m, M_DONTWAIT, MT_DATA);
		if ((*mp = m) == NULL) {
			m_freem(top);
if(sl_printfs)
	printf("... couldn't get an mbuf\n");

			return (NULL);
		}
		if (ifp)
			m->m_off += sizeof(ifp);
		/*
		 * If we have at least NBPG bytes,
		 * allocate a new page.  Swap the current buffer page
		 * with the new one.  We depend on having a space
		 * left at the beginning of the buffer
		 * for the interface pointer.
		 */
		if (len >= NBPG) {
			MCLGET(m);
			if (m->m_len == CLBYTES) {
if(0 && sl_printfs)
	printf("... using SWAP technique\n");
				cp = mtod(m, char *);
				m->m_off = (int)sc->sc_buf - (int)m;
				sc->sc_buf = cp;
				if (ifp) {
					m->m_off += sizeof(ifp);
					count = MIN(len,
					    CLBYTES - sizeof(struct ifnet *));
				} else
					count = MIN(len, CLBYTES);
				goto nocopy;
			}
if(sl_printfs)
	printf("... wanted to use SWAP technique, but m->m_len=%d\n", m->m_len);
		}
		if (ifp)
			count = MIN(len, MLEN - sizeof(ifp));
		else
			count = MIN(len, MLEN);

		bcopy(cp, mtod(m, caddr_t), count);
nocopy:
		m->m_len = count;
		if (ifp) {
			m->m_off -= sizeof(ifp);
			m->m_len += sizeof(ifp);
			*mtod(m, struct ifnet **) = ifp;
			ifp = NULL;
		}
		cp += count;
		len -= count;
		mp = &m->m_next;
	}
	return (top);
}


/*
 * scan a string of "n" bytes looking for the character "c"
 * return (n-x) where is is the number of characters
 * preceding the search target. Thus if the target is not
 * found, return 0; if it is the first character, return n
 */
visibility int
locc(c,n,cp)
register char c;
register int n;
register char *cp;
{
register int res = n;

while(n--) {
	if(c == *cp++)
		return(res);
	else
		res--;
	}
return(0);
}

extern struct in_ifaddr *in_ifaddr;

visibility int
zap_addressing(ifp)
register struct ifnet *ifp;
{
	register struct in_ifaddr *ia = 0;
	struct ifaddr *ifa;
	struct mbuf *m;

	/*
	 * Find address for this interface, if it exists.
	 */
	for (ia = in_ifaddr; ia; ia = ia->ia_next)
		if (ia->ia_ifp == ifp)
			break;

	if(ia == (struct in_ifaddr *)0)
		return(1); /* implausible */

	/*
	 *	unlink this first in case the routing code gets confused -
	 *	this after noticing that SIOCSIFDSTADDR in in.c
	 *	changes the address BEFORE it deletes the old route
	 */
	(void) remove_from_in_ifaddr_chain(ia);
	(void) remove_from_if_addrlist_chain(ifp, ia);

	if(ia->ia_flags & IFA_ROUTE)
		rtinit(&ia->ia_dstaddr, &ia->ia_addr, (int)SIOCDELRT,
			RTF_HOST);
	/*
	 *	Now release the mbuf which held the address
	 */
	(void) m_free(dtom(ia));
	return(0);
}

visibility int
remove_from_in_ifaddr_chain(ia)
register struct in_ifaddr *ia;
{
	register struct in_ifaddr *ib = 0;

	/*
	 *	sanity check - is the chain empty?
	 */
	if(in_ifaddr == (struct in_ifaddr *)0)
		return(1); /* implausible */

	/*
	 *	is the entry at the head of the list?
	 */
	if(in_ifaddr == ia) {
		in_ifaddr = ia->ia_next;
		return(0);
	}

	/*
	 *	scan the list until we see the target, then unlink it
	 */
	ib = in_ifaddr;
	for(; ib; ib = ib->ia_next)
		if (ib->ia_next == ia) {
			ib->ia_next = ia->ia_next;
			return(0);
		}
	return(1);
}

visibility int
remove_from_if_addrlist_chain(ifp, ia)
struct ifnet *ifp;
struct in_ifaddr *ia;
{

	register struct ifaddr *ifa = (struct ifaddr *) ia;
	register struct ifaddr *ifb = 0;

	/*
	 *	sanity check - is the chain empty?
	 */
	if(ifp->if_addrlist == (struct ifaddr *)0)
		return(1); /* implausible */

	/*
	 *	is the entry at the head of the list?
	 */
	if(ifp->if_addrlist == ifa) {
		ifp->if_addrlist = ifa->ifa_next;
		return(0);
	}

	/*
	 *	scan the list until we see the target, then unlink it
	 */
	ifb = ifp->if_addrlist;
	for(; ifb; ifb = ifb->ifa_next)
		if (ifb->ifa_next == ifa) {
			ifb->ifa_next = ifa->ifa_next;
			return(0);
		}
	return(1);
}
#endif /* #if NSL > 0 */
