/**************************************************************************/
/*                                    WORDY                               */
/*                    Educational Word Construction Game                  */
/*                                                                        */
/*                                     by                                 */
/*                                  M_Cooper                              */
/*                              3138 Foster Ave.                          */
/*                          Baltimore, MD 21224-3934                      */
/**************************************************************************/


#include <stdio.h>
#include <stdlib.h>

/**************************************************************************/
/*         Structure for storing valid entered words                      */
/**************************************************************************/

struct wordstorage
{
char words[50][13];
short int index;
}word;

/***************************************************************************/
/*                              FINAL(score)                               */
/*    final screen                                                         */
/***************************************************************************/

void final(final_score)
int final_score;

{

two_tone();   /*make beep*/

poscurs(21,0);
printf("-GAME OVER-                                                             ");
poscurs(22,0);
printf("Final score = %5d",final_score);

box1();
restore();   /*timer back to normal*/
return;


}

/***************************************************************************/
/*                               DUPE()                                    */
/*         Function to check for duplicate entry of word                   */
/*            Formal parameter: word to be checked                         */
/*                Returns flag = 0 if duplicate                            */
/***************************************************************************/

int dupe(checkword)
char *checkword;
{
register int i;
int flag = 1;

for (i = word.index; i >= 0; i--)
{flag = strcmp(checkword,word.words[i]);
        if(!flag) break; }  /*terminate loop if duplicate found*/

return(flag);
}





/*************************BOX1()*************************************/
/*           Draws split "window" for score display                 */
/*        embedded machine language routine (for speed)             */
/********************************************************************/

char box[] = {  '\120', '\121', '\006', '\127', '\277', '\350', '\000',
'\120', '\270', '\000', '\260', '\216', '\300', '\130', '\270', '\332',
'\007', '\046', '\211', '\005', '\270', '\304', '\007', '\271', 
'\050', '\000', '\107', '\107', '\363', '\253', '\270', '\277', '\007', 
'\046', '\211', '\005', '\270', '\263', '\007', '\271', '\026', '\000', 
'\201', '\307', '\240', '\000', '\046', '\211', '\005', '\342', '\367',
'\270', '\331', '\007', '\046', '\211', '\005', '\270', '\304', '\007', 
'\271', '\050', '\000', '\117', '\117', '\375', '\363', '\253', '\374', 
'\270', '\300', '\007', '\046', '\211', '\005', '\270', '\263', '\007',
'\271', '\025', '\000', '\201', '\357', '\240', '\000', '\046', '\211',
'\005', '\342', '\367', '\270', '\263', '\007', '\277', '\020', '\001',
'\271', '\023', '\000', '\201', '\307', '\240', '\000', '\046', '\211',
'\005', '\342', '\367', '\270', '\304', '\007', '\271', '\050', '\000',
'\277', '\310', '\014', '\107', '\107', '\363', '\253', '\137', '\007', 
'\131', '\130', '\220', '\303' }; 

void box1()
{
int bx = 0;
asm(box, &bx);
}



/***********************routine to restore timer***************************/ 

char restor[] = {'\120','\122','\36','\272','\123','\377','\260','\34',
'\264','\45','\120','\270','\0','\360','\216','\330',
'\130','\315','\41','\37','\132','\130',
'\123','\6','\120','\270','\100','\0','\216','\300',
'\130','\46','\213','\36','\32','\0','\46','\211',
'\36','\34','\0','\63','\300','\7','\133','\303'};

 /***********END HERE***********/


void restore()

{int bx = 0;
 asm(restor,&bx); }

 /************************************************************************/



/***************************************************************************/
/*          Checks for time left & returns flag = 0 if time up             */
/***************************************************************************/

int time_left()
{
int time_flag;
char *ti,*gettime();

ti = gettime();

time_flag = ( *(ti + 4) - 51 );

return(time_flag);

}



/**************************************************************************/
/*                               SCORE()                                  */
/*                    Updates and displays score                          */
/*                                                                        */
/*         Args.: oldscore, wordlength, # of words, error flag            */          
/**************************************************************************/

score(wlength, wordcount, errflag, dflag)

int wlength, wordcount, errflag, dflag;

{
int Wscore = 0, bonus;


if (errflag)    /*word invalid*/
{ Wscore = -5;    /*penalty*/
  return (Wscore);  }


if (!dflag)  /*duplicate word*/
{ Wscore = -50;  /*BIG penalty*/
  return (Wscore);  }



switch (wlength)  {

case 0: return (0);   /*No more words! Return*/

case 1: case 2: bonus = - 10;
                break;

case 3: bonus = -4;
        break;

case 4: bonus = -2;
        break;

case 5: bonus = 1;
        break;

case 6: bonus = 10;
        break;

case 7: bonus = 30;
        break;

case 8: bonus = 95;
        break;

case 9: bonus = 300;
        break;

case 10: bonus = 1000;
         break;

case 11: bonus = 2000;
         break;

case 12: bonus = 5000;
         break;

case 13: bonus = 10000;
         break;        }


if (wordcount > 18) 
Wscore += 2;


Wscore += 5 + bonus;

return (Wscore);
}



/****************************WORDTEST*************************************/
/*        Function test if word is constructable from Letterset          */
/*                        Argument: char wrd;                            */
/*              Returns error_flag <0 if o.k., 1 if not                  */
/*************************************************************************/

int wordtest(str,word)
char *str,*word;
{
extern int find_chr();
int i, y, error_flag = 0;


for(i=0; i < strlen(word); i++)
{


y = find_chr(str,word[i]);


if (y == -1) 
   {error_flag = 1;   return(error_flag);}   /* word not there!!! */

else *(str + y) = '*';            
 }


return(error_flag);
                                     } 
/*************************************************************************/
/*WORD_OK()    If entered word is allright, do this...                   */
/*************************************************************************/
word_ok(word1p,wordsp)
char *word1p;
int wordsp;
{
poscurs(21,0);     /* erase 'non-constructible' message */
printf("LAST WORD: - o.k. -                      ");

if (wordsp >18) poscurs(wordsp - 17,60);
else poscurs (wordsp + 1,40);

printf("%s",word1p);

}

/***************************************************************************/
/*                        WORD_ERROR()                                     */
/*If word is not constructible, indicate error...                          */
/*& do not post wrong word, update score.                                  */
/***************************************************************************/
void word_error()

{
extern blatt();

poscurs(21,0);
blatt();
printf("LAST WORD: - not constructible - \n");
}


/**************************************************************************/
/*                          DUPE_ERROR()                                  */
/*If word entered is duplicate, indicate error...                         */
/*& do not post dupe word, update score.                                  */
/**************************************************************************/
void dupe_error()

{

extern blatt();

poscurs(21,0);
blatt();
blatt();
printf("Last word DUPLICATES earlier one! \n");
}



/*************************************************************************/


main()
{
extern void display();
extern char letrgen();

char *string,*savestr,*word1;

short flag, wordlength, j, dupeflag, i , number = 11, space = 32, words = 0;

int score = 0, lastscore = 0;

exec("display.com");   /*opening screen*/

clrscrn();

string = letrgen(number);
savestr = strsave(string);   /*store string*/

printf("Letters are:                                 ");



i = 0;


while (i <= (number) )
{ putchar(*(string + i++));
  putchar(space);  }



printf("\n\nPressing only [ENTER] quits.\n\n");

poscurs(15,0);
printf("Elapsed time:");

exec("tmr.com");

do {

poscurs(7,0);


for (j = 1; j < 4; j++)  {
writechs(20,0,40);       /* blanking */
printf("\n"); }


poscurs(7,0);
printf("Enter a word: ");
  

box1();    /* display box! */

poscurs(9,0);

gets(word1);

if ( ! (time_left() ) )  break;    /* end if out of time */


flag = wordtest(string,word1);
strcpy(string,savestr);               /* restore string */

wordlength = strlen(word1);
/***************************************************************************/

     if (flag)  word_error(); 
     
     

     else if (!(dupeflag = dupe(word1)) && wordlength)  dupe_error();

     else
  {
     words++;
     word_ok(word1,words);
     strcpy (word.words[word.index++],word1);
 }


if(!wordlength) dupeflag++;
lastscore = score(wordlength, words, flag, dupeflag);
score += lastscore;

poscurs(21,51);
printf("Word score: %5d",lastscore);

poscurs(22,0);
printf("SCORE = %5d",score);


 } while ( wordlength );

final(score);   /* final screen */

}

