(*$A- $D- $I- $L- $S- $V- $M65520,65536,131071 *)
PROGRAM superlotto;

(*
   ------------------------------------------------------------------------
   AUTOR:   Martin Kochloefl
            Kreuzstr. 2
            8052 Moosburg          Tel. 08761-1247
   ------------------------------------------------------------------------
   REV:                       2.02  11.02.1991
   DATEI:                     SLOTTO.PAS
   SPRACHE:                   TURBO PASCAL 6.0
   EINZUBINDENDE UNITS:       CRT
                              SCREEN.PAS  in Datei SCREEN.PAS
                              CONFIG.PAS  in Datei CONFIG.PAS
                              MENU.PAS    in Datei MENU.PAS
                              SLOPROC.PAS in Datei SLOPROC.PAS

   LETZTE NDERUNG: Programmdokumentation und neuer Name
                    TP6.0 und ARJ-Archiv
   ------------------------------------------------------------------------

Das Programm SUPERLOTTO ist eine fast vollstndige und nur  wenig  genderte
Simulation eines sterreichischen  Geldspielautomaten  gleichen  Namens  und
erinnert etwas an das beliebte amerikanische Casinospiel Bingo.

Zum Programm gehren neben den 4 Units noch folgende Dateien:

SLOTTO.CFG      Konfigurationsdatei
SLOTTO.DOC      Anleitung
READ.ME         Hinweisdatei

Die Konfigurationsdatei erlaubt die Vernderung aller Bildschirmattribute,
sowie der Gewinnmglichkeiten und aller Textausgaben. Damit ist eine
Umstellung auf eine andere Sprache bzw. eine andere Gewinnausschttung
ohne Programmeingriff sehr einfach mglich. Auch die exotischsten Bildschirme
sind kein Problem.

*)

USES
     crt, screen, config, sloproc, menu;

(*
   CRT      = Bildschirmunit von TP fr CLRSCR und READKEY
   SCREEN   = eigenes Bildschirmunit fr alle Ausgaben
   CONFIG   = Unit zum Einlesen der Konfiguration und der Anleitung
   MENU     = Unit zur Mendarstellung
   SLOPROC  = Hilfsunit zur Zahlenausgabe
*)

VAR
    anzahl    : BYTE;      (* Anzahl gesetzter Zahlen *)
    auto      : BOOLEAN;   (* Autospiel-Modus *)
    m         : menuerec;  (* RECORD fr Men *)

   PROCEDURE ziehung(i : BYTE; VAR auto : BOOLEAN);
   (* Erzeugt die Ziehung der i-ten Zahl *)

   VAR
       j, zahl  : BYTE;
       moeglich : BOOLEAN;

   BEGIN
      IF auto
      THEN BEGIN
         meldung(txt_autostart);
         meldung2(txt_untauto);
         IF i = 1
         THEN RANDOMIZE;
         (* Bei Autospiel wird bei jedem Spielanfang eine zeitabhngige
            Startzahl fr den Zufallswert erzeugt *)

      END
      ELSE meldung(txt_manzie);
      REPEAT
         REPEAT
            zahl := RANDOM(80) + 1;
         UNTIL (zahl > 0) AND (zahl <= 80);
         (* Es wird eine Zahl zwischen 1 und 80 erzeugt *)

         moeglich := TRUE;
         FOR j := 1 TO i - 1
         DO IF zahl = gz_zahlen[j]
            THEN moeglich := FALSE;
         (* Die erzeugte Zahl wird auf bereinstimmung mit bereits
            gezogenen Zahlen berprft und evtl. neu erzeugt *)

      UNTIL moeglich AND (keypressed OR auto);
      (* Im manuellen Modus wartet das Programm in der Schleife
         auf einen Tastendruck, es werden also fortlaufend Zahlen erzeugt *)

      IF auto
      THEN IF keypressed
         THEN auto := FALSE;
         (* Unterbrechung des Autospiels *)
      puffer_leeren;
      gz_zahlen[i] := zahl;
   END;

   PROCEDURE zrisiko(i : BYTE; VAR w : BYTE);
   (* Die i-te Risikozahl wird auf Tastendruck erzeugt.
      W ist 1=ROT 2=BLAU 3=Risiko angenommen *)

   VAR
       j, zahl  : BYTE;
       moeglich : BOOLEAN;
       m        : menuerec;

   BEGIN
      meldung(txt_risiko);
      wr_risiko(TRUE) ;
      m.anzahl := 3;
      m.wahl := 1;
      m.zeile := mzeile;
      m.spalte := mspalte + LENGTH(txt_risiko) + 3;
      m.namen[1] := txt_menr1;
      m.namen[2] := txt_menr2;
      m.namen[3] := txt_menr3;
      m.melde[1] := txt_memr1;
      m.melde[2] := txt_memr2;
      m.melde[3] := txt_memr3;
      menue(m) ;
      (* Menauswahl fr das Risiko *)

      w := m.wahl;
      IF w < 3
      THEN BEGIN
         meldung(txt_srisiko) ;
         (* Wenn riskiert wurde, wird eine Risikozahl 1-80 erzeugt,
            wobei diese Zahl nicht unter den gezogenen Zahlen sein darf.
            Die Risikozahl wird fortlaufend erzeugt, bis eine Taste
            gedrckt wird. *)

         REPEAT
            REPEAT
              zahl := RANDOM(80) + 1;
            UNTIL (zahl > 0) AND (zahl <= 80);
            moeglich := TRUE;
            FOR j := 1 TO 20
            DO IF zahl = gz_zahlen[j]
               THEN moeglich := FALSE;
            FOR j := 1 TO i - 1
            DO IF zahl = ri_zahlen[j]
               THEN moeglich := FALSE;
            ri_zahlen[i] := zahl;
            wr_risiko(TRUE);
            sound2(100);
            delay2(20);
            nosound;
            IF KEYPRESSED AND moeglich
            THEN puffer_leeren
            ELSE moeglich:=FALSE;
         UNTIL moeglich ;
         ri_zahlen[i] := zahl;
      END ;
   END;

   PROCEDURE bild;
   (* Erzeugt den Startbildschirm des Programmes *)

   BEGIN
      wr_gewinne(0, 0);
      kredit := 100;
      gewinn := 0;
      wette := 1;
      neu_gesetzt;
      neu_gezogen;
      neu_risiko;
      clrscr;
      kreuzfeld(20, 15, 20, 4);
      norm_feld;
      kasten(2, 16, 17, 8);
      ecklinie(1, 17, 18);
      bwr(5, 16, f, txt_gewinn1);
      bwr(63, 5, f, txt_kredit);
      kasten(63, 7, 7, 1);
      bwr(73, 5, f, txt_einsatz);
      kasten(73, 7, 7, 1);
      bwr(64, 13, f, txt_gewinn2);
      kasten(73, 13, 7, 1);
      bwr(3, 7, f, txt_gesetzt);
      kreuzfeld(20, 6, 10, 1);
      bwr(3, 10, f, txt_gezogen);
      kreuzfeld(20, 9, 20, 1);
      bwr(3, 13, f, txt_zrisiko);
      kreuzfeld(20, 12, 10, 1);
      wr_kredit;
      wr_wette;
      wr_gewinn;
      dkasten(mspalte - 1, mzeile, 78, 2);
      bwr(29, 1, rr, ' S U P E R - L O T T O ');
      bwr(21, 24, bb, 'Dieses Programm ist PUBLIC DOMAIN. Bitte weitergeben');
      bwr(1, 25, rb, ' geschrieben von Martin Kochloefl, Kreuzstr.2, 8052 Moosburg, Tel. 08761-1247 ');
   END;

   PROCEDURE neues_spiel(VAR auto : BOOLEAN);
   (* Startet ein neues Spiel *)

   VAR
       i, j, w                : BYTE;
       risk, super, getroffen : BOOLEAN;
       k                      : WORD;

   BEGIN
      puffer_leeren;
      anzahl := 0;
      FOR i := 1 TO 10               (* Anzahl der gesetzten Zahlen *)
      DO IF gs_zahlen[i] > 0
         THEN INC(anzahl);
      IF anzahl = 0                  (* Keine Zahlen gesetzt *)
      THEN BEGIN
         meldung(txt_nixsetzt);
         sound2(100);
         delay2(1000);
         nosound;
         meldung('');
         auto := FALSE;
         EXIT;
      END;
      IF kredit < wette              (* Kein Kredit vorhanden *)
      THEN BEGIN
         meldung(txt_nixkredit);
         sound2(80);
         delay2(1000);
         nosound;
         meldung('');
         auto := FALSE;
         EXIT;
      END;
      kredit := kredit - wette;      (* Zurcksetzen der Spielvariablen *)
      gewinn := 0;
      neu_gezogen;
      neu_risiko;
      getroffen := welchetreffer(1);
      norm_feld;
      wr_kredit;
      wr_wette;
      wr_gewinn;
      wr_gesetzt;
      FOR i := 1 TO 20               (* Erzeugen von 20 Zahlen *)
      DO BEGIN
         ziehung(i, auto);
         getroffen := welchetreffer(i);
         IF getroffen
         THEN sound2(200)
         ELSE sound2(100);
         wr_gesetzt;
         wr_gezogen;
         wr_gewinne(anzahl, anzahltreffer);
         delay2(100);
         nosound;
      END;
      gewinn := wette * gew[anzahl, anzahltreffer];    (* GEWINNERMITTLUNG *)
      IF gewinn > 0
      THEN BEGIN                 (* Gewinnauswertung *)
         auto := FALSE;
         meldung('');
         delay2(300);
         meldung(txt_gewinn2);
         meldung2(txt_ausstop);
         sound2(60);
         delay2(200);
         sound2(80);
         delay2(200);
         sound2(120);
         delay2(300);
         sound2(160);
         delay2(300);
         nosound;
         j := 10;
         puffer_leeren;
         REPEAT                           (* Ausspielung der Risikostufe *)
            DEC(j);
            wr_ausspielung(snd);
         UNTIL (j = 0) OR keypressed;
         puffer_leeren;
         REPEAT
            k := RANDOM(10000) + 1;
         UNTIL (k > 0) AND (k <= 10000);
         CASE k OF
            1..6000 : i := 1;
            6001..9000 : i := 2;       (* Prozente der Risikostufe *)
            9001..9500 : i := 3;
            9501..9800 : i := 4;
            9801..9900 : i := 5;
            9901..9950 : i := 6;
            9951..9980 : i := 7;
            9981..9990 : i := 8;
            9991..9995 : i := 9;
            9996..9999 : i := 10;
            10000 : i := 11;
         END;
         FOR j := 1 TO i - 1
         DO BEGIN
            gewinn := 2 * gewinn;
            ri_zahlen[j] := 99;
         END;
         wr_risiko(TRUE);
         wr_gewinn;
         IF i = 11
         THEN super := TRUE
         ELSE super := FALSE;
         REPEAT                                      (* Riskieren *)
            IF (i <= 10) AND (gewinn < 1000000)
            THEN BEGIN
               ri_zahlen[i]:=99 ;
               zrisiko(i, w);
               CASE w OF
                  1 : IF (ri_zahlen[i] MOD 2) = 1
                      THEN risk := TRUE
                      ELSE risk := FALSE;
                  2 : IF (ri_zahlen[i] MOD 2) = 0
                      THEN risk := TRUE
                      ELSE risk := FALSE;
                  3 : BEGIN
                         i := 12 ;
                         super:=TRUE;
                         meldung(txt_gewan);
                      END;
               END;
               IF i <= 10
               THEN BEGIN
                  IF risk
                  THEN BEGIN
                     wr_risiko(TRUE);
                     gewinn := 2 * gewinn;
                     INC(i);
                     meldung('');
                     delay2(300);
                     meldung(txt_erfolg);
                     FOR j := 20 TO 120
                     DO BEGIN
                        sound2(j);
                        delay2(7);
                     END;
                     nosound;
                     delay2(300);
                  END
                  ELSE BEGIN
                     wr_risiko(FALSE);
                     gewinn := 0;
                     meldung('');
                     delay2(300);
                     meldung(txt_verloren);
                     FOR j := 120 DOWNTO 20
                     DO BEGIN
                        sound2(j);
                        delay2(7);
                     END;
                     nosound;
                     i := 12;
                     delay2(300);
                  END;
                  wr_gewinn;
               END;
            END;
            IF i = 11
            THEN BEGIN
               super := TRUE;
               meldung(txt_riskende) ;
            END ;
         UNTIL i >= 11;
         IF super                   (* letzte Risikostufe erreicht *)
         THEN BEGIN
            FOR i := 1 TO 7
            DO BEGIN
               sound2(40 + 20 * i);
               delay2(150);
               sound2(60 + 20 * i);
               delay2(150);
               sound2(90 + 20 * i);
               delay2(300);
            END;
            nosound;
         END;
         meldung('');
         delay2(300);
         kredit := kredit + gewinn;
         wr_kredit;
         wr_gewinn;
      END
      ELSE BEGIN                           (* kein Gewinn *)
         meldung('');
         delay2(300);
         meldung(txt_nixgewinn);
         sound2(160);
         delay2(200);
         sound2(120);
         delay2(200);
         sound2(80);
         delay2(300);
         sound2(60);
         delay2(500);
         nosound;
         meldung('');
         delay2(300);
      END;
   END;

   PROCEDURE neu_setzen;
   (* Erlaubt und kontrolliert das Setzen von Zahlen *)

   VAR
       ch           : CHAR;
       i, j, welche : BYTE;
       moeglich     : BOOLEAN;

   BEGIN
      meldung(txt_setz1);
      meldung2(txt_setz2);
      anzahl := 0;
      norm_feld;
      neu_gesetzt;
      wr_gesetzt;
      i := 1;
      wrzahl(1, ue);
      REPEAT
         nosound;
         ch := readkey;
         sound2(300);
         IF ch = CHR(0)
         THEN ch := readkey;
         IF ch = CHR(75)
         THEN DEC(i);
         IF ch = CHR(77)
         THEN INC(i);
         IF ch = CHR(72)
         THEN IF i > 20
            THEN i := i - 20;
         IF ch = CHR(80)
         THEN IF i < 60
            THEN i := i + 20;
         IF i < 1 THEN i := i + 80;
         IF i > 80 THEN i := i - 80;
         IF ch = CHR(13)
         THEN BEGIN
            moeglich := TRUE;
            FOR j := 1 TO 10
            DO IF gs_zahlen[j] = i
               THEN moeglich := FALSE;
            IF (anzahl < 10) AND moeglich
            THEN BEGIN
               INC(anzahl);
               gs_zahlen[anzahl] := i;
               sound2(400);
            END;
         END;
         IF ch = CHR(8)
         THEN BEGIN
            sound2(200);
            welche := 0;
            FOR j := 1 TO 10
            DO IF gs_zahlen[j] = i
               THEN welche := j;
            IF welche > 0
            THEN BEGIN
               FOR j := welche TO anzahl - 1
               DO gs_zahlen[j] := gs_zahlen[j + 1];
               gs_zahlen[anzahl] := 0;
               DEC(anzahl);
            END;
         END;
         norm_feld;
         wr_gesetzt;
         wrzahl(i, ue);
         wr_gewinne(anzahl, 0);
      UNTIL (ch = CHR(27));
      norm_feld;
      wr_gesetzt;
      wr_gewinne(anzahl, 0);
      nosound;
   END;

PROCEDURE ablauf;
(* HAUPTPROZEDUR FR DEN ABLAUF *)

BEGIN
   snd := TRUE;
   auto := FALSE;
   wschirm;
   bild;
   m.wahl := 1;
   REPEAT
      meldung('');                    (* Festlegen der Menpunkte *)
      m.anzahl := 8;
      m.namen[1] := txt_menh1;
      m.namen[2] := txt_menh2;
      m.namen[3] := txt_menh3;
      m.namen[4] := txt_menh4;
      m.namen[5] := txt_menh5;
      IF snd
      THEN m.namen[6] := txt_menh61
      ELSE m.namen[6] := txt_menh62;
      m.namen[7] := txt_menh7;
      m.namen[8] := txt_menh8;
      m.melde[1] := txt_memh1;
      m.melde[2] := txt_memh2;
      m.melde[3] := txt_memh3;
      m.melde[4] := txt_memh4;
      m.melde[5] := txt_memh5;
      IF snd
      THEN m.melde[6] := txt_memh61
      ELSE m.melde[6] := txt_memh62;
      m.melde[7] := txt_memh7;
      m.melde[8] := txt_memh8;
      m.zeile := mzeile;
      m.spalte := mspalte;
      IF NOT auto
      THEN menue(m)                  (* Menaufruf beim manuellen Spiel *)
      ELSE m.wahl := 2;
      bwr(21, 24, bb, copy(leerzeile,1,57));
      CASE m.wahl OF                 (* Menauswertung *)
         6 : snd := NOT snd;         (* SOUND-Umschaltung *)
         3 : BEGIN                   (* Kredit erhhen *)
                IF kredit < 1000
                THEN BEGIN
                   sound2(120);
                   INC(kredit);
                END
                ELSE meldung(txt_max);
                wr_kredit;
                delay2(50);
                nosound;
             END;
         4 : BEGIN                   (* Wette erhhen *)
                IF wette < 5
                THEN INC(wette)
                ELSE wette := 1;
                sound2(150);
                wr_wette;
                wr_gewinne(anzahl, 0);
                delay2(50);
                nosound;
             END;
         1 : BEGIN                   (* neues Spiel manuell *)
                auto := FALSE;
                neues_spiel(auto);
             END;
         2 : BEGIN                   (* Autospiel *)
                auto := TRUE;
                neues_spiel(auto);
             END;
         5 : neu_setzen;             (* Setzen von Zahlen *)
         7 : BEGIN                   (* Anleitung *)
                clrscr;
                anleitung;
                bild;
             END;
      END;
   UNTIL m.wahl = m.anzahl;
END;

BEGIN (* HAUPTPROGRAMM *)
   readcfg;                  (* Lesen der Konfiguration *)
   IF fehler
   THEN WRITELN(
        'Konfigurationsdatei SLOTTO.CFG nicht gefunden oder fehlerhaft')
   ELSE BEGIN
      readanl;               (* Lesen der Anleitung *)
      ablauf;                (* der eigentliche Programmablauf *)
      CLRSCR;
      WRITELN(txt_ende);
   END;
END.
